#!/usr/bin/perl
#
# A Debhelper sequencing module for cabalized Haskell packages.
#
# Copyright © 2015  Bogatov Dmitry <KAction@gnu.org>
# Copyright © 2021  Felix Lechner
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

use v5.20;
use warnings;
use utf8;

use Debian::Debhelper::Dh_Lib;

use constant USE_LEGACY => 1;

add_command_options('dh_makeshlibs', '-XlibHS');
add_command_options('dh_shlibdeps', '-u --ignore-missing-info');

if (USE_LEGACY) {
    add_command_options('dh_gencontrol',
        '-u-DGHC-Package=${haskell:ghc-package}');
}

# We must forbid debhelper compress interface description files,
# otherwise hoogle would be unhappy. FIXME: It it true?
add_command_options('dh_compress', '-X.haddock', '-X.hs', '-X.txt');

# Starting from debhelper v9.20151219, dh_strip automatically generats debug
# symbol packages. GHC cannot produce debugging symbols so the dbgsym
# package ends up being empty. Disable dbgsym generation.
add_command_options('dh_strip', '--no-automatic-dbgsym');

# Build with haskell buildsystem by default
add_command_options('dh_auto_configure', '--buildsystem=haskell');
add_command_options('dh_auto_build', '--buildsystem=haskell');
add_command_options('dh_auto_test', '--buildsystem=haskell');
add_command_options('dh_auto_install', '--buildsystem=haskell');
add_command_options('dh_auto_clean', '--buildsystem=haskell');

# Disable dh_missing --fail-missing in compat 13+
if (!compat(12)) {
    add_command_options('dh_missing', '--list-missing');
}

# Insert dh_haskell_* addons (in reverse order)
insert_after('dh_auto_install', 'dh_haskell_compiler');
insert_after('dh_auto_install', 'dh_haskell_description');
insert_after('dh_auto_install', 'dh_haskell_blurbs');
insert_after('dh_auto_install', 'dh_haskell_suggests');
insert_after('dh_auto_install', 'dh_haskell_shlibdeps');
insert_after('dh_auto_install', 'dh_haskell_recommends_documentation_references');
insert_after('dh_auto_install', 'dh_haskell_provides_ghc');
insert_after('dh_auto_install', 'dh_haskell_extra_depends_ghc');
insert_after('dh_auto_install', 'dh_haskell_depends_hugs');
insert_after('dh_auto_install', 'dh_haskell_depends_haddock');
insert_after('dh_auto_install', 'dh_haskell_depends_cabal');
insert_after('dh_auto_install', 'dh_haskell_install_docfiles');
insert_after('dh_auto_install', 'dh_haskell_install_haddock');
insert_after('dh_auto_install', 'dh_haskell_install_htmldocs');
insert_after('dh_auto_install', 'dh_haskell_install_profiling_libs');
insert_after('dh_auto_install', 'dh_haskell_install_development_libs');
insert_after('dh_auto_install', 'dh_haskell_install_ghc_registration');

1;

# Local Variables:
# indent-tabs-mode: nil
# cperl-indent-level: 4
# End:
# vim: syntax=perl sw=4 sts=4 sr et
