'\"
'\" This software (TkDND) is copyrighted by:
'\"   George Petasis, National Centre for Scientific Research "Demokritos",
'\"   Aghia Paraskevi, Athens, Greece.
'\"   e-mail: petasis@iit.demokritos.gr
'\"    
'\" The following terms apply to all files associated
'\" with the software unless explicitly disclaimed in individual
'\" files.
'\"    
'\" The authors hereby grant permission to use, copy, modify, distribute,
'\" and license this software and its documentation for any purpose, provided
'\" that existing copyright notices are retained in all copies and that this
'\" notice is included verbatim in any distributions. No written agreement,
'\" license, or royalty fee is required for any of the authorized uses.
'\" Modifications to this software may be copyrighted by their authors
'\" and need not follow the licensing terms described here, provided that
'\" the new terms are clearly indicated on the first page of each file where
'\" they apply.
'\"    
'\" IN NO EVENT SHALL THE AUTHORS OR DISTRIBUTORS BE LIABLE TO ANY PARTY
'\" FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
'\" ARISING OUT OF THE USE OF THIS SOFTWARE, ITS DOCUMENTATION, OR ANY
'\" DERIVATIVES THEREOF, EVEN IF THE AUTHORS HAVE BEEN ADVISED OF THE
'\" POSSIBILITY OF SUCH DAMAGE.
'\"    
'\" THE AUTHORS AND DISTRIBUTORS SPECIFICALLY DISCLAIM ANY WARRANTIES,
'\" INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY,
'\" FITNESS FOR A PARTICULAR PURPOSE, AND NON-INFRINGEMENT.  THIS SOFTWARE
'\" IS PROVIDED ON AN "AS IS" BASIS, AND THE AUTHORS AND DISTRIBUTORS HAVE
'\" NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR
'\" MODIFICATIONS.
'\" 
'\" The definitions below are for supplemental macros used in Tcl/Tk
'\" manual entries.
'\"
'\" .AP type name in/out ?indent?
'\"	Start paragraph describing an argument to a library procedure.
'\"	type is type of argument (int, etc.), in/out is either "in", "out",
'\"	or "in/out" to describe whether procedure reads or modifies arg,
'\"	and indent is equivalent to second arg of .IP (shouldn't ever be
'\"	needed;  use .AS below instead)
'\"
'\" .AS ?type? ?name?
'\"	Give maximum sizes of arguments for setting tab stops.  Type and
'\"	name are examples of largest possible arguments that will be passed
'\"	to .AP later.  If args are omitted, default tab stops are used.
'\"
'\" .BS
'\"	Start box enclosure.  From here until next .BE, everything will be
'\"	enclosed in one large box.
'\"
'\" .BE
'\"	End of box enclosure.
'\"
'\" .CS
'\"	Begin code excerpt.
'\"
'\" .CE
'\"	End code excerpt.
'\"
'\" .VS ?version? ?br?
'\"	Begin vertical sidebar, for use in marking newly-changed parts
'\"	of man pages.  The first argument is ignored and used for recording
'\"	the version when the .VS was added, so that the sidebars can be
'\"	found and removed when they reach a certain age.  If another argument
'\"	is present, then a line break is forced before starting the sidebar.
'\"
'\" .VE
'\"	End of vertical sidebar.
'\"
'\" .DS
'\"	Begin an indented unfilled display.
'\"
'\" .DE
'\"	End of indented unfilled display.
'\"
'\" .SO
'\"	Start of list of standard options for a Tk widget.  The
'\"	options follow on successive lines, in four columns separated
'\"	by tabs.
'\"
'\" .SE
'\"	End of list of standard options for a Tk widget.
'\"
'\" .OP cmdName dbName dbClass
'\"	Start of description of a specific option.  cmdName gives the
'\"	option's name as specified in the class command, dbName gives
'\"	the option's name in the option database, and dbClass gives
'\"	the option's class in the option database.
'\"
'\" .UL arg1 arg2
'\"	Print arg1 underlined, then print arg2 normally.
'\"
'\" RCS: @(#) $Id: TkDND.n,v 1.2 2002/04/12 08:42:24 petasis Exp $
'\"
'\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
'\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1	\\fI\\$2\\fP	(\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
'\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
'\"	# BS - start boxed text
'\"	# ^y = starting y location
'\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
'\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
'\"	# VS - start vertical sidebar
'\"	# ^Y = starting y location
'\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
'\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
'\"	# Special macro to handle page bottom:  finish off current
'\"	# box/sidebar if in box/sidebar mode, then invoked standard
'\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
'\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
'\"	# DE - end display
.de DE
.fi
.RE
.sp
..
'\"	# SO - start of list of standard options
.de SO
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 4c 8c 12c
.ft B
..
'\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\fBoptions\\fR manual entry for details on the standard options.
..
'\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
'\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
'\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.de UL
\\$1\l'|0\(ul'\\$2
..
.TH TkDND n 8.4 Tk "Tk Built-In Commands"
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
TkDND \- Tk Drag and Drop Interface
.SH SYNOPSIS
\fBtkdnd::drop_target register\fI window ?type-list?\fR
.br
\fBtkdnd::drop_target unregister\fI window\fR
.PP
\fBtkdnd::drag_source register\fI window ?type-list? ?mouse-buttons?\fR
.br
\fBtkdnd::drag_source unregister\fI window\fR
.PP
\fBtkdnd::platform_specific_types\fI type-list\fR
.br
\fBtkdnd::platform_independent_types\fI type-list\fR
.PP
\fBtkdnd::GetDropFileTempDirectory\fR
.br
\fBtkdnd::SetDropFileTempDirectory \fIdirectory\fR

.SH INTRODUCTION
The \fBTkDND\fR family commands provide a Tcl interface to native,
platform specific drag and drop mechanism.
Under Unix the drag & drop protocol in use is the XDND protocol version 5
(also used by the Qt toolkit, and the KDE and GNOME desktops). 
Under Windows, the OLE2 drag & drop interfaces are used.
Under Macintosh, the Cocoa drag and drop interfaces are used.
.PP
The \fbTkDND\fR family can be built from source code using the standard configure; make; make install procedure. Cmake is also supported. Some binary package are available from the SourceForge download site, from ActiveState's ActiveTcl distribution, and elsewhere.
.PP
With the \fBTkDND\fR family commands the user is able to register existing Tk
widgets as drag sources or drop targets, that are able to send or receive data
during drag and drop operations, encoded in specific types.
These types can be platform independent types like DND_Text and DND_Files or
platform specific types, like CF_UNICODETEXT or text/plain.
.PP
The legal forms for the \fBTkDND\fR commands are:
.TP
\fBtkdnd::drop_target register\fI window ?type-list?\fR
This command will register \fIwindow\fR as a drop target. A drop target is a
widget than can accept a drop action. \fIwindow\fR must exist when this command
is executed and this command can be executed multiple times on a widget.

When \fIwindow\fR is registered as a drop target, and optional \fItype-list\fR
can be provided. This type list can contain one or more types that \fIwindow\fR
will accept during a drop action, and it can contain platform independent or
platform specific types. Platform independent are \fBDND_Text\fR
for dropping text portions and \fBDND_Files\fR for dropping a list of files
(which can contain one or multiple files) on \fIwindow\fR.
If \fItype-list\fR is not specified, it defaults to the empty list.
.TP
\fBtkdnd::drop_target unregister\fI window\fR
This command will stop \fIwindow\fR from being a drop target.
Thus, \fIwindow\fR will stop receiving events related to drop operations.
It is an error to use this command for a \fIwindow\fR that has not been
registered as a drop target with \fBtkdnd::drop_target register\fR.
.TP
\fBtkdnd::drag_source register\fI window ?type-list? ?mouse-buttons?\fR
This command will register \fIwindow\fR as a drag source. A drag source is a
widget than can start a drag action. \fIwindow\fR must exist when this command
is executed and this command can be executed multiple times on a widget.

When \fIwindow\fR is registered as a drag source, and optional \fItype-list\fR
can be provided. This type list can contain one or more types that \fIwindow\fR
will provide during a drag action, and it can contain platform independent or
platform specific types. Platform independent are \fBDND_Text\fR
for dropping text portions and \fBDND_Files\fR for dropping a list of files
(which can contain one or multiple files) on \fIwindow\fR. However, this type
list is indicative/informative. \fIwindow\fR can initiate a drag action with
even a different type list. If \fItype-list\fR is not specified, it defaults to
the empty list.

Finally, \fImouse-buttons\fR is one or more mouse buttons that will be used for
starting the drag action. It can have any of the values "1" (left mouse
button), "2" (middle mouse button - wheel) and "3" (right mouse button).  If
\fImouse-buttons\fR is not specified, it defaults to "1" (left mouse button).
Multiple mouse buttons can be specified as a list of values (i.e. {1 3}).
.TP
\fBtkdnd::drag_source unregister\fI window\fR
This command will stop \fIwindow\fR from being a drag source.
Thus, \fIwindow\fR will stop receiving events related to drag operations.
It is an error to use this command for a \fIwindow\fR that has not been
registered as a drag source with \fBtkdnd::drag_source register\fR.
.TP
\fBtkdnd::platform_specific_types \fItype-list\fR
This command will accept a list of types that can contain platform independent
or platform specific types. A new list will be returned, where each platform
independent type in \fItype-list\fR will be substituted by one or more platform
specific types. Thus, the returned list may have more elements than
\fItype-list\fR.
.TP
\fBtkdnd::platform_independent_types\fI type-list\fR
This command will accept a list of types that can contain platform independent
or platform specific types. A new list will be returned, where each platform
specific type in \fItype-list\fR will be substituted by one or more platform
independent types. Thus, the returned list may have more elements than
\fItype-list\fR.
.TP
\fBtkdnd::GetDropFileTempDirectory\fR
This command will return the temporary directory used by TkDND for storing
temporary files. When the package is loaded, this temporary directory will be
initialised to a proper directory according to the operating system. This
default initial value can be changed to be the value of the following
environmental variables: \fBTKDND_TEMP_DIR\fR, \fBTEMP\fR, \fBTMP\fR.
.TP
\fBtkdnd::SetDropFileTempDirectory \fIdirectory\fR
This command will change the temporary directory used by TkDND for storing
temporary files to \fIdirectory\fR.
.SH SUPPORTED TYPES
In order to declare the format that the data that will transferred during
a drag and drop operation, all drag and drop protocols use the notion of types.
Unfortunately, each protocol defines its own, usually platform specific, types. TkDND, trying to maintain portability among different platforms, offers some
predefined types for some basic kinds of data, like text, and filenames.
Currently, the following predefined cross-platform values are available:
.IP  \fBDND_Text\fR: 5
This type can be used for transferring textual data. Internally, it is
translated to the following platform specific formats:
.br
Windows: \fBCF_UNICODETEXT\fR, \fBCF_TEXT\fR.
.br
Unix: \fBtext/plain;charset=UTF-8\fR, \fBtext/plain\fR.
.br
Mac: \fBNSStringPboardType\fR.
.IP  \fBDND_Files\fR: 5
This type can be used for transferring a list of file names.
Internally, it is translated to the following platform specific formats:
.br
Windows: \fBCF_HDROP\fR.
.br
Unix: \fBtext/uri-list\fR.
.br
Mac: \fBNSFilenamesPboardType\fR.
.TP
Additionally to the platform independent types, TkDND supports the following platform specific types:
.IP  \fBWindows\fR: 5
\fBCF_UNICODETEXT\fR: Text transfer encoded in Unicode.
.br
\fBCF_TEXT\fR: Text transfer with application dependent encoding. If an encoding
locale is specified through CF_LOCALE it is used, else the system encoding is
used for the conversion.
.br
\fBFileGroupDescriptor - FileContents\fR: These two types are used for
transferring a set of files that do not appear physically on disk, like files
from compressed folders or Outlook e-mail messages. File names are transferred as
in the CF_TEXT type, while file contents are transferred in binary. TkDND
retrieves both the file names and the file contents, and saves then in a
temporary directory. When the transfer is complete, the file names of the saved
files in the temporary folder are returned. Note that TkDND support this type
pair only as drop targets and not as drag sources.
.br
\fBFileGroupDescriptorW - FileContents\fR: These two types are used for
transferring a set of files that do not appear physically on disk, like files
from compressed folders or Outlook e-mail messages. File names are transferred as
in the CF_UNICODETEXT type, while file contents are transferred in binary. TkDND
retrieves both the file names and the file contents, and saves then in a
temporary directory. When the transfer is complete, the file names of the saved
files in the temporary folder are returned. Note that TkDND support this type
pair only as drop targets and not as drag sources.
.br
\fBCF_HDROP\fR: Files transfer encoded in UTF-8.
.IP  \fBUnix\fR: 5
.PP
Finally, format types used for drop types can have \fBwildcards\fR, following
the same rules as "string match". For example, registering a drop target with
the type "*", will accept any drop, no matter what the drop format is.
.SH EVENTS
Windows registered as either drop targets or drag sources, will receive certain
events, during drag and drop operations. As a result, the windows are expected
to have bindings for some of these events. Some events are mandatory (in the
sense that a drag or drop operation can be stopped if the bindings do not
exist), while others are not. However, it is a good practice to define bindings
for all events, so as the application will behave as expected during drag and
drop operations.

The TkDND package defines a set of virtual events, that correspond to various
phases of a drag and drop operation. All windows that are either a drop target
or a drag source are expected to have bindings for (all) these events, created
with the \fBbind\fR Tk command. While these event bindings are regular Tk
events, they have a small difference from plain Tk events: most of them are
expected to return a value. Since Tk bindings cannot return a value, TkDND does
not actually generate these events (i.e. through "event generate"). Instead,
TkDND locates the script that has been bound to the virtual event, and directly
executes it, as a script. Apart from this small difference in how the events are
triggered, the events required by TkDND can be viewed as regular events. In the
following two sections all virtual events defined by the TkDND package are
presented.
.SH DROP TARGET EVENTS
A window registered as a drop target, is expected to have bindings for the
following virtual events:
.TP
\fB<<DropEnter>>\fR:
This event is triggered when the mouse enters the window
during a drop action. The purpose of this event is to change the visual state of
the window, so as to notify the user whether the drop will be accepted or not.
The binding script is expected to return a single value that will define the
drop action. This returned action can be one of \fBcopy\fR, \fBmove\fR,
\fBlink\fR, \fBask\fR, \fBprivate\fR and \fBrefuse_drop\fR. This event is not
mandatory, but if it is defined, it has to return an action. In case an action
is not returned, the drop is refused for this window.
.TP
\fB<<DropPosition>>\fR:
This events is triggered when the mouse moves inside the
window during a drop action. The purpose of this event is to let window decide
if it will accept the drop and the action of the drop, if a drop is going to
happen at the specific mouse coordinates. Thus, the script binding for such an
event can get the mouse coordinates and the pressed modifier buttons (such as
ctrl, shift or alt), and is expected to return the drop action, which again must
be one of \fBcopy\fR, \fBmove\fR,
\fBlink\fR, \fBask\fR, \fBprivate\fR and \fBrefuse_drop\fR. This event is not
mandatory, but if it is defined, it has to return an action. In case an action
is not returned, the drop is refused for this window.
.TP
\fB<<DropLeave>>\fR:
This event is triggered when the mouse leaves outside the
area covered by window, without a drop happening. The binding of such an event
is expected to restore the visual state of the window to normal (i.e. the visual
state the window was in before the <<DropEnter>> event was triggered). The
binding for such an event is not expected to return a value.
.TP
\fB<<Drop>>\fR:
This event is triggered by a drop action, and it is expected to
handle the dropped data and reset the visual state of the window. The binding
script is expected to return a value, which will be the action that has been
performed to the data and must be one of \fBcopy\fR, \fBmove\fR,
\fBlink\fR, \fBask\fR, \fBprivate\fR and \fBrefuse_drop\fR. This event is not
mandatory, but if it is defined, it has to return an action. In case an action
is not returned, the drop is refused for this window.
.TP
\fB<<Drop:\fItype\fB>>\fR:
This event is a specialisation of the generic
<<Drop>> event, augmented with a type. If such a binding exists and the drop
type matches \fItype\fR, this event binding will be executed, instead of the
generic <<Drop>> event binding. These events allow for easy specialisation of
drop bindings, according to the type of the dropped data. \fItype\fR can be
either a platform independent or a platform specific type. The binding script of
such an event is expected to return a value, which will be the action that has
been performed to the data and must be one of \fBcopy\fR, \fBmove\fR,
\fBlink\fR, \fBask\fR, \fBprivate\fR and \fBrefuse_drop\fR. This event is not
mandatory, but if it is defined, it has to return an action. In case an action
is not returned, the drop is refused for this window.
.SH DRAG SOURCE EVENTS
A window registered as a drag source, is expected to have bindings for the
following virtual events:
.TP
\fB<<DragInitCmd>>\fR:
This event is triggered when a drag action is about to start. This is a
mandatory event (whose absence will cancel the drag action), and is responsible
for providing three things: the list of actions and format types supported by
the drag source, and of course the data to be dropped. Thus, the binding script
for such an event must return a list of three elements: the drop actions
supported by the drag source (which can be any of \fBcopy\fR, \fBmove\fR,
\fBlink\fR, \fBask\fR, and \fBprivate\fR), the format type list that the data
can be dropped as (which can be any platform independent or platform specific
type), and finally the data. A simple example of such a binding, is:
.CS
bind .drag_source <<DragInitCmd>> \\
     {list copy DND_Text {Hellow world!}}
.CE
.TP
\fB<<DragEndCmd>>\fR:
This event is triggered when the drag action has finished (either when the drop
was successful or not). Its main purpose is to process the dropped data
according to the drop action returned by the drop target. Binding for such an
event is not mandatory, and the binding is not expected to return a value.
.SH BINDING SCRIPTS AND SUBSTITUTIONS
All bindings scripts defined for any of the virtual events above will be
executed in the same interpreter that was used for creating the window the 
event is bound to, and the binding script will executed at the global
level (i.e. only global variables will be accessible).

If the binding script contains any % characters, then substitutions will be
made, like in normal Tk binding scripts. Valid % specifiers are:
.IP \fB%%\fR 5
Replaced with a single percent. 
.IP  \fB%A\fR 5
The current action of the drag/drop operation.
.IP  \fB%a\fR 5
The action list supported by the drag source. 
.IP  \fB%b\fR 5
The mouse buttons that are pressed during a drag/drop operation. Note that
typically a single mouse button is reported as pressed, even if more than one
mouse buttons are actually pressed. Under Unix though, all pressed mouse
buttons will be reported (if the XKeyboard extension is available - else only
"1" will always be reported).
.IP  \fB%c\fR 5
The codes of the list of types supported by the drag source. All codes are in
octal format and have the same order as the list of types obtained through the
\fB%t\fR substitution.
.IP  \fB%C\fR 5
The code (in octal format) of the current type of the drag and drop operation.
.IP  \fB%CTT\fR 5
The list of types from the drop target type list that are common to the drag
source type list.
.IP  \fB%CST\fR 5
The list of types from the drag source type list that are common to the drop
target type list.
.IP  \fB%D\fR 5
The data that has been dropped. Under some platforms the data will be 
available before the drop has occurred. The format of the data is the current
type of the drop operation.
.IP  \fB%e\fR 5
The name of the current virtual event. One of <<DropEnter>>, <<DropPosition>>,
<<DropLeave>>, <<Drop:\fItype\fR>>, <<Drop>>, <<DragInitCmd>>, <<DragEndCmd>>.
.IP  \fB%L\fR 5
The list of types supported by the drag source.
.IP  \fB%m\fR 5
The list of modifier keyboard keys that are pressed. 
Modifier keys are some special keys, like Shift, Control or Alt. 
Valid modifiers are "shift", "ctrl" and "alt" (under all operating systems),
and "mod1" to "mod5" under Unix. Please note that the usefulness of modifiers
may differ across operating systems. For example, under Windows the drop target
must examine the modifiers, and decide upon the drop action that must be
performed (by selecting an action from the list of actions supported by the
drag source). However, under Unix, the drag source is expected to decide on the
drop action, not the drop target. The drop target is expected to either accept
the action selected by the drag source (and return it back), or select "copy",
"default", or "ask". So, under Unix examining the pressed modifier keys
fulfills only informative purposes.
.IP  \fB%ST\fR 5
The list of types supported by the drag source.
.IP  \fB%t\fR 5
The list of types supported by the drag source.
.IP  \fB%T\fR 5
The current type of the drag and drop operation.
.IP  \fB%TT\fR 5
The list of types supported by the drop target.
.IP  \fB%W\fR 5
The window that the event is delivered to.
.IP  \fB%X\fR 5
The mouse pointer x coordinate, relative to the root window.
.IP  \fB%Y\fR 5
The mouse pointer y coordinate, relative to the root window.
.IP  \fB%x\fR 5
The mouse pointer x coordinate, relative to the drop target window.
.IP  \fB%y\fR 5
The mouse pointer y coordinate, relative to the drop target window.

.SH SPECIFYING DROP TARGETS
Creating drop targets is easy: we have to only register a window as a drop
target with the list of format types it can accept, and add a few bindings. For
example, a window that accepts textual drops can be as follows:
.CS
label .drop_target -text {Text Drop Target!} -bg white
tkdnd::drop_target register .drop_target DND_Text
bind .drop_target <<DropEnter>> {%W configure -bg yellow; list copy}
bind .drop_target <<DropPosition>> {list copy}
bind .drop_target <<DropLeave>> {%W configure -bg white}
bind .drop_target <<Drop>> {%W configure -text %D; %W configure -bg white}
.CE
From the above bindings, none is obligatory. However, we usually want to receive
dropped data (thus the <<Drop>> event must be handled) and we want to give
visual feedback to the users through the <<DropEnter>> and <<DropLeave>> events.
Finally, <<DropPosition>> is only necessary if we want to only accept drops on
specific areas of the window, or we want to change the drop action according to
the pressed modifiers.

Now, if we want to also add the ability to receive file drops, we could add:
.CS
tkdnd::drop_target register .drop_target DND_Files
bind .drop_target <<Drop:DND_Files>> \\
   {puts %D; %W configure -bg white}
.CE
Note that we have added a "specialised" drop binding, for the event
<<Drop:DND_Files>>: this means that when a text portion is dropped over the
window, the <<Drop>> event binding will be executed. But when a list of files is
dropped onto the window, the <<Drop:DND_Files>> event binding will be executed.
If we proceed and define a binding for the <<Drop:DND_Text>> event, the binding
of the "general" <<Drop>> event will never be executed.
.SH SPECIFYING DRAG SOURCES
In order to specify a drag source, we need to register a window as a drag
source:
.CS
tkdnd::drag_source register .text_drag_source
.CE
The above command defines a drag source with an empty type list (and which will
be declared in the <<DragInitCmd>> event binding) and arranges mouse bindings
such as a drag will be started with the left mouse button.
Then, it is absolutely necessary to define a binding for the <<DragInitCmd>>:
this event binding must return the list of actions, the list of format types and
the actual data to be dropped:
.CS
bind .text_drag_source <<DragInitCmd>> \\
     {list {copy move} DND_Text {Hello from Tk!}}
.CE
Please note that all specified format types must be compatible to each other, as
they all characterise the same data.
.SH SPECIFYING DRAG SOURCES WITH MULTIPLE DATA TYPES
In the case the drag source wants to send a set of (incompatible) data types,
the result of the <<DragInitCmd>> event binding must be slightly different, as
it must return two items (instead of three described in the previous paragraph).
The first element is again a list of allowable actions. However, the second item
is a list of "format type" and "data" pairs:
bind .text_drag_source <<DragInitCmd>> \\
     {list {copy move} {DND_Text {Hello from Tk!} DND_Files {/tmp}}}
.CE
And that was all!
.SH BUGS
\fBOS X:\fR
TkDND under OS X is built on top of the Cocoa framework. Thus, it is compatible
with Tk version >= 8.6
.br
.SH KEYWORDS
dnd, drag and drop
