/*
* Copyright 2016 Nu-book Inc.
* Copyright 2016 ZXing authors
* Copyright 2020 Axel Waggershauser
*/
// SPDX-License-Identifier: Apache-2.0

#pragma once

#include "ODRowReader.h"

namespace ZXing::OneD {

/**
* Decodes DataBarExpandedReader (formerly known as RSS) symbols, including truncated and stacked variants. See ISO/IEC 24724:2006.
*/
class DataBarExpandedReader : public RowReader
{
public:
	using RowReader::RowReader;

	BarcodeData decodePattern(int rowNumber, PatternView& view, std::unique_ptr<DecodingState>& state) const override;
};

} // namespace ZXing::OneD
