/* -*- mode: c++; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */

/*
 Copyright (C) 2020 Klaus Spanderen

 This file is part of QuantLib, a free-software/open-source library
 for financial quantitative analysts and developers - http://quantlib.org/

 QuantLib is free software: you can redistribute it and/or modify it
 under the terms of the QuantLib license.  You should have received a
 copy of the license along with this program; if not, please email
 <quantlib-dev@lists.sf.net>. The license is also available online at
 <https://www.quantlib.org/license.shtml>.

 This program is distributed in the hope that it will be useful, but WITHOUT
 ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 FOR A PARTICULAR PURPOSE.  See the license for more details.
*/

/*! \file exponentialfittinghestonengine.cpp
*/

#include <ql/pricingengines/blackcalculator.hpp>
#include <ql/math/integrals/gaussianquadratures.hpp>
#include <ql/math/integrals/gausslobattointegral.hpp>
#include <ql/math/interpolations/lagrangeinterpolation.hpp>
#include <ql/pricingengines/vanilla/exponentialfittinghestonengine.hpp>
#include <functional>

namespace QuantLib {

    namespace {
        const double values4[][129] = {
                { 0.0, 234.8095791713261, 218.0318519353285, 204.6720284850595, 193.1511360370731, 182.8582046914314, 173.4749468364244, 164.8086026551506, 156.7310751326711, 149.1516659000495, 142.0031214899315, 135.2337879495259, 128.8028787692377, 122.6774602685386, 116.8304450513065, 111.2392075244396, 105.8845994688, 100.750231969514, 95.82194001552078, 91.08737561313309, 86.53569334945649, 82.15730377831932, 77.94367743446313, 73.8871872324829, 69.98098037714679, 66.21887325124759, 62.59526440015139, 59.10506191901711, 55.74362241327837, 52.50669934134626, 49.3903990256247, 46.39114297861616, 43.5056354664215, 40.73083544445857, 38.06393216564644, 35.50232389114117, 33.04359923643779, 30.68552076752596, 28.42601052750101, 26.26313722711847, 24.19510487593323, 22.22024266595088, 20.33699594873022, 18.5439181708592, 16.83966365264874, 15.22298111152472, 13.6927078455475, 12.24776450424429, 10.88715038388637, 9.60993919279611, 8.415275239483032, 7.302370002587396, 6.270499046923647, 5.318999254496381, 4.447266343313092, 3.654752650207289, 2.940965156725249, 2.305463739307505, 1.747859626059435, 1.267814040775252, 0.8650370046481092, 0.5392862212279848, 0.290365744018042, 0.11812251209679, 0.02241587414672291, 19.7904730415389, 14.64287849684275, 12.29787550435821, 10.83820345905683, 9.798443299108831, 8.999307532256775, 8.354314484533429, 7.815638985966243, 7.354263948608144, 6.951358017695886, 6.594058135618385, 6.27321659221623, 5.98211240191717, 5.715672861918123, 5.469981785549187, 5.24195701287718, 5.029132122798146, 4.829504600649047, 4.641427702702372, 4.463531827796793, 4.294666286068176, 4.133855463009227, 3.980265333061287, 3.833177538891964, 3.691969085114964, 3.556096255713026, 3.42508174873024, 3.298504289717459, 3.175990175055341, 3.057206332403495, 2.941854584510562, 2.829666875458116, 2.720401272597374, 2.613838598180361, 2.509779575606303, 2.408042398876443, 2.308460652136126, 2.210881520418866, 2.115164243858015, 2.02117877644997, 1.928804617452471, 1.837929789102533, 1.748449938844707, 1.660267547903212, 1.573291230997683, 1.487435114419195, 1.40261828167578, 1.318764277552648, 1.235800662793408, 1.153658612733963, 1.072272554169656, 0.9915798355270596, 0.9115204260895459, 0.8320366406138465, 0.7530728862177118, 0.674575428995979, 0.5964921786168993, 0.5187724907443817, 0.441366991509971, 0.364227443636659, 0.2873067415931395, 0.2105595201900571, 0.1339474500125191, 0.05752803788948557 },
                { 0.05, 234.2683512992485, 217.5652513510042, 204.2608770758455, 192.7849756796624, 182.5300291920975, 173.1795829183935, 164.5420057558895, 156.4899620596637, 148.9332999194404, 141.8051761627553, 135.054255630516, 128.6400062658957, 122.5297019371973, 116.6964275848426, 111.1177028636259, 105.7745035286647, 100.6505476345717, 95.73176333754835, 91.00588445721034, 86.46213794280316, 82.09099875973048, 77.88399510262698, 73.83355176333369, 69.93286283271761, 66.17578724116877, 62.55676228595253, 59.07073147343707, 55.7130838637403, 52.47960273993026, 49.36642189821734, 46.36998821411457, 43.48702941342039, 40.71452618812902, 38.04968796179686, 35.48993173795288, 33.03286356724488, 30.67626225039232, 28.41806495932832, 26.25635451167667, 24.18934807659869, 22.21538712511386, 20.33292846683142, 18.54053623886463, 16.83687473249949, 15.22070195972028, 13.69086387555865, 12.2462891839139, 10.88598466437716, 9.609030965992248, 8.414578821054335, 7.301845638188178, 6.270112439227548, 5.318721108968854, 4.447071930797849, 3.6546213845556, 2.940880185829794, 2.305411548018228, 1.747829649558985, 1.267798287078069, 0.865029684961297, 0.5392833869746307, 0.2903649293765078, 0.11812238095134, 0.02241587037546683, 19.69916274343335, 14.58017388582429, 12.24845416104839, 10.79710829783229, 9.763275690870078, 8.968668805528184, 8.327294608293961, 7.791601365305953, 7.332739711343556, 6.931988251617563, 6.576559758402458, 6.257360936613612, 5.967711123308542, 5.702568297969066, 5.458040145869966, 5.231063435608646, 5.019187002125522, 4.820420803212686, 4.633128420459334, 4.455948896052475, 4.287738847729877, 4.127528894736217, 3.974490372420735, 3.827909567821301, 3.687167536378474, 3.551724117193278, 3.42110514631576, 3.294892133905787, 3.17271385964117, 3.054239476077969, 2.939172808068394, 2.827247608748426, 2.718223586479143, 2.611883057621558, 2.508028110758968, 2.406478191516223, 2.307068035300078, 2.209645889430603, 2.114071977225534, 2.020217165357372, 1.927961802763817, 1.8371947049587, 1.747812262068525, 1.659717652541767, 1.572820147423197, 1.487034492492155, 1.402280357539424, 1.318481843686772, 1.235567041002679, 1.153467629790401, 1.072118519862915, 0.9914575229087829, 0.9114250537247282, 0.8319638566759891, 0.7530187542860148, 0.6745364154297774, 0.596465141400492, 0.5187546697087099, 0.4413559998512321, 0.3642212606638437, 0.2873037066466006, 0.2105583276842426, 0.1339471455650227, 0.05752801551838103 },
                { 0.1, 232.6616279835473, 216.1806101061962, 203.0409996627243, 191.6986529354063, 181.5563838387744, 172.3032201020834, 163.7509038389486, 155.7743725917344, 148.2851042961916, 141.2174782034082, 134.5211079447418, 128.1562179664579, 122.0906985643736, 116.298146028833, 110.7565105958126, 105.4471352263999, 100.3540545689635, 95.46347233134401, 90.76336415475587, 86.24317075960123, 81.89355730823829, 77.70622219186564, 73.673743285077, 69.7894530036334, 66.04733578606166, 62.44194323407706, 58.96832330580525, 55.62196080004967, 52.39872699313946, 49.29483675572285, 46.30681182898199, 43.43144920869808, 40.66579379303607, 38.00711461136637, 35.45288407815874, 33.00075981622926, 30.6485686735149, 28.39429262166695, 26.23605627654957, 24.17211582282957, 22.20084915926591, 20.32074710960723, 18.53040556739845, 16.82851846242974, 15.21387145278349, 13.68533626004034, 12.24186557666808, 10.88248848431603, 9.606306329980236, 8.412489014037567, 7.300271650171452, 6.268951562391603, 5.317885588814585, 4.446487665722357, 3.654226668717093, 2.940624490552334, 2.305254337329934, 1.747739225754234, 1.267750662450325, 0.8650074760724744, 0.5392747280127196, 0.2903624013083418, 0.1181219533036879, 0.02241585257353072, 19.42718031519661, 14.39373856919362, 12.10168617784474, 10.67516752160333, 9.658985192010958, 8.877846847619767, 8.247222882374721, 7.720380243268126, 7.268971531644766, 6.874604276997105, 6.524717945902563, 6.210381807219462, 5.925035571103697, 5.663728737701915, 5.422640138170565, 5.198762903932961, 4.989691255635626, 4.7934722209592, 4.608500040590655, 4.433439396985166, 4.267168565027318, 4.108736621179749, 3.957330758966992, 3.81225099163693, 3.672890336264371, 3.538719121118826, 3.409272433509946, 3.284139987004636, 3.162957872124423, 3.045401787571403, 2.931181445688388, 2.820035916979011, 2.711729731425256, 2.606049594111934, 2.50280160285089, 2.401808878610175, 2.302909537400565, 2.205954946162037, 2.110808216083759, 2.01734289539004, 1.925441830458653, 1.834996169603027, 1.74590448824573, 1.65807201776635, 1.571409963197856, 1.485834897307841, 1.401268220540341, 1.317635677893176, 1.234866925130263, 1.152895137830144, 1.071656657692984, 0.9910906713032496, 0.9111389172047534, 0.8317454177197424, 0.7528562324755021, 0.6744192311673117, 0.5963838838759056, 0.5187010688415302, 0.4413229019707581, 0.3642026077250811, 0.2872945188119721, 0.2105546891305471, 0.1339461934036071, 0.05752793175097446 },
                { 0.11, 232.2162524384619, 215.7969393963619, 202.7030409321226, 191.397711549136, 181.2866519852657, 172.0604207307601, 163.5317009218791, 155.576063633773, 148.1054405720773, 141.0545509713773, 134.3732720695177, 128.0220382826102, 121.9689108315041, 116.1876276645253, 110.656258197417, 105.356246948308, 100.2717160610699, 95.38894534644033, 90.69597719402554, 86.18231130027293, 81.83866527741461, 77.65678443464872, 73.62928883524543, 69.74954900887522, 66.0115839721048, 62.40997681630143, 58.93980427533277, 55.59657752545848, 52.3761920899415, 49.27488518437013, 46.28919918899815, 43.41595020198845, 40.65220083382199, 37.99523656375259, 35.44254510525165, 32.99179832711543, 30.64083635638588, 28.38765355302058, 26.23038609777186, 24.16730097661579, 22.19678617931318, 20.31734195783706, 18.52757301366996, 16.82618150230464, 15.21196075941869, 13.68378966672644, 12.24062758691387, 10.88150980670946, 9.605543435342695, 8.41190371263693, 7.299830686976213, 6.268626228536939, 5.317651347615923, 4.446323791715681, 3.654115898330527, 2.940552683122748, 2.305210145273273, 1.747713772780544, 1.26773722878545, 0.8650011897091167, 0.5392722610651034, 0.2903616705876975, 0.1181218242669378, 0.02241584582606895, 19.35154106463813, 14.34198355580624, 12.06098980763912, 10.64138233650857, 9.630106600767101, 8.852707782336678, 8.22506540237696, 7.700675208959914, 7.251330028477834, 6.858729226452035, 6.510375523693677, 6.197383518048268, 5.913226459415846, 5.652979328440462, 5.412840747865736, 5.189819514926439, 4.981522453993296, 4.786006877980649, 4.601675526455473, 4.427200183101984, 4.261465115508268, 4.10352450287276, 3.952569919109812, 3.807905165755469, 3.668926558475897, 3.53510731582238, 3.405985072399795, 3.281151798989279, 3.160245596452524, 3.042943962516838, 2.928958226710235, 2.81802891947642, 2.709921894143024, 2.604425059986309, 2.501345614664984, 2.400507687290084, 2.301750321153593, 2.20492573895737, 2.109897844218787, 2.016540921084025, 1.924738501578589, 1.834382374761332, 1.745371716621387, 1.657612323094572, 1.571015931451726, 1.485499617661406, 1.400985259258511, 1.317399054841275, 1.234671092636599, 1.152734961669707, 1.071527399990294, 0.9909879751782293, 0.9110587930079389, 0.8316842307227538, 0.752810691899847, 0.6743863804497366, 0.5963610920819143, 0.518686023150645, 0.4413136011678289, 0.3641973566416527, 0.2872919236705703, 0.2105536537528967, 0.1339459162513727, 0.05752790377099955 },
                { 0.12, 231.7306973426709, 215.3787284946245, 202.3346855839198, 191.0697108890286, 180.992663995281, 171.7957778044963, 163.2927643471882, 155.3598870693619, 147.9095733511795, 140.8769136277229, 134.2120728101974, 127.8757143485919, 121.8360858254228, 116.0670795760582, 110.5468948547024, 105.2570867794794, 100.1818727495269, 95.30761540357669, 90.62242975926829, 86.11587966969656, 81.77873979347038, 77.60280646157902, 73.58074561054528, 69.70596920902533, 65.97253386617163, 62.37505690751448, 58.90864635088397, 55.5688420502401, 52.35156589195733, 49.25307938898373, 46.2699473666482, 43.39900669996387, 40.63733926748935, 37.98224844652009, 35.43123859973234, 32.98199710256325, 30.63237853963746, 28.3803907619704, 26.22418254790839, 24.16203265240637, 22.19234006328839, 20.31361531112643, 18.5244727025076, 16.82362336567836, 15.20986901359756, 13.68209634288457, 12.23927199848483, 10.88043804346588, 9.604707881507915, 8.411262586607253, 7.299347600468117, 6.268269763179802, 5.317394647190252, 4.446144168393567, 3.653994451411742, 2.940473928879042, 2.305161656616959, 1.747685827563299, 1.267722465610621, 0.8649942702071622, 0.5392695376379698, 0.2903608586748846, 0.1181216782244361, 0.02241583754145965, 19.26895315898067, 14.28552173950088, 12.0166160357452, 10.60455777328085, 9.598638158106737, 8.82531915292076, 8.20092807044389, 7.67921103784366, 7.23211429612784, 6.841437658071836, 6.494753009152442, 6.183224495529024, 5.900362016042312, 5.641268383750234, 5.402163831605144, 5.180074255502574, 4.972620230859464, 4.777870287588391, 4.594236430331433, 4.420398181076071, 4.255246335126957, 4.097840627784619, 3.947377400696841, 3.803164577122642, 3.664602060348783, 3.531166211367338, 3.402397433400832, 3.277890149805177, 3.15728464515196, 3.040260370832333, 2.926530412161817, 2.815836884332586, 2.707947076909871, 2.602650205917802, 2.499754662421146, 2.399085669374556, 2.300483276166654, 2.203800634027135, 2.108902506238651, 2.01566397560122, 1.923969318356916, 1.833711019188319, 1.744788906252406, 1.657109388728463, 1.570584782218027, 1.48513270967135, 1.400675567432944, 1.317140047580435, 1.234456709040933, 1.152559591058801, 1.071385863499609, 0.9908755092415213, 0.9109710345577617, 0.831617203962762, 0.7527607965213748, 0.6743503811816119, 0.596336109477095, 0.5186695255263004, 0.4413033976271934, 0.3641915911165613, 0.2872890699332362, 0.2105525113543646, 0.1339456073521893, 0.05752787083017166 },
                { 0.13, 231.2055557171608, 214.9265075443152, 201.9364077377117, 190.7150748604367, 180.6747986766232, 171.5096295865167, 163.0343959053259, 155.1261118699219, 147.6977420728276, 140.684779042529, 134.0376991425204, 127.7174136636657, 121.6923717564262, 115.9366326651028, 110.4285359541836, 105.1497562157416, 100.0846137107713, 95.21956049200853, 90.54278995827345, 86.04393518472518, 81.71383236785912, 77.54433286847381, 73.52815209351353, 69.65874669590242, 65.93021381907727, 62.33720770074778, 58.87487009025351, 55.53877176416951, 52.32486303774305, 49.22943162780777, 46.24906656904444, 43.38062714990111, 40.62121603843698, 37.96815592708057, 35.4189691498684, 32.97135982427715, 30.62319814829842, 28.37250654643029, 26.21744740917069, 24.15631221197732, 22.1875118334907, 20.30956792063131, 18.52110517117086, 16.82084442347527, 15.2075964590588, 13.68025643695834, 12.23779889020072, 10.87927322416624, 9.603799664750344, 8.410565611135526, 7.298822353904704, 6.267882124315744, 5.317115444942645, 4.445948755670504, 3.653862292272539, 2.94038819750652, 2.305108846730738, 1.747655371000228, 1.267706358882343, 0.864986707916598, 0.5392665516973914, 0.2903599623190895, 0.1181215138542812, 0.02241582746898052, 19.17948355259108, 14.22441233754043, 11.96861785035503, 10.56474138551776, 9.564622598871919, 8.795719393585581, 8.174845467397608, 7.656018848150667, 7.211352334453601, 6.82275475839255, 6.477873047201147, 6.167925086027893, 5.886460507029955, 5.628612285939991, 5.390624065525563, 5.169540256398702, 4.96299631743444, 4.769072914006101, 4.586192070106135, 4.413041672375099, 4.248519569162852, 4.091691496463721, 3.941758943028201, 3.798034280006218, 3.659921280696013, 3.52689969461212, 3.398512909342835, 3.274357991058142, 3.154077576697762, 3.037353221615922, 2.92389990151776, 2.813461437462516, 2.705806664740203, 2.600726205537063, 2.498029734983669, 2.397543652904478, 2.299109091134843, 2.202580199927782, 2.107822667679784, 2.014712436658394, 1.923134584132339, 1.832982343677191, 1.744156245750631, 1.656563360126404, 1.570116625617606, 1.484734254841812, 1.400339203686604, 1.316858696705817, 1.234223800978555, 1.152369042045873, 1.071232056445205, 0.9907532761243124, 0.9108756406648503, 0.8315443338113144, 0.752706541324972, 0.6743112277411056, 0.5963089303915761, 0.5186515706338914, 0.4412922865980435, 0.3641853071318769, 0.2872859543946207, 0.2105512595773298, 0.1339452652062796, 0.05752783228494211 },
                { 0.14, 230.6414649218037, 214.4408463274901, 201.5087167936979, 190.3342587412925, 180.3334627321054, 171.2023391449009, 162.7569194440711, 154.8750266183074, 147.4702036074696, 140.4783755710095, 133.8503537886942, 127.5473159188929, 121.5379276356985, 115.7964273894569, 110.3013053244945, 105.0343641982676, 99.98003457511685, 95.12486435813421, 90.45713094456974, 85.96654157347579, 81.64399835821803, 77.48141159487218, 73.47154966445074, 69.60791706410222, 65.88465433538213, 62.29645523514303, 58.83849762695918, 55.50638539582575, 52.29609929776016, 49.20395511096763, 46.22656779915999, 43.36082066030145, 40.60383863664753, 37.95296511960832, 35.40574170670875, 32.95989046580359, 30.61329833971262, 28.36400338704162, 26.21018260552144, 24.15014112529753, 22.1823025932041, 20.30520059668286, 18.51747099883878, 16.81784507509266, 15.20514335772299, 13.67827010786827, 12.23620834574686, 10.87801537931689, 9.602818779641527, 8.409812758087437, 7.298254906362556, 6.267463265452453, 5.316813693869799, 4.445737509386521, 3.653719381636075, 2.940295455661936, 2.305051688533101, 1.747622382091947, 1.267688893163767, 0.8649784922302243, 0.5392632966108557, 0.2903589779469078, 0.1181213297033522, 0.0224158153330159, 19.08320391642864, 14.15871913813403, 11.91705237375121, 10.52198441317081, 9.528105934136977, 8.763949850159882, 8.146854764343773, 7.631132065623551, 7.189074201631587, 6.80270755210053, 6.459759925814178, 6.151507105562575, 5.871541513523562, 5.6150285943034, 5.378237179042147, 5.158231590605837, 4.952663287361131, 4.759625974047038, 4.577552435282827, 4.405139537055515, 4.241292695595099, 4.085084082700355, 3.935720704999384, 3.792519699886956, 3.654888985939944, 3.522311940766808, 3.394335146107427, 3.270558495714352, 3.150627142525767, 3.034224891531106, 2.921068739164371, 2.81090432953993, 2.703502149533598, 2.598654323561634, 2.496171898391954, 2.395882530895678, 2.297628509077449, 2.201265050287998, 2.1066588311578, 2.013686712187412, 1.922234626603005, 1.832196608421631, 1.743473938962759, 1.655974394513965, 1.569611580681059, 1.48430434125903, 1.399976231353304, 1.316555046041933, 1.233972397162181, 1.152163331880488, 1.071065987603794, 0.9906212785468063, 0.9107726099137532, 0.8314656162152271, 0.7526479207614809, 0.6742689139296987, 0.5962795485842465, 0.5186321526062568, 0.4412802628574265, 0.3641785002711059, 0.2872825735315448, 0.2105498958303241, 0.1339448881650269, 0.05752778742787002 },
                { 0.15, 230.0391049693341, 213.9223527523978, 201.0521560352823, 189.9277478905308, 179.9690895725498, 170.8742932690923, 162.4606798860664, 154.6069386234182, 147.2272314632837, 140.2579463462843, 133.6502525900747, 127.365612443281, 121.3729227885117, 115.6466133370405, 110.1653348651798, 104.9110267914833, 99.86823724845986, 95.0236162660659, 90.36553071231763, 85.88376680038949, 81.56929681982146, 77.41409379847244, 73.41098249577976, 69.55351832254043, 65.83588799968636, 62.25282733484633, 58.79955261984288, 55.47170297124281, 52.26529154063378, 49.17666397308649, 46.20246283372799, 43.33959698315193, 40.58521508352736, 37.93668257379662, 35.39156157520033, 32.94759328554429, 30.60268249806518, 28.35488394289701, 26.2023901993393, 24.14352096792773, 22.17671352466495, 20.30051420719249, 18.51357080535008, 16.81462574739659, 15.20250998888349, 13.67613752435204, 12.23450045312956, 10.87666453989487, 9.601765218667083, 8.409003995682697, 7.297645212461361, 6.267013135375551, 5.316489342362331, 4.445510381141892, 3.653565676500635, 2.94019566686335, 2.304990152404477, 1.747586837875782, 1.267670051576446, 0.8649696115505851, 0.5392597651265709, 0.290357901651171, 0.118121124182755, 0.02241580083219161, 18.98019037935728, 14.08851037205215, 11.86198075452834, 10.47634167767463, 9.489137346975825, 8.730054677557076, 8.116995623399392, 7.604586328821796, 7.165311924977296, 6.781324818950295, 6.440439499321828, 6.133993769558746, 5.855625867877673, 5.600535987372471, 5.36501990295005, 5.146163226973582, 4.941634515458227, 4.749541400586272, 4.568328154800041, 4.396701225544197, 4.23357410047323, 4.07802581213023, 3.929269246601026, 3.786626617539501, 3.649510256481646, 3.517407401781041, 3.389868032787259, 3.266495049805698, 3.146936280080388, 3.030877919013718, 2.918039109601583, 2.808167432048388, 2.701035126846117, 2.596435913174055, 2.494182293746349, 2.394103259646554, 2.296042325993264, 2.199855842748292, 2.105411535537484, 2.012587239690273, 1.921269797328675, 1.831354092633755, 1.742742204678392, 1.65534266066125, 1.56906977517872, 1.483843063460833, 1.399586718376463, 1.316229142562828, 1.233702528317691, 1.151942478960311, 1.070887666259639, 0.9904795192793449, 0.9106619406286305, 0.8313810466659356, 0.7525849287201719, 0.6742234329474929, 0.5962479572207776, 0.5186112650243944, 0.4412673206936825, 0.3641711657054043, 0.2872789234920429, 0.2105484172799556, 0.1339444744258179, 0.05752773548540226 },
                { 0.16, 229.3991967504013, 213.3716712586835, 200.5673011535784, 189.4960563836444, 179.5821380629443, 170.5259013258719, 162.1460421920341, 154.3221729863985, 146.9691149498521, 140.0237485342227, 133.437623846436, 127.1725056205827, 121.1975363417056, 115.4873487774015, 110.0207641558633, 104.779866843894, 99.74932961915158, 94.91591074534967, 90.26807188009928, 85.79568288172678, 81.48979034881968, 77.34243372253739, 73.34649744040515, 69.49559080089656, 65.78394939860664, 62.20635354426125, 58.75806019961367, 55.43474577000315, 52.23245769728139, 49.1475732441362, 46.17676419968323, 43.31696649498821, 40.56535391676503, 37.91931526281321, 35.37643440465321, 32.93447281924071, 30.59135422847981, 28.34515104691676, 26.19407238780205, 24.13645341819026, 22.17074588684232, 20.29550967590336, 18.50940524981637, 16.81118689361217, 15.19969664830878, 13.67385886422978, 12.23267530406761, 10.87522073683864, 9.600638971796718, 8.408139288129986, 7.296993222053335, 6.266531677884826, 5.316142333982044, 4.445267318110915, 3.653401129986147, 2.940088791366062, 2.304924206089452, 1.747548713351239, 1.267649815746, 0.8649600532527356, 0.5392559493501708, 0.2903567291783679, 0.1181208955626952, 0.022415783638401, 18.87052325562726, 14.01385858026008, 11.8034680551534, 10.42787147135685, 9.447769081985702, 8.694080730934531, 8.085310092333857, 7.576419388724446, 7.140099406522726, 6.75863700592011, 6.419939107425561, 6.115409618767028, 5.838735586345182, 5.585154202128126, 5.35098991482758, 5.133350981426626, 4.929924134343055, 4.73883180417147, 4.558530463212251, 4.387736728979779, 4.225372652024815, 4.070524539733082, 3.922411509454692, 3.780361152274783, 3.643790472343337, 3.512190794104022, 3.385115691305016, 3.262171243672419, 3.143008105467863, 3.027314998144081, 2.914813332362425, 2.805252733095354, 2.698407292463813, 2.594072413235902, 2.492062134958762, 2.392206856934921, 2.294351389425711, 2.198353277827594, 2.104081355044066, 2.011414485547118, 1.920240471195392, 1.830455094132224, 1.741961276314355, 1.654668338641328, 1.568491345435483, 1.483350522293844, 1.399170737197784, 1.315881036303881, 1.233414227112757, 1.151706502771941, 1.070697102154292, 0.9903280010987441, 0.9105436308346464, 0.8312906201649672, 0.7525175584977164, 0.674174777365378, 0.5962141488488545, 0.5185889008957305, 0.4412534538877875, 0.3641632981780503, 0.2872750000830264, 0.2105468208418183, 0.1339440220262363, 0.05752767561537465 },
                { 0.17, 228.7225001790445, 212.789481148069, 200.0547587005316, 189.0397255814827, 179.1730912074467, 170.1575940601193, 161.8133902746289, 154.021071622994, 146.6961583030819, 139.7760525541424, 133.2127076252307, 126.9682082797711, 121.0119566881138, 115.3188001930629, 109.8677400478178, 104.6410136335696, 99.62342525152293, 94.80184732709602, 90.16484146466691, 85.70236569238415, 81.40554491799676, 77.26648855687007, 73.27814391456443, 69.4341770513547, 65.72887503875186, 62.15706505991066, 58.71404691252772, 55.39553627892383, 52.19761672302556, 49.11669881860684, 46.14948514920705, 43.29294017680173, 40.544264174237, 37.90087057047263, 35.36036617856374, 32.92053387193312, 30.57931735068697, 28.33480770087437, 26.18523149898256, 24.1289402541033, 22.1644010130244, 20.29018798048118, 18.50497502910148, 16.8075289921013, 15.19670364724971, 13.67143431358835, 12.23073299331459, 10.87368400047914, 9.599440026002927, 8.407218595217707, 7.296298879874684, 6.266018831498026, 5.31577260721172, 4.44500826283268, 3.653225691161743, 2.939974786023228, 2.304853814586949, 1.74750798139631, 1.267628165741117, 0.8649498036424417, 0.5392518407185631, 0.2903554559145266, 0.1181206419667243, 0.02241576339571182, 18.75428676001033, 13.93484047891824, 11.74158313562581, 10.37663544161037, 9.4040563289504, 8.656077450906449, 8.051842493495954, 7.546671003015865, 7.113472323743679, 6.734676134998395, 6.398287490308839, 6.095780441708619, 5.820893798689587, 5.568903970489942, 5.336165782036022, 5.119811466060176, 4.91754698918379, 4.72751043298502, 4.548171165418714, 4.378256548276886, 4.216697673641281, 4.0625885263475, 3.915154796487767, 3.773729744430931, 3.637735298156709, 3.506667085877088, 3.38008246554195, 3.257590862783532, 3.13884590574768, 3.023538972210548, 2.911393856670614, 2.802162333005242, 2.695620438790748, 2.591565345347084, 2.489812706374939, 2.390194400109073, 2.292556596941291, 2.196758097719249, 2.102668898317259, 2.010168944278062, 1.919147045843017, 1.829499928900546, 1.741131401575072, 1.653951619569363, 1.567876436129984, 1.482826824757903, 1.398728364635348, 1.315510780264691, 1.233107528077852, 1.151455423825126, 1.070494305430483, 0.9901667267393989, 0.9104176782146526, 0.8311943311851579, 0.7524458027633169, 0.6741229390937477, 0.5961781153703389, 0.5185650526297054, 0.4412386556923957, 0.3641548919870066, 0.2872707987564334, 0.2105451031702853, 0.1339435288375466, 0.0575276069042073 },
                { 0.18, 228.0098122681967, 212.176494848409, 199.5151644775054, 188.5593226385494, 178.7424547790791, 169.7698223458318, 161.4631258680237, 153.7039922467788, 146.4086797756754, 139.5151412692582, 132.9757550443313, 126.7529430622896, 120.8163809306661, 115.1411417930969, 109.7064162400027, 104.49460250007, 99.49064306758217, 94.68153026980907, 90.0559306457339, 85.60389476493709, 81.31662970579748, 77.18631829297632, 73.20597377567278, 69.36932174604581, 65.67070326102068, 62.10499465916238, 58.66754066140397, 55.35409814348788, 52.1607885578059, 49.08405742308011, 46.12063963343707, 43.26752959283395, 40.52195537698858, 37.88135627764259, 35.34336320380453, 32.90578150939742, 30.56657589226121, 28.32385707006673, 26.17586998765118, 24.12098335007191, 22.15768030820257, 20.28455015043596, 18.50028087615868, 16.80365254502034, 15.1935313113444, 13.66886406587819, 12.22867361790569, 10.87205435990598, 9.59816836472351, 8.40624187185622, 7.295562125155331, 6.265474529118977, 5.315380095174676, 4.444733152976545, 3.653039304852471, 2.939853604129647, 2.304778940027158, 1.7474646126737, 1.267605080005205, 0.8649388479093563, 0.5392474299706391, 0.290354076869402, 0.118120361365295, 0.02241573971914214, 18.6315687121555, 13.85153682316014, 11.67639853399739, 10.32269847029851, 9.358057101020557, 8.616096743177399, 8.016639307409343, 7.515382825454037, 7.085468025845606, 6.709475707008951, 6.375514700241536, 6.075133194030205, 5.802124675078719, 5.551806953416574, 5.320566902619342, 5.105562036388538, 4.90451859082647, 4.715591131375187, 4.537262600131891, 4.368271662080129, 4.207558915886133, 4.054226414325718, 3.907506750852755, 3.766739137201603, 3.631350667571639, 3.500841483620657, 3.37477291002686, 3.252757878176569, 3.134453130895683, 3.019552826991229, 2.907783255857431, 2.798898439707939, 2.692676451064217, 2.588916310759972, 2.48743536027551, 2.38806702407819, 2.29065889452494, 2.195071085018768, 2.101174807409547, 2.00885113775966, 1.917989941055932, 1.82848893061553, 1.74025284208872, 1.653192705322033, 1.567225200077632, 1.482272083837108, 1.398259681750493, 1.315118430302444, 1.232782467519042, 1.151189263579774, 1.070279286569614, 0.9899956988386574, 0.9102840800606974, 0.8310921736271853, 0.7523696535196068, 0.6740679093474155, 0.5961398480100538, 0.5185397120104015, 0.4412229188083511, 0.3641459409653828, 0.2872663145937123, 0.2105432606470783, 0.1339429925573953, 0.05752752836376374 },
                { 0.19, 227.2619651450133, 211.5334561191035, 198.9491818662498, 188.0554389571453, 178.2907559000601, 169.3630558929896, 161.0956673584397, 153.3713073180557, 146.1070106975396, 139.2413091508484, 132.7270275318048, 126.5269417692306, 120.6110143089414, 114.954555011347, 109.5369528416676, 104.3407744646133, 99.35110701842512, 94.5550682762194, 89.94143452290621, 85.50035308182604, 81.22311691938242, 77.10198557403748, 73.13004119566904, 69.30107157060144, 65.60947415154805, 62.05017662607673, 58.61857064417673, 55.31045611717536, 52.12199408460669, 49.04966658229239, 46.09024227490299, 43.24074686829964, 40.49843751131759, 37.86078054790031, 35.32543209918907, 32.89022104906088, 30.55313408142479, 28.31230247762313, 26.16599043077692, 24.11258467332711, 22.150585246244, 20.27859726486546, 18.49532355821668, 16.79955807684876, 15.19017997941273, 13.66614832091486, 12.22649727632246, 10.87033184226224, 9.596823967262388, 8.405209067566743, 7.294782891182693, 6.264898697666379, 5.314964725320996, 4.444441921079687, 3.652841911423014, 2.939725195246981, 2.30469954153385, 1.747418575525925, 1.267580535279963, 0.8649271700746597, 0.5392427071145232, 0.2903525866587973, 0.1181200515685573, 0.02241571219329182, 18.50246023181404, 13.7640322711132, 11.60799034449924, 10.26612854884226, 9.309832107777565, 8.574192852963215, 7.979749051426092, 7.482598290731958, 7.056125426029232, 6.683070601895344, 6.351652010087264, 6.05349591515865, 5.782453350626105, 5.533885672955239, 5.304213444412607, 5.090620737025644, 4.890855067546019, 4.703088297177014, 4.525817602279301, 4.357793493776763, 4.19796652767164, 4.04544720245367, 3.899475334197667, 3.759396357891845, 3.624642767160747, 3.494719418478304, 3.369191778237175, 3.247676436558812, 3.129833385472977, 3.01535968378115, 2.903984221559442, 2.795463363939627, 2.689577303410086, 2.586126987158123, 2.484931514263008, 2.385825919207282, 2.288659274895894, 2.193293061385755, 2.09959975673019, 2.007461614396765, 1.916769598117202, 1.827422450145789, 1.739325873018825, 1.652391808236718, 1.566537797996858, 1.481686418316829, 1.397764773702823, 1.314704045015078, 1.232439083421895, 1.15090804436513, 1.07005205632226, 0.9898149198759017, 0.9101428332198392, 0.8309841407709405, 0.7522891020588814, 0.6740096786063385, 0.596099337280843, 0.5185128701659116, 0.4412062353584084, 0.3641364384595806, 0.2872615422884698, 0.2105412893684859, 0.1339424107016512, 0.0575274389278396 },
                { 0.2, 226.47982401593, 210.8611382058592, 198.3575001091763, 187.528688593739, 177.8185415787847, 168.9377819159219, 160.7114485808957, 153.023402963303, 145.7914945105802, 138.9548614201518, 132.4667960663075, 126.29044469162, 120.3960696109642, 114.7592279917348, 109.3595159236318, 104.1796758402983, 99.20494574690431, 94.42257420243083, 89.8214518658562, 85.39182686160515, 81.12508161247325, 77.01355554031961, 73.05040253037279, 69.22947511422976, 65.54522944962887, 61.99264667463488, 58.56716729018637, 55.26463600884818, 52.08125508621581, 49.01354458377234, 46.05830833874893, 43.21260466608071, 40.47372100998692, 37.83915191245382, 35.3065797834171, 32.87385805039709, 30.5389963394134, 28.30014739844578, 26.15559552271811, 24.10374628010271, 22.14311736684208, 20.27233045000946, 18.490103874804, 16.79524613277911, 15.18665000213112, 13.66328728377712, 12.22420406756757, 10.86851647196129, 9.595406808122581, 8.404120125911449, 7.293961104814759, 6.264291257659194, 5.314526419076939, 4.444134494253836, 3.652633446535993, 2.939589505008455, 2.304615575070562, 1.747369835858149, 1.267554506520013, 0.864914752932588, 0.5392376613910035, 0.2903509794848253, 0.1181197102183145, 0.02241568037081466, 18.36705542666508, 13.67241524967234, 11.53643809399611, 10.20699664940916, 9.259444623531163, 8.530422234562364, 7.941222153832602, 7.448362495251581, 7.025484890167466, 6.655496975894688, 6.32673181913161, 6.030897642653077, 5.761905847951756, 5.515163442582954, 5.287126282671153, 5.075006246078609, 4.876573115672135, 4.690016838044938, 4.513849464533599, 4.346833877737632, 4.187931026750569, 4.03626022026206, 3.891068804394565, 3.751708698691946, 3.617618019895692, 3.488306532081052, 3.363344010564186, 3.24235085011252, 3.124990420035, 3.010962792192385, 2.899999557718801, 2.791859514272881, 2.686325054751311, 2.583199125309448, 2.482302648542153, 2.383472329121902, 2.286558775747701, 2.191424886142364, 2.097944451936359, 2.0060009482505, 1.915486479126359, 1.826300855020131, 1.738350782650852, 1.65154915078985, 1.565814398257896, 1.481069952585927, 1.397243729592543, 1.314267685613478, 1.23207741534577, 1.15061178929041, 1.069812625631012, 0.9896243921047044, 0.9099939340336802, 0.8308702252211995, 0.7522041389141746, 0.673948236571707, 0.5960565729445126, 0.5184845175341057, 0.4411885968578708, 0.3641263773048818, 0.287256476127092, 0.2105391851310909, 0.1339417805952952, 0.05752733744824241 },
                { 0.21, 225.6642850913903, 210.1603419527182, 197.7408325458079, 186.979706623937, 177.3263772094816, 168.4945037688634, 160.310917587491, 152.6606778700643, 145.462485782343, 138.6561131720198, 132.1953404016938, 126.0436999269892, 120.1717665730368, 114.5553550630825, 109.1742770603398, 104.011457834189, 99.05229224309717, 94.28416476068503, 89.69608485883537, 85.27840534016932, 81.02260149874632, 76.92109567064175, 72.96711618535955, 69.15458275672301, 65.47801245294481, 61.93244186960478, 58.51336219440789, 55.2166646283412, 52.03859420042934, 48.97571044113622, 46.02485370280091, 43.18311616242956, 40.44781673259039, 37.81647925434104, 35.28681346240522, 32.85669830479821, 30.52416727239765, 28.28739545277274, 26.14468807009165, 24.09447031153805, 22.1352782722323, 20.26575087660294, 18.48462265560009, 16.79071727695713, 15.18294174057733, 13.66028116359189, 12.22179409014105, 10.86660826981767, 9.59391685626441, 8.402974983858702, 7.293096685937171, 6.263652122754039, 5.314065091453639, 4.443810793857901, 3.652413840882184, 2.939446474900883, 2.304526993268939, 1.74731835700744, 1.267526966797659, 0.8649015779852044, 0.53923228123274, 0.290349249113893, 0.1181193347790529, 0.02241564377071446, 18.22545107455863, 13.57677782357095, 11.46182461744768, 10.14537659258388, 9.206960351179208, 8.4848434164343, 7.901110823804698, 7.412722074236508, 6.993588122332911, 6.626792156038337, 6.300787556655223, 6.007368324656391, 5.740508998137126, 5.495664296183906, 5.269326936533261, 5.058737818535526, 4.861689949340546, 4.676392127018427, 4.501371898164917, 4.335405024955294, 4.177463269668895, 4.026675101853653, 3.882295692832906, 3.743683697059477, 3.610283068270842, 3.481608662094844, 3.357234721994369, 3.236785586046647, 3.119928122315183, 3.006365522754711, 2.89583217440798, 2.788089391993074, 2.682921844582712, 2.580134545603708, 2.479550303100675, 2.381007548427828, 2.284358477915941, 2.189467454810603, 2.096209628772762, 2.00446973812297, 1.914141066280923, 1.825124528865535, 1.737327871953266, 1.650664965253746, 1.565055176613291, 1.480422816423333, 1.396696642289276, 1.313809415781846, 1.23169750430764, 1.150300522146088, 1.069561005544897, 0.9894241174773553, 0.9098373782709644, 0.8307504188469946, 0.7521147538046295, 0.6738835721169095, 0.5960115439682174, 0.5184546438244123, 0.4411699941818185, 0.3641157497982083, 0.2872511099671251, 0.2105369434158507, 0.1339410993622587, 0.05752722269041953 },
                { 0.22, 224.8162734801413, 209.4318938791271, 197.0999148121556, 186.4091474723611, 176.8148450405495, 168.0337395543821, 159.8945353925278, 152.2835421621755, 145.1203492029558, 138.3453884843304, 131.9129482794115, 125.7869626853887, 119.9383312703714, 114.3431362058579, 108.9814128647754, 103.8362761430444, 98.89328349409396, 94.13996021703189, 89.56543884060862, 85.16018054786273, 80.91575676152269, 76.82467562051759, 72.88024247885417, 69.07644655279897, 65.40786792041545, 61.86960054529743, 58.4571880498131, 55.16656973040882, 51.9940348738128, 48.9361838561218, 45.98989482653575, 43.15229502171908, 40.4207359450937, 37.79277179191724, 35.26614061600485, 32.83874782492051, 30.50865166295212, 28.27405039935215, 26.13327098630821, 24.084758989293, 22.12706962365993, 20.25885975701431, 18.47888075809995, 16.78597209055958, 15.1790555646337, 13.65713017219549, 12.21926744090839, 10.86460725208339, 9.592354074281239, 8.401773571076604, 7.292189546858355, 6.262981199229472, 5.313580650610727, 4.443470735132846, 3.652183019879614, 2.939296042021569, 2.30443374523731, 1.747264099596997, 1.267497887196714, 0.8648876253696917, 0.5392265542188009, 0.2903473888521654, 0.1181189225279436, 0.02241560187644612, 18.07774630208296, 13.47721556931611, 11.38423593299939, 10.08134491185166, 9.152447281931768, 8.437516862132104, 7.859468917609185, 7.375725075614343, 6.960478047621006, 6.596994532421861, 6.273853583679037, 5.982938730849978, 5.718290360449231, 5.475412916006526, 5.250837504627527, 5.041835228926555, 4.846223249617788, 4.662229957539601, 4.48839899340726, 4.323519488246126, 4.166574421323614, 4.016701759370416, 3.873164781383028, 3.7353291157986, 3.602644757149151, 3.474631827513519, 3.35086918955829, 3.230985255937189, 3.114650508217329, 3.001571359344154, 2.891485081500583, 2.784155585838019, 2.679369888625017, 2.576935134484117, 2.476676074797862, 2.378432920350856, 2.282059503477159, 2.187421697590722, 2.094396051861007, 2.002868606599238, 1.912733861121648, 1.823893870814353, 1.736257454112422, 1.649739493331077, 1.564260315909212, 1.479745144768011, 1.396123608246374, 1.313329301525271, 1.231299392654522, 1.149974267294944, 1.06929720712453, 0.9892140975609697, 0.9096731610525102, 0.8306247127140115, 0.7520209355745544, 0.6738156732328184, 0.5959642384758015, 0.5184232379751878, 0.4411504175285623, 0.3641045476677507, 0.2872454372131752, 0.2105345593703527, 0.1339403639140996, 0.05752709332858586 },
                { 0.23, 223.9367410628836, 208.6766442295951, 196.4355030095937, 185.8176832136345, 176.2845426175128, 167.556020710315, 159.4627746997427, 151.8924162601789, 144.765458569781, 138.0230195171272, 131.6199146322062, 125.5204945879533, 119.6959955012457, 114.1227765132063, 108.7811045182717, 103.6542905444416, 98.72806012959568, 93.99008408516594, 89.4296220408691, 85.03724708335268, 80.80462986048609, 76.72436705757138, 72.789843502131, 68.99512011417036, 65.33484197298704, 61.8041622224597, 58.39867857805691, 55.11437995717163, 51.94760131412632, 48.89498517943723, 45.95344871900382, 43.12015537027284, 40.39249029856964, 37.76803906163873, 35.24456898410713, 32.82001283349686, 30.49245446106143, 28.26011612821457, 26.12134728575817, 24.07461461085948, 22.11849313758345, 20.25165834215333, 18.47287906507752, 16.78101116969591, 15.17499185123597, 13.65383452265938, 12.21662421384966, 10.86251342938012, 9.59071841748411, 8.400515809147283, 7.291239591636091, 6.262278385411459, 5.31307299737002, 4.443114226794723, 3.651940903338177, 2.939138138807375, 2.304335776347387, 1.747207021373733, 1.267467236694208, 0.8648728737773591, 0.5392204670240215, 0.2903453915182382, 0.1181184705437089, 0.02241555413380089, 17.92404226146205, 13.37382745556295, 11.3037611172513, 10.01498071516799, 9.095975551171164, 8.388504827425392, 7.816351801448033, 7.337420831102496, 6.926198692717156, 6.566143448688946, 6.245965093309525, 5.957640362314294, 5.695278141206582, 5.454434559940437, 5.231680600132094, 5.024318713533177, 4.830191113243446, 4.647546498137744, 4.474945179526993, 4.311190127179865, 4.155275924266784, 4.006350356221638, 3.863685079133015, 3.726652922924035, 3.594710116403638, 3.467382213758503, 3.344252839597701, 3.224954604897614, 3.109161712650379, 2.996583891466435, 2.886961382209634, 2.78006076661755, 2.675671474370991, 2.573602840782708, 2.473681614367929, 2.375749834301696, 2.279663013782379, 2.185288577782768, 2.092504513439836, 2.001198199046962, 1.911265383741364, 1.822609294880194, 1.735139854040483, 1.648772985766058, 1.563430005776532, 1.479037077471235, 1.395524727299619, 1.312827411003431, 1.230883123923469, 1.149633049551877, 1.069021241337079, 0.9889943334442974, 0.9095012767676601, 0.8304930970092632, 0.7519226721254782, 0.6737445269667845, 0.5959146436935463, 0.5183902881061944, 0.4411298563789131, 0.3640927620391272, 0.2872394507900605, 0.2105320277890498, 0.1339395709373898, 0.05752694794029763 },
                { 0.24, 223.026664354869, 207.8954650031833, 195.7483718495739, 185.2060018505248, 175.7360812064323, 167.0618905807673, 159.0161186168433, 151.4877297317052, 144.3981957641115, 137.6893456053678, 131.3165407825864, 125.2445629610542, 119.4449961673314, 113.8944856485702, 108.5735372972037, 103.4656644849953, 98.55676606476859, 93.83466281765279, 89.28874531416171, 84.90970188512591, 80.68930533613836, 76.62024349481008, 72.69598297789425, 68.91065848972275, 65.25898199266164, 61.73616752354092, 58.33786845867068, 55.06012477920104, 51.89931844151493, 48.85213537049713, 45.9155329057542, 43.08671176930538, 40.36309180714299, 37.74229090014739, 35.22210655213116, 32.80049975160672, 30.47558077464989, 28.2455966530273, 26.10892007763131, 24.06403954455169, 22.10955058159602, 20.24414791813132, 18.46661848183115, 16.7758351231181, 15.17075098245307, 13.6503944276671, 12.21386449867774, 10.86032680551621, 9.589009832885705, 8.399201610693438, 7.29024671532814, 6.261543571033642, 5.312542024673842, 4.442741170581312, 3.651687405086022, 2.938972692732927, 2.304233027996674, 1.747147077027393, 1.267434982028678, 0.8648573003634645, 0.5392140053626263, 0.2903432494127157, 0.1181179756942274, 0.02241549994855229, 17.76444180789805, 13.26671573149407, 11.22049218116184, 9.946365543820703, 9.037617290685448, 8.33787121393651, 7.771816211338793, 7.297859824932374, 6.890795064657554, 6.534279091173734, 6.217158010109915, 5.93150536069442, 5.671501112154592, 5.432754988447708, 5.21187928558678, 5.006208912414177, 4.813612001227694, 4.632358246989907, 4.461025184776264, 4.298430072895436, 4.143579467892977, 3.995631280190706, 3.853865798999268, 3.717663271394681, 3.586486343425961, 3.459866157644868, 3.337391234900188, 3.218698500619889, 3.103465980238409, 2.991406806421692, 2.882264266514257, 2.775807681729367, 2.671828956536188, 2.570139671968868, 2.470568623345044, 2.3729597233708, 2.277170207428408, 2.183069090153268, 2.0905358320572, 1.999459182573945, 1.909736171957108, 1.821271229301851, 1.733975407855469, 1.647765701931245, 1.562564442300496, 1.478298759029932, 1.394900102449098, 1.312303814349203, 1.230448742687959, 1.149276894051382, 1.068733118939961, 0.9887648256342554, 0.90932171898134, 0.8303555609572036, 0.7518199503404444, 0.6736701193546502, 0.5958627458897161, 0.518355781465655, 0.4411082994508137, 0.3640803833976972, 0.2872331431129168, 0.2105293430912564, 0.1339387168796746, 0.05752678500041211 },
                { 0.25, 222.087042366784, 207.0892479696938, 195.0393127802269, 184.5748055750966, 175.1700842034695, 166.5519029766195, 158.555059362439, 151.0699201364966, 144.0189497241433, 137.3447123490675, 131.0031336394008, 124.959440128984, 119.1855746527671, 113.6584773021232, 108.3589000984775, 103.2705646673089, 98.37954814174905, 93.67382549572285, 89.14292187230373, 84.7776440014314, 80.56986961267386, 76.51238012231081, 72.59872611709249, 68.82311804416585, 65.180336520056, 61.66565808655941, 58.27479325693605, 55.00383443537227, 51.84921183855902, 48.80765595611192, 45.87616539480545, 43.05197918699782, 40.33255282515633, 37.71553742565661, 35.19876153588845, 32.78021518639098, 30.4580358596184, 28.23049610301223, 26.09599255935003, 24.05303622415458, 22.1002437700448, 20.23632980265403, 18.46009993319271, 16.77044456972143, 15.16633334338202, 13.64681009772763, 12.21098837931223, 10.85804737617684, 9.587228258072935, 8.397830878407756, 7.289210803158712, 6.260776636525342, 5.311987616981956, 4.44235146074731, 3.651422432553526, 2.938799625974587, 2.304125437343967, 1.747084217989198, 1.267401087553557, 0.8648408806468508, 0.5392071539254878, 0.2903409542843582, 0.1181174346227422, 0.02241543868383675, 17.59904917959796, 13.15598582474075, 11.13452394693113, 9.875583228715308, 8.9774464774759, 8.285681419599028, 7.725920110421308, 7.257093560646498, 6.854313028232551, 6.501442377143558, 6.187468888918735, 5.904566417063382, 5.646988528710723, 5.410400391474701, 5.191457007750728, 4.987526811508762, 4.796504687534225, 4.616681986559645, 4.446653996407752, 4.285252692956163, 4.131496957642287, 3.984555116533969, 3.843716334307551, 3.708368478798863, 3.577980785571092, 3.4520901322714, 3.330290061749148, 3.212221922325296, 3.097567655937755, 2.986043881376087, 2.877397004495042, 2.771399149586994, 2.667844752426445, 2.566547690320109, 2.467338850916618, 2.370064061757712, 2.274582318169925, 2.18076425924878, 2.088490851214974, 1.997652244943668, 1.908146780445119, 1.819880115854413, 1.732764462332337, 1.646717909388713, 1.561663827667629, 1.47753033829974, 1.394249839622871, 1.311758583470869, 1.229996294389381, 1.148905826101437, 1.068432850352137, 0.9885255739410925, 0.9091344803307177, 0.8302120927263543, 0.7517127559996992, 0.6735924353450231, 0.5958085303072243, 0.5183197043712921, 0.4410857346488239, 0.3640674015466078, 0.287226506053925, 0.2105264992966605, 0.133937797933849, 0.05752660287436652 },
                { 0.27, 220.1232582952353, 205.4053544691538, 193.5586490675927, 183.2567374947799, 173.9880280615426, 165.4866142537195, 157.5917379958876, 150.196715014212, 143.2260928230124, 136.6239760799185, 130.3474702313711, 124.3627309044549, 118.642449315794, 113.16417980537, 107.9091866173944, 102.8616243728508, 98.00794057467342, 93.33643029451319, 88.83689786825237, 84.50039553446039, 80.31901849496321, 76.2857420770075, 72.39429080415833, 68.63903199164866, 65.0148884307769, 61.51726610341519, 58.14199385559549, 54.88527267861265, 51.74363277712071, 48.71389700050184, 45.79314951366762, 42.97870881247455, 40.26810436555181, 37.65905630178207, 35.14945767054076, 32.73735888712413, 30.42095404379367, 28.19856882143212, 26.06864978088589, 24.02975484889752, 22.08054484282611, 20.21977590243902, 18.44629271696682, 16.7590224521525, 15.15696929583338, 13.63920955217418, 12.20488722442596, 10.85321003434046, 9.583445833383325, 8.394919366873596, 7.287009357300538, 6.259145877471467, 5.310807987934929, 4.441521616386403, 3.650857659549676, 2.938430290334266, 2.303895454774912, 1.746949543899999, 1.267328223665712, 0.8648053955162801, 0.5391922149441015, 0.290335868964789, 0.1181161991697886, 0.02241529213755685, 17.2513093848211, 12.92410853204226, 10.95488219875588, 9.727863058904272, 8.851971397074144, 8.176901444518251, 7.630283493238449, 7.172155559205358, 6.778300736700786, 6.433018529921619, 6.125593295639445, 5.848409669324995, 5.595875650027261, 5.363772592145054, 5.148844882050639, 4.948531038647797, 4.760781810186734, 4.583933719055846, 4.416619044689239, 4.257700399058345, 4.106222293828729, 3.961374694132387, 3.822465186614761, 3.688897442304881, 3.56015434921235, 3.435784656806616, 3.315392294770714, 3.198627751590336, 3.085181056453288, 2.974776021250835, 2.867165481843188, 2.762127338346562, 2.659461239271791, 2.558985788217872, 2.460536177526303, 2.363962172980417, 2.269126388827221, 2.175902804222595, 2.084175481470089, 1.993837453741546, 1.904789755783393, 1.816940575762929, 1.730204510149669, 1.644501906552524, 1.559758281893926, 1.475903805312607, 1.392872836837644, 1.310603514238143, 1.229037381581193, 1.148119053969823, 1.067795913718354, 0.9880178338847214, 0.908736925644529, 0.8299073064877088, 0.7514848866843428, 0.6734271719761376, 0.5956930811928876, 0.5182427790382736, 0.4410375286308453, 0.3640395837316268, 0.2872122083380738, 0.2105203083311727, 0.1339357487699692, 0.0575261739327495 },
                { 0.29, 218.0537502946579, 203.6324176706212, 192.0001063917895, 181.869313677585, 172.7435431763798, 164.3647395034553, 156.5768814197169, 149.2764174158246, 142.3901016350606, 135.8636664167409, 129.6554610605992, 123.7326187626958, 118.0686167695589, 112.6416535484583, 107.4335297253173, 102.4288527726297, 97.6144571215129, 92.97897193168066, 88.51249269413015, 84.20632749701395, 80.05279804500426, 76.04508153760786, 72.177083516354, 68.44333451559551, 64.83890524247215, 61.35933634708228, 58.0005798024436, 54.75894961193566, 51.63108007721008, 48.61389024461276, 45.70455343918099, 42.90047101754538, 40.19924964248344, 37.59868151527709, 35.09672710672931, 32.69150001052579, 30.38125360864175, 28.16436929147567, 26.03934601819336, 24.00479103756024, 22.05941161799079, 20.20200765893923, 18.43146507509602, 16.74674986092365, 15.14690275648209, 13.63103444674783, 12.1983212361132, 10.8480011477762, 9.579370404549817, 8.391780253436497, 7.284634101294244, 6.257384933199994, 5.309532988799204, 4.440623675099419, 3.650245696868407, 2.93802938803051, 2.303645229093677, 1.746802536219623, 1.267248305483491, 0.8647661852409, 0.5391755042850328, 0.2903300569725356, 0.1181147322106443, 0.02241510842814956, 16.88167268906107, 12.67909942799185, 10.76564607209083, 9.572531022544263, 8.72017308295643, 8.062712156797525, 7.529924649816171, 7.083034099631957, 6.698541189946376, 6.361209602001423, 6.060639517318556, 5.789439190382247, 5.542180140151119, 5.3147665224248, 5.104037035522854, 4.907504028384393, 4.723177008033087, 4.549439940407342, 4.384963902642496, 4.228643595175801, 4.079550339786148, 3.936896707943202, 3.800009507738226, 3.668308879087235, 3.541291920505692, 3.418519724051785, 3.299607005714627, 3.184213735037059, 3.072038320971511, 2.962812020910574, 2.85629431975503, 2.752269084677219, 2.650541344972688, 2.550934579262576, 2.453288417250821, 2.357456682336861, 2.263305716129282, 2.17071293738063, 2.079565596860123, 1.989759696784006, 1.90119904906825, 1.813794451182756, 1.727462962017735, 1.64212726311059, 1.557715092970702, 1.474158744192026, 1.391394614647045, 1.309362805378557, 1.228006758902271, 1.147272932546058, 1.067110502215895, 0.9874710926229312, 0.9083085305566827, 0.8295786182734746, 0.7512389245250289, 0.6732485912539453, 0.5955681547190574, 0.5181593813532718, 0.4409851229936312, 0.3640092114653435, 0.2871964802466023, 0.2105133979433252, 0.1339333871850917, 0.05752564554478501 },
                { 0.31, 215.8871056465711, 201.7780807738274, 190.3704260450688, 180.4184836541, 171.441890422785, 163.1909391130864, 155.5146239201165, 148.3126984978369, 141.5142379052066, 135.066681903049, 128.9296815383903, 123.0713909775514, 117.4661069075863, 112.0926982267422, 106.9335230566505, 101.9736589608433, 97.20034159035604, 92.6025462050682, 88.17066967513126, 83.89628474237153, 79.7719472784756, 75.79104309546782, 71.94766473790701, 68.23651132239097, 64.65280631937243, 61.19222946451746, 57.85085991438682, 54.62512843681833, 51.51177692510431, 48.50782389776003, 45.61053492738392, 42.81739715728316, 40.12609723050039, 37.53450208504956, 35.04064217056138, 32.64269672175853, 30.33898078812258, 28.12793377043941, 26.00810925637877, 23.97816598097991, 22.03685976548916, 20.18303631067313, 18.4156247394823, 16.73363179952186, 15.13613664879993, 13.62228615914028, 12.19129068084757, 10.84242021999995, 9.575000986361522, 8.388412275553629, 7.282083653958414, 6.255492418981061, 5.308161310870919, 4.439656455374084, 3.64958551910744, 2.937596061700569, 2.303374070321165, 1.746642662715621, 1.267160942770927, 0.8647229819195874, 0.5391568544210861, 0.2903234280001266, 0.1181129969992648, 0.02241488058295468, 16.490991921946, 12.4219087874592, 10.56766305378767, 9.410324926867273, 8.582693625279539, 7.943674749221593, 7.425336486677483, 6.990164069645274, 6.615419568380943, 6.286357834299441, 5.992912419409198, 5.727927093100791, 5.486145240504697, 5.263599843045942, 5.057228364117453, 4.86462034194211, 4.683846620973739, 4.513340620278643, 4.351813801532271, 4.198194221195326, 4.051581033997126, 3.911210250531941, 3.776428583791076, 3.646673207460386, 3.521455900419535, 3.400350490394667, 3.282982810280748, 3.169022590126564, 3.058176856013912, 2.950184513445649, 2.844811870195416, 2.74184891047036, 2.641106174565297, 2.542412130000032, 2.445610944273397, 2.35056058785296, 2.257131210293124, 2.165203743483367, 2.074668694738736, 1.985425099322193, 1.897379607454786, 1.810445685241431, 1.724542912457392, 1.639596362986106, 1.555536056013525, 1.472296467976174, 1.38981609681434, 1.308037071364535, 1.226904799788774, 1.146367651824162, 1.066376670378263, 0.9868853086220372, 0.9078491892679022, 0.8292258831925428, 0.750974705010091, 0.6730565236952877, 0.5954335870861537, 0.5180693606303104, 0.4409283850722599, 0.3639761731177553, 0.287179232853576, 0.2105057026982685, 0.1339306715099595, 0.05752499981520569 },
                { 0.33, 213.6320735856776, 199.8501136207288, 188.676435928451, 178.9102562028797, 170.0883722942167, 161.9699039304046, 154.4091232825252, 147.309248657425, 140.6017800867114, 134.2359363428361, 128.1727215489513, 122.3813488876268, 116.8369634743476, 111.5191272466466, 106.410773814701, 101.4974654102001, 96.76685090407469, 92.20826167937634, 87.81240446996364, 83.57112394372991, 79.477216446354, 75.52428193323202, 71.70660485377741, 68.0190572952517, 64.45701945825045, 61.01631378282248, 57.69314993929266, 54.48407854989696, 51.38595198872487, 48.39589096726078, 45.511255884803, 42.72962213081593, 40.04875868655134, 37.46660949804203, 34.9812771905211, 32.59100877182783, 30.29418303415236, 28.08929941307813, 25.97496810297048, 23.94990126036083, 22.01290515364401, 20.1628731393452, 18.39877936335692, 16.71967310062953, 15.12467365939809, 13.61296578660203, 12.18379552006795, 10.83646644057188, 9.570336283312194, 8.384813873798131, 7.279356357846585, 6.253466699405421, 5.306691423385205, 4.438618583656386, 3.648875938899826, 2.93712932107686, 2.303081182782654, 1.746469310196122, 1.267065686151366, 0.8646754771113135, 0.5391360724784447, 0.2903158780699953, 0.1181109512236255, 0.02241460057265309, 16.08011476927899, 12.15353247426471, 10.36181410294369, 9.242004453346797, 8.440189048840239, 7.820359170185956, 7.317017321833866, 6.893983622381336, 6.529322956730689, 6.208806528640701, 5.922717427649388, 5.664145776691667, 5.428014353523461, 5.210490345958538, 5.008613924403723, 4.82005476478717, 4.64294729385629, 4.47577611938849, 4.317294447357822, 4.166464767896455, 4.022414931331551, 3.884405083941195, 3.751802410311261, 3.624061581948781, 3.500709440240552, 3.381332864809173, 3.265569068253924, 3.15309776035354, 3.043634767833962, 2.936926798457138, 2.832747112821132, 2.730891922176625, 2.6311773714204, 2.533436997136711, 2.437519573864525, 2.343287279616551, 2.250614125458794, 2.159384604687328, 2.069492525551298, 1.980839998114017, 1.893336551124395, 1.806898358994508, 1.721447562377604, 1.636911668590712, 1.553223020363162, 1.470318323221548, 1.388138223324828, 1.306626928804282, 1.225731868692523, 1.145403384383982, 1.065594449288732, 0.9862604129495012, 0.9073587664127581, 0.8288489261049203, 0.7506920339013346, 0.6728507715622422, 0.5952891884341175, 0.5179725428449965, 0.44086716195229, 0.3639403401378906, 0.2871603637852215, 0.2104971472648599, 0.1339275537669839, 0.05752421613716417 },
                { 0.35, 211.2975046064198, 197.8563511827453, 186.9249911727204, 177.3506447933914, 168.6882838966258, 160.7063117052981, 153.2645222706399, 146.269743550146, 139.6559933997133, 133.3743324374475, 127.3871622483849, 121.6647874882787, 116.183226124945, 110.9227519669218, 105.866888942739, 101.001695850887, 96.31524449117973, 91.79723041532214, 87.43867698422166, 83.23170655470609, 79.16936092036604, 75.24545852617682, 71.45447956945267, 67.79147254536981, 64.25197749304999, 60.83196239779285, 57.52777006637092, 54.33607341985572, 51.253837611838, 48.27828772631656, 45.40688107144622, 42.63728328545569, 39.96734762544834, 37.39509693001422, 34.918707840976, 32.53649694430204, 30.24690854979384, 28.04850387699343, 25.93995145342701, 23.92001856275687, 21.98756360615353, 20.14152926138224, 18.38093634162267, 16.7048782706153, 15.11251610290722, 13.60307402819627, 12.17583530739713, 10.83013859535735, 9.56537461136332, 8.380983123878425, 7.276450220497171, 6.25130583799923, 5.305121530741678, 4.437508458506585, 3.648115577365888, 2.936628019125264, 2.302765646333667, 1.746281770226105, 1.266962016713227, 0.8646233147231243, 0.5391129357925373, 0.2903072871373376, 0.1181085460293292, 0.02241425912584954, 15.64987717402719, 11.87501213803912, 10.14900971778301, 9.068345763514305, 8.2933237335126, 7.693338854368254, 7.20546609203594, 6.794929890776507, 6.44063654174331, 6.128896685512554, 5.850357558155003, 5.598365303302498, 5.368028724146567, 5.155653903979054, 4.958387119340809, 4.773980700739292, 4.600634554857987, 4.436885931279227, 4.281530907828116, 4.133567293237607, 3.992152334680115, 3.856570874341735, 3.726211018987242, 3.600545302326673, 3.479115924181818, 3.36152305716288, 3.247415490405899, 3.136483074309193, 3.028450567803684, 2.923072588463658, 2.820129437587566, 2.719423625232754, 2.620776959516218, 2.5240280940598, 2.429030449900155, 2.335650445371434, 2.243765980743176, 2.153265134729467, 2.064045038089436, 1.976010895939331, 1.889075135484436, 1.803156659949461, 1.718180192761643, 1.63407569869183, 1.550777870816009, 1.46822567392421, 1.386361936454178, 1.305132984225454, 1.2244883102442, 1.144380275679034, 1.064763837804856, 0.9855963013012748, 0.9068370897987339, 0.828447535014157, 0.7503906812456947, 0.6726311034760474, 0.5951347380531318, 0.5178687264436527, 0.4408012768827377, 0.3639015640775905, 0.2871397548614779, 0.2104876446810276, 0.1339239785639961, 0.05752327071645658 },
                { 0.37, 208.892293496268, 195.804633241798, 185.1229158275554, 175.7456144744316, 167.2468656744616, 159.4047853896889, 152.0849119632683, 145.197811881474, 138.680101530326, 132.4847369044961, 126.5755541779209, 120.9239761709982, 115.5069134726425, 110.3053667792009, 105.3034619987661, 100.4877637313862, 95.84677415043689, 91.37055907778681, 87.05046358054578, 82.87889199607391, 78.84913524476005, 74.95523345956179, 71.1918654050112, 67.55425850316275, 64.03811491209391, 60.63955025327185, 57.35504241052719, 54.18138842565327, 51.11566796048762, 48.15521212795175, 45.29757674607303, 42.54051926125737, 39.88197873544228, 37.32005840730049, 34.85301042841088, 32.47922244715612, 30.19720577040988, 28.00558487910582, 25.90308811100121, 23.88853935423589, 21.9608506200812, 20.11901538368704, 18.36210259853241, 16.68925130434517, 15.09966576001351, 13.59261104288979, 12.16740906422316, 10.82343495752275, 9.560113802665112, 8.376917653693661, 7.273362842657349, 6.249007535614014, 5.303449520172464, 4.43632420673298, 3.64730282794675, 2.93609082283737, 2.302426393379933, 1.746079221644485, 1.266849333288372, 0.8645660823060888, 0.539087186469308, 0.2902975161565824, 0.1181057248247607, 0.0224138455021738, 15.20109889758619, 11.58743635762132, 9.930185687544287, 8.890135741751352, 8.14276463075596, 7.563185398149004, 7.091177608913481, 6.693434815387736, 6.34973995903464, 6.046963807096295, 5.776130616169859, 5.530850938605055, 5.306425275799004, 5.099302562719993, 4.906738012832641, 4.726568681014328, 4.557061495193722, 4.396807512430157, 4.244646575551406, 4.099612503703434, 3.960892481527119, 3.827796472540081, 3.69973384217268, 3.576195253350447, 3.456738476500295, 3.340977145698347, 3.22857176001317, 3.119222415508324, 3.012662885347241, 2.908655760203034, 2.806988430095875, 2.70746973950872, 2.609927185385641, 2.514204556004713, 2.420159930268512, 2.327663973463314, 2.236598478289836, 2.146855109896355, 2.058334321432062, 1.970944412789196, 1.884600710092834, 1.799224847409955, 1.714744135298768, 1.631091003368596, 1.548202506095645, 1.466019882837844, 1.384488164388381, 1.303555819561928, 1.223174436266724, 1.143298432317003, 1.063884791913995, 0.9848928242952369, 0.9062839415442112, 0.8280214529902886, 0.7500703740487085, 0.6723972478246041, 0.5949699785206924, 0.5177576772129402, 0.4407305248852185, 0.3638596729486598, 0.2871172692095271, 0.2104770942309138, 0.1339198817404714, 0.05752213598930333 },
                { 0.39, 206.4253263792977, 193.7027451020018, 183.2769457912046, 174.1010305637325, 165.7692582709478, 158.069853679695, 150.8742972904092, 144.097005265647, 137.6772602183712, 131.5699572868194, 125.7403968652015, 120.1611407553235, 114.8100072454799, 109.6687351291943, 104.7220608187086, 99.95706133191475, 95.36267444824109, 90.92934047194356, 86.64872962600087, 82.51353110180304, 78.51728738110665, 74.65426238318819, 70.91933527987593, 67.30791406191298, 63.81586449658066, 60.43945121694858, 57.17528847370838, 54.02029865689583, 50.97167712062569, 48.02686216246135, 45.18350924998177, 42.439468771302, 39.79276672849405, 37.24158790362418, 34.78426111414872, 32.41924624333115, 30.14512278633483, 27.96057969683521, 25.86440635474347, 23.85548450473613, 21.93278103912248, 20.09534151821808, 18.34228433765828, 16.67279546563022, 15.08612368433684, 13.58157627953816, 12.15851513006727, 10.81635315604859, 9.554551090364123, 8.372614542886084, 7.270091331257642, 6.246569055666801, 5.301672898207228, 4.435063630117702, 3.646435812473111, 2.935516177748576, 2.302062180959834, 1.745860709324542, 1.266726936996964, 0.8645033004810708, 0.5390585247779521, 0.2902864035175993, 0.1181024218295349, 0.02241334721663411, 14.73458198555813, 11.29194244667663, 9.706298250997257, 8.708165774670732, 7.989175271382379, 7.430463214618814, 6.974637911156972, 6.589921133073026, 6.257003832037304, 5.96333490268906, 5.700326594796952, 5.461860882539141, 5.24343462264088, 5.041642792949497, 4.853851788254976, 4.677985000982224, 4.512377560980094, 4.355675209951418, 4.206762215363957, 4.064708907546552, 3.928732791375449, 3.798169245468583, 3.672449119634037, 3.55108137902835, 3.433639496436692, 3.319750666525132, 3.209087171398962, 3.101359405001644, 2.996310190093151, 2.893710112185579, 2.793353660755195, 2.695056016598406, 2.598650360339346, 2.503985604277876, 2.410924470406311, 2.319341853236362, 2.229123418294912, 2.140164396660757, 2.05236854337746, 1.96564723347312, 1.87991867400599, 1.79510721430648, 1.711142739606118, 1.627960135689239, 1.545498814193996, 1.463702289818903, 1.382517802032203, 1.301895974990889, 1.221790510299187, 1.142157908008623, 1.06295721191256, 0.9841497757416865, 0.9056990473455894, 0.8275703683735941, 0.7497307873808981, 0.6721488847560845, 0.5947946085796005, 0.5176391220471372, 0.4406546674195211, 0.3638144667972216, 0.2870927477571128, 0.2104653788659118, 0.1339151887229014, 0.05752077991504424 },
                { 0.41, 203.9054317533058, 191.5583589139831, 181.3936730762883, 172.4226094491455, 164.2604598733784, 156.7059141238668, 149.6365650457833, 142.9707703814422, 136.6505329212825, 130.632720603986, 124.8841200377743, 119.3784469147671, 114.0944376353782, 109.0145765474729, 104.1242160253326, 99.41094957828446, 94.86415368870281, 90.47464554074485, 86.23442240446489, 82.1364598473818, 78.17455316492132, 74.34319111828226, 70.63745420013224, 67.05293178280342, 63.58565398684103, 60.23203515684109, 56.98882658553129, 53.85307667695891, 50.82209714609768, 47.89343415630979, 45.06484352625328, 42.33426931383678, 39.69982522074856, 37.15977836701376, 34.71253506828763, 32.35662831455161, 30.09070670153041, 27.91352460847669, 25.82393345023006, 23.82087385936486, 21.90336867711429, 20.07051665061572, 18.32148674965477, 16.65551302911667, 15.07188997427057, 13.56996827520351, 12.14915098449539, 10.80889001883065, 9.548682970874557, 8.368070202563199, 7.266632195093292, 6.243987134455592, 5.299788714413944, 4.433724141450237, 3.645512328404299, 2.934902265317972, 2.301671557206879, 1.745625118656836, 1.266594012678744, 0.8644344102337021, 0.5390266012119699, 0.2902737607635189, 0.1180985603303106, 0.02241274970839644, 14.25111306501301, 10.98971834178018, 9.478318304813086, 8.523224964088215, 7.833209569506609, 7.295724209677819, 6.856319761609697, 6.484798571898147, 6.162786541641518, 5.878325728067569, 5.623225299039403, 5.391644210409705, 5.179279274199255, 4.98287391631494, 4.799907361436112, 4.628390493240247, 4.466727464410902, 4.313619292898446, 4.167995100967067, 4.028962044401228, 3.895768177939913, 3.767774462106491, 3.644433350578945, 3.525272194122989, 3.409880223355699, 3.297898227209394, 3.189010287315977, 3.082937098337412, 2.979430524572744, 2.878269129605842, 2.779254478661754, 2.682208059666887, 2.586968703505833, 2.493390409920889, 2.401340505212908, 2.310698073008672, 2.221352611033922, 2.133202875923308, 2.046155885232302, 1.960126051452362, 1.875034427313142, 1.790808045242931, 1.707379336746772, 1.624685619800646, 1.542668644264824, 1.461274186879367, 1.380451688689156, 1.300153928809562, 1.220336729329948, 1.140958686895123, 1.06198092713258, 0.9833668786293635, 0.9050820636281027, 0.8270939030308559, 0.7493715337067976, 0.6718856365672733, 0.5946082745851669, 0.5175127414617669, 0.4405734259753859, 0.3637657123867383, 0.2870660050193275, 0.210452362105933, 0.13390981254863, 0.05751916512623273 },
                { 0.43, 201.3413351561182, 189.3789749729523, 179.4794914916452, 170.7158718052487, 162.7252863671754, 155.3171990791293, 148.3754546040806, 141.8224236048407, 135.602868694905, 129.6756539566833, 124.0090665361227, 118.5779850668457, 113.3620698969265, 108.3445547373159, 103.5114104229488, 98.85074859048587, 94.35238548614528, 90.00751584967798, 85.80846441671674, 81.74849338029323, 77.82165099144929, 74.0226509317312, 70.34677506129973, 66.78979417224944, 63.34790278540504, 60.01766502579874, 56.79596932894802, 53.67999025316937, 50.66715605999427, 47.75512101433427, 44.9417415752891, 42.22505581623618, 39.60326554243719, 37.0747206754375, 34.63790555298315, 32.2914268561539, 30.03400292570487, 27.86445427006473, 25.7816951002027, 23.78472575328487, 21.87262588894797, 20.04454836009679, 18.29971367513532, 16.63740498106315, 15.05696350737474, 13.55778441955828, 12.13931303849773, 10.80104138847057, 9.542505041893244, 8.363280233647388, 7.262981221844577, 6.241257875351731, 5.297793471379713, 4.432302688987651, 3.644529786502012, 2.934246952569392, 2.301252821715145, 1.74537114538865, 1.266449606942564, 0.8643587578939766, 0.5389910071026393, 0.29025936752742, 0.1180940506183448, 0.02241203594911645, 13.75147061295989, 10.68200357287633, 9.247224245842287, 8.336092687651003, 7.675505447086336, 7.159502531443515, 6.736678341394042, 6.37846029620477, 6.067431261146459, 5.792238285214746, 5.545094215012581, 5.320439039191868, 5.114172043521479, 4.923186712864276, 4.745076154584024, 4.57793944211767, 4.420250218392684, 4.270765090678639, 4.128458243869263, 3.992473793928311, 3.86209042852048, 3.736694736051918, 3.615760793026249, 3.498834334805354, 3.385520333869819, 3.27547314610957, 3.168388616681462, 3.063997698244011, 2.962061248694195, 2.862365757698972, 2.764719811138998, 2.668951146659809, 2.574904186360703, 2.482437957362723, 2.391424329772389, 2.301746515950196, 2.213297786117745, 2.125980364003707, 2.039704473029581, 1.9543875089101, 1.869953318817318, 1.786331570678342, 1.703457198931036, 1.6212699152928, 1.539713774914475, 1.458736789779939, 1.378290582438437, 1.298330074173457, 1.218813202560329, 1.139700664077797, 1.060955678043343, 0.9825437686606891, 0.9044325624214165, 0.8265915985138868, 0.7489921502962409, 0.6716070563571931, 0.5944105604041357, 0.5173781607489804, 0.440486474499669, 0.36371313691344, 0.2870368241178558, 0.2104378843756954, 0.1339036515291773, 0.0575172479236299 },
                { 0.45, 198.7416167076502, 187.1718622220144, 177.5405438992874, 168.9860985797117, 161.1683346337249, 153.9077447843328, 147.0945315493571, 140.6551282742424, 134.5370824091376, 128.7012671749239, 123.1174769982169, 117.7617567860547, 112.6146922456181, 107.660266763106, 102.8850693169613, 98.27772900182181, 93.82850097335772, 89.52895659009179, 85.37174709771783, 81.35042038043743, 77.45927675673417, 73.69325400211451, 70.04783458929989, 66.51897005254949, 63.10301871617538, 59.79669397160551, 56.5970209668467, 53.50130006831423, 50.50707582207249, 47.61211041647703, 44.8143608564865, 42.11195921934888, 39.50319548460681, 36.98650252750048, 34.56044294047656, 32.22369740749155, 29.975054403728, 27.81340103192192, 25.73771483776645, 23.74705647236665, 21.84056309066495, 20.01744239206005, 18.27696722382243, 16.61847067992995, 15.0413416380511, 13.54502068594129, 12.12899639576947, 10.79280191107972, 9.536011816393686, 8.358239264017514, 7.259133336544728, 6.238376626934714, 5.295683020964898, 4.430795669351741, 3.643485138933532, 2.933547733979296, 2.300803979789105, 1.745097260800863, 1.266292602817101, 0.8642755777869371, 0.5389512637755084, 0.2902429656824181, 0.1180887876064501, 0.02241118599036825, 13.2364385566984, 10.37008775003062, 9.013993016816283, 8.147530465732074, 7.516678334743943, 7.022309460760239, 6.61614719872074, 6.271279645785794, 5.971263288428551, 5.705358604975473, 5.466186640044388, 5.248470929902322, 5.048314666347862, 4.86276221559372, 4.68952103489761, 4.526778642403676, 4.373078296860191, 4.227232240448641, 4.088259716372334, 3.955341765168976, 3.827787652226548, 3.705009526433844, 3.586503012229234, 3.471832150185773, 3.360617572670359, 3.252527119160479, 3.147268314325569, 3.044582284633971, 2.944238797515363, 2.846032184973918, 2.749777970269608, 2.655310058097426, 2.562478379855946, 2.471146909058383, 2.381191979771968, 2.292500854645919, 2.204970499661125, 2.118506530972796, 2.033022305683189, 1.948438133491108, 1.864680590229102, 1.781681917551953, 1.6993794956589, 1.61771537805293, 1.536635879067996, 1.456091206310615, 1.376035131329362, 1.296424692794309, 1.21721992727808, 1.138383623412682, 1.059881095777289, 0.9816799753736097, 0.9037500139873941, 0.8260629001393163, 0.7485920847299654, 0.6713126149524923, 0.5942009757675031, 0.5172349397737631, 0.4403934306559468, 0.3636564207501905, 0.2870049510285257, 0.210421758772416, 0.1338965865504853, 0.0575149771149352 },
                { 0.47, 196.114670365551, 184.9439972418507, 175.5826714173819, 167.2382902310068, 159.5939493924821, 152.4813638547824, 145.7971644400747, 139.4718747576286, 133.4558374291854, 127.7119376148695, 122.211476403196, 116.931662816137, 111.8540051245306, 106.9632334034138, 102.246551819095, 97.69310410702158, 93.29358170210105, 89.03993015585036, 84.92512500412669, 80.94299780174803, 77.0880991033044, 73.35558912481231, 69.74114946471787, 66.24091106865888, 62.8513948801342, 59.56946251068209, 56.39227490513692, 53.31725744658819, 50.34207029295966, 47.46458299742422, 44.68285266217527, 41.9951050262021, 39.39971800460386, 36.89520728820753, 34.48021368407079, 32.1534919344406, 29.91390079731001, 27.76039420842304, 25.6920133743531, 23.70787967059623, 21.80718823860839, 19.98920219225194, 18.25324735788166, 16.59870748382949, 15.02501986476061, 13.53167133460339, 12.11819458876718, 10.78416480236408, 9.529196516311876, 8.352940767648626, 7.255082444240437, 6.235337847396237, 5.293452448779915, 4.429198830473634, 3.64237479911303, 2.932801666653307, 2.300322691386492, 1.744801672829778, 1.266121691439861, 0.8641839728506091, 0.5389068104334625, 0.2902242528035352, 0.1180826481652488, 0.02241017645772681, 12.70682774739669, 10.05530429393528, 8.77958898963543, 7.958273172800927, 7.357314649366275, 6.884628531997539, 6.49513451885683, 6.16360721568402, 5.874587706889151, 5.617954833662418, 5.386740087489051, 5.175951535066985, 4.981896637215564, 4.80177069597006, 4.63339542063077, 4.475046604412068, 4.325336922573493, 4.183134045209288, 4.047502070343542, 3.91765876845509, 3.792943799035006, 3.67279469928438, 3.556728480395022, 3.444327337062676, 3.335227419474017, 3.229109916549732, 3.125693905200809, 3.024730564351807, 2.925998454686307, 2.829299638620643, 2.734456468624859, 2.641308911553317, 2.549712306134081, 2.459535472977792, 2.370659113356683, 2.28297444596082, 2.196382040859439, 2.110790817705023, 2.026117181348225, 1.942284272876483, 1.859221317942479, 1.776863057331946, 1.695149247202313, 1.614024218433135, 1.533436486165781, 1.453338401950811, 1.373685842027415, 1.294437926178044, 1.215556762370898, 1.13700721305374, 1.058756679519402, 0.9807749012475261, 0.9030337675578505, 0.8255071393097004, 0.748170678783607, 0.6710016863543244, 0.5939789432941526, 0.5170825615965071, 0.4402938460720461, 0.3635951893453921, 0.2869700881559162, 0.2104037663366293, 0.1338884780554285, 0.05751229271665622 },
                { 0.49, 193.4686633536658, 182.7020013583826, 173.61136531777, 165.4771299189023, 158.0061941212219, 151.0416215928834, 144.4865050083787, 138.2754635538616, 132.3616309514669, 126.7098972649913, 121.2930626162657, 116.0894928113336, 111.0816119607031, 106.2548907840375, 101.5971432490345, 97.09802294633702, 92.74865333952636, 88.54135039376251, 84.46941056925751, 80.52694608886586, 76.70875506084563, 73.01021774291219, 69.42721271329525, 65.95604841012686, 62.59340668264941, 59.33629583643606, 56.18201125934549, 53.12810215700928, 50.17234325423171, 47.31271056439116, 44.54736051531346, 41.87461186294542, 39.29292993472313, 36.80091283088293, 34.39727927998562, 32.0808578989412, 29.85057765104807, 27.70545933040793, 25.64460792937149, 23.66720576880159, 21.77250628998104, 19.95982842276983, 18.22855145777709, 16.57811036136182, 15.00799148161224, 13.51772860139007, 12.10689930131398, 10.77512160139174, 9.522050855052256, 8.347376873699337, 7.250821263706901, 6.232134961076103, 5.291095951833702, 4.427507168704758, 3.641194556651117, 2.932005301492266, 2.299806216863393, 1.744482284727441, 1.265935341936798, 0.8640828940053223, 0.5388569912541388, 0.29020287520353, 0.1180754882852497, 0.02240898001170586, 12.16350689979451, 9.739016354472338, 8.544950503249332, 7.76901975126399, 7.197965408016214, 6.746911001290065, 6.374019794925533, 6.055768329430851, 5.777687409887859, 5.530275646398321, 5.306974981307825, 5.103077501393638, 4.915094269504005, 4.740370845556998, 4.576842558655864, 4.422872908863491, 4.277143485639627, 4.138576945804009, 4.006281855057481, 3.879512373294415, 3.757638253253895, 3.640122153090742, 3.526502231545704, 3.416378621830278, 3.309402796086829, 3.205269113312667, 3.103708037068023, 3.004480644637545, 2.907374145460474, 2.812198195892147, 2.718781847872892, 2.626971006363374, 2.536626298224209, 2.44762127618482, 2.359840897498222, 2.273180229120402, 2.187543340724285, 2.102842354241533, 2.018996624421634, 1.935932029478134, 1.85358035453417, 1.771878753492976, 1.690769277303103, 1.610198458484822, 1.530116943327975, 1.450479164436024, 1.371243047333927, 1.292369745724485, 1.213823400705443, 1.13557091987725, 1.057581772803123, 0.9798277997493657, 0.9022830310537908, 0.8249235148650667, 0.747727151398806, 0.6706735323369056, 0.5937437847386907, 0.5169204204001469, 0.4401871959799776, 0.3635290046090158, 0.2869318874958439, 0.2103836510166389, 0.1338791628294839, 0.05750912457097133 },
                { 0.51, 190.811493964072, 180.4520762928711, 171.6317229184928, 163.7069516617515, 156.4088267918322, 149.5918166633472, 143.1654722195932, 137.0684917749294, 131.2567822891684, 125.69722242197, 120.3640971714862, 115.2369170264282, 110.2990116184641, 105.5365834883738, 100.9380488216044, 96.49356450746262, 92.19468033558867, 88.03407769637002, 84.00536958766563, 80.10294502466252, 76.32184623122801, 72.65767044681354, 69.10649049904511, 65.66478987806334, 62.32940915573007, 59.09750137913286, 55.96649463518898, 52.9340603984633, 49.99808658234969, 47.1566544450139, 44.40801867705238, 41.75059013248741, 39.18292076902354, 36.70369044501332, 34.31169528484554, 32.00583737554111, 29.78511559824564, 27.6486174313129, 25.59551158849971, 23.62504137775333, 21.73651868417619, 19.92931849578385, 18.20287390323877, 16.55667151532391, 14.99024724089194, 13.50318239568511, 12.09510009900241, 10.76566193088061, 9.514564825399571, 8.341538180036096, 7.246341164761894, 6.228760217878496, 5.288606718452414, 4.425714827686423, 3.639939493640128, 2.931154615350088, 2.29925136343643, 1.74413665422393, 1.265731771639173, 0.8639711197373474, 0.5388010426128169, 0.2901784210328847, 0.118067140264055, 0.02240756481336134, 11.60744437134067, 9.422591171722482, 8.310974203973635, 7.580423744496354, 7.039140209162875, 6.609571813510044, 6.253150997102851, 5.948060969122228, 5.68082153054903, 5.442549015526296, 5.227093660189192, 5.030029642026786, 4.848069990423341, 4.678709162668449, 4.519994981205128, 4.370377718553499, 4.228607099354211, 4.093660113250344, 3.964689240492274, 3.840984558633701, 3.721945507838479, 3.607059515018109, 3.495885578041824, 3.388041496071003, 3.283193820087261, 3.181049860292491, 3.081351268019637, 2.983868836551694, 2.888398255378899, 2.794756617401137, 2.7027795260218, 2.612318684121377, 2.52323987306489, 2.43542124963166, 2.348751903778365, 2.263130631680659, 2.178464887425708, 2.094669883688449, 2.011667817188936, 1.92938719904579, 1.847762273572814, 1.766732511809459, 1.686242168281332, 1.606239891269646, 1.526678378317916, 1.447514069890092, 1.368706875071852, 1.290219924019637, 1.212019342545407, 1.134074044807485, 1.056355540582678, 0.9788377540423554, 0.901496851363873, 0.8243110749000698, 0.7472605820360861, 0.670327287353781, 0.5934947074826284, 0.5167478096057218, 0.4400728689983315, 0.3634573564033179, 0.2868899438719415, 0.2103611146823902, 0.1338684508156563, 0.05750539097462848 },
                { 0.53, 188.1507459307225, 178.1999401313307, 169.6484094505902, 161.9317148450709, 154.8052814078672, 148.134966876382, 141.8367407852302, 135.8533435065664, 130.1434245413456, 124.6758263263999, 119.4262986509135, 114.3754802901577, 109.5075928653161, 104.8095594449194, 100.27038890552, 95.8807333188558, 91.63256182342912, 87.51891518801848, 83.53371766960054, 79.67163043842221, 75.92793573745061, 72.29844415199972, 68.77941951951008, 65.36751748685137, 62.05973475530049, 58.85336678788474, 55.74597228444139, 52.73534311863018, 49.81947871987442, 46.99656410018428, 44.26495089069121, 41.62314087930606, 39.06977163904038, 36.60360391328751, 34.22351048491717, 31.92846630420268, 29.7175396892105, 27.58988444346785, 25.54473276110142, 23.58138881044434, 21.6992229042892, 19.89766617926088, 18.17620571876806, 16.53438006411912, 14.97177506701, 13.48802004398978, 12.08278419990431, 10.75577329288359, 9.506726518309952, 8.335413593488237, 7.241632028514207, 6.225204572163377, 5.28597682453813, 4.423815010736276, 3.63860391193348, 2.930244951951843, 2.298654438449034, 1.743761957804425, 1.265508919982239, 0.8638472381780627, 0.5387380818525207, 0.2901504142092613, 0.1180574102299768, 0.02240589405362612, 11.03976146585267, 9.107358866529097, 8.078497808913856, 7.393084150027061, 6.881301889208987, 6.472986256182057, 6.132842358480676, 5.840754239328679, 5.584224329046365, 5.354981370861678, 5.147279718374094, 4.956972399449971, 4.780971888103365, 4.61691955868964, 4.462974154806542, 4.317671458773445, 4.179828304650091, 4.048475172246887, 3.922807756623573, 3.802151465830851, 3.685934929725367, 3.573669917823844, 3.464935898646477, 3.35936801556054, 3.256647614691135, 3.156494704844653, 3.058661898015715, 2.962929497313933, 2.869101483337959, 2.77700221078365, 2.686473671477565, 2.597373212857661, 2.509571625458316, 2.422951531475415, 2.337406020593414, 2.252837490092895, 2.16915665464734, 2.086281697761114, 2.004137541937455, 1.922655218722818, 1.841771322997184, 1.761427538454201, 1.681570223281569, 1.602150046719654, 1.523121668529517, 1.444443454506571, 1.366077222085482, 1.28798801083776, 1.21014387329964, 1.132515682112162, 1.055076949930935, 0.9778036589898888, 0.9006740976000411, 0.8236687012522077, 0.7467698964041771, 0.669961945537226, 0.5932307928464883, 0.5165639115473839, 0.4399501582227565, 0.363379655099517, 0.2868437890041503, 0.2103358127438959, 0.1338561223116824, 0.05750099747146893 },
                { 0.55, 185.4936379928764, 175.9507673055893, 167.6656285424579, 160.1549868017465, 153.1986565543423, 146.6738010007563, 140.5027348781057, 134.6321846855457, 129.02350020969, 123.6474552698062, 118.4812391323207, 113.5065987033974, 108.708631266473, 104.0749669863436, 99.59519622897136, 95.26045679225213, 91.06312909426306, 86.99660633036811, 83.055117976762, 79.23359207191132, 75.52754621994939, 71.9330002250058, 68.44640526010431, 65.06458584477414, 61.78469186519702, 58.60415855430509, 55.52067284380165, 52.53214486297572, 49.63668362895214, 46.83257617596975, 44.11826952565743, 41.49235501891857, 38.95355462208793, 36.50070889209706, 34.13276634229367, 31.84877399586689, 29.64786895018212, 27.52927080472418, 25.49227482929662, 23.53624576878958, 21.66061219710012, 19.86486134636168, 18.1485343490558, 16.5112218402624, 14.95255987559203, 13.47222612749592, 12.06993632887629, 10.74544093838258, 9.498522006604021, 8.328990226652744, 7.236682156443795, 6.22145760336899, 5.283197165060752, 4.421799922559453, 3.637181284418136, 2.929270982038153, 2.298011217650308, 1.743354966326785, 1.265264430603141, 0.8637096347617321, 0.5386670995238144, 0.290118310211708, 0.1180460764232669, 0.02240392562631111, 10.46179656200305, 8.794552319734772, 7.848282447860083, 7.207537271063991, 6.724862229234555, 6.337487519393607, 6.013372913408048, 5.73408745390357, 5.488104598991562, 5.267757196704913, 5.067697717620346, 4.884053626719489, 4.713933534025014, 4.555123204326839, 4.405890339634706, 4.264854683279181, 4.130898938927429, 4.003106070877115, 3.880714163161201, 3.76308326831899, 3.649670629778326, 3.540011870711597, 3.433706511057871, 3.330406675303889, 3.229808187109545, 3.131643473286048, 3.035675856116045, 2.941694922912938, 2.849512740063375, 2.758960735409094, 2.669887114245624, 2.582154704872988, 2.4956391525671, 2.410227398165095, 2.325816390664322, 2.242311993386076, 2.159628051118187, 2.07768559178364, 1.996412140996771, 1.915741131669571, 1.835611393847343, 1.755966712358848, 1.676755441793583, 1.597930169870321, 1.51944742151612, 1.441267396996628, 1.363353738276708, 1.285673318485612, 1.208196049946155, 1.130894706729983, 1.053744758143966, 0.9767242099563438, 0.8998134505542157, 0.8229950996080367, 0.746253857236537, 0.6695763521859718, 0.5929509883429607, 0.5163677905523452, 0.4398182551957856, 0.3632952264978227, 0.286792887432982, 0.2103073511248118, 0.1338419260271106, 0.05749583601371909 },
                { 0.57, 182.8469682593866, 173.7091385167767, 165.6871043568032, 158.3799353228214, 151.5917122457305, 145.2107575868692, 139.1656278511392, 133.4069631826782, 127.898761376123, 122.6136887317664, 117.5303442230878, 112.6315595468776, 107.903288965456, 103.3338545138829, 98.91341544469258, 94.63358470774313, 90.4871450221782, 86.46783430577837, 82.5701805815931, 78.78937292998823, 75.1211591918567, 71.56176385455526, 68.10782139030258, 64.75632158248601, 61.50456426334402, 58.3501215201649, 55.29080588632739, 52.32464337095542, 49.44985043215185, 46.66481418799013, 43.96807530353907, 41.35831310305571, 38.83433254258565, 36.3950527456896, 34.03949685834825, 31.76678302159741, 29.57611629458067, 27.46678138833984, 25.43813609320892, 23.48960530121952, 21.62067554030243, 19.83088994993205, 18.11984363871812, 16.4871793737019, 14.93258355907741, 13.45578246898129, 12.0565387050716, 10.73464785499887, 9.489935332677901, 8.322253385583252, 7.231478258175936, 6.217507504064349, 5.280257442627601, 4.419660758584172, 3.635664245345619, 2.928226694878627, 2.297316938019083, 1.742912039215824, 1.26499564689253, 0.8635564890503633, 0.5385869573330863, 0.2900814949457165, 0.1180328887257979, 0.02240161203793858, 9.875177101568659, 8.485227055231454, 7.620996146234638, 7.024250358543391, 6.570179117285356, 6.203365389484959, 5.894985927178726, 5.628269936536534, 5.392645656244526, 5.181039112379258, 4.98849330671843, 4.811404716750705, 4.647074106063381, 4.493428638012192, 4.348842679370193, 4.212018144365978, 4.08190218668758, 3.957629113065329, 3.838478465598752, 3.723844173271327, 3.613211452176181, 3.506139238532034, 3.402246642928636, 3.301202374253514, 3.202716388695421, 3.106533228034236, 3.012426656003657, 2.92019530323082, 2.829659103878326, 2.740656359664733, 2.65304130544016, 2.566682079024332, 2.481459019380445, 2.397263233354607, 2.313995383536916, 2.231564659281326, 2.149887900268579, 2.068888847727978, 1.988497502932012, 1.908649576126749, 1.829286011874009, 1.750352579020325, 1.671799515296526, 1.593581217986182, 1.515655973256342, 1.437985717679334, 1.360535826237835, 1.283274921735873, 1.206174701068216, 1.129209774256953, 1.052357512570126, 0.9755979024138269, 0.8989134020557564, 0.8222887986170745, 0.7457110631937729, 0.6691692025078694, 0.5926541063245384, 0.5161583915649579, 0.4396762485800066, 0.3632033106187962, 0.286736635490822, 0.2102752854651979, 0.1338255785567066, 0.05748978473113864 },
                { 0.59, 180.2170545937461, 171.4790084888603, 163.7160781963007, 156.609332689457, 149.9868761253435, 143.7479915856523, 137.8273485977959, 132.1794146402559, 126.770774931885, 121.5759439973161, 116.5748971003477, 111.7515247947993, 107.0926177274357, 102.5871731266837, 98.22590539881941, 94.0008911715789, 89.90530575568736, 85.93322348267986, 82.07946374192566, 78.33947039560416, 74.70921602136778, 71.18512492455479, 67.7640105471069, 64.44302406369591, 61.21961177360937, 58.09147948187941, 55.05656248779433, 52.11300011153294, 49.2591139227211, 46.49338901051433, 43.81445776886937, 41.22108577392991, 38.71215941074451, 36.28667496952529, 33.94372898149232, 31.68250960410111, 29.50228889741344, 27.4024158592769, 25.38231010814384, 23.44145611979982, 21.57939793876659, 19.79573429730776, 18.09011408527402, 16.4622321228564, 14.911825195968, 13.43866832068087, 12.042571209089, 10.72337491429306, 9.480948637014204, 8.31518668072157, 7.22600554615319, 6.213341159752767, 5.277146233843764, 4.417387759304858, 3.634044634056298, 2.927105432725697, 2.296566324229761, 1.742429144148016, 1.264699626025655, 0.8633857841609831, 0.5384963939441597, 0.2900392878352727, 0.1180175699098917, 0.02239890064376927, 9.281893324799313, 8.180164428331546, 7.397199997499297, 6.843617811121597, 6.417555530600578, 6.07086626944924, 5.777889329226464, 5.523481605639013, 5.298005957843648, 5.094968470720333, 4.909793774968813, 4.739141101061034, 4.580498830332749, 4.431932152541254, 4.291919536224579, 4.159243080730546, 4.032912824963792, 3.912113166278604, 3.796164089694216, 3.684492567088704, 3.57661109481868, 3.472101340689926, 3.370601512531312, 3.271796480674991, 3.175409967649602, 3.081198310008208, 2.988945430164212, 2.89845874983016, 2.80956584368715, 2.722111680499412, 2.635956334539552, 2.550973076645825, 2.467046774070171, 2.384072543293094, 2.301954611449666, 2.220605350838683, 2.13994445783104, 2.059898252833197, 1.980399082151014, 1.901384805901396, 1.822798358732205, 1.744587372185092, 1.666703849186557, 1.589103882469325, 1.51174740977941, 1.434597999570409, 1.357622661571202, 1.280791677174191, 1.20407844506025, 1.127459337881005, 1.050913566182732, 0.9744230461007277, 0.8979722676992343, 0.8215481612031654, 0.7451399587984126, 0.6687390502370976, 0.5923388313549825, 0.5159345463508461, 0.4395231292741953, 0.3631030658068428, 0.2866743644601502, 0.210239123390742, 0.1338067658036524, 0.05748270853733869 },
                { 0.61, 177.6096742917807, 169.2637001447902, 161.7553212765957, 154.8455719655049, 148.3862593978622, 142.28738899581, 136.4895947211564, 130.9510742020774, 125.6409329844298, 120.5354853771867, 115.6160466799156, 110.8675383584279, 106.2775653713893, 101.835782344018, 97.53344423289736, 93.36307917693934, 89.31824480656005, 85.39334309314047, 81.58347722029768, 77.88433923709855, 74.2921206672206, 70.80344051262619, 67.41528662676097, 64.12496749599256, 60.93007221794205, 57.82843700285997, 54.81811691524819, 51.89736186135022, 49.06459604354249, 46.31840026541129, 43.65749659558766, 41.08073499427495, 38.58708158103473, 36.17560828101092, 33.8454836331959, 31.59596458141114, 29.42638909851278, 27.33616951854433, 25.32478647137019, 23.39178333067738, 21.53676109986049, 19.75937367177787, 18.05932340813558, 16.43635699267368, 14.89026151967861, 13.42086078584678, 12.02801175935148, 10.71160120525103, 9.471542451220791, 8.307772282063978, 7.220247955600618, 6.208944336369977, 5.273851147106109, 4.414970341132978, 3.632313601618866, 2.925899975923656, 2.295753654844946, 1.741901906864968, 1.264373174853181, 0.8631953311108501, 0.5383940400814268, 0.2899909499235667, 0.1179998189248215, 0.02239573427052679, 8.684363975894612, 7.879767950067206, 7.177337835491064, 6.665960462912821, 6.267240558907385, 5.940194621755235, 5.662257192304946, 5.419874361818114, 5.204320357865724, 5.009666475915998, 4.83170903860362, 4.667363116069004, 4.514299739841976, 4.370718458264441, 4.235199069960089, 4.106601722536932, 3.983997663570265, 3.866620045083274, 3.753828215540969, 3.645081306374556, 3.539918362871045, 3.437943172284056, 3.338812521952736, 3.242227001351376, 3.14792371774082, 3.055670469965425, 2.965261046576275, 2.876511400401716, 2.789256513281348, 2.703347809410401, 2.618651008620394, 2.535044335360066, 2.452417017491621, 2.370668022927325, 2.289704992765789, 2.209443337780013, 2.12980547146445, 2.050720157807291, 1.972121955842975, 1.893950746101432, 1.816151326487712, 1.738673067037564, 1.661469614508071, 1.584498638961096, 1.50772161544693, 1.431103634649302, 1.354613236954472, 1.278222264893218, 1.20190572930657, 1.125641684932057, 1.049411111421734, 0.9731977961094566, 0.8969882151653205, 0.8207714101348882, 0.7445388572957818, 0.6682843278454201, 0.5920037378437875, 0.5156949886342913, 0.4393578031345618, 0.3629935791124967, 0.2866053486861066, 0.2101983304136432, 0.1337851467133152, 0.05747446072851212 },
                { 0.63, 175.0300083610278, 167.0659321726847, 159.8071633321482, 153.0906948464147, 146.7916817671742, 140.8305888630861, 135.1538519050651, 129.7232935987446, 124.5104679679572, 119.493437612622, 114.6548195447532, 109.9805367332471, 105.4589853021333, 101.0804586642996, 96.83673709186244, 92.72078756597646, 88.72653935676222, 84.84871296341596, 81.08268750645553, 77.42439638206264, 73.87024405559787, 70.41703891499483, 67.06193849669358, 63.80240436375603, 60.63616459963459, 57.56118237252205, 54.57562938364229, 51.67786327778994, 48.86640829270427, 46.1399385739402, 43.4972636966962, 40.93731602473222, 38.45913960563656, 36.06188035605778, 33.7447773336178, 31.50715492667481, 29.34841582086609, 27.2680346239162, 25.26555204867857, 23.34056956966515, 21.49274448109045, 19.72178529524825, 18.0274474292724, 16.40952913634402, 14.86786764445922, 13.40233547217694, 12.01283689648847, 10.69930455321558, 9.461696155245507, 8.299991318510624, 7.214188489953974, 6.204301975798904, 5.270359072246133, 4.412397304214321, 3.630461780847352, 2.92460267910803, 2.294872868620747, 1.741325691438497, 1.264012907905025, 0.862982808264484, 0.538278443054764, 0.2899356970494413, 0.1179793162489351, 0.02239205223119268, 8.085480901950824, 7.583970188791413, 6.961728659760352, 6.491528003856432, 6.119432438777676, 5.811515767873867, 5.548232186580603, 5.317574211340916, 5.111701940668809, 4.925235768345933, 4.754333014370526, 4.596157196924995, 4.448556714906638, 4.309861592051702, 4.178750033798731, 4.054157989752956, 3.935216158984855, 3.821205051764122, 3.711522254529828, 3.605658139535613, 3.503177542205401, 3.40370573567063, 3.306917552278348, 3.212528845216305, 3.120289714634585, 3.029979081265844, 2.941400301202157, 2.854377593875431, 2.768753111606894, 2.684384520080412, 2.601142989284264, 2.518911516946798, 2.437583523401004, 2.357061669649467, 2.277256860227088, 2.198087400036399, 2.119478280211758, 2.041360572658526, 1.963670916510533, 1.886351082576719, 1.809347604073965, 1.732611463695782, 1.656097828444435, 1.57976582473444, 1.50357834711967, 1.427501894654505, 1.351506429413319, 1.275565252097866, 1.199654889990206, 1.123754992788369, 1.047848232119136, 0.9719202007822617, 0.8959593080680593, 0.8199566678330031, 0.7439059764542998, 0.6678033783871114, 0.5916473180010982, 0.515438378236349, 0.4391791113716014, 0.3628738830208714, 0.2865288187024913, 0.2101523395118241, 0.1337603593487676, 0.05746488558832363 },
                { 0.65, 172.4825970457243, 164.887882373359, 157.8735342225588, 151.3464285971081, 145.2047033205784, 139.3790108728741, 133.821417962339, 128.4972622500123, 123.3804712718726, 118.450802405859, 113.6921346811339, 109.0913621895049, 104.6376483614307, 100.3219062495005, 96.13642578780916, 92.07459979732649, 88.13071823632979, 84.29981079403265, 80.57752447909197, 76.96002702966801, 73.44392970299805, 70.02622483212249, 66.70423478943451, 63.47556987004637, 60.33809322777526, 57.28989144342083, 54.32924963184695, 51.45463023659392, 48.66465484242613, 45.95808847401688, 43.33382595456988, 40.79087997987844, 38.32837062710796, 35.94551606780994, 33.64162429454459, 31.41608570239354, 29.26836639238074, 27.19800208475443, 25.20459254726269, 23.2877964577917, 21.44732663266251, 19.68294556199844, 17.99446120227819, 16.38172298379363, 14.84461799749087, 13.38306733178652, 11.99702253557816, 10.6864621889275, 9.451388567874759, 8.29182439459998, 7.20780966870912, 6.199398579789866, 5.266656505526964, 4.40965710353212, 3.628479508537764, 2.923205649579369, 2.293917703980157, 1.740695705752522, 1.26361532372931, 0.8627458133159066, 0.5381480991117821, 0.2898727172434232, 0.1179557309597718, 0.02238779166597323, 7.488617894748665, 7.2921739468074, 6.750559068698184, 6.320503891069843, 5.974283250745772, 5.68495978165414, 5.435928800930659, 5.2166839576384, 5.020244293046862, 4.8417623603164, 4.677745281509998, 4.525597313804759, 4.383338731266547, 4.249426006978449, 4.122632729622872, 4.001968332409789, 3.886621155817763, 3.775917632496494, 3.669292431612135, 3.566266224830544, 3.466428861552376, 3.369426453901644, 3.274951334557343, 3.182734157291441, 3.092537617572207, 3.004151413480081, 2.91738816720708, 2.832080098488439, 2.748076292525185, 2.665240442323412, 2.583448972962813, 2.50258947589348, 2.422559396874758, 2.343264932967867, 2.264620103038216, 2.186545963205988, 2.108969944107239, 2.031825291060877, 1.955050591552124, 1.878589377044137, 1.802389788169917, 1.726404293953719, 1.650589456955322, 1.574905737192859, 1.499317328437389, 1.423792021031923, 1.348301085808921, 1.272819173998362, 1.197324228264789, 1.121797400216051, 1.04622296991675, 0.9705882631435298, 0.8948835623651054, 0.8191020077483583, 0.7432394849245618, 0.6672944968725244, 0.5912680182739873, 0.5151633326316734, 0.4389858572896344, 0.3627429774355228, 0.2864439785167571, 0.2101005637636456, 0.1337320289133407, 0.05745382182979529 },
                { 0.67, 169.9713131880945, 162.7312821606871, 155.9560136414755, 149.6142280756569, 143.62666016512, 137.933885865754, 132.4934292661934, 127.2740303777734, 122.2519136087745, 117.4084764839952, 112.728819585585, 108.2007772012341, 103.8142558070914, 99.56076864326333, 95.43309941548496, 91.42505359301495, 87.53127071601071, 83.74708019632138, 80.06838877098741, 76.49159141783807, 73.01349994927972, 69.6312851232694, 66.34242922727307, 63.14468687380808, 60.03605230410372, 57.01473190018384, 54.07912090197614, 51.22778354628562, 48.45943601009657, 45.7729316665855, 43.16724825892387, 40.64147667190122, 38.19481104001013, 35.82653997684758, 33.53603874741921, 31.32276223435968, 29.18623857284506, 27.1260633483243, 25.14189426709903, 23.2334462229833, 21.40048669436599, 19.64283141544394, 17.96034027356634, 16.3529133918288, 14.82048736252066, 13.36303160295335, 11.98054481073433, 10.67305150081627, 9.440598611729019, 8.283252173344482, 7.201094033354385, 6.194218644347944, 5.262729917922023, 4.406738156565899, 3.626357078023715, 2.921700950277207, 2.29288185791281, 1.740007121807477, 1.263176892041944, 0.8624819226808502, 0.5380014904266635, 0.289801190627209, 0.1179287288245661, 0.02238288907711015, 6.897590743073073, 7.003252928615768, 6.543871487794952, 6.153011360418209, 5.831904632398941, 5.560626039571679, 5.325437005901684, 5.117286206787744, 4.93002401049056, 4.759317753437005, 4.602012889461135, 4.455746528462266, 4.318705209828926, 4.189467749615709, 4.066900039951802, 3.950082639069648, 3.83825968955201, 3.730802089052357, 3.627180418254016, 3.526944694946357, 3.429708997541168, 3.33513962382388, 3.242945857529821, 3.152872686756201, 3.064695002777153, 2.978212935512422, 2.893248071649654, 2.809640365432686, 2.727245598401497, 2.645933278236548, 2.565584891931748, 2.486092447276745, 2.407357250796845, 2.32928888109408, 2.251804324822816, 2.174827248942245, 2.098287387870458, 2.022120028054183, 1.946265575511774, 1.870669194289467, 1.795280505631758, 1.720053339112389, 1.644945528085298, 1.569918742659866, 1.494938354034417, 1.419973324479718, 1.344996117588245, 1.26998262362897, 1.194912095003627, 1.119767086919383, 1.044533398505399, 0.9692000097375447, 0.8937590097286233, 0.8182055122260249, 0.7425375545808905, 0.6667559770923015, 0.5908642806754889, 0.5148684628166667, 0.4387768367355534, 0.3625998547517565, 0.2863500253501577, 0.2100424107920957, 0.1336997769287388, 0.05744110653454791 },
                { 0.69, 167.4993582381039, 160.5975300575585, 154.0558833592643, 147.8953181447021, 142.0587001346421, 136.4962862325761, 131.1708869642633, 126.0545318598546, 121.1256651109678, 116.3672693945499, 111.7656261145024, 107.3094786325167, 102.989452065135, 98.79764027784649, 94.72730477165637, 90.77265040320977, 86.92865513054848, 83.19093857120521, 79.55565898690763, 76.01943145267801, 72.57926206159074, 69.23249443982197, 65.97676583294331, 62.80997071985956, 59.73023040901243, 56.73586743364461, 53.82538382974181, 50.99744257928114, 48.25085165154229, 45.58455018968262, 42.9975964778719, 40.48915739271047, 38.05849909625902, 35.70497877033929, 33.42803722545505, 31.2271922447021, 29.10203254487682, 27.05221225479724, 25.07744582549909, 23.17750329915392, 21.35220587381844, 19.60142170990154, 17.92506193187513, 16.32307678554325, 14.79545191735008, 13.34220474794019, 11.96338091763172, 10.65905078674139, 9.429305978890334, 8.274255960573661, 7.194024655409916, 6.188747096584286, 5.258566126007887, 4.403629153545005, 3.624084994174123, 2.920080804945959, 2.291759146752484, 1.739255197554856, 1.262694142052844, 0.8621887517300649, 0.5378371226326743, 0.2897203096138261, 0.1178979805153041, 0.02237728188756348, 6.316561135717439, 6.715630983959199, 6.341544333632479, 5.989118531874823, 5.692373679774306, 5.438587905952017, 5.216825980406213, 5.019446396929438, 4.841103206331239, 4.677961048004761, 4.527192152281104, 4.386658535303922, 4.25470735046308, 4.130035621836927, 4.011598445376836, 3.89854513190091, 3.790173777088513, 3.685898279464709, 3.585223955408451, 3.487729212532289, 3.39305157150747, 3.300876861627323, 3.210930768362828, 3.122972148474341, 3.036787690667545, 2.952187612794634, 2.869002166437786, 2.787078776907204, 2.706279688196142, 2.626480012925245, 2.547566109953591, 2.469434229325006, 2.391989377086711, 2.315144362346158, 2.238818996494982, 2.162939420385762, 2.087437539805141, 2.012250553145866, 1.937320557962721, 1.8625942252696, 1.788022532122637, 1.713560544333312, 1.63916724214002, 1.564805382395502, 1.490441391348545, 1.416045282451887, 1.341590593850017, 1.267054340323708, 1.192416974524973, 1.117662352358976, 1.042777697391727, 0.967753559218733, 0.8925837608569947, 0.8172653304615561, 0.7417984130700266, 0.6661861587291206, 0.5904345844493866, 0.5145524095324622, 0.4385508688957682, 0.3624435252494575, 0.2862461696505039, 0.2099772974202912, 0.1336632305526528, 0.05742657915316616 },
                { 0.71, 165.0692825067247, 158.4878068142205, 152.1741775705427, 146.1907322692586, 140.5018152837262, 135.0671534989894, 129.8546806866403, 124.8396048314078, 120.0025133911325, 115.3279194521356, 110.8032446475074, 106.4181103798977, 102.1638360635498, 98.03307667379507, 94.01955556617203, 90.11786375126497, 86.32330646195442, 82.63178402002018, 79.03969801897186, 75.54387649509338, 72.14151355024213, 68.83012012100549, 65.60748344937306, 62.47163342133965, 59.4208143805207, 56.45346134593688, 53.56817980152779, 50.76372840350381, 48.03900408682493, 45.39302915547131, 42.82494002096481, 40.33397731572847, 37.91947715663843, 35.58086337269879, 33.31764054151319, 31.12938770391007, 29.01575264604927, 26.97644665463088, 25.01123966424773, 23.11995572710218, 21.30246874474892, 19.55869840963338, 17.88860631129891, 16.29219216850663, 14.76949015437157, 13.32056528715266, 11.94550986468876, 10.64443992576592, 9.417491727014745, 8.264818229321885, 7.186585593211543, 6.182969688188435, 5.254152626569542, 4.400319337759889, 3.621654204086899, 2.918337783965471, 2.290543651953733, 1.738435387463778, 1.2621637426846, 0.8618640095285125, 0.5376535589485604, 0.2896292972817019, 0.1178631690831267, 0.0223709098593751, 5.749886283642342, 6.427444712000586, 6.143263318975641, 5.828840304427483, 5.555738195754186, 5.318897071433531, 5.110147562516157, 4.923215594116917, 4.753531820136048, 4.597740878360707, 4.453330291149932, 4.318379069022181, 4.191389347902655, 4.071172237900093, 3.956768948483903, 3.847395177832543, 3.742401131609337, 3.641242250111378, 3.543457414045631, 3.44865246861276, 3.356487593802871, 3.266667499919453, 3.178933728423724, 3.093058542629031, 3.008840033870674, 2.9260981676522, 2.844671564551933, 2.764414861299215, 2.685196534349633, 2.606897095524166, 2.529407589584155, 2.452628338904533, 2.376467892025254, 2.300842141759234, 2.225673585399263, 2.150890704892364, 2.076427449000552, 2.002222802709177, 1.928220431676408, 1.854368391488376, 1.780618893006098, 1.706928116247955, 1.633256066111474, 1.559566463852795, 1.485826668654576, 1.412007623860063, 1.338083822566051, 1.264033287282712, 1.18983755831634, 1.115481685445958, 1.040954217383046, 0.9662471834644727, 0.8913560620746937, 0.8162797304718422, 0.7410203910624787, 0.6655834698235484, 0.589977483706484, 0.514213876045825, 0.438306824210135, 0.3622730401384478, 0.286131653273482, 0.2099046629961427, 0.1336220310547756, 0.05741008514530838 },
                { 0.73, 162.6830275014336, 156.4031742368875, 150.3117293208879, 144.5013446411943, 138.9568690227921, 133.647321363506, 128.5456082813681, 123.6300087612632, 118.8831784428946, 114.2911068300991, 109.8423156552038, 105.5272736427608, 101.3379703887562, 97.26760263351286, 93.31033977862433, 89.4611458597336, 85.71564232532276, 82.07000076770264, 78.52085797413954, 75.06524785059709, 71.70054627131817, 68.42442595333608, 65.23481919445794, 62.12988684345073, 59.10799225640396, 56.16767927670254, 53.30765348707547, 50.52676614102415, 47.82400030171196, 45.19845880910599, 42.64935376795374, 40.17599730522841, 37.77779338977509, 35.45423054183722, 33.20487528803444, 31.02936623978068, 28.92740869128288, 26.89876964807971, 24.94327320929499, 23.06079623696822, 21.25126425444921, 19.5146475232809, 17.85095725455478, 16.26024191666594, 14.74258360693667, 13.29809445990054, 11.92691307029286, 10.62920091409806, 9.4051387564465, 8.254923040786725, 7.178762259599125, 6.17687331293678, 5.249477867205965, 4.396798732706201, 3.619056284351846, 2.916464955425743, 2.28922983875906, 1.737543432626138, 1.261582568006758, 0.8615055435200701, 0.5374494480533861, 0.2895274223896003, 0.1178239960681522, 0.0223637162532829, 5.201926782417399, 6.136774867432012, 5.948488559954904, 5.672134882329719, 5.422020559069518, 5.201587206245176, 5.005439199035044, 4.828632886750703, 4.667349593977035, 4.51869706791775, 4.38046683674142, 4.250947104081855, 4.128789425440548, 4.012914920674702, 3.902447854710654, 3.796667971613457, 3.694975762049541, 3.596866763264182, 3.50191226048334, 3.409744593868497, 3.320045827978104, 3.232538910781952, 3.146980700382935, 3.063156410385193, 2.980875145408051, 2.899966283509769, 2.820276523370335, 2.741667458383233, 2.664013572306734, 2.587200575227954, 2.511124016649317, 2.435688126161, 2.36080484257685, 2.286393000415237, 2.212377648798963, 2.138689482665158, 2.065264369936276, 1.992042961242596, 1.918970371080234, 1.845995921067604, 1.773072937326347, 1.700158595034984, 1.627213803943228, 1.554203129137768, 1.481094741654711, 1.407860393672551, 1.334475413023705, 1.260918711663144, 1.187172802562195, 1.113223819290081, 1.039061532345111, 0.9646793561458741, 0.8900743405397925, 0.8152471407874174, 0.7402019603038425, 0.6649464610845143, 0.5894916379184767, 0.5138516547717718, 0.438043647086105, 0.3620875103404975, 0.2860057643187144, 0.2098239802753198, 0.1335758407439172, 0.05739147895563989 },
                { 0.75, 160.3419850383731, 154.3446444701263, 148.4692133369459, 142.8278951698128, 137.4246171669574, 132.2375336252417, 127.2443911166746, 122.4264376109117, 117.7683240388108, 113.257463492972, 108.8834383977162, 104.6375345730494, 100.5123880370876, 96.50171821888602, 92.60012496619393, 88.80293237645974, 85.10606718828098, 81.50596294015121, 77.99948356528281, 74.58386182253917, 71.25664918426443, 68.01567466940648, 64.85901073323919, 61.78494477716608, 58.79195517399866, 55.87869095040382, 53.04395445290379, 50.28668646368007, 47.60595333934554, 45.00093582828759, 42.47091928626816, 40.01528506016193, 37.63350284930832, 35.32512388539789, 33.08977479694722, 30.92715204463915, 28.83701683018895, 26.81919039477754, 24.87354963412541, 23.00002296649083, 21.19858639768694, 19.46925973397562, 17.81210289970369, 16.22721232204847, 14.71471735044766, 13.27477668338514, 11.90757478034356, 10.61331824204204, 9.39223214764755, 8.244556343540666, 7.1705416844498, 6.170446234315238, 5.244531441023528, 4.393058306022453, 3.616283576573485, 2.914455994716623, 2.287812642451689, 1.736575426358687, 1.260947744941765, 0.8611113721419774, 0.5372235444495724, 0.2894140103524136, 0.1177801859676745, 0.0223556486769678, 4.67683416032265, 5.841913672248057, 5.756428160453551, 5.518893444274127, 5.291219624754413, 5.086676763489704, 4.902726310053507, 4.735727320998258, 4.582587673286746, 4.440861969893091, 4.308634763981647, 4.184395823287047, 4.0669406671685, 3.955296420474658, 3.848667395728967, 3.746395078075022, 3.647928445868369, 3.552801709947089, 3.460617417328309, 3.371033474417789, 3.28375306717607, 3.198516747754374, 3.115096160120567, 3.033289019517603, 2.952915061397408, 2.873812747642028, 2.795836570120137, 2.718854829842871, 2.642747798232041, 2.567406188102944, 2.492729877855617, 2.418626844448712, 2.345012269987254, 2.271807793900425, 2.198940888233857, 2.126344337909886, 2.053955811196085, 1.981717508272652, 1.909575877855549, 1.837481393428825, 1.76538838185207, 1.693254898002348, 1.621042639734209, 1.548716897835953, 1.476246535857865, 1.403603994717745, 1.330765316878792, 1.257710184674048, 1.184421967052976, 1.11088776868683, 1.037098475033695, 0.9630487866816727, 0.8887372361165279, 0.8141661800634474, 0.7393417608100266, 0.6642738305412977, 0.5889758339248449, 0.5134646465567388, 0.4377603723995505, 0.3618861201656293, 0.2858678479523069, 0.2097347633706461, 0.1335243480323816, 0.0573706261905779 },
                { 0.77, 158.0470661699063, 152.3132145687306, 146.6471865847914, 141.1710084306181, 135.9057233604857, 130.8384574038131, 125.9516853190925, 121.2295294109791, 116.6585659298424, 112.2275802469244, 107.9271770076705, 103.7494295372407, 99.6875969757347, 95.73590271086212, 91.88936170565972, 88.14364537018981, 84.49497498115716, 80.94003684150886, 77.47591410114441, 74.10003145439374, 70.81010988111057, 67.60412929429528, 64.48029746795403, 61.43702399603949, 58.47289831393582, 55.58667102451328, 52.7772379301309, 50.04362629358577, 47.38498294458261, 44.8005639208522, 42.28972538971188, 39.85191564041575, 37.48666797289836, 35.19359433657968, 32.97237959536981, 30.82277631310776, 28.74459996833638, 26.73772451929188, 24.80207824986049, 22.93763983549748, 21.14443457510521, 19.42253074095094, 17.77203600414939, 16.19309389827899, 14.68588028855552, 13.25059981883689, 11.88748231373813, 10.59677911843203, 9.378759364401556, 8.233706155566109, 7.161912675850482, 6.163678226377527, 5.23930420795775, 4.389090072263306, 3.613329272770652, 2.912305253889154, 2.286287523148163, 1.735527856004918, 1.260256683739572, 0.860679705700825, 0.5369747215172943, 0.2892884502856787, 0.1177314891061913, 0.02234665963013484, 4.178343920816693, 5.541624216504007, 5.566032782378423, 5.368922725875946, 5.163310132316639, 4.974170888047726, 4.802024097913795, 4.644519409668855, 4.499269861045338, 4.36426151884588, 4.237861381250822, 4.118753374968072, 4.005871666206772, 3.898345472183616, 3.795456209548388, 3.696604846517837, 3.601287086943004, 3.509074418974159, 3.419599530067435, 3.332544981405463, 3.247634331395096, 3.164625114828919, 3.083303241004302, 3.003478487105584, 2.924980844948195, 2.847657538757587, 2.77137057538278, 2.695994720709178, 2.621415820196887, 2.54752939966262, 2.474239496234286, 2.401457679975483, 2.329102234823192, 2.257097473802306, 2.185373168411413, 2.113864075936264, 2.042509551477837, 1.971253233856995, 1.900042796408378, 1.828829755100185, 1.757569327486914, 1.686220336773676, 1.614745155785319, 1.543109685923812, 1.471283366290368, 1.399239208069197, 1.326953849042208, 1.254407622755903, 1.181584636425308, 1.10847285117411, 1.035064157722479, 0.9613544402004361, 0.8873436204510056, 0.8130356750698044, 0.7384386175977641, 0.6635644388671884, 0.5884289997286553, 0.5130518728500176, 0.4374561359670699, 0.3616681360290446, 0.2857173133273682, 0.2096365728474257, 0.1334672706872119, 0.05734740501692273 },
                { 0.79, 155.7987730306996, 150.3098696083094, 144.8461271018747, 139.5312086986873, 134.4007700132189, 129.450692572709, 124.6680897635843, 120.0398729838532, 115.5544775018866, 111.202011502519, 106.9740644998134, 102.8634684878004, 98.86408297106835, 94.97061697414879, 91.17848556172409, 87.48369495994659, 83.88275043681549, 80.37258204724874, 76.95048436990666, 73.61406723632434, 70.36121514448817, 67.1900535799686, 64.09892087065968, 61.0863445061531, 58.15102108407263, 55.29179922189737, 52.50766490779895, 49.79772886809273, 47.16121560965472, 44.59745385870603, 42.10586816689405, 39.68597149472718, 37.33735861349607, 35.05970019162151, 32.85273745126643, 30.71627729708957, 28.65018783201847, 26.65439418552884, 24.72887458865377, 22.87365663723483, 21.08881369112045, 19.37446136241652, 17.73075405076147, 16.15788148816672, 14.65606526044206, 13.22555527680415, 11.86662616411436, 10.57957356745562, 9.364710344556952, 8.222362647990988, 7.152865896143052, 6.156560641661084, 5.233788354356183, 4.38488714416451, 3.610187458535875, 2.910007797094238, 2.284650494047573, 1.734397624646983, 1.2595070939013, 0.8602089573327401, 0.5367019783934193, 0.2891501987276742, 0.1176776831545886, 0.02233670679332539, 3.709598488087843, 5.235348369389416, 5.376025012868726, 5.221922145212561, 5.038239093492559, 4.8640624050937, 4.703338881893688, 4.555022293517519, 4.417413591937917, 4.288916049311165, 4.168169022275169, 4.054043460717566, 3.94560702580001, 3.842087223437221, 3.74283970670888, 3.647322723749372, 3.555076982706547, 3.465709884233157, 3.378883159601607, 3.294303133150403, 3.211713003022204, 3.130886678663772, 3.051623825686532, 2.973745853494476, 2.897092644597167, 2.821519871988796, 2.746896786520476, 2.673104382933706, 2.600033873455899, 2.527585413266625, 2.455667033955216, 2.38419375020619, 2.313086812028528, 2.242273080374398, 2.17168450833219, 2.101257713494305, 2.030933629790924, 1.960657229194535, 1.890377305346757, 1.820046312420511, 1.749620253467671, 1.679058613159695, 1.608324330239992, 1.537383805197596, 1.466206938663348, 1.394767195841849, 1.323041691945717, 1.251011293118096, 1.178660726746101, 1.105978694422192, 1.032957980153109, 0.9595955458097564, 0.8858926053315023, 0.811854668933708, 0.7374915486243436, 0.6628173168567882, 0.587850211378006, 0.5126124818808322, 0.4371301799328478, 0.361432910981694, 0.2855536372089515, 0.209529018407298, 0.1334043575490463, 0.05732170690275435 },
                { 0.81, 153.5972680772496, 148.3355634847921, 143.0664697849398, 137.9089334032428, 132.9102660703351, 128.0747784143911, 123.3941517048313, 118.8580126081974, 114.4565936064637, 110.1812784007578, 106.02460530205, 101.9801369904178, 98.04231118828576, 94.20630469355446, 90.46791801479409, 86.82347998127551, 83.26976953605437, 79.80395166413223, 76.42352474466264, 73.12627708331201, 69.91025082226406, 66.7737117973842, 63.71512421122711, 60.7331292261494, 57.82652676567087, 54.99425995540324, 52.23540174645066, 49.54914335140045, 46.93478419144773, 44.39172310711182, 41.91945062766793, 39.51754212832423, 37.18565173122952, 34.92350682806416, 32.73090311938349, 30.60770007993356, 28.55381677054279, 26.56922792646936, 24.6539602597066, 22.80808891909387, 21.03173405746818, 19.3250574597999, 17.68825919053244, 16.12157422241824, 14.62526901322047, 13.19963800092913, 11.84499999280045, 10.56169442873407, 9.350077505387936, 8.210518154099467, 7.143393873187096, 6.149086423541502, 5.227977405496412, 4.380443744615625, 3.606853123954384, 2.907559410117166, 2.282898129403712, 1.733182057465398, 1.25869698898048, 0.8596977463825045, 0.536404442128226, 0.2889987808206207, 0.1176185736161477, 0.0223257531207152, 3.273018176501263, 4.923330525673603, 5.184971408442375, 5.077459378793325, 4.915918678732, 4.756331784616271, 4.606669030009157, 4.467242638129612, 4.337030698216654, 4.214840942267602, 4.099575592745168, 3.990285798865173, 3.886167752996691, 3.786543569133905, 3.690840354168835, 3.598571494316614, 3.50932102648782, 3.422730933965345, 3.338490922572451, 3.256330210052526, 3.176010919394885, 3.097322741503157, 3.020078601782545, 2.944111122880495, 2.869269721737926, 2.795418214925227, 2.7224328339191, 2.650200573311768, 2.578617811402034, 2.507589155350737, 2.437026472975214, 2.366848080978843, 2.296978065467994, 2.22734571538031, 2.157885053221191, 2.088534450494694, 2.019236317582224, 1.949936859688187, 1.880585891926121, 1.811136707728173, 1.74154599557359, 1.671773799583155, 1.601783519841417, 1.531541948405736, 1.461019336855455, 1.390189490940169, 1.31902988741934, 1.24752180756808, 1.175650481085402, 1.103405233322385, 1.03077962790274, 0.9577715960064704, 0.8843835429144711, 0.8106224219708293, 0.7364997660342765, 0.662031666922815, 0.5872386945727034, 0.5121457502592421, 0.4367818542710016, 0.3611798860416594, 0.2853763650796525, 0.2094117597281348, 0.1333353890790104, 0.05729343685524866 },
                { 0.83, 151.4424371381997, 146.3911886439244, 141.3086361895573, 136.3045468811998, 131.4346528446258, 126.7111983429246, 122.1303707876378, 117.684451290111, 113.3654131673514, 109.1658708504454, 105.0792768098913, 101.0998973691715, 97.22272698964188, 93.44339287835674, 89.75806671701918, 86.16338803331751, 82.65639937997656, 79.23449205786027, 75.89536079269765, 72.6369658492893, 69.45750126702715, 66.35536811943532, 63.32915189971504, 60.37760330309523, 57.49962181507962, 54.69424162610973, 51.96061948224989, 49.29802415251253, 46.70582725002301, 44.18349518935885, 41.73058209846834, 39.34672353246202, 37.03163085975583, 34.78508620969129, 32.60693788578089, 30.49709616085636, 28.45552938021343, 26.48226030682567, 24.57736264923019, 22.74095771810228, 20.97321116211969, 19.27432973772709, 17.64455807108215, 16.08417537401816, 14.59349207950631, 13.17284636604747, 11.82260054486291, 10.54313728886744, 9.334855688353752, 8.198167125219648, 7.133490965505771, 6.141250078990209, 5.221866204532052, 4.375755190584508, 3.603322151495295, 2.904956591401434, 2.281027558002197, 1.731878897121122, 1.257824683429407, 0.8591448963596691, 0.5360813664637154, 0.2888337896738827, 0.1175539935732706, 0.02231376679265176, 2.870229445637961, 4.606642019793139, 4.991395372052787, 4.934950479889773, 4.796215402017231, 4.650945855157555, 4.512005508242527, 4.381181328028249, 4.258128024934751, 4.142047149024422, 4.032095014359764, 3.927496500876526, 3.827571577659499, 3.73173342140115, 3.63947790302273, 3.550371471564863, 3.464039866567844, 3.380158361750335, 3.298443597636577, 3.218646839065869, 3.14054843802068, 3.063953289398182, 2.988687095107788, 2.91459328338132, 2.841530459175811, 2.769370286163229, 2.697995720921815, 2.62729953608388, 2.557183082025563, 2.487555246847833, 2.418331582446371, 2.349433570851035, 2.280788010090272, 2.212326502881115, 2.143985034676536, 2.075703630184454, 2.007426079532111, 1.939099726880856, 1.870675315569892, 1.802106884834995, 1.733351713846087, 1.664370309261181, 1.595126432720507, 1.525587164714626, 1.45572300106247, 1.38550797783749, 1.314919819993767, 1.243940108186479, 1.172554457379792, 1.100752699830701, 1.028529063986579, 0.9558823398132194, 0.8828160201756255, 0.8093384072441247, 0.7354626726374056, 0.6612068603269431, 0.5865938225049722, 0.5116510813076159, 0.4364106155112392, 0.360908589237858, 0.2851851104431759, 0.2092845059847383, 0.1332601770670587, 0.05726251329851019 },
                { 0.85, 149.3339445362598, 144.477544699595, 139.5730550821066, 134.7183554217898, 129.9743089754472, 125.3603833252309, 120.8772019631763, 116.5196531185168, 112.2814009982475, 108.1562488746161, 104.138530329706, 100.2231893068682, 96.40575624378012, 92.68229192528575, 89.04932534755815, 85.50379515999351, 82.04299772655247, 78.66454227095322, 75.36631259761167, 72.14643457382491, 69.0032485253723, 65.93528576884937, 62.9412486070901, 60.01999321859596, 57.17051496632634, 54.39193573211084, 51.68349295040897, 49.0445300705849, 46.4744882220683, 43.97289889347275, 41.53937746647718, 39.17361746934097, 36.87538543438888, 34.64451625954025, 32.48090898667444, 30.38452291989769, 28.35537401507474, 26.39353147870442, 24.49911451967979, 22.67228920196831, 20.91326535002963, 19.22229346209263, 17.59966158946329, 16.04569214304608, 14.56073859145042, 13.14518201863286, 11.79942751320607, 10.52390036652962, 9.319042062668749, 8.185306050419028, 7.123153295950513, 6.133047624258205, 5.215450868454359, 4.370817857819407, 3.59959128810835, 2.902196530368411, 2.279036446684778, 1.730486291597267, 1.256888783979919, 0.8585494291679321, 0.5357321282899104, 0.2886548844775117, 0.1174838029260043, 0.02230072107176899, 2.502050840212347, 4.28710967250381, 4.793918542202058, 4.793651923716885, 4.67893605024392, 4.547854941762614, 4.419331998505539, 4.296833989507465, 4.180707933238522, 4.070541627153247, 3.965737596402443, 3.86568838699884, 3.769833220040965, 3.677672935715739, 3.588769578642916, 3.502740656353471, 3.419252037291581, 3.338011033261358, 3.258760210658131, 3.181272059761052, 3.105344485652373, 3.030797026202821, 2.957467690310701, 2.885210315863272, 2.813892359574488, 2.743393044685022, 2.673601805357783, 2.604416977747528, 2.535744697068029, 2.467497967675755, 2.399595879466961, 2.331962948983498, 2.264528567755948, 2.197226543761999, 2.129994724591037, 2.06277469310032, 1.995511528115218, 1.928153624135771, 1.860652565115964, 1.792963048217914, 1.725042854035601, 1.656852860147744, 1.588357095005172, 1.519522829088384, 1.450320699986874, 1.380724867555044, 1.310713194595095, 1.24026744761797, 1.16937351116291, 1.098021607954127, 1.02620651589862, 0.95392777166466, 0.8811898494339153, 0.8080023025268903, 0.7343798551274831, 0.6603424314897519, 0.5859151111184161, 0.5111280011487283, 0.4360160235580049, 0.3606186330822733, 0.2849795528896326, 0.2091470144628505, 0.1331785637639, 0.05722886770393554 },
                { 0.87, 147.2712799146012, 142.5953127173016, 137.86017170911, 133.1506235262571, 128.5295554204716, 124.0227144782494, 119.6350576645099, 115.364045023713, 111.2049891239728, 107.1528435344123, 103.202791657877, 99.35043012902443, 95.59180535825264, 91.92339543768898, 88.34207325165801, 84.84506533818528, 81.42991235364566, 78.09443328343088, 74.83669393794056, 71.65497959677582, 68.54777140473841, 65.51372605164384, 62.55165827818121, 59.66052579271912, 56.83941623618755, 54.08753588371643, 51.40419981839013, 48.78882335295802, 46.24091450961223, 43.76006739654175, 41.34595634361912, 38.99833067900698, 36.71701004436199, 34.50188015925487, 32.35288895592226, 30.27004301394835, 28.25340423130322, 26.30308667365205, 24.41925354826575, 22.60211425245104, 20.85192144940109, 19.16896812696008, 17.5535845972071, 16.00613539721052, 14.52701605400079, 13.11664967998361, 11.77548336889358, 10.503984367199, 9.302636001824058, 8.171933352341711, 7.112378664546909, 6.124476512608806, 5.208728728782297, 4.365629132757738, 3.595658106795014, 2.899277077262236, 2.276922977229041, 1.729002777003826, 1.255888177371558, 0.8579105568431366, 0.5353562225484823, 0.2884617877800347, 0.1174078872906492, 0.02228659409460512, 2.168529997406602, 3.967167015947207, 4.591410507838066, 4.652671568951802, 4.563811802455611, 4.446988100832835, 4.328624466214801, 4.214191343430144, 4.104768714118298, 4.000327710907439, 3.900510354719697, 3.804871258586345, 3.712964622318408, 3.624375706884756, 3.538730245548679, 3.455694874554797, 3.374974072366755, 3.296305978076507, 3.21945810738036, 3.144223379913462, 3.070416598614408, 2.99787140026996, 2.926437645414353, 2.855979197676363, 2.786372039625579, 2.717502675614287, 2.64926677795844, 2.581568039142389, 2.514317198725867, 2.447431218955567, 2.380832587661163, 2.314448730881043, 2.248211520893315, 2.182056868010343, 2.115924386712699, 2.049757128522722, 1.983501375507526, 1.917106489502144, 1.850524813089406, 1.783711619087474, 1.716625105792632, 1.649226435510281, 1.581479813981192, 1.513352608168677, 1.444815499509248, 1.375842669138845, 1.306412010787339, 1.236505365992314, 1.166108775038423, 1.095212735618327, 1.023812459695632, 0.9519081175175623, 0.8795050562948175, 0.8066139798915836, 0.7332510751406694, 0.6594380703596858, 0.5852022126478663, 0.5105761532978469, 0.4355977372369019, 0.3603097109923295, 0.284759435333152, 0.2089990885668967, 0.1330904206274072, 0.05719244405504678 },
                { 0.89, 145.2537972327225, 140.745038423798, 136.1704458954037, 131.6015903118862, 127.1006612022478, 122.6985252461538, 118.404309484757, 114.2180181496126, 110.1365777990511, 106.1560576087537, 102.2724614601548, 98.48201492342369, 94.78126117630983, 91.16707993237656, 87.63667498651939, 84.18754988824399, 80.81748035692649, 77.52448721843595, 74.30681141866402, 71.1628916319894, 68.09134450396224, 65.0909473577097, 62.16062311413153, 59.29942715892971, 56.50653590109348, 53.78123679076179, 51.12291959107245, 48.53106872470711, 46.00525653960675, 43.54513735914699, 41.15044219986268, 38.82097405479051, 36.55660365295363, 34.35726561576383, 32.2229549394767, 30.15372373959037, 28.14967819848565, 26.21097566190006, 24.33782183322199, 22.53046801728529, 20.78920836753158, 19.11437709228144, 17.50634557761509, 15.9655193862182, 14.49233509372092, 13.08725692678608, 11.75077317073303, 10.48339231907154, 9.285638943212193, 8.158049268041066, 7.101166448174428, 6.115535550646011, 5.201698262514687, 4.360187356253135, 3.591520961432433, 2.896196707552334, 2.274685818955121, 1.727427257139763, 1.254822015726368, 0.857227671685107, 0.5349532561349417, 0.2882542822270293, 0.1173261566790144, 0.02227136862159497, 1.869020725205547, 3.649655665913114, 4.383123750757893, 4.511003065823072, 4.450483135086522, 4.348246276531736, 4.239849999231298, 4.133239359361558, 4.030304922205492, 3.931405430310972, 3.836417291229569, 3.745052138666287, 3.656975154264517, 3.57185294390723, 3.489372555060203, 3.409247900589577, 3.331220606926478, 3.255058472550591, 3.180553019094663, 3.10751682572059, 3.035780959128305, 2.965192628289445, 2.895613104444938, 2.826915905246853, 2.758985223692485, 2.691714575926101, 2.625005641087081, 2.558767268100258, 2.492914627074967, 2.427368486023278, 2.362054596551854, 2.296903174863427, 2.231848466768052, 2.166828387448262, 2.101784228466168, 2.036660425972107, 1.971404385300819, 1.905966358145254, 1.840299369296623, 1.774359190542256, 1.708104359723301, 1.641496243169525, 1.574499139739972, 1.507080424494043, 1.439210729583399, 1.37086415927764, 1.302018535106762, 1.232655665920439, 1.16276163624185, 1.092327104665793, 1.021347602277609, 0.949823819244004, 0.8777618659801397, 0.8051734938016395, 0.7320762589432128, 0.6584936135442052, 0.5844549080589275, 0.5099952922947517, 0.4351555090227599, 0.3599815930372764, 0.2845245607160332, 0.2088405754367166, 0.1329956468202855, 0.05715319820549714 },
                { 0.91, 143.2807467985801, 138.9271247967367, 134.5043411807558, 130.0714843348187, 125.6878503580164, 121.3881035370669, 117.1852895420121, 113.0819289810591, 109.0765363529779, 105.1662661490392, 101.3479155609839, 97.61831659660175, 93.9744908319429, 90.41370452167429, 86.93347985578221, 83.53158688360073, 80.20602745491845, 76.95501656095775, 73.77696362004174, 70.6704548610944, 67.63423726544835, 64.66720418350786, 61.76838257660736, 58.93692175973014, 56.17208349312768, 53.47323326697008, 50.83983263060808, 48.27143243029629, 45.76766683289553, 43.3282480264082, 40.95296150038368, 38.64166181993512, 36.39426881626296, 34.21076412424813, 32.09118800398107, 30.03563638818343, 28.0442581015126, 26.11725220087613, 24.25486538827835, 22.45738944953578, 20.72515867359308, 19.05854720832137, 17.45796630977299, 15.92386144310589, 14.45670919500626, 13.05701395967711, 11.72530436359439, 10.46212939854439, 9.268054238230117, 8.143655721240784, 7.089517492639936, 6.106224807994144, 5.19435901736335, 4.35449176246926, 3.5871789375932, 2.892954483094435, 2.27232409878024, 1.725758981114158, 1.25368970051276, 0.8565003354253411, 0.5345229411991422, 0.288032206975517, 0.1172385440457404, 0.02225503176202042, 1.602287344296385, 3.337606683246044, 4.168793297037684, 4.367584049869325, 4.338489061915162, 4.25149354011774, 4.152964708810903, 4.053959151234848, 3.957307627442327, 3.863771787252299, 3.773459642771131, 3.686235488608091, 3.601871799939569, 3.520113629768229, 3.440707081094396, 3.363411571777359, 3.288004472651367, 3.21428211763838, 3.142059124857297, 3.071166989911497, 3.001452430657503, 2.932775719083538, 2.865009110789149, 2.798035418022629, 2.731746739299579, 2.666043342377322, 2.600832689958663, 2.536028594760634, 2.471550490251988, 2.407322804214379, 2.343274423655981, 2.279338241150796, 2.215450774209957, 2.151551850723234, 2.087584354799844, 2.023494028472971, 1.959229325709146, 1.894741315982687, 1.829983635337068, 1.764912483356425, 1.69948666480435, 1.63366767484164, 1.567419826693177, 1.500710420376458, 1.433509950608063, 1.365792351247738, 1.297535272605169, 1.228720386613108, 1.159333713268796, 1.08936595989218, 1.018812862703176, 0.9476755180779537, 0.8759606887476584, 0.8036810683440253, 0.7308554863219036, 0.6575090347139603, 0.5836730988365819, 0.5093852767647313, 0.4346891792790678, 0.3596341212798129, 0.2842747883928437, 0.2086713633293858, 0.1328941675581709, 0.05711109717281206 },
                { 0.93, 141.3513013299039, 137.141832764494, 132.8623084927626, 128.5605349933175, 124.2913101597557, 120.0916941786922, 115.9782916885229, 111.9561003229489, 108.0252039473059, 104.1838169875286, 100.4295052151674, 96.75968593388806, 93.17184162478629, 89.66361062793203, 86.23282148608354, 82.87750060960473, 79.59586734836482, 76.38632343422971, 73.24744030600521, 70.1779460874857, 67.17671308712333, 64.24274621326356, 61.37517244849257, 58.57323139618153, 55.83626684683207, 53.16371928168029, 50.55511921993771, 48.01008131500773, 45.52829910897522, 43.10954036081387, 40.75364287054366, 38.46051072816748, 36.23011092220032, 34.06247024778771, 31.95767245873698, 29.91585561127082, 27.93720955002056, 26.02197348878954, 24.1704336400389, 22.38292084799694, 20.6598081809019, 19.00150843831007, 17.40847152981153, 15.88118168209633, 14.42015443233732, 13.02593336756381, 11.69908657238572, 10.44020275140635, 9.249886998258702, 8.128756190733497, 7.077434001215369, 6.096545523810146, 5.186711534208979, 4.348542415390959, 3.582631801367928, 2.889550011660061, 2.269837369979696, 1.723997519978345, 1.252490865787478, 0.8557282678998939, 0.5340650881362938, 0.2877954539413408, 0.1171450037675787, 0.02223757468603836, 1.366623703163872, 3.034028809346524, 3.948687422657427, 4.221373548852546, 4.227264619705429, 4.156547077260845, 4.067910503546689, 3.976326523549162, 3.885764569423686, 3.797420991789825, 3.711636104985635, 3.628423406236047, 3.547659330075838, 3.469164670225391, 3.392742447649112, 3.3181958966221, 3.245336788717271, 3.173988914141213, 3.103989112481088, 3.035187079772406, 2.967444594126837, 2.900634499075292, 2.834639622880857, 2.769351725277644, 2.704670515896494, 2.640502763025489, 2.576761497668801, 2.513365310832194, 2.450237738642354, 2.387306728647507, 2.324504180510446, 2.261765554756942, 2.199029543977604, 2.136237801726485, 2.073334725217201, 2.010267288732077, 1.946984925399891, 1.883439455642968, 1.819585061129222, 1.755378303474146, 1.690778187204502, 1.625746266598922, 1.560246795935929, 1.494246922378693, 1.427716920177295, 1.360630464042543, 1.292964938413463, 1.224701777885224, 1.155826832283271, 1.086330747784584, 1.016209353153791, 0.945464037679456, 0.8741021049158697, 0.8021370840697437, 0.7295889790974224, 0.6564844346540197, 0.582856798451758, 0.5087460621932118, 0.4341986702499459, 0.3592672049112839, 0.2840100303504838, 0.2084913788802327, 0.1327859323806464, 0.05706611839897227 },
                { 0.95, 139.4645770137163, 135.3892880040618, 131.2447680770896, 127.0689791356397, 122.9112002355384, 118.8095020011934, 114.7835727146675, 110.840822199853, 106.9828902980454, 103.2090312485851, 99.51755740714643, 95.906451704535, 92.37364095309604, 88.91712176585331, 85.53501747861396, 82.22560110242079, 78.98730116293972, 75.81869896125257, 72.71852171817967, 69.68563397535944, 66.71902851794278, 63.81781748144454, 60.98122397295639, 58.2085743523621, 55.4992912170921, 52.8528870784728, 50.26895868878212, 47.74718196426559, 45.28730744398236, 42.88915622358664, 40.55261630475115, 38.27763930359049, 36.06423746438154, 33.91248092767564, 31.82249520432262, 29.79445880886991, 27.82860100722704, 25.92519963441089, 24.08457893866075, 22.30710740831054, 20.59319553763483, 18.94329348757568, 17.35788859697369, 15.83750269986522, 14.3826892048057, 12.99402989331206, 11.67213139670114, 10.41762131418465, 9.231143940435454, 8.113355578335669, 7.064919422595246, 6.086500012656709, 5.178757268915841, 4.342340144731931, 3.577879947647442, 2.885983406002902, 2.267225580567474, 1.722142743059512, 1.251225361215406, 0.8549113355677813, 0.5335795984803402, 0.2875439639934642, 0.1170455101009437, 0.02221899233257178, 1.159975842622859, 2.741724155962138, 3.723604666892359, 4.071439734264082, 4.116149994114259, 4.063167176855121, 3.984610643272811, 3.900311052236031, 3.815660184082276, 3.732344656428434, 3.650943034303579, 3.571615808841806, 3.494340463221662, 3.419011034221132, 3.345485450232038, 3.273609158974932, 3.203227050250927, 3.134189336845275, 3.066354239594596, 2.999588966236935, 2.93376978604813, 2.868781640367109, 2.804517533079525, 2.740877836579489, 2.677769587657222, 2.61510581306356, 2.552804904736831, 2.490790053490947, 2.428988743758492, 2.367332308689018, 2.305755543312585, 2.244196372879685, 2.182595573457318, 2.12089654214337, 2.059045114704198, 1.996989428949301, 1.934679832672612, 1.872068835471867, 1.809111104175185, 1.745763501930654, 1.681985171223593, 1.617737661148049, 1.552985099141169, 1.487694407054749, 1.4218355608479, 1.355381892298019, 1.288310429906801, 1.220602274595012, 1.152243003821602, 1.08322309544246, 1.013538359992011, 0.9431903672261676, 0.8721868498682634, 0.8005420647818183, 0.72827708956586, 0.6554200312338644, 0.5820061237447031, 0.5080776936206458, 0.4336839799796557, 0.3588808153243195, 0.2837302473773589, 0.2083005843257809, 0.1326709133977215, 0.05701824900038778 },
                { 0.97, 137.6196504391491, 133.669491755641, 129.6520927701423, 125.5970623616869, 121.5476618391034, 117.5416957519877, 113.6013537002903, 109.7363527305697, 105.9498763949918, 102.2422038906202, 98.61237520353476, 95.0589208353048, 91.58019632609952, 88.17454341217188, 84.8403691537237, 81.57618378481691, 78.38061699112399, 75.25242272642698, 72.19047796982425, 69.1937783875045, 66.26143255016656, 63.39265562931952, 60.58676308332649, 57.84316460687129, 55.16135847991573, 52.54092637222884, 49.981528613378, 47.48289991185596, 45.04484549263593, 42.66723761503219, 40.35001242935902, 38.0931671297402, 35.89675736043584, 33.76089483355851, 31.68574511664951, 29.67152554904399, 27.7185032461462, 25.82699315060846, 23.9973560889574, 22.22999679147661, 20.52536183221115, 18.88393744491742, 17.30624716979238, 15.79284928507109, 14.34433397732174, 12.96132020478147, 11.6444522097039, 10.39439563881452, 9.211833236011566, 8.097460078836824, 7.051978340382916, 6.076091571540464, 5.170498515029776, 4.335886482508465, 3.572924348903897, 2.882255243295353, 2.264489041947559, 1.720194794487932, 1.249893235223302, 0.8540495401173684, 0.5330664578506039, 0.2872777231763395, 0.1169400556507196, 0.02219928311931975, 0.9800595754086662, 2.463144291194774, 3.494821013575996, 3.917046630959023, 4.004413229960483, 3.971049005512248, 3.902964164823032, 3.825874576510132, 3.746975455998367, 3.668531939829207, 3.591374628659568, 3.515810603091702, 3.441916017546903, 3.369655887533892, 3.298941172574254, 3.229658019182766, 3.161683215211181, 3.094892408312955, 3.029164395403323, 2.964383234573633, 2.900439139003785, 2.837228691818565, 2.774654690082029, 2.712625796227545, 2.65105610059861, 2.589864655241805, 2.528975013429278, 2.468314794183277, 2.407815282084027, 2.34741106738625, 2.28703972847858, 2.226641557109786, 2.166159326037452, 2.105538098496943, 2.04472507893396, 1.983669504661281, 1.922322578403054, 1.860637442018693, 1.798569192008103, 1.73607493765276, 1.673113902807089, 1.609647572384404, 1.545639884440553, 1.48105746840168, 1.415869929361445, 1.350050177437398, 1.283574799877405, 1.216424471904382, 1.148584400156478, 1.08004479002244, 1.010801325230854, 0.94085564482449, 0.8702157993044437, 0.7988966645132909, 0.7269202890864643, 0.6543161494901704, 0.5811212863956397, 0.5073802984050758, 0.433145176284437, 0.3584749812254629, 0.2834354452622773, 0.2080989747475502, 0.1325491035492001, 0.05696748502332019 },
                { 0.99, 135.8155721594871, 131.9823338621845, 128.0845946298023, 124.1450354700723, 120.2008262954248, 116.2884128879388, 112.4318216647654, 108.6429190292424, 104.9264152362285, 101.2836042918516, 97.71423817080788, 94.21737866319232, 90.79179546518866, 87.43616297112065, 84.14916139620487, 80.92952920583673, 77.77608953976787, 74.68776234347422, 71.66356854563014, 68.70262982763541, 65.80416601409717, 62.9674912612512, 60.19200972941741, 57.47721113704941, 54.82266642180994, 52.22802363036783, 49.69300409573964, 47.21739892285434, 44.80106577996299, 42.44392597969737, 40.14596182539972, 37.90721419356087, 35.72778032040727, 33.60781175898209, 31.54751247190792, 29.5471370240496, 27.6069888382977, 25.72741847654817, 23.90882190660592, 22.15163871418999, 20.45635021751087, 18.82347744011568, 17.25357889599226, 15.74724813947455, 14.30511103154242, 12.92782267396088, 11.61606396371998, 10.37053772283764, 9.191964363241563, 8.081077053647406, 7.038616365581018, 6.065324389378185, 5.161938328426751, 4.329183601167999, 3.56776650519821, 2.878366525518249, 2.261628398291323, 1.71815407026196, 1.248494718536365, 0.8531430073301583, 0.532525729057116, 0.2869967590170234, 0.1168286498733551, 0.02217844865925512, 0.8244667624481295, 2.200292287268593, 3.263997662972901, 3.757728248563086, 3.89128631818885, 3.879818253836645, 3.822839535927005, 3.752968999800598, 3.679687534500201, 3.605969624033468, 3.532923084991231, 3.461003842638874, 3.390385054383289, 3.32110072058387, 3.253113099348084, 3.186347612769747, 3.120711790099514, 3.056105772614434, 2.992428163346594, 2.929579236790638, 2.867462624551234, 2.805986113143908, 2.745061924858363, 2.684606701633115, 2.624541323979869, 2.564790644836839, 2.505283186828909, 2.445950832310167, 2.386728523876255, 2.327553985881754, 2.268367473155181, 2.209111550519088, 2.149730905245464, 2.090172193799693, 2.030383923891109, 1.970316372786849, 1.90992154294648, 1.849153156219743, 1.787966688060057, 1.726319443393779, 1.664170675904864, 1.601481752501541, 1.538216364577372, 1.474340787310857, 1.409824187607711, 1.34463898031734, 1.27876123098947, 1.212171101624357, 1.144853333572218, 1.076797758943643, 1.007999828635042, 0.938461141444475, 0.8681899549252128, 0.7972016548651511, 0.7255191569684363, 0.6531732119583373, 0.5802025846021094, 0.5066540791555607, 0.4325823908639725, 0.3580497838594863, 0.2831256710794123, 0.2078865753778825, 0.1324205149030732, 0.05691383071596613 },
                { 1.01, 134.0513775184791, 130.3276066607739, 126.5425158416508, 122.7131472635652, 118.8708216673923, 115.0497650949852, 111.2751316499038, 107.5607181894471, 103.9127325899428, 100.3334768835092, 96.82340286080458, 93.38208926941451, 90.00870649547445, 86.70224983667439, 83.46166260183756, 80.28590288469243, 77.17397988354524, 74.12497312981931, 71.13804190760226, 68.21242898760644, 65.34746107578456, 62.54254740142658, 59.79717730124124, 57.11091731707882, 54.48340811916691, 51.91436143991896, 49.40355712434055, 46.95084035337878, 44.55611906513203, 42.21936157884662, 39.94059441382747, 37.71990028709878, 35.55741626815323, 33.45333206531724, 31.40788841541678, 29.42137554608548, 27.4941316779144, 25.62654153151374, 23.81903480233864, 22.0720845637835, 20.38620555658873, 18.76195232009862, 17.19991711848072, 15.70072761284673, 14.26504422854656, 12.89355716605437, 11.58698300421472, 10.34606084662666, 9.171547966132524, 8.064214909308974, 7.024840033095382, 6.054203459755754, 5.153080454643164, 4.322234253881457, 3.562408395912147, 2.874318641203127, 2.258644596952775, 1.716021196086259, 1.247030208267893, 0.8521919763178368, 0.531957545436696, 0.2867011369557746, 0.1167113176299865, 0.02215649348659468, 0.6907564616987119, 1.954670190282041, 3.033063503314806, 3.593340696461706, 3.776012067929135, 3.789032667259986, 3.744068198903343, 3.6815333597677, 3.613769042142686, 3.544642100991347, 3.475578728614963, 3.407189873167776, 3.339745013973681, 3.273345470846321, 3.208003225208271, 3.14368164683941, 3.080317914576766, 3.017835768986071, 2.95615288456475, 2.89518514561614, 2.834849098364795, 2.775063311815679, 2.71574907987802, 2.656830725397738, 2.598235665736745, 2.539894338925751, 2.48174005241773, 2.423708793576494, 2.365739026730685, 2.307771492635873, 2.249749020538558, 2.191616359510401, 2.133320033560462, 2.074808223757086, 2.016030679890521, 1.956938663879654, 1.897484927035229, 1.837623723341679, 1.777310861038777, 1.716503794914142, 1.655161761805347, 1.593245961803389, 1.530719787491977, 1.467549103188425, 1.403702575505051, 1.339152055553287, 1.273873011693014, 1.207845009818769, 1.141052235718421, 1.073484051012602, 1.005135570603791, 0.9360082455176415, 0.866110430679572, 0.7954579128206326, 0.7240743697615838, 0.6519917293460178, 0.5792503950448792, 0.5058993069071812, 0.4319958136122648, 0.3576053523944617, 0.2828010095978637, 0.20766343899594, 0.1322851770107986, 0.05685729782486365 },
                { 1.05, 130.6387543825446, 127.1142081359781, 123.535210865311, 119.9107162499776, 116.2618234271574, 112.6167279396841, 109.0007541483491, 105.4306603614081, 101.9154746185164, 98.45949574347459, 95.06455190065557, 91.73122140440077, 88.45944049784029, 85.24881402888056, 82.09878339369794, 79.00872170143746, 75.97798932195055, 73.00596675720047, 70.09207407143151, 67.235782163846, 64.43661901615922, 61.69417282243006, 59.00809318662742, 56.37809113600962, 53.80393842730148, 51.28546645137298, 48.82256493210797, 46.41518054345297, 44.06331552127843, 41.76702631498192, 39.52642230222023, 37.34166457524137, 35.2129647966937, 33.14058411499265, 31.12483212330688, 29.16606584129644, 27.26468869443155, 25.4211494617282, 23.63594115885758, 21.9095998197024, 20.24270313550299, 18.63586890678056, 17.08975325933608, 15.60504857196232, 14.18248106031852, 12.82280795903368, 11.52681424295805, 10.29530882910306, 9.129120203827259, 8.029091425945928, 6.99607446641451, 6.03092385979048, 5.134489662434516, 4.307609737754499, 3.551101419718541, 2.865752641781107, 2.25231265789202, 1.711482522869097, 1.243905536650327, 0.8501578813359109, 0.530739661691968, 0.2860663500980502, 0.1164590419615953, 0.02210925218376637, 0.4794841271035222, 1.518579583355592, 2.579152465565036, 3.250509578879559, 3.536365186149364, 3.606749684776389, 3.589694264068753, 3.542741685443596, 3.485901358328727, 3.425616067571248, 3.364164028367203, 3.302509919501767, 3.241120116387298, 3.180227405857174, 3.119939231622859, 3.060291284815444, 3.001277035707868, 2.942864930508412, 2.885008724266497, 2.827653810066307, 2.770741137871624, 2.714209648050252, 2.657997773410315, 2.602044349664465, 2.546289147302052, 2.490673160681989, 2.435138742284884, 2.379629639853618, 2.3240909748229, 2.268469187938984, 2.212711969830843, 2.156768188979958, 2.100587826079171, 2.044121921550499, 1.987322541602498, 1.930142767380935, 1.872536711319235, 1.814459564598799, 1.755867679587815, 1.696718691163917, 1.636971680872865, 1.576587387866271, 1.5155284704269, 1.453759821553825, 1.391248941456601, 1.327966368803604, 1.263886171084481, 1.198986492379749, 1.133250154091815, 1.066665300716881, 0.9992260785103089, 0.9309333299784434, 0.8617952816847456, 0.7918281971949947, 0.721056961585299, 0.6495155594796871, 0.5772474060089353, 0.504305490783634, 0.4307523017265475, 0.3566595171399779, 0.2821075318140572, 0.2071852891953178, 0.1319944497310384, 0.05673567675663916 },
                { 1.09, 127.3740450339031, 124.0261879621403, 120.6306252956015, 117.1913672688722, 113.7217175305948, 110.2431800277036, 106.7789340075521, 103.3472043239305, 99.95939601202768, 96.62174380357422, 93.33743671417239, 90.10802211940545, 86.9341639029424, 83.8160389074588, 80.75355276784509, 77.74646393329775, 74.79445808176502, 71.8971940939055, 69.05433297343756, 66.26555620806922, 63.53057743989968, 60.84914982676569, 58.22107059799352, 55.64618377286546, 53.12438167530681, 50.65560566417874, 48.23984635898418, 45.87714354824018, 43.56758590541409, 41.31131059464381, 39.10850281876051, 36.95939534105619, 34.86426799691923, 32.82344719997868, 30.83730543844754, 28.90626075004042, 27.03077615753973, 25.21135904136535, 23.4485604200706, 21.74297410435162, 20.09523568481407, 18.50602130836411, 16.97604619273447, 15.50606282345967, 14.09685877281352, 12.74925407616144, 11.46409809832985, 10.24226582155625, 9.084653488095357, 7.992173535482676, 6.965748771748897, 6.006305752519145, 5.114767342822618, 4.292044474259151, 3.539027143174048, 2.85657473726791, 2.245505825238144, 1.706587593867943, 1.240525164467444, 0.8479510554316539, 0.5294150490346378, 0.2853745186158218, 0.1161836846455237, 0.02205764425363414, 0.328463980778295, 1.157166760963071, 2.149171142488271, 2.894057044302143, 3.281604019026418, 3.419835222843105, 3.437597592898621, 3.408609629131874, 3.363011471920699, 3.311271582353238, 3.257017852457099, 3.201695868751045, 3.145993072013589, 3.090274450551662, 3.034739261369713, 2.979491533453465, 2.924577489970584, 2.870007282325343, 2.815768233052158, 2.76183314323857, 2.70816560716009, 2.654723458065243, 2.601461020539948, 2.548330587251899, 2.495283384716016, 2.44227019913934, 2.389241774905099, 2.33614906097863, 2.282943356378301, 2.22957639001628, 2.176000359718836, 2.122167948238373, 2.068032329397833, 2.013547174405966, 1.958666666353052, 1.903345529609545, 1.847539080078713, 1.791203301839279, 1.734294955537771, 1.676771723859368, 1.618592399439544, 1.559717120598807, 1.500107660207835, 1.439727772729843, 1.378543603938327, 1.31652416685463, 1.253641885961737, 1.189873209591693, 1.12519928742088, 1.059606706128025, 0.9930882714097222, 0.9256438187250865, 0.8572810284983191, 0.7880162143619538, 0.7178750459124564, 0.6468931611788389, 0.5751166197095903, 0.5026021465269959, 0.4294171232700978, 0.3556393046795801, 0.2813563174515746, 0.2066654067593832, 0.1316774498365858, 0.05660284096567514 },
                { 1.13, 124.249663701937, 121.0596616493084, 117.8281088832342, 114.556123522545, 111.2515081425265, 107.9296285272374, 104.6100860169805, 101.3109936750128, 98.04541368236037, 94.82135289333758, 91.64334388176225, 88.51388909226196, 85.4343540257267, 82.40545729082374, 79.42753954835479, 76.50071816406652, 73.62498073496896, 70.80024391260643, 68.02639144514846, 65.30329926655008, 62.63085227251404, 60.0089556438126, 57.43754253431337, 54.91657930587153, 52.44606909380891, 50.02605423053226, 47.65661788662958, 45.33788517623595, 43.07002389684121, 40.85324502066883, 38.68780301738894, 36.57399606109329, 34.51216615474296, 32.50269919039865, 30.54602495188338, 28.64261705701142, 26.79299282837578, 24.9977130743708, 23.25738175525218, 21.57264550233801, 19.94419295176466, 18.37275384745531, 16.8590978611468, 15.40403307056256, 14.00840403033466, 12.67308936441521, 11.39899880397358, 10.18706959181775, 9.038262174051214, 7.953555103004362, 6.933939083637202, 5.980410109861593, 5.093961658816054, 4.275575941089482, 3.5262142438385, 2.846806451536773, 2.23823988446378, 1.701347655081012, 1.236896801662539, 0.845576505728775, 0.5279867028344544, 0.2846272040160072, 0.1158858666337876, 0.02200178603909528, 0.2224918929193252, 0.8666224032190183, 1.756408100348939, 2.533467104554062, 3.010957031703164, 3.224140944705933, 3.284874963662895, 3.277801947932051, 3.244554622980833, 3.201359068628644, 3.153996744576762, 3.104651669703639, 3.054296905523186, 3.003441431296646, 2.952375889717014, 2.901269883025903, 2.850219481575246, 2.799273945913032, 2.748451939719528, 2.697751786071959, 2.64715813061258, 2.596646353248342, 2.546185530309575, 2.495740443579782, 2.445272951922097, 2.394742930893176, 2.344108916613604, 2.293328545929147, 2.242358856078374, 2.191156488027059, 2.139677824882548, 2.087879088204075, 2.035716409204871, 1.983145887910248, 1.930123650708179, 1.876605915014008, 1.822549068701817, 1.767909771344051, 1.71264508401069, 1.656712634301923, 1.600070823331737, 1.542679081456313, 1.484498179558926, 1.425490602559393, 1.365620991391711, 1.304856658849533, 1.243168183276125, 1.180530081897667, 1.11692156248414, 1.052327347801067, 0.9867385618609127, 0.9201536602532405, 0.8525793789263398, 0.7840316670149558, 0.7145365602396611, 0.644130942968796, 0.5728631405845466, 0.5007932813078256, 0.4279933715909343, 0.3545470510149098, 0.2805490728711244, 0.2061049671274416, 0.1313348925183609, 0.05645908992941583 },
                { 1.17, 121.2582709233969, 118.2102540991748, 115.1260980589489, 112.005305235038, 108.8520057597194, 105.6765507937779, 102.4944470186728, 99.32236618213897, 96.17410827136648, 93.05913115655093, 89.98325582282195, 86.94993357274699, 83.96121773010433, 81.01834669838003, 78.12207206233511, 75.27284708439615, 72.47094038257549, 69.71650772508029, 67.00963901104658, 64.35038983026035, 61.73880309036757, 59.17492407464523, 56.65881106605086, 54.19054293167134, 51.77022459775345, 49.39799104707894, 47.07401027397089, 44.79848550020602, 42.57165686475466, 40.39380273733284, 38.26524076112343, 36.18632869776704, 34.15746512388966, 32.17909001035079, 30.25168520122424, 28.37577479797682, 26.55192544447258, 24.78074649964571, 23.06289007647707, 21.39905091793991, 19.78996607262042, 18.23641432463641, 16.73921532423879, 15.29922835715652, 13.91735068253039, 12.59451536151521, 11.33168849182829, 10.12986575840341, 8.99006820781918, 7.913337155492243, 6.900728141167021, 5.953303861566762, 5.072126030822929, 4.258246150955083, 3.512695217291069, 2.836472437547354, 2.230533107287247, 1.695775855671145, 1.233029547835289, 0.8430401916892477, 0.5264582138164739, 0.2838262888884032, 0.1155663396152484, 0.02194181870319887, 0.1492973682033286, 0.6391956216820771, 1.409625211971841, 2.180034166467999, 2.727168827899754, 3.01673574410939, 3.128290798516103, 3.148489257967433, 3.129722344848219, 3.095525295584677, 3.054916890316846, 3.011260024650332, 2.965948345493784, 2.9196680999311, 2.872806977186307, 2.82559930493502, 2.778188891390128, 2.730661953022248, 2.683066562744546, 2.63542489359904, 2.587741212824498, 2.540007229049022, 2.492205733410235, 2.444313113252114, 2.396301105997347, 2.348138032733273, 2.299789670998973, 2.251219875015502, 2.202391018142442, 2.153264310138826, 2.103800026875956, 2.053957680013801, 2.003696147235032, 1.952973778910871, 1.90174849387937, 1.849977874900299, 1.797619273005267, 1.744629929172831, 1.690967121370562, 1.636588344898989, 1.581451534044549, 1.525515333204595, 1.468739425787272, 1.411084929199551, 1.352514863984316, 1.292994704492057, 1.232493017185375, 1.170982190558299, 1.108439257471606, 1.044846806223921, 0.980193970693087, 0.9144774822721317, 0.8477027571193524, 0.7798849817096222, 0.7110501484148222, 0.6412359818894552, 0.5704926879691106, 0.4988834519368618, 0.4264846163227678, 0.3533854898191913, 0.2796878203421445, 0.2055053781800991, 0.1309676411364585, 0.05630478681780272 },
                { 1.21, 118.3928292732976, 115.4733136892021, 112.5223255190934, 109.5385205157418, 106.5236802743185, 103.4843675372138, 100.4321662439439, 97.3814404431858, 94.34577520844853, 91.33559489778758, 88.35787604213088, 85.41700272298697, 82.51571128416614, 79.65574664354757, 76.83825288581041, 74.06399979979658, 71.33351867452083, 68.6471876757151, 66.00528781818607, 63.40804085991647, 60.85563559597911, 58.34824646751044, 55.88604695579297, 53.46921937116672, 51.09796211262211, 48.7724951318133, 46.49306411021092, 44.25994370679357, 42.07344012989477, 39.93389321431873, 37.84167813325818, 35.79720683714339, 33.80092928383639, 31.85333450352246, 29.95495152514271, 28.10635017778563, 26.30814176905773, 24.56097963231821, 22.86555952522815, 21.22261985291958, 19.63294167994022, 18.0973484857872, 16.61670560922154, 15.1919193166807, 13.82393542013812, 12.5137373600169, 11.26234365976864, 10.07080465123426, 8.940198364945072, 7.871625478436777, 6.866203220077372, 5.925058137757704, 5.049317663113794, 4.24010043474142, 3.498505389740126, 2.825599692656144, 2.222405643803658, 1.689886792121977, 1.228933564787699, 0.8403488035380057, 0.5248336308610259, 0.2829739034184375, 0.1152259562286409, 0.02187790258790086, 0.09941315238899865, 0.4652432883397363, 1.112722443785932, 1.844643721899357, 2.435976150560878, 2.796707480467774, 2.964832386832032, 3.018434312652518, 3.017380113729791, 2.993264294205887, 2.959535117085305, 2.921378378860107, 2.880848823068313, 2.838881399363031, 2.795978116650711, 2.752440609117998, 2.70845948350281, 2.664156290285448, 2.619606893797799, 2.57485586130408, 2.52992581256283, 2.48482369148557, 2.439545066183194, 2.394077126454637, 2.348400800812014, 2.302492267430174, 2.256324041719103, 2.209865764709002, 2.16308477827091, 2.115946547845748, 2.068414976272082, 2.020452640665969, 1.972020976326535, 1.923080426163333, 1.873590570407184, 1.823510248868369, 1.772797686400263, 1.721410631273337, 1.669306515691331, 1.61644264755714, 1.562776442711257, 1.508265707119308, 1.452868978771309, 1.396545939252947, 1.339257904912524, 1.280968407097517, 1.221643869853955, 1.161254391511804, 1.099774633427351, 1.037184814509065, 0.973471803723893, 0.9086302943463855, 0.8426640332088062, 0.775587065834662, 0.7074249446814293, 0.6382158339024274, 0.5680114318646109, 0.4968776248512185, 0.4248947864305355, 0.3521576574654592, 0.2787748241234776, 0.2048682266246138, 0.130576673358669, 0.05614034400877185 },
                { 1.25, 115.646632758846, 112.8440676970751, 110.0140155623443, 107.1547370356438, 104.2665681737233, 101.3533650958596, 98.42334478753027, 95.4881974441072, 92.56048501515582, 89.65100584339367, 86.76765610272923, 83.91570276255557, 81.09856124031017, 78.31847735626133, 75.5769753665437, 72.87512619062836, 70.21370810155181, 67.59330688432179, 65.01438115654969, 62.47730661146197, 59.98240687469378, 57.52997552931239, 55.12029214536656, 52.75363415013197, 50.43028576337149, 48.15054483305908, 45.91472815236904, 43.7231756678323, 41.57625387140049, 39.47435858726512, 37.41791730595533, 35.40739117589051, 33.44327673115894, 31.52610741042113, 29.65645490314394, 27.83493034420174, 26.06218536504523, 24.33891299826466, 22.66584842181725, 21.04376951896187, 19.47349721969141, 17.95589557892456, 16.49187153577214, 15.08237428680267, 13.72839419451149, 12.43096114043544, 11.19114222105835, 10.01003867459977, 8.888781919075064, 7.828528578137207, 6.830454373032724, 5.895746768772615, 5.025596282852854, 4.221186398136051, 3.483682070100759, 2.814216884008294, 2.213878999480039, 1.683696115827767, 1.224619794544493, 0.8375095714218898, 0.5231173428225289, 0.2820723620839109, 0.1148656444030956, 0.02181021235448836, 0.06579188256816409, 0.3348099729262898, 0.8653893329370682, 1.536114972678409, 2.144929656287461, 2.565485057623631, 2.792336757792133, 2.885239499252111, 2.906063229384278, 2.893868235616301, 2.867520598455898, 2.834829455603349, 2.798883248119807, 2.760996863597391, 2.721824665582059, 2.681744535826632, 2.640994910948438, 2.599731784699562, 2.558057556169741, 2.516037956590782, 2.473712849315141, 2.431103441439356, 2.388217235554903, 2.345051497531455, 2.30159572232157, 2.257833408893333, 2.213743350773055, 2.169300582398488, 2.124477078410082, 2.079242274447036, 2.033563458770247, 1.987406070908236, 1.940733934499544, 1.893509445289314, 1.845693730980024, 1.79724679677146, 1.748127668570669, 1.698294544744512, 1.647704966737383, 1.596316018743487, 1.544084566791642, 1.49096754796559, 1.436922320934772, 1.381907089383173, 1.32588141014215, 1.268806797662069, 1.210647435652777, 1.151371004985334, 1.090949633925089, 1.029360972069167, 0.9665893825951309, 0.9026272382538612, 0.8374762947705517, 0.771149101047834, 0.7036703893365603, 0.6350783715310022, 0.5654258519725193, 0.4947810557481676, 0.4232280695686935, 0.350866811254649, 0.2778125267988923, 0.204195231812032, 0.1301630519913081, 0.05596621061077886 },
                { 1.29, 113.0133190151008, 110.3177325207183, 107.5980490326961, 104.852392690596, 102.0802461958154, 99.28361168446657, 96.46802543046447, 93.64253978501305, 90.81814630509187, 88.00541405330107, 85.21282492343612, 82.44642263353793, 79.71028560124984, 77.00715907386659, 74.3389410477426, 71.70699245463842, 69.11232570028805, 66.55572139297311, 64.03780374189996, 61.55909135433867, 59.1200326489753, 56.72103121613529, 54.36246438173841, 52.04469705825218, 49.76809226279378, 47.53301924161435, 45.3398598538155, 43.18901367587289, 41.08090215776856, 39.0159720702559, 36.99469841781583, 35.01758694470971, 33.08517632658074, 31.19804011350951, 29.35678846967918, 27.56206973801037, 25.81457184396131, 24.11502354018082, 22.46419548211915, 20.86290111348857, 19.31199732919713, 17.8123848717459, 16.3650084048775, 14.9708561954086, 13.63095932073019, 12.34639030565953, 11.11826107865696, 9.947720124659698, 8.835948701091082, 7.784155976576248, 6.793572950629344, 5.865445019664594, 5.001023073133748, 4.201553036624703, 3.468263829406877, 2.802353774415682, 2.204975589592254, 1.677220198546246, 1.220099718837528, 0.8345301025816427, 0.5213139776774935, 0.2811241096285289, 0.1144863854577737, 0.02173893283583441, 0.04333722462427072, 0.2386509857835879, 0.664241635273806, 1.260342953836005, 1.862008838514323, 2.32661066440524, 2.609987905841918, 2.746714944286537, 2.7940627457933, 2.796399439928587, 2.778422024369296, 2.751385742220476, 2.719915660669432, 2.685918733893268, 2.65027322390658, 2.613453538731975, 2.575750501460182, 2.537354813390737, 2.498394619025392, 2.458955833016342, 2.419094617015875, 2.37884558863899, 2.338227434529704, 2.297246843479169, 2.255901311715092, 2.214181171763073, 2.172071076464044, 2.129551094803172, 2.086597527863902, 2.043183521298607, 1.999279529243327, 1.954853669973325, 1.909872003532425, 1.864298754623594, 1.818096499276643, 1.771226330585857, 1.723648016714527, 1.675320163106026, 1.626200390218713, 1.576245537964628, 1.525411908259744, 1.473655557579132, 1.420932652042587, 1.367199898206456, 1.31241506324415, 1.256537598353472, 1.199529378765651, 1.141355572310995, 1.081985645708582, 1.021394513118036, 0.9595638245140826, 0.8964833816438482, 0.8321526563634622, 0.7665823699766952, 0.6997960732637828, 0.6318316463860045, 0.5627426179880238, 0.4925991871647263, 0.4214888263302644, 0.3495163596849383, 0.2768034949615767, 0.2034882063261708, 0.1297279000841137, 0.05578286181307741 },
                { 1.33, 110.486870310416, 107.889590185082, 105.2710948326782, 102.6295150532332, 99.96385789981897, 97.2748988634238, 94.56615219134973, 91.84431918596739, 89.11856165569987, 86.3987043373501, 83.69342084215418, 81.00935831788189, 78.35121486973649, 75.72223127015735, 73.12467730357095, 70.56019713440957, 68.03002747600009, 65.53513302685752, 63.07629307950299, 60.65415931248456, 58.26929587490338, 55.92220806486444, 53.61336336374118, 51.34320719079139, 49.11217492753249, 46.92070125988479, 44.76922756448353, 42.65820785246004, 40.58811363903398, 38.5594380064094, 36.57269905584863, 34.62844289290198, 32.72724625136161, 30.86971883239095, 29.05650541257574, 27.28828775632163, 25.56578635262686, 23.88976198271016, 22.26101711245898, 20.68039709155323, 19.14879112892643, 17.66713300157278, 16.23640144033011, 14.85762012201405, 13.53185718214521, 12.26022414668321, 11.04387416509451, 9.883999411499814, 8.781827506756259, 7.738616803830495, 6.755650374007004, 5.834228535284655, 4.975659780259942, 4.181249992788342, 3.452289894650913, 2.790040738524365, 2.195718363225739, 1.670475849809135, 1.215385155807896, 0.8314182436586853, 0.5194283172160767, 0.280131675354137, 0.1140891955717543, 0.02166425552678087, 0.02844955921195235, 0.1687674987179497, 0.504036545159813, 1.020174552478947, 1.594418339380659, 2.085092153764025, 2.418534933981575, 2.601271141458445, 2.679604893416025, 2.699705925286905, 2.691640226705714, 2.670749436641989, 2.643781164166562, 2.613538282065385, 2.581242343321498, 2.547503191007379, 2.51267480229623, 2.476984827171692, 2.440587056822765, 2.403586914029919, 2.366056088816943, 2.328041876547926, 2.289573487113337, 2.250666449211236, 2.211325751561853, 2.171548119163868, 2.131323683650972, 2.090637221782225, 2.049469081899526, 2.007795882645311, 1.965591044437531, 1.922825198016301, 1.879466503254844, 1.83548090374851, 1.790832337412143, 1.745482919738024, 1.699393114032364, 1.652521901543892, 1.604826963704903, 1.556264888564982, 1.506791413787098, 1.456361719186699, 1.404930782616564, 1.352453813904696, 1.298886782375421, 1.244187054008272, 1.188314154227923, 1.131230671298344, 1.072903312846981, 1.013304123609874, 0.952411865440235, 0.8902135503319727, 0.8267061031571615, 0.7618981127720297, 0.6958116084163866, 0.6284837740717744, 0.5599684890136903, 0.4903375621917281, 0.4196815178761995, 0.3481098035340784, 0.2757503732888996, 0.202749022646944, 0.1292723798675717, 0.0555907898745472 },
                { 1.3703766903125, 108.039231662365, 105.533485647488, 103.0089989320872, 100.4639852342266, 97.89721010540481, 95.30865791809024, 92.70036682279865, 90.07706888512476, 87.44606324059513, 84.81605747285859, 82.19551701089669, 79.59146152650543, 77.00913049893872, 74.45224935853465, 71.92346256869703, 69.42469721846549, 66.95740966576993, 64.52274175459108, 62.12162022091718, 59.75482226466371, 57.42302061722725, 55.12681563105206, 52.86675878557869, 50.64337031121674, 48.45715267358329, 46.3086010847206, 44.1982118453654, 42.12648908486823, 40.09395030507436, 38.10113102355098, 36.1485887330669, 34.23690633753071, 32.36669518273751, 30.53859776863041, 28.75329020518309, 27.01148445423137, 25.31393038302626, 23.66141764076777, 22.05477735600882, 20.4948836398924, 18.98265486714688, 17.51905469317193, 16.10509275106801, 14.74182495687402, 13.43035333450663, 12.1718252540527, 10.96743195853051, 9.818406235729529, 8.726019074453673, 7.691575130201549, 6.71640681649758, 5.80186683799852, 4.949318994176866, 4.160127112473361, 3.435642022166528, 2.777186559133716, 2.186038699764627, 1.663413058739186, 1.210441143635269, 0.8281509225480301, 0.5174463861113501, 0.2790877074540854, 0.1136711337063805, 0.02158562762884274, 0.01856058673352917, 0.1181877895037628, 0.3776842202638013, 0.8140363967138602, 1.345574684615214, 1.844352656372479, 2.218298928200711, 2.446748941022203, 2.55995247482098, 2.60157149149015, 2.605621363172017, 2.591805614918807, 2.569593933634937, 2.543084286030691, 2.51402624753, 2.483233970264975, 2.451146584431631, 2.418034787013009, 2.384079300902024, 2.349404985453857, 2.314098631791816, 2.278219716382776, 2.241807491440562, 2.204885886320599, 2.167466991322296, 2.129553580996843, 2.091140967862283, 2.052218379703567, 2.012769992571935, 1.972775712001156, 1.932211768624296, 1.891051176540588, 1.849264090553814, 1.806818089968067, 1.763678410820108, 1.719808144488919, 1.675168418047122, 1.629718570164939, 1.583416335611233, 1.53621805125154, 1.488078896793705, 1.438953184270363, 1.388794711266228, 1.337557194071161, 1.285194798103685, 1.231662783882156, 1.176918287220068, 1.120921251783565, 1.063635530150047, 1.005030165399746, 0.9450808583049633, 0.8837716145555906, 0.8210965514472877, 0.7570618236036841, 0.6916876027127869, 0.6250100179852201, 0.5570829345486102, 0.4879794206928504, 0.4177927391693258, 0.3466367071422987, 0.2746453503932537, 0.2019722015072849, 0.1287931172773898, 0.05538857288274586 },
                { 1.411952810001479, 105.6208193941579, 103.2022186682849, 100.767044201337, 98.3136326842336, 95.84065279603575, 93.34759253541956, 90.83543349685394, 88.30731787121591, 85.76878774095535, 83.22720264435735, 80.69045171836602, 78.16565270795177, 75.65846684979504, 73.17307991197444, 70.71251765878746, 68.27899799360795, 65.87419956786883, 63.49943996381167, 61.15578989646926, 58.84414782537596, 56.56529062296576, 54.31990934386, 52.10863530735573, 49.93205962228697, 47.79074813008755, 45.68525306980192, 43.61612235526638, 41.58390708839137, 39.58916775476093, 37.63247942573242, 35.71443620536556, 33.83565509875182, 31.99677943289539, 30.19848192708327, 28.44146748318704, 26.72647574512687, 25.05428345905348, 23.42570665037524, 21.84160261959005, 20.30287174520274, 18.81045906819112, 17.36535561802058, 15.96859942468903, 14.62127614441658, 13.32451920821732, 12.07950938273494, 10.88747361168494, 9.749682984687175, 8.667449659359814, 7.642122544096799, 6.675081535596416, 5.767730100520672, 4.921485999205949, 4.137769976550329, 3.41799229698816, 2.763537082430381, 2.175744528169845, 1.655891222411333, 1.205168974282944, 0.8246627455028674, 0.515328437208527, 0.2779712372059588, 0.1132237939393129, 0.0215014672533608, 0.01194168863755072, 0.08145792568730453, 0.2781124377549185, 0.6378756039793449, 1.115628798608057, 1.605572127169473, 2.008383205595371, 2.279957634436408, 2.431160092799398, 2.498547864427569, 2.517739518976512, 2.512556131075808, 2.495718950345487, 2.473114314884304, 2.447293045961311, 2.419390265760851, 2.389972316810211, 2.359366426223492, 2.327784199215597, 2.295370946446267, 2.262228693389928, 2.228428963184344, 2.194020837329931, 2.159036418196617, 2.123494679520998, 2.0874042462566, 2.050765434997909, 2.013571770631567, 1.975811125104467, 1.937466579773494, 1.898517083565186, 1.858937959502086, 1.818701298718797, 1.777776271843652, 1.736129381260562, 1.6937246734473, 1.65052392775645, 1.606486836292877, 1.561571188695941, 1.515733075480936, 1.468927124003888, 1.421106781981201, 1.372224664717628, 1.322232983652074, 1.271084075361547, 1.218731051546677, 1.165128591445381, 1.110233898153761, 1.054007838900773, 0.9964162856917066, 0.9374316660200405, 0.8770347225619959, 0.8152164649457212, 0.7519802750943769, 0.6873441001180055, 0.6213426341495284, 0.5540293553786625, 0.4854782516379522, 0.4157850455059107, 0.3450677339164791, 0.2734663358572871, 0.2011421671977124, 0.1282804827406119, 0.05517214305682702 },
                { 1.454790315512773, 103.2313129362899, 100.895845550381, 98.54570132519452, 96.17935768550473, 93.79547738433488, 91.39325862693257, 88.97295715109521, 86.53649228912131, 84.08786515611095, 81.63301313821262, 79.17895791928663, 76.73261714115195, 74.29989942045594, 71.88539155549107, 69.49249607491463, 67.12372978931615, 64.78099907028502, 62.46579812430729, 60.17933960896812, 57.92263981941629, 55.69657583787238, 53.50192540408102, 51.33939575727193, 49.20964513296913, 47.11329918485011, 45.05096380021007, 43.02323529822949, 41.03070869842045, 39.07398454836901, 37.1536746652376, 35.27040705150148, 33.42483017818882, 31.61761677971646, 29.8494672675417, 28.12111284143039, 26.43331835450265, 24.78688496945059, 23.18265262702189, 21.62150233295228, 20.10435825516014, 18.63218960849053, 17.20601228903345, 15.82689020356024, 14.4959362215413, 13.21431265727904, 11.98323116784355, 10.80395192893122, 9.677781926057377, 8.606072173750759, 7.590213652470589, 6.63163173456271, 5.731778860569529, 4.892125230694401, 4.114147299455229, 3.399313911627584, 2.749070001561337, 2.164817901489337, 1.64789646945866, 1.199558448928187, 0.820946692161577, 0.5130700710651257, 0.2767798895540802, 0.1127462090213602, 0.02141159078618782, 0.007579504427190441, 0.05527684003624998, 0.2013244607466917, 0.4909485326755622, 0.9085948142970285, 1.374661571021257, 1.792750710379628, 2.101615720018145, 2.291905811828507, 2.388938855999591, 2.42678168437497, 2.432360463315571, 2.421888300245138, 2.403543455017846, 2.381033193510481, 2.355990430018653, 2.329180288340842, 2.301011678143226, 2.271735088813101, 2.241518624785329, 2.210480128414148, 2.178703209200328, 2.146246647239045, 2.113150536813031, 2.079440546546661, 2.045130972865194, 2.010226974143844, 1.974726229291606, 1.938620182759914, 1.901894987472711, 1.864532224490078, 1.826509456441253, 1.787800656982838, 1.748376548401728, 1.708204872521472, 1.667250615345539, 1.625476202768932, 1.5828416828062, 1.539304908848953, 1.494821738295461, 1.449346261357995, 1.402831075847279, 1.355227625161082, 1.306486618453122, 1.25655855387774, 1.205394367677071, 1.152946233383994, 1.099168536105245, 1.044019046104284, 0.9874603129046835, 0.9294612948603964, 0.8699992284019956, 0.8090617247291249, 0.7466490585168946, 0.6827765827323343, 0.6174771665215126, 0.5508035117633109, 0.4828301634334711, 0.4136549985634573, 0.3433999757800419, 0.2722110023223675, 0.2002572015298463, 0.1277333800135473, 0.05494102919540571 },
                { 1.498927476271347, 100.871837372032, 98.61577693128851, 96.34669962746065, 94.06322759734865, 91.76407220272455, 89.44828240694415, 87.11563737886678, 84.76715575553188, 82.40556518757452, 80.03543895527193, 77.66275048462891, 75.29393822540497, 72.93494226497275, 70.5906482734161, 68.26481011163286, 65.9602469433918, 63.67909977212512, 61.42304262729505, 59.19342973636012, 56.99139280298153, 54.81790576868969, 52.67382939589109, 50.55994315755862, 48.4769688306214, 46.42558844404618, 44.4064582562222, 42.42021986898066, 40.46750923813864, 38.5489641170258, 36.66523031997067, 34.81696708949974, 33.00485177778795, 31.22958399967397, 29.49188937487805, 27.79252294665293, 26.13227234001591, 24.51196070286645, 22.93244945615517, 21.39464086366613, 19.89948041697501, 18.44795901598257, 17.04111490944084, 15.68003534252767, 14.36585783931434, 13.09977102656059, 11.8830148814831, 10.7168802600557, 9.602707534477305, 8.541884139708765, 7.535840801228539, 6.58604619221415, 5.69399975232875, 4.861222397769905, 4.089244870328563, 3.37959352024986, 2.733773402440358, 2.153248695623847, 1.639420633279532, 1.193603359898397, 0.8169983785828417, 0.5106684870094378, 0.2755121314740192, 0.1122377488912207, 0.02131587803168554, 0.004748889458749638, 0.0369564533673806, 0.1433590918073319, 0.3713137150290561, 0.7269744529617141, 1.157170602123373, 1.576383184087802, 1.913846372522517, 2.141740555641176, 2.271249090426953, 2.331392616478817, 2.350395740187274, 2.3477268706132, 2.334252645180001, 2.315244630853888, 2.293078219802777, 2.268830249610812, 2.243035250136169, 2.215997759290258, 2.187913476758147, 2.158917459204728, 2.129105726920397, 2.098546743026229, 2.067288468801206, 2.0353631112725, 2.002790479640737, 1.969580425357871, 1.935734647831409, 1.901248047632511, 1.866109750378176, 1.830303887474946, 1.793810195640568, 1.756604480796156, 1.71865898078871, 1.679942653782229, 1.640421413986464, 1.600058332994216, 1.558813822926641, 1.516645816548558, 1.473509959317644, 1.429359828839053, 1.384147198311037, 1.337822362178474, 1.290334544258467, 1.241632410925559, 1.191664714334983, 1.140381092806197, 1.087733056922256, 1.033675189964354, 0.9781665890980433, 0.9211725680997378, 0.8626666319594098, 0.802632716879164, 0.7410676645632899, 0.6779838663316485, 0.6134119707105561, 0.5474035000245358, 0.4800331725241084, 0.4114006868434312, 0.3416317142908991, 0.2708779141484366, 0.1993162129295225, 0.1271510993987917, 0.05469492319707348 },
                { 1.544403722765545, 98.54342902369615, 96.36330579318192, 94.17161868786335, 91.96713038820653, 89.74863118219395, 87.51511339791512, 85.26606053127612, 83.00185420605322, 80.72422072935952, 78.43651740812329, 76.1436054786809, 73.85122361773487, 71.56511254158957, 69.2903131499215, 67.03087566087068, 64.78991376546335, 62.56980888210908, 60.37241994588717, 58.19924426913074, 56.05152779690108, 53.93033873433575, 51.83661765936859, 49.77121288518126, 47.73490634863905, 45.728433169895, 43.75249682304082, 41.80778117156901, 39.89496021443619, 38.01470613301992, 36.16769606171837, 34.35461789090325, 32.5761753309092, 30.83309240805069, 29.12611752096164, 27.45602715305169, 25.82362931130582, 24.22976674073112, 22.67531994580195, 21.1612100340008, 19.6884013809824, 18.25790410115939, 16.87077629088926, 15.52812599329103, 14.23111281347265, 12.98094909015007, 11.77890050398229, 10.62628597437744, 9.524476665368457, 8.474893888310222, 7.479005656335638, 6.538321615573872, 5.654386055386957, 4.828768690380491, 4.063052918648477, 3.35882130328967, 2.717638108286812, 2.141028855240322, 1.630457060453078, 1.187298560667307, 0.8128141231887706, 0.508121311065502, 0.2741666550339271, 0.1116978737418958, 0.02121422578292413, 0.002939075151710932, 0.02436022117805984, 0.10048509866198, 0.2761168863276317, 0.5716071987766157, 0.9576156063145964, 1.364611820272477, 1.719958718308591, 1.981249912749866, 2.144401870216196, 2.230161648079087, 2.265624232957041, 2.272675367772249, 2.265014128460875, 2.249872691746991, 2.230674209515993, 2.208971495184678, 2.185496358862572, 2.160634449948873, 2.134618287281793, 2.107603054531021, 2.079698020956627, 2.050981505756363, 2.021509293747094, 1.991320016111721, 1.960438861317331, 1.928880241582287, 1.896649754572924, 1.863745648706247, 1.8301599295, 1.795879201706553, 1.76088531460939, 1.725155859710839, 1.688664557762746, 1.651381563726458, 1.613273712585828, 1.574304725211239, 1.534435391190979, 1.493623744389496, 1.45182524675216, 1.408992996416442, 1.365077977413809, 1.320029370075404, 1.273794943599511, 1.226321554975656, 1.177555781395095, 1.127444716105256, 1.075936959918644, 1.022983841576675, 0.9685408989280592, 0.9125696481178162, 0.8550396580779487, 0.7959309307007007, 0.735236561281382, 0.6729656176947468, 0.6091461300407831, 0.5438280271080541, 0.4770857974865018, 0.4090206025188665, 0.3397615466062693, 0.26946587295113, 0.1983182769958348, 0.126533034567563, 0.0544335606435208 },
                { 1.591259681772818, 96.24703650504059, 94.13961195276783, 92.02189617321998, 89.89278372783146, 87.75115842692229, 85.59601477594664, 83.42666764157389, 81.24306650079951, 79.04618355917095, 76.83835438333214, 74.62336429620853, 72.40611458831411, 70.1919333486506, 67.98584392672805, 65.79210406401629, 63.61409550520323, 61.45444048553727, 59.31518845683062, 57.19798314433888, 55.10418505570344, 53.03495501981271, 50.99131080404157, 48.97416653363073, 46.98436117129955, 45.02267982568346, 43.0898701736299, 41.18665543733673, 39.31374486764054, 37.47184238704119, 35.66165385568202, 33.88389329636785, 32.13928832672093, 30.42858498382467, 28.75255208067837, 27.11198519902997, 25.50771039602753, 23.94058768010455, 22.41151429275894, 20.92142781601585, 19.47130910927836, 18.06218506304515, 16.695131139804, 15.3712736535652, 14.09179171832193, 12.85791877164099, 11.67094355216117, 10.53221037879729, 9.443118545075128, 8.40512060499397, 7.419719288727064, 6.488462750141899, 5.612937817995875, 4.794760905216589, 4.035566234699275, 3.336991076594316, 2.700657773728209, 2.128152471061153, 1.621000671065344, 1.180640010309427, 0.8083909772886046, 0.5054266149877775, 0.2727423876149571, 0.1111261381641, 0.02110654860603706, 0.001798049722463549, 0.01584303238909382, 0.06938145481680527, 0.2020089010373068, 0.4418725667964821, 0.7791525829131891, 1.162544127780325, 1.524129834442411, 1.812139760241944, 2.008004817273345, 2.121823829538106, 2.176863198337388, 2.195980630956783, 2.195461782896489, 2.184787327104216, 2.168763543226762, 2.14963740456726, 2.128446485399974, 2.105702868598904, 2.081692626765259, 2.05659672636698, 2.030539467839653, 2.003609529017718, 1.975870602436118, 1.947367687955904, 1.918131251967615, 1.888180155059757, 1.857523784221339, 1.826163636788, 1.794094512230387, 1.761305416877573, 1.727780255263927, 1.693498361393514, 1.658434909587943, 1.622561235362384, 1.585845090553074, 1.548250852825394, 1.509739707171909, 1.470269815712413, 1.429796491808983, 1.388272395066508, 1.345647765110398, 1.301870714048711, 1.256887600162668, 1.210643508522592, 1.16308286772204, 1.114150235472785, 1.063791288945213, 1.01195405776639, 0.9585904374739508, 0.9036580175508496, 0.8471222490940453, 0.7889589604916483, 0.7291572028355447, 0.6677223681319226, 0.604679471777931, 0.5400764277114551, 0.4739870756202588, 0.4065136564459071, 0.3377883982505595, 0.267973927774789, 0.1972626439477495, 0.1258786872713464, 0.05415672281375435 },
                { 1.639537212654159, 93.98352196642145, 91.94576632468397, 89.89883523525701, 87.84174430245001, 85.77347553247203, 83.69306118871688, 81.59973404871969, 79.49316424550103, 77.3737780749478, 75.24309377918645, 73.10392744845553, 70.96029322639983, 68.81693972015903, 66.67869213175928, 64.54989601870506, 62.43415012481341, 60.33430704153647, 58.2526103177269, 56.19085459926629, 54.1505168446086, 52.1328500207106, 50.13894718889838, 48.16978571409071, 46.22625875079859, 44.30919850717763, 42.41939401418724, 40.5576050841056, 38.72457354348528, 36.92103247115539, 35.14771395171127, 33.40535571137482, 31.69470690554403, 30.01653325871208, 28.3716217076421, 26.76078466144341, 25.18486396339286, 23.64473461616858, 22.14130831259943, 20.67553679657233, 19.24841506218426, 17.86098438257214, 16.51433514221648, 15.20960942707812, 13.94800330493398, 12.73076870303365, 11.55921476112315, 10.43470850459569, 9.358674645000018, 8.332594273906394, 7.358002172621555, 6.436482417177591, 5.569661919903641, 4.759201522551461, 4.006784250965775, 3.314100370117784, 2.682828955717972, 2.114615839952071, 1.611048006660315, 1.173624809394942, 0.803726749996504, 0.5025829319153322, 0.2712385003568256, 0.1105221945799343, 0.02099277949115157, 0.001088132125105943, 0.01017411570988061, 0.04722655137118799, 0.1455063490412169, 0.3360141850565372, 0.623465197528438, 0.9745666730733005, 1.330959118415578, 1.637146475706415, 1.862541790476902, 2.005490856197654, 2.082911646730898, 2.116720807939901, 2.125071088251073, 2.119758233555695, 2.107279640886956, 2.09083727057197, 2.071925832639067, 2.051254712736237, 2.029192156261118, 2.005955300792904, 1.981686969801403, 1.956487296808449, 1.930428181110343, 1.903561023827183, 1.875921511013155, 1.847532863952941, 1.818408165815733, 1.788552074706601, 1.757962105799019, 1.726629600951645, 1.694540467079967, 1.66167574125819, 1.628012025248472, 1.593521821923891, 1.558173799185016, 1.521933002454551, 1.484761034041799, 1.446616216205075, 1.407453754360963, 1.367225917445203, 1.325882253831171, 1.28336986339901, 1.239633749265962, 1.194617276253653, 1.148262767233099, 1.10051227278892, 1.051308553734367, 1.000596319176737, 0.9483237640054496, 0.8944444473215401, 0.8389195453914035, 0.7817204966239459, 0.7228320289492024, 0.662255519077723, 0.6000125767500533, 0.5361486760307364, 0.4707365752433334, 0.4038791898147562, 0.3357115333141333, 0.2664013833656023, 0.1961487447461506, 0.1251876712393268, 0.0538642383551441 },
                { 1.689279444749699, 91.75366254971258, 89.78273501922102, 87.80361148033356, 85.81541700183461, 83.81723042441614, 81.80814174030349, 79.7873587444998, 77.7543824088891, 75.70925897523585, 73.65287998544263, 71.5872371612356, 69.51548360678427, 67.44168532812845, 65.37030556176298, 63.30563821775333, 61.25142147870577, 59.21071143862393, 57.18594355659199, 55.17906763768069, 53.19168030347649, 51.225127457464, 49.28057644934357, 47.35906587631653, 45.4615406153683, 43.58887733707323, 41.74190376619209, 39.92141368750631, 38.12817895501517, 36.36295933181588, 34.62651072801286, 32.91959223919865, 31.24297227856513, 29.59743402000866, 27.98378031542504, 26.40283820934345, 24.85546314340351, 23.34254291877149, 21.86500146419327, 20.4238024393401, 19.01995268611695, 17.65450552358297, 16.32856386411188, 15.04328310849509, 13.7998737550011, 12.59960363113479, 11.44379962625644, 10.33384876775811, 9.271198442910455, 8.257355523091422, 7.2938840980909, 6.382401478104197, 5.52457207437566, 4.722098733321321, 3.976711083649814, 3.290150475359502, 2.66415116053965, 2.100417507200874, 1.600597265343411, 1.166251226982339, 0.7988200273129577, 0.4995892685049219, 0.269654414754442, 0.1098857959372242, 0.02087287036433738, 0.0006518931231082361, 0.006456567236215592, 0.03171613798105388, 0.1032664480953229, 0.2515125277438074, 0.4908449927032628, 0.8039952949458561, 1.144982027909804, 1.459786145769117, 1.709442776494119, 1.880865740871509, 1.982722066743794, 2.033874754681191, 2.053159659519107, 2.054433201249239, 2.046084960399293, 2.032544998693862, 2.015957943370117, 1.997333370460845, 1.977167637469516, 1.955732110252809, 1.933194606328494, 1.909668882631115, 1.885235722594394, 1.859953103515723, 1.833861934652051, 1.806989742288526, 1.779353231737732, 1.75096014624427, 1.72181064711865, 1.691898351979174, 1.661211121970382, 1.629731661519302, 1.597437976807112, 1.56430372767709, 1.530298500072416, 1.49538802109288, 1.459534335650124, 1.422695962039906, 1.384828043265474, 1.345882511478555, 1.305808284364941, 1.26455151464135, 1.222055917011925, 1.178263200899434, 1.133113641900438, 1.086546829983658, 1.038502637536783, 0.9889224547664147, 0.9377507425664491, 0.884936952163884, 0.8304378543655785, 0.7742203061364419, 0.7162644550855804, 0.6565673397037449, 0.5951467822572082, 0.5320453919929624, 0.4673344035566222, 0.4011169823177323, 0.3335305619814911, 0.2647478064667793, 0.1949761958360823, 0.1244597152276085, 0.05355598459700176 },
                { 1.740530815908843, 89.5581520607314, 87.65138332500331, 85.73727954265453, 83.81506378499808, 81.88390689287355, 79.94296631216904, 77.99146114982158, 76.02880031915424, 74.05477661838349, 72.06981904907116, 70.0752508799286, 68.07344444262544, 66.0677467259206, 64.06213285372653, 62.06070295502689, 60.06723449818611, 58.0849400349032, 56.11643459406155, 54.16382472222046, 52.22883047618835, 50.31289273183979, 48.41725314456593, 46.54301022360089, 44.69115854251266, 42.8626168952084, 41.05824925583373, 39.27888093295019, 37.52531140034823, 35.79832475604199, 34.09869844749764, 32.42721070817885, 30.78464702572841, 29.17180587769811, 27.58950391135356, 26.03858070078474, 24.51990318182877, 23.03436983955242, 21.58291470175871, 20.16651117335386, 18.78617572902187, 17.44297146432169, 16.13801148699535, 14.87246210996379, 13.64754578422765, 12.46454368273901, 11.32479781437529, 10.22971250966915, 9.180755076445763, 8.179455374032279, 7.22740400015468, 6.326248727342045, 5.477688770001622, 4.683466416560795, 3.9453555341296, 3.26514646122038, 2.644626866527275, 2.085558290640716, 1.589648323750338, 1.158518718492677, 0.793670185221641, 0.4964451134517032, 0.2679898073573817, 0.1092167976452411, 0.0207467924569561, 0.0003869181456323765, 0.004052345103760319, 0.02103229482002396, 0.07226909976403267, 0.1854448733527396, 0.3804123140655122, 0.652904463822499, 0.9702290162128939, 1.283992542867357, 1.551011055998676, 1.748393043605052, 1.875589487897268, 1.946435334007727, 1.978918315950903, 1.98832729984711, 1.984951753794452, 1.974684981623427, 1.960542042895494, 1.94397040990481, 1.925663436349422, 1.905976317695826, 1.885113251584929, 1.8632056603814, 1.84034456271571, 1.816594930253365, 1.792002994700758, 1.766600575650886, 1.740407950464607, 1.71343588668323, 1.685687132065284, 1.657157527144271, 1.627836844181222, 1.597709423050296, 1.566754654362935, 1.534947347133612, 1.502258009743183, 1.468653067373604, 1.434095035606678, 1.39854266798321, 1.361951094699976, 1.324271970105533, 1.285453648151841, 1.245441407427932, 1.204177750826481, 1.161602809244891, 1.117654883917369, 1.072271167821261, 1.025388692717762, 0.9769455540954362, 0.9268824704722971, 0.8751447344737743, 0.8216846083883905, 0.7664642032220285, 0.7094588535812172, 0.6506609566402035, 0.5900841782736646, 0.5277678419288016, 0.4637812100094926, 0.3982272567631428, 0.3312454453256396, 0.2630130300855906, 0.1937448024732974, 0.1236946651980725, 0.05323188849738008 },
                { 1.793337112189378, 87.39760285908485, 85.55247961677346, 83.70077930389785, 81.84181213241789, 79.97483429378338, 78.09907386523433, 76.21378318290909, 74.318331502795, 72.41235155317288, 70.49594329821325, 68.56990971605821, 66.63595302031115, 64.69672228268986, 62.75562798930117, 60.81645022105238, 58.88289277316048, 56.95825715201799, 55.04531149069852, 53.14631484291123, 51.26311359158606, 49.39724649352881, 47.5500305912305, 45.72262378894876, 43.91606886512145, 42.13132475193571, 40.36928947711801, 38.63081761296176, 36.91673399910168, 35.22784485140428, 33.56494698502827, 31.92883564899777, 30.32031132478811, 28.74018574594981, 27.18928733001384, 25.66846616676504, 24.17859867184371, 22.7205919873555, 21.29538818892043, 19.9039683393532, 18.547356411389, 17.22662308427053, 15.94288940045333, 14.69733024808954, 13.49117761124597, 12.32572350193175, 11.20232245489752, 10.12239342685803, 9.08742089554615, 8.098954900569037, 7.158609708000844, 6.268060716018091, 5.429039153841509, 4.643324068087159, 3.912731050800277, 3.239097158426479, 2.624261522491301, 2.070041286535153, 1.578202745781403, 1.150427934377447, 0.7882773967366336, 0.4931504423561107, 0.2662446125500094, 0.1085151587429143, 0.02061453653074366, 0.000227692082929088, 0.002517499472617787, 0.01378396588093931, 0.04991442283200267, 0.1347905351062403, 0.2904154092047643, 0.5221290094529094, 0.8098947266641459, 1.113713232296627, 1.390219636538895, 1.60930845085255, 1.761320670929939, 1.853553871290046, 1.901477752294463, 1.920831261825308, 1.923547697242867, 1.917116625693349, 1.905643047438957, 1.891180485680063, 1.874715249722772, 1.856731937031685, 1.837490102517011, 1.817146007869104, 1.795803436590491, 1.773535198780507, 1.750393105869797, 1.726413324306913, 1.701619685097473, 1.676025937241668, 1.649637366665542, 1.622451991686623, 1.594461457999522, 1.565651712969837, 1.53600351463875, 1.505492815788618, 1.474091053725448, 1.441765370155666, 1.408478781612275, 1.374190318708023, 1.338855151705536, 1.302424720300085, 1.264846887015093, 1.226066136182769, 1.186023844123732, 1.144658650850854, 1.101906969361022, 1.057703675198741, 1.011983026144495, 0.9646798689597634, 0.9157311960076538, 0.8650781175063469, 0.8126683125447801, 0.7584590101604498, 0.7024205260972216, 0.6445403360240508, 0.5848275970530654, 0.5233179337246078, 0.4600781851652229, 0.395210680115246, 0.32885649734414, 0.2611971557103459, 0.1924545606187267, 0.1228924856166505, 0.05289192721880036 },
                { 1.847745508761031, 85.2725479588798, 83.48669921842124, 81.69494180445055, 79.89666305458052, 78.09119709543951, 76.27784177328012, 74.45589485214065, 72.62472042664692, 70.78385800591052, 68.93318246345381, 67.07310633991347, 65.2047824022866, 63.33022426660194, 61.45225226605828, 59.57423103159802, 57.69967849345478, 55.8319014173375, 53.97377826288752, 52.12770715933033, 50.29566070059303, 48.47927848483747, 46.67995494270635, 44.8989077316656, 43.13722697086821, 41.39591016556656, 39.67588748928399, 37.97804072965464, 36.30321800602156, 34.65224557681834, 33.02593758078784, 31.42510427519226, 29.85055916256867, 28.30312528770382, 26.78364091266502, 25.29296472586275, 23.83198070314875, 22.40160270991845, 21.00277890985248, 19.63649602603362, 18.30378348200735, 17.00571743252364, 15.74342467497309, 14.51808641174303, 13.33094180969654, 12.18329127452271, 11.07649932359775, 10.0119969000577, 8.991282922005788, 8.015924803574031, 7.087557619146694, 6.207881510057393, 5.378656858361224, 4.601696682068244, 3.878855652329556, 3.212015113135479, 2.603063522192095, 2.053871857401587, 1.566263778186053, 1.141980719618375, 0.7826426329169363, 0.4897057189445274, 0.2644190234157028, 0.1077809423008608, 0.0204761129588762, 0.0001329548552899444, 0.001549359590528094, 0.008935456459951389, 0.03405280871464481, 0.09666020578948786, 0.2185489199696863, 0.4114031468518069, 0.6661512363435424, 0.9525338712955583, 1.230416521693994, 1.46557372965112, 1.640346708104494, 1.75469197852572, 1.82000765008083, 1.851245576140138, 1.861432559631229, 1.859620437600389, 1.85117988433308, 1.838954473014487, 1.824346769337643, 1.808036368732693, 1.790368032086461, 1.771534969234412, 1.751658243287361, 1.730820087655333, 1.709078421258619, 1.686473914629207, 1.663033979020832, 1.638775325055473, 1.613705742080224, 1.587825389787749, 1.561127755540953, 1.533600370383524, 1.505225345767514, 1.475979775075138, 1.445836032824427, 1.414761997309168, 1.382721217969766, 1.349673046276648, 1.315572747911106, 1.280371614323487, 1.244017093231297, 1.206452960265148, 1.167619557798713, 1.127454132041392, 1.085891305729476, 1.042863731130938, 0.9983029763073152, 0.9521407060704596, 0.9043102267632765, 0.8547484691004295, 0.8033984830741185, 0.7502125094003466, 0.6951556678922461, 0.638210258213246, 0.5793805963497124, 0.5186982065773531, 0.45622705513143, 0.3920683609914834, 0.326364384250602, 0.2593005534832839, 0.1911056574037347, 0.1220532598725508, 0.05253612833355003 },
                { 1.903804612049997, 83.18344332851573, 81.45462824233792, 79.72049488858179, 77.9804986621952, 76.23404408874619, 74.48049555290793, 72.71920202236115, 70.94954425719989, 69.17101510811694, 67.38334253255858, 65.58665605894516, 63.78167521672693, 61.96986432309577, 60.15347175378922, 58.33539019155674, 56.51885413948078, 54.70708411621723, 52.90301059907411, 51.10914545676994, 49.32758180229498, 47.56006173858929, 45.80805956897618, 44.07285390590163, 42.35558204731945, 40.65727899745621, 38.97890550258142, 37.32136875626557, 35.68553825514244, 34.07225837654992, 32.48235867097902, 30.91666251668198, 29.37599457657803, 27.86118736865857, 26.37308717687042, 24.91255947171893, 23.48049396841062, 22.07780941924517, 20.70545821238146, 19.36443082846681, 18.0557601880389, 16.78052590456811, 15.53985843917401, 14.33494313216002, 13.16702406229222, 12.03740765587554, 10.94746593276816, 9.89863923412603, 8.892438225596248, 7.930444908936105, 7.014312304423381, 6.145762387111744, 5.326581775428524, 4.558614587796467, 3.843751813921547, 3.183916510782277, 2.58104415554017, 2.037057602199225, 1.55383633326067, 1.133180104219637, 0.7767676579444543, 0.4861118926987614, 0.2625134907133495, 0.1070143150684007, 0.02033155166511573, 7.709574551375823e-05, 0.0009454045622694912, 0.005734434820037261, 0.02296745108675117, 0.06844585319046199, 0.1622463851813647, 0.3195873299041231, 0.5401072039072742, 0.8033856336829634, 1.074993680923886, 1.319708288803294, 1.51375315308675, 1.649751410779416, 1.733835744488376, 1.77884213198867, 1.79807186724945, 1.801889835616793, 1.797013738680691, 1.787251041076004, 1.774565075703821, 1.759918244718945, 1.743784649463888, 1.726413823013923, 1.707951798350018, 1.688493068865531, 1.668102654172207, 1.646826058742548, 1.624694369350468, 1.601727269745935, 1.577935034693312, 1.553319938956027, 1.527877286353305, 1.501596172201036, 1.474460050365151, 1.446447153772987, 1.417530803984624, 1.387679637185459, 1.35685776885506, 1.325024916443955, 1.292136498136606, 1.25814372592563, 1.222993712649844, 1.186629615334152, 1.148990841150258, 1.110013347656398, 1.069630075717351, 1.027771561619659, 0.9843667841775923, 0.9393443125617029, 0.8926338301609807, 0.8441681172360106, 0.7938855775803052, 0.7417333876255883, 0.6876713245451834, 0.6316762856183258, 0.5737474365651305, 0.5139118155551045, 0.4522300716839597, 0.3888018436973021, 0.3237701210724211, 0.2573238603623277, 0.1896984701876062, 0.1211771898312888, 0.05216456966394271 },
                { 1.961564503162104, 81.13067037368496, 79.4567674182855, 77.77806862041438, 76.09408932195437, 74.40429717029218, 72.7081185854433, 71.00495538000879, 69.29421803003885, 67.57538425007635, 65.84809218457437, 64.11227343389996, 62.36831756288537, 60.61723417069411, 58.86074939166297, 57.10126665969824, 55.3416647779258, 53.58498934192079, 51.83415319611471, 50.09174366932541, 48.35996062198859, 46.64064721879776, 44.93535979265847, 43.24543974646877, 41.57207211721122, 39.91632889044926, 38.27920019922697, 36.66161710509207, 35.06446878186025, 33.48861596448077, 31.93490184227484, 30.40416115185532, 28.89722797140926, 27.41494256378248, 25.95815751795927, 24.52774337328741, 23.12459386509512, 21.74963089672936, 20.40380931698032, 19.08812156037009, 17.80360218874904, 16.55133235439556, 15.33244418591469, 14.14812507732048, 12.99962183638928, 11.88824461923617, 10.81537054254434, 9.782446821351701, 8.790993227190061, 7.842603597362227, 6.938946050568353, 6.081761477601891, 5.272859781364268, 4.514113244609798, 3.807446318692634, 3.154821071627846, 2.558217537516974, 2.019608309542044, 1.540926959090684, 1.124030284968365, 0.7706550184364865, 0.482370392994088, 0.260528720017603, 0.1062155463860028, 0.02018090192487043, 4.442919662612407e-05, 0.0005724370651217191, 0.003646466775847865, 0.01532809050689348, 0.04789977452421496, 0.1189186397196445, 0.2449321995686012, 0.4318897143495589, 0.6683665924865616, 0.9270753490682195, 1.174549255326699, 1.383219487904553, 1.539154861928727, 1.642567048283345, 1.702948656833231, 1.732871304501671, 1.743533348950936, 1.742938849369523, 1.735987491562662, 1.725354769616687, 1.712394402769317, 1.697770925325926, 1.681819480404079, 1.664723541381003, 1.646594722240952, 1.627506921960175, 1.607511101144731, 1.586642228076146, 1.564923017001014, 1.54236623205127, 1.518976248903486, 1.494750170047986, 1.46967864044248, 1.443746448490575, 1.416932967645849, 1.389212477668682, 1.360554394844711, 1.330923434544615, 1.300279726081894, 1.268578898257474, 1.235772153936, 1.201806353334016, 1.166624128389941, 1.130164054682081, 1.092360912957604, 1.053146079525026, 1.012448093576002, 0.9701934598140135, 0.9263077561540831, 0.8807171277853473, 0.8333502588204129, 0.7841409181776922, 0.7330311727489573, 0.6799753418618563, 0.6249447242011171, 0.5679330522161328, 0.5089625112390735, 0.4480899982720257, 0.3854130989251956, 0.3210750656405733, 0.2552679763301841, 0.1882335642462586, 0.1202645945450576, 0.0517773787674077 },
                { 2.021076782623397, 79.11453858463464, 77.4935359183187, 75.86820050108013, 74.23810042963361, 72.60275966362938, 70.9616615867258, 69.31425992702852, 67.66000197018435, 65.9983709458191, 64.32895581631223, 62.6515553661276, 60.96631588071064, 59.27388419622707, 57.5755322396334, 55.87319021781746, 54.16933954021452, 52.46677530559067, 50.76831871293873, 49.07658267701835, 47.39385022185537, 45.72205901218297, 44.06284804202176, 42.41762351368528, 40.78761940117268, 39.1739447485025, 37.57761832876662, 35.99959384215069, 34.44077866384882, 32.90204829978292, 31.38425795107086, 29.88825207890056, 28.4148725500186, 26.9649657556184, 25.53938898056361, 24.1390162248792, 22.76474362831653, 21.41749461208405, 20.09822482398323, 18.8079269506916, 17.5476354413745, 16.31843116833858, 15.12144603150495, 13.95786749261692, 12.82894300082958, 11.73598424208152, 10.68037110871177, 9.663555241322766, 8.687062940026679, 7.752497175237648, 6.861538347929543, 6.015943355827667, 5.217542417658683, 4.46823299843728, 3.769970076714906, 3.124751919841608, 2.534600516095873, 2.001535894811886, 1.527543797922834, 1.114536598845799, 0.7643080272329185, 0.4784831198869225, 0.2584656670958955, 0.1053850063921508, 0.02002423203360527, 2.546583752715726e-05, 0.0003442244818341577, 0.002299514578205731, 0.01013121017181066, 0.03315790343986814, 0.08612646959489439, 0.1853371352376125, 0.3408111866066382, 0.5486824649920563, 0.7892698774966189, 1.032983089041785, 1.250878718904372, 1.423860109797037, 1.54618080031639, 1.623044566255565, 1.665231521140985, 1.684091105468005, 1.688679163013662, 1.685031413688692, 1.676671218633946, 1.665465919529057, 1.652349243364243, 1.637783619282796, 1.62200915132124, 1.60516253456314, 1.587329604156225, 1.568567889495091, 1.54891662994996, 1.528401698978785, 1.507038384854421, 1.48483316539112, 1.461784932669285, 1.437885871957237, 1.413122101616472, 1.387474138618266, 1.360917233240445, 1.33342160469084, 1.304952602396661, 1.275470813653026, 1.244932136370142, 1.213287835374327, 1.180484601920512, 1.14646463872904, 1.111165797031068, 1.074521797917755, 1.036462577879231, 0.9969148078880845, 0.9558026466908031, 0.913048801796957, 0.8685759851690949, 0.8223088631523293, 0.7741766088116243, 0.7241161648589257, 0.6720763097863652, 0.6180225792741983, 0.5619430181968673, 0.5038546147889969, 0.4438100921463997, 0.3819045112871821, 0.3182809100896261, 0.253134058732858, 0.186711689147389, 0.1193159081538203, 0.05137473208039673 },
                { 2.082394616478119, 77.13528832658524, 75.56527517886553, 73.9913405109135, 72.41309883392807, 70.83012417732951, 69.24195168849178, 67.64808456321928, 66.04801003494966, 64.4412298046818, 62.82731182594044, 61.20597049738901, 59.57717853119592, 57.94130265647121, 56.29923548617588, 54.652474081342, 53.0030909842281, 51.35357583672891, 49.70658804126875, 48.06470846257972, 46.43026961123244, 44.80529019331424, 43.19148949132694, 41.59033993892794, 40.00312603964564, 38.43099454788156, 36.87499260945803, 35.3360956816311, 33.81522811500512, 32.31327878890324, 30.83111344282973, 29.369584761787, 27.92954089515591, 26.5118328593043, 25.11732113458807, 23.74688167959135, 22.40141152733434, 21.08183408756536, 19.78910424919605, 18.52421335321433, 17.28819408621698, 16.08212532597913, 14.90713695152134, 13.76441460937721, 12.65520440362542, 11.58081744803458, 10.54263418250995, 9.54210831087574, 8.580770160703084, 7.660229196287831, 6.782175331314166, 5.948378587625328, 5.160686532457485, 4.421018803892832, 3.731357914667355, 3.093735428265497, 2.510212560694761, 1.982854322237921, 1.513696533392093, 1.104705488567295, 0.7577307419606293, 0.474452431730409, 0.2563255316145592, 0.104523163561306, 0.01986162884947742, 1.452896608656418e-05, 0.0002057381790975243, 0.00143930571224964, 0.006637630129954962, 0.02272424964199269, 0.06168871812409713, 0.1385740339653446, 0.2655800246745625, 0.4446914072000928, 0.6635109408157069, 0.8976919444114885, 1.119122849486736, 1.305303688281947, 1.445085838373288, 1.538852371367064, 1.594618035945785, 1.623067314520579, 1.633894127143425, 1.634195335652132, 1.628433779086423, 1.61911334235925, 1.607530789708409, 1.594331453911108, 1.579840008234476, 1.564230653991894, 1.547606202546273, 1.530032664643761, 1.51155424512739, 1.49220022069006, 1.47198848467863, 1.4509276390353, 1.429018367040439, 1.406254391015343, 1.382623158278611, 1.358106334357903, 1.332680153405246, 1.30631566074372, 1.278978873980878, 1.250630884278873, 1.221227916939514, 1.190721369879113, 1.159057849592109, 1.12617922678144, 1.092022738037454, 1.056521165925586, 1.019603137784319, 0.9811935936071378, 0.9412144856407405, 0.8995857865696277, 0.8562268986683736, 0.8110585715308355, 0.764005448032986, 0.7149993622017031, 0.6639835012029608, 0.6109175063020686, 0.5557835113713614, 0.4985929888304893, 0.4393940829001583, 0.3782788638880301, 0.3153896700152445, 0.25092351485094, 0.1851337738818742, 0.1183316770193661, 0.05095685373880014 },
                { 2.145572783785266, 75.19309375084324, 73.67225271678478, 72.14785599449517, 70.61955894252783, 69.08698001653628, 67.54970106479444, 66.00727148132675, 64.45921902753775, 62.90507148874251, 61.34439479949586, 59.77685410454175, 58.20230273986641, 56.62089759935987, 55.03322532901909, 53.44040407824879, 51.8441115502317, 50.24650100430273, 48.6500113025709, 47.0571315242308, 45.47020146266685, 43.8912994855568, 42.32221826836214, 40.76449631577575, 39.21947020254153, 37.68832550397115, 36.17213796002594, 34.67190428602651, 33.18856485978179, 31.72302074236519, 30.27614690084652, 28.84880288076741, 27.4418417311174, 26.05611770455282, 24.69249308571549, 23.35184439587823, 22.03506815491256, 20.74308633597351, 19.47685161547244, 18.23735249566451, 17.02561835620447, 15.84272447198135, 14.68979701555982, 13.56801804194605, 12.47863042947275, 11.42294272154794, 10.40233377781689, 9.418257097682194, 8.472244621646196, 7.565909744059383, 6.700949182352385, 5.879143241419487, 5.102353888292961, 4.372519916190419, 3.691648339347058, 3.061801041272575, 2.485075632905599, 1.963579513173295, 1.49939632744841, 1.094544460813155, 0.7509279387322153, 0.4702811298288206, 0.2541097492833631, 0.1036305816163662, 0.01969319721832893, 8.257132101026825e-06, 0.0001223197710675285, 0.0008949281358020087, 0.004314390208292744, 0.01543195731477804, 0.0437351972070327, 0.1024607958388728, 0.2045183300096571, 0.3560247725151119, 0.5509942222301185, 0.7709491711442203, 0.9903875754417607, 1.18528419353445, 1.340123087165615, 1.450408054897812, 1.520636492279958, 1.559977173181225, 1.578195911482566, 1.583236821809108, 1.580520343030509, 1.573291563806389, 1.563312306835193, 1.551480060966552, 1.538242432913392, 1.523829560976454, 1.508369185029163, 1.491938962151533, 1.474589253234387, 1.456353170789269, 1.437251366589793, 1.417294618617754, 1.396485416893383, 1.374819024804169, 1.352284221646968, 1.328863828707893, 1.304535078345995, 1.279269865372869, 1.253034909357121, 1.225791850569237, 1.197497299247493, 1.168102856911099, 1.137555129241093, 1.105795752507498, 1.072761459712091, 1.038384218712766, 1.002591482832272, 0.9653066050703418, 0.9264494801884592, 0.8859374945402289, 0.8436868810177707, 0.7996145944608981, 0.7536408385164901, 0.7056923833109601, 0.6557068065577553, 0.6036377574550302, 0.5494612680838757, 0.493183004610096, 0.4348461477521045, 0.3745393201795243, 0.3124036714619158, 0.2486379928256821, 0.183500920834053, 0.1173125561423327, 0.05052401409580379 },
                { 2.210667725556151, 73.28806580348435, 71.81466593296966, 70.33803640107547, 68.85786853832453, 67.37382017340307, 65.88551508030318, 64.39254521265848, 62.8944778435505, 61.39087081599219, 59.88130040616896, 58.36540739078773, 56.84296672196078, 55.31398275553961, 53.77880275955986, 52.2382257433619, 50.69356704748982, 49.14663598239338, 47.59960879853241, 46.05482722343692, 44.51459092851783, 42.98100881236191, 41.45593431202737, 39.94096908630322, 38.43750261444815, 36.94676061295537, 35.46984807963418, 34.00778289094475, 32.56152080856501, 31.13197410852944, 29.72002584776913, 28.32654121165435, 26.95237689074814, 25.59838909997124, 24.2654406460733, 22.95440732293119, 21.6661838350512, 20.40168939759264, 19.16187312488318, 17.94771929223962, 16.76025253395305, 15.60054302084032, 14.46971164172944, 13.3689351928102, 12.29945155514683, 11.26256481188835, 10.25965022065801, 9.292158910789909, 8.361622116749436, 7.469654685292274, 6.61795750189635, 5.808318369729155, 5.042610741778993, 4.322789557403726, 3.650883278528619, 3.028981078341477, 2.459214041419375, 1.943729241935815, 1.48465574792934, 1.084062037782918, 0.743905081382365, 0.465972440369317, 0.2518199825621387, 0.1027079158647141, 0.01951905929023312, 4.678057173731583e-06, 7.239849992713635e-05, 0.0005532225051184095, 0.002784521618119068, 0.01039339831645268, 0.03071753927754905, 0.07498074918983534, 0.1557594530800535, 0.2817513513425842, 0.4521993384514889, 0.6544843814163795, 0.8669491151274265, 1.065805787987664, 1.232514278335908, 1.358097167200985, 1.4431010611747, 1.494403080823342, 1.521178426538328, 1.531866146405074, 1.532764891786233, 1.527925126433693, 1.519672419618588, 1.509236241766667, 1.497236642182757, 1.483985610176365, 1.469647788964242, 1.454317514037223, 1.438053273820591, 1.42089275434196, 1.402859635283642, 1.383966968021057, 1.364219084198606, 1.343612801478077, 1.322138238876248, 1.299779383027633, 1.276514479808234, 1.25231629693478, 1.227152289127717, 1.200984690011464, 1.173770551106334, 1.145461746848533, 1.116004965079321, 1.085341704732672, 1.053408306581081, 1.020136049062342, 0.9854513496839184, 0.9492761235965053, 0.9115283649019699, 0.8721230331688002, 0.8309733470766872, 0.7879926078607006, 0.7430966945943676, 0.6962073864025628, 0.647256665251463, 0.596192124699232, 0.5429835382114051, 0.4876305059004651, 0.4301708839359396, 0.3706894033635102, 0.3093255359350672, 0.2462793710776998, 0.1818143986843874, 0.1162593049187696, 0.05007652796085869 },
                { 2.277737595176689, 71.42025530841618, 69.99264589473546, 68.56209788849488, 67.12833432941538, 65.6910479247535, 64.24989996305117, 62.80452123651698, 61.35451656941962, 59.89947540975926, 58.43899203736046, 56.97270005500903, 55.50032630577389, 54.02176782335155, 52.53718978008789, 51.04713095573186, 49.55258780135059, 48.05503772141071, 46.55637114697049, 45.0587365647645, 43.56434540648502, 42.07530177221416, 40.59350095152215, 39.12060097465666, 37.65804352421408, 36.20709558466232, 34.76889238852446, 33.3444732673225, 31.9348090483822, 30.54082250028954, 29.16340381733598, 27.80342275256634, 26.46173850738978, 25.1392081002011, 23.83669368612103, 22.55506914631101, 21.29522617072608, 20.05807999770776, 18.84457493293358, 17.65568974064673, 16.49244297688099, 15.35589831439213, 14.24716988986867, 13.16742768374018, 12.11790291961336, 11.09989344200284, 10.1147689952767, 9.163976280946179, 8.249043611552936, 7.371584904107312, 6.533302660948186, 5.73598946824936, 4.981527401109174, 4.271884561744485, 3.609107802819511, 2.995310521118696, 2.432654283196106, 1.92332302068568, 1.469488687805071, 1.073267702762727, 0.7366682866827086, 0.4615299938920718, 0.249458110064835, 0.1017559090115688, 0.01933935373765456, 2.643990483241045e-06, 4.269214310363896e-05, 0.0003402813887333095, 0.001785949266352998, 0.00694815282433756, 0.02139156452892801, 0.05435253879302422, 0.1174090865315112, 0.220554991630036, 0.3669762564026511, 0.5494236102804081, 0.7507592092539195, 0.9489073728857872, 1.123765963025311, 1.262649820900653, 1.362084138247678, 1.42605227013604, 1.462456043910049, 1.479762684345252, 1.484959744423024, 1.482905038025442, 1.476567966475545, 1.467594003549343, 1.456835386414364, 1.444720398478535, 1.431467754669688, 1.417196135607419, 1.401975306048983, 1.385848744089835, 1.368843612808432, 1.35097540550977, 1.332250358761585, 1.312666870068847, 1.292216411751388, 1.270884148154124, 1.248649355037696, 1.225485696405033, 1.201361394537891, 1.176239319372354, 1.150077018460898, 1.122826706761094, 1.094435235633672, 1.06484406249728, 1.033989246607061, 1.001801502600337, 0.9682063521023208, 0.9331244251884259, 0.8964719782195546, 0.8581617127030606, 0.8181040011737874, 0.7762086496030149, 0.7323873490332501, 0.6865569871329174, 0.6386439947555049, 0.5885898802214206, 0.5363580364058033, 0.4819417701640645, 0.4253732785832582, 0.3667329736330725, 0.3061581636490039, 0.2438497463689695, 0.1800756343468395, 0.1151727822981599, 0.04961475258565907 },
                { 2.346842310359459, 69.58965610205831, 68.20626108669079, 66.82018779517909, 65.43118725236852, 64.03898306497856, 62.64327001841934, 61.24371411532054, 59.83995526213838, 58.43161448493499, 57.01830845676338, 55.59967514534953, 54.17541515669533, 52.74535294847583, 51.30951892077855, 49.86824560859534, 48.42225854658557, 46.97272952273328, 45.52125804060526, 44.0697668232206, 42.62033495579333, 41.17502297958443, 39.73574324705588, 38.30419871578684, 36.88188014868653, 35.47009618149477, 34.07001333772622, 32.68269302833194, 31.30912115737284, 29.95023052486365, 28.60691770817913, 27.28005611147624, 25.97050644637271, 24.67912549153918, 23.40677368428963, 22.15432191104556, 20.92265774934621, 19.71269134272223, 18.52536104298579, 17.36163892176209, 16.22253622826493, 15.10910884958381, 14.02246281042757, 12.96375982918141, 11.93422292423469, 10.93514203666417, 9.967879600071439, 9.033875942825709, 8.134654348842899, 7.271825526601201, 6.447091138420887, 5.662245919551241, 4.919177767199437, 4.219865004588862, 3.566369832242926, 2.960826786833995, 2.40542487301833, 1.902381974889178, 1.453910277181821, 1.062171840438343, 0.7292242860045553, 0.4569578025769863, 0.2470262148052951, 0.1007753865078919, 0.01915423488594258, 1.491831956207981e-06, 2.510018728761295e-05, 0.0002084222187016735, 0.001139275132882517, 0.004614438021096338, 0.01478308136601331, 0.03905965996677726, 0.08766350685084626, 0.1709021132737394, 0.2946712656517569, 0.4562975934744666, 0.6433338488352324, 0.8365020444867536, 1.015544956483072, 1.1650954271355, 1.277938577511216, 1.354806813718047, 1.401707546531122, 1.426599626509185, 1.436863760973014, 1.438088306321873, 1.433930989451589, 1.426531881960525, 1.417042291680685, 1.406049926947377, 1.393850958255039, 1.380599578744648, 1.366381668101707, 1.351248445478247, 1.335231305276685, 1.318348463677737, 1.300608168837429, 1.282010441269933, 1.262548127847813, 1.242207586393604, 1.220969140164755, 1.198807372781876, 1.175691305581148, 1.151584486246795, 1.126445011187039, 1.100225501337092, 1.072873050761154, 1.044329169205055, 1.014529743607417, 0.9834050497111949, 0.9508798536798849, 0.9168736554610798, 0.8813011410220617, 0.844072929857984, 0.8050967273297014, 0.7642790176271401, 0.721527460215632, 0.6767541757794283, 0.6298801183856718, 0.5808407149854707, 0.5295928911825756, 0.4761234674992385, 0.420458676505386, 0.3626742035568942, 0.3029047152350549, 0.2413514206685929, 0.1782862040500743, 0.1140539414089081, 0.04913908542472582 },
                { 2.418043606671944, 67.79620819771157, 66.45552111892462, 65.1123889820654, 63.76658754438793, 62.41786780015663, 61.06595440810247, 59.71054514734916, 58.35131231473162, 56.98790750343677, 55.61997193183933, 54.24715538646516, 52.86914769025644, 51.48572682779888, 50.09682630872738, 48.70261939318538, 47.3036082861804, 45.90069408221039, 44.49519541301399, 43.08879149002023, 41.68339296285871, 40.28097811000847, 38.88344707909349, 37.49253141164548, 36.10976461855137, 34.73649597772644, 33.37392409352185, 32.02313328386718, 30.68512484629991, 29.36084142151866, 28.05118542630183, 26.757033162833, 25.47924598579966, 24.21867950707447, 22.976191486514, 21.75264883526523, 20.54893401975898, 19.36595106929045, 18.20463133571129, 17.06593911697574, 15.95087722936844, 14.86049259153048, 13.79588186377524, 12.75819716622705, 11.74865187682499, 10.76852648293079, 9.819174425590294, 8.902027830401903, 8.018602959870594, 7.170505144950415, 6.359432853701803, 5.587180428237477, 4.855638864210037, 4.166793819946488, 3.522719831291709, 2.925569490972007, 2.377556163613875, 1.880928710963426, 1.437936789188346, 1.050785672715541, 0.7215803839186982, 0.4522602356372083, 0.2445265714352891, 0.09976725149257089, 0.01896387176733885, 8.408984744438599e-07, 1.472419708768168e-05, 0.0001272177681537664, 0.0007233902753818874, 0.003046907196827279, 0.01014639837669379, 0.02785044668851006, 0.06488607822498272, 0.1311838930660672, 0.2342686485270066, 0.3751029492933456, 0.5457002209234374, 0.7302461148896201, 0.9095443502044846, 1.066684923363943, 1.191288657395635, 1.280757815899089, 1.338719223920613, 1.372074886530819, 1.38821690408597, 1.393301274370982, 1.391667186176936, 1.386010478719073, 1.377850010837869, 1.367983553448438, 1.356814917976414, 1.344549331231, 1.331295924523077, 1.317116669299074, 1.30204838522619, 1.286112467966351, 1.269319351226512, 1.251670747855137, 1.233160911176713, 1.213777412696434, 1.193501642364158, 1.172309126763433, 1.150169716785057, 1.127047677601054, 1.102901705104764, 1.077684889150168, 1.051344643032603, 1.023822620075098, 0.9950546418200739, 0.9649706683611524, 0.9334948501606035, 0.9005457127947408, 0.8660365420238983, 0.8298760568995942, 0.791969483495492, 0.7522201707441657, 0.7105319208020097, 0.6668122348428421, 0.6209766926320207, 0.5729546762009254, 0.5226965925100494, 0.4701826178974424, 0.4154327462881075, 0.3585175519216497, 0.2995685921430077, 0.2387868869895708, 0.1764478236763371, 0.1129038237201658, 0.04864996169937927 },
                { 2.491405092688782, 66.03980095884384, 64.74038038102876, 63.4387240443288, 62.13462959672962, 60.8278723266202, 59.5182035203454, 58.20534954676865, 56.88901236134553, 55.56887253296207, 54.24459648014514, 52.91585035873557, 51.58232386091861, 50.24376771046961, 48.90004808663962, 47.55121827955365, 46.19760118471061, 44.83986584433409, 43.47907117644875, 42.11664919170631, 40.75431663282338, 39.39393439600464, 38.0373589054471, 36.68632951802889, 35.34241244668077, 34.00699455206971, 32.68130660058231, 31.3664566421749, 30.06346192605165, 28.7732750073455, 27.49680381807471, 26.23492697685775, 24.98850575184728, 23.7583937780276, 22.54544528364018, 21.35052232349076, 20.17450135089043, 19.01827935736417, 17.88277974512109, 16.76895805525311, 15.6778076449951, 14.61036538436742, 13.56771742243296, 12.5510050535056, 11.56143069156605, 10.60026393446524, 9.668847665523216, 8.768604095676785, 7.90104059057776, 7.067755049500786, 6.270440501530005, 5.510888454071903, 4.790990364977381, 4.112736410949505, 3.478210496141889, 2.889580202088281, 2.3490801585415, 1.858987177714538, 1.421585540888926, 1.03912119082523, 0.7137444142326556, 0.4474419931166198, 0.2419616326289873, 0.09873247939004034, 0.01876844710994709, 4.738255618677175e-07, 8.624146250119843e-06, 7.744062212329265e-05, 0.0004575450231237111, 0.002001859292709809, 0.006922018148981271, 0.01971883108690851, 0.04764784414738541, 0.09982580010966801, 0.1845287157386873, 0.3053974677069846, 0.4583970507986561, 0.6314492237468483, 0.8073581878599535, 0.9687928932568233, 1.102991443172349, 1.20421821606339, 1.273420652543467, 1.315944563229113, 1.338760426534973, 1.348347415382251, 1.349656636302711, 1.345970714903859, 1.33923838509913, 1.330522778599758, 1.320372162466006, 1.309063343216757, 1.296738788226494, 1.283475704406009, 1.269318185466596, 1.254291531213419, 1.238408639039976, 1.221673023276471, 1.204080391080353, 1.185619553956934, 1.166272989896591, 1.14601719196798, 1.124822870110461, 1.102655044908226, 1.079473059968435, 1.055230534191707, 1.029875273572804, 1.003349163142485, 0.9755880630130772, 0.9465217383673798, 0.9160738620244903, 0.8841621404931309, 0.850698630855872, 0.8155903370753013, 0.7787402007909321, 0.740048633131197, 0.6994157688495448, 0.6567446579969934, 0.6119456348930609, 0.5649421044531353, 0.5156779385373899, 0.4641265473358056, 0.4103014451147631, 0.3542677363513865, 0.29615341597345, 0.2361588143676673, 0.1745623384746032, 0.1117235528105342, 0.04814785179457492 },
                { 2.566992306817284, 64.32027626191883, 63.06074163061207, 61.799159391422, 60.53534659902601, 59.26910011427133, 58.0001949577306, 56.72838317027941, 55.45339370733581, 54.17493421342601, 52.89269598763876, 51.60636407530858, 50.3156351588078, 49.02024656197435, 47.72001970968016, 46.41491982893757, 45.10512924498194, 43.79112355740962, 42.47373000093807, 41.15414149688449, 39.83386695485399, 38.5146212694547, 37.19818603671342, 35.88628442427206, 34.58050152401105, 33.282256122531, 31.99281002611901, 30.71329555580329, 29.44474659664101, 28.18812592718532, 26.94434689138322, 25.71429002090807, 24.49881590969011, 23.29877552397753, 22.11501881082665, 20.9484021849817, 19.79979527857144, 18.6700872146988, 17.56019258956505, 16.47105729899796, 15.40366431208804, 14.35903946990043, 13.3382573664602, 12.34244734927839, 11.37279965499236, 10.43057166968438, 9.517094270289041, 8.633778159859648, 7.782120051295562, 6.963708476589371, 6.180228896138345, 5.433467649189408, 4.725314116597065, 4.057760257748718, 3.432896437598808, 2.852902191595132, 2.320030320003957, 1.836582523171987, 1.404874790365881, 1.027191084493542, 0.7057246939687763, 0.4425080783906172, 0.2393340147692275, 0.09767211222496538, 0.0185681562731981, 2.670676553135865e-07, 5.046881580826455e-06, 4.704514094664141e-05, 0.0002884914376633556, 0.00130970484634843, 0.004697498029241075, 0.0138745057090677, 0.03474022667386211, 0.07536348883083763, 0.1441089442381579, 0.246411075986842, 0.381517278629294, 0.5410289888339848, 0.7103788288117369, 0.8728137059743465, 1.014074884947455, 1.125712296182805, 1.205907678597881, 1.258054466885806, 1.288260791365435, 1.303019575809871, 1.30775744152536, 1.306333357935724, 1.301172910454428, 1.293659966539263, 1.284529473796566, 1.274155668466536, 1.262727984053435, 1.250345281901205, 1.237061699421451, 1.222907561220074, 1.207898665055584, 1.192040496799677, 1.17533028797738, 1.157758125211962, 1.139307598960057, 1.119956192775932, 1.099675504194534, 1.078431345260266, 1.056183752974372, 1.032886932366422, 1.008489152211551, 0.9829326138174817, 0.9561533162996405, 0.9280809474202107, 0.8986388377779776, 0.8677440285142845, 0.8353075195150675, 0.8012347871530036, 0.7654266885674687, 0.7277809033742827, 0.6881941022518365, 0.6465650712249197, 0.6027990523990902, 0.5568135712019702, 0.5085459820740278, 0.457962843215545, 0.4050709827275294, 0.3499297050215654, 0.2926630069792289, 0.2334700321544861, 0.1726317122654775, 0.1105143278147254, 0.0476332585182972 },
                { 2.644872775846996, 62.63743163096905, 61.41645950545123, 60.19360919312046, 58.96871498205599, 57.74159291218764, 56.51203916743278, 55.27982881437214, 54.04471528900712, 52.80643128269696, 51.56469204601001, 50.31920263925896, 49.06967129798237, 47.81583173513826, 46.55747753764108, 45.2945111451977, 44.02700714953941, 42.75528378175277, 41.4799677646213, 40.20202978446229, 38.92276793774751, 37.6437308537789, 36.36659722814385, 35.09304854146406, 33.82467162454849, 32.56290862458968, 31.30904958501188, 30.06425100721625, 28.8295640506029, 27.60596220052847, 26.39436431895796, 25.19565262861078, 24.01068660747788, 22.84031398105534, 21.68537976954836, 20.54673405915446, 19.42523894382923, 18.32177493723638, 17.23724706311885, 16.17259077499708, 15.12877781837532, 14.10682212162603, 13.10778577998884, 12.13278517701567, 11.18299726643849, 10.25966601211075, 9.364108951419789, 8.497723804894819, 7.661994997390919, 6.858499879036275, 6.088914330971205, 5.355017305002824, 4.658693671039624, 4.001934526951068, 3.386833863180098, 2.815580181236576, 2.29044137369052, 1.81374094838743, 1.3878236310967, 1.015008668948117, 0.697529975782129, 0.4374637696672251, 0.2366464830898197, 0.0965872527151727, 0.01836320614126086, 1.506666351757495e-07, 2.952795002474448e-06, 2.854176596545436e-05, 0.0001814589316293459, 0.0008538831654036961, 0.003173521581315314, 0.009708980754939109, 0.02516815128277818, 0.05648833940000238, 0.1116610224557287, 0.1971570928860109, 0.3147791246517738, 0.4595068524607343, 0.61972537273537, 0.7800647683952266, 0.9256619646433621, 1.045943779011895, 1.136449183637597, 1.198365243751534, 1.236534535405325, 1.257115864838861, 1.265812562194607, 1.267000333181454, 1.263603865849912, 1.257377164022594, 1.249287052173679, 1.239836020620927, 1.229278063556218, 1.217742521933641, 1.205297582298426, 1.191980277853968, 1.17780997831861, 1.162794403372113, 1.146932414428172, 1.130215421384361, 1.112628156141931, 1.094149117722104, 1.074750819004908, 1.054399897665507, 1.033057127139749, 1.010677352452733, 0.9872093715968895, 0.9625957828047612, 0.9367728206091327, 0.9096702089546402, 0.8812110681862089, 0.8513119251406098, 0.8198828926659175, 0.7868281076538895, 0.7520465459605146, 0.7154333687794634, 0.6768819972460015, 0.6362871568847813, 0.5935491730364213, 0.5485798173035061, 0.5013099773979307, 0.4516993096351553, 0.3997477849245645, 0.345508607779165, 0.2891013619711552, 0.2307235137953228, 0.1706580162544427, 0.1092774166187605, 0.04710671425299294 },
                { 2.725116075275607, 60.99102332780356, 59.807343949179, 58.62193918887393, 57.4346586649032, 56.24533549162182, 55.05378473687113, 53.85980210873219, 52.66316317881688, 51.46362364398078, 50.26092141927769, 49.05478176798302, 47.84492721562801, 46.63109460645069, 45.41306213803533, 44.19068908120594, 42.96396932637117, 41.73309585970262, 40.49852631012851, 39.26103154017168, 38.02170509718674, 36.78191807732251, 35.54322336562678, 34.30723577261419, 33.07552437206111, 31.84954322093259, 30.63060574163551, 29.41989152760215, 28.21846938174126, 27.02732405565887, 25.84738021495614, 24.67952172931701, 23.52460666760334, 22.38347906400994, 21.25697846968727, 20.14594804702483, 19.0512417229562, 17.97373074691807, 16.91430989003084, 15.87390345411325, 14.85347121559151, 13.85401439938146, 12.87658175475683, 11.9222757847526, 10.99225915955663, 10.08776131969685, 9.210085243536675, 8.360614312018916, 7.540819147297539, 6.752264225383197, 5.996613959592014, 5.275637813875888, 4.591213825264331, 3.945329686428136, 3.340080261526209, 2.777660090828281, 2.260349112659052, 1.790489559709632, 1.370451884717086, 1.002587810512034, 0.6891693993057035, 0.4323145907792469, 0.2339019364249373, 0.09547905820275713, 0.01815381398561427, 8.512537671667342e-08, 1.728283238354356e-06, 1.730412041967654e-05, 0.0001139372229639821, 0.0005551565531925119, 0.002135861761217815, 0.006761937045736095, 0.0181310167191025, 0.04206825318839901, 0.0859016853597323, 0.1565327364744422, 0.2576115962345562, 0.387037169227003, 0.5362057207883151, 0.6917069413873307, 0.8388911413761655, 0.9657474943074116, 1.065476831609471, 1.136967532969949, 1.183470885440274, 1.210457654402006, 1.223659647539291, 1.22785816442304, 1.226466467381587, 1.221645232369009, 1.214637687706163, 1.206109263284996, 1.196400166842639, 1.185681855324043, 1.174042147122245, 1.16152723580886, 1.148161071389107, 1.133954006271961, 1.118906689889774, 1.103011923125562, 1.086255615163534, 1.068617307255297, 1.050070454846751, 1.030582553601752, 1.010115153755296, 0.988623790867007, 0.9660578547495339, 0.9423604170040093, 0.9174680395787462, 0.8913105917784212, 0.8638111114939824, 0.834885758768285, 0.8044439270965118, 0.7723886011934964, 0.7386170804385461, 0.7030222255305593, 0.6654944316113948, 0.6259245813476976, 0.5842082787038555, 0.5402516931486582, 0.4939793279273559, 0.4453439229588398, 0.3943384569728446, 0.3410097669695039, 0.2854726318566654, 0.2279223602584224, 0.1686434175675981, 0.1080141488728328, 0.04656877802792041 },
                { 2.807793891465096, 59.38076938349228, 58.23316354136019, 57.08397035772058, 55.93305311130487, 54.78026013944088, 53.62542337552599, 52.46835703111268, 51.30885665776492, 50.14669897651603, 48.98164309300466, 47.81343404920081, 46.64181011341813, 45.46651575590889, 44.28732277737726, 43.10406223839868, 41.91666906606826, 40.7252385910039, 39.53008902626346, 38.33181653776866, 37.13132334778417, 35.92980029118306, 34.72865804295727, 33.52942221092764, 32.33362359128918, 31.14271421398628, 29.95802377730527, 28.78075253996795, 27.61198678859404, 26.45272303940716, 25.30389217353101, 24.16637982784674, 23.04104251680048, 21.92872025532224, 20.83024668647466, 19.7464575449443, 18.67819804703414, 17.62632960591121, 16.59173614241561, 15.57533018100382, 14.57805886952764, 13.60091002772998, 12.64491830447364, 11.71117150265382, 10.8008171097955, 9.915069048339448, 9.055214629324268, 8.222621652808703, 7.418745543317476, 6.645136333067317, 5.903445202662159, 5.195430150043326, 4.522960174838498, 3.888017128980745, 3.292694092079025, 2.739188788663935, 2.22979020215047, 1.766856220971133, 1.352779993213415, 0.9899428515075118, 0.6806524418929522, 0.4270662815482324, 0.2311033917116066, 0.09434873448130824, 0.01794020630762389, 4.819345976411146e-08, 1.012566435907598e-06, 1.049035714563972e-05, 7.146231242086706e-05, 0.0003601788553052734, 0.00143306146211777, 0.00469050741926225, 0.012997445707604, 0.03115005475802579, 0.06565886099461958, 0.1234023746154212, 0.2092424965055232, 0.3234593452246879, 0.4603099813578538, 0.6086881245010932, 0.7548424325877988, 0.8860314500615998, 0.9935595606481119, 1.074085129719735, 1.129049130063673, 1.162907650785355, 1.181143136056999, 1.188783616278029, 1.189682348700474, 1.186423531137547, 1.180566060842032, 1.172974875498268, 1.16410173708286, 1.154174915111952, 1.143309350025507, 1.13156384892235, 1.118968415423883, 1.105536630461188, 1.091271167454237, 1.07616631525086, 1.060209206544437, 1.043380454606121, 1.025654484574745, 1.006999680791079, 0.9873784079969175, 0.9667469394406963, 0.9450553153961449, 0.9222471528621495, 0.8982594284715099, 0.8730222611991614, 0.8464587295138215, 0.818484769827342, 0.789009220468046, 0.75793409918547, 0.7251552337058643, 0.6905634051345374, 0.6540462130622761, 0.6154909267455252, 0.5747886417477178, 0.5318401009465423, 0.4865635352418714, 0.4389047881064817, 0.3888497472937599, 0.3364386482557698, 0.2817810990307841, 0.2250697832762364, 0.1665901676201496, 0.1067259088886662, 0.04602003254033501 },
                { 2.892980085683646, 57.80635255853697, 56.69364872388391, 55.57948244623699, 54.46372919923426, 53.34625091338006, 52.22689460159163, 51.10549106782159, 49.98185387929724, 48.85577890282675, 47.72704488803844, 46.5954158479768, 45.46064635927674, 44.32249137701583, 43.18072266711178, 42.03515429956572, 40.88567938279372, 39.73231862887017, 38.57527759520651, 37.41500334752476, 36.25222457237867, 35.08795640138622, 33.92345788384733, 32.76014690809007, 31.59949594245441, 30.44293931348445, 29.29181370284483, 28.14733601401769, 27.01060906039819, 25.88264138945037, 24.76437055637615, 23.65668422245279, 22.56043734441185, 21.47646571226693, 20.40559672474556, 19.34865827459403, 18.30648640630366, 17.27993220398232, 16.26986821917639, 15.27719465300236, 14.30284544710025, 13.34779439921787, 12.41306139198608, 11.49971880146853, 10.60889813111207, 9.74179689331782, 8.89968573156965, 8.083915736989097, 7.295925859537399, 6.537250239826434, 5.809525185124696, 5.114495373647701, 4.45401868458411, 3.830068807970936, 3.244734482691215, 2.700213846790004, 2.198801987090534, 1.742869406930174, 1.334828911528428, 0.9770885351539769, 0.6719888692049011, 0.4217247679880014, 0.2282539683846735, 0.09319752957459093, 0.01772261767148011, 2.735475057471838e-08, 5.941577566450338e-07, 6.362960809935648e-06, 4.480035711176807e-05, 0.0002333387832335507, 0.0009591940557933484, 0.003242777729588769, 0.009278133272331589, 0.02294952119676716, 0.04989682318516674, 0.09666093635732225, 0.1687800506981895, 0.2683626626730606, 0.3922295833924825, 0.5317119173970058, 0.6744762504369697, 0.8077166201450649, 0.921366585664688, 1.010065938740415, 1.073348485840669, 1.114385846741165, 1.138127460515762, 1.14965128068951, 1.153162531589048, 1.151660377448078, 1.147048317674471, 1.140426457498541, 1.132386206005162, 1.123230398047756, 1.113110760483723, 1.102103412054741, 1.090246500157279, 1.077557704466789, 1.064042070810839, 1.049695516226622, 1.034506458779033, 1.018456618459551, 1.001521417804306, 0.9836701590907513, 0.9648660566956435, 0.9450661653205098, 0.9242212303078472, 0.902275481524928, 0.8791663925940254, 0.8548244312525615, 0.8291728343135524, 0.8021274526943474, 0.773596729345382, 0.7434818970152154, 0.7116775151746592, 0.6780725074634816, 0.642551913217466, 0.6049996272624778, 0.5653024649344935, 0.5233559396104632, 0.4790721498851487, 0.432390095952815, 0.3832885117517371, 0.3318008316992422, 0.2780311548268134, 0.2221690885514019, 0.1645005904228129, 0.1054141284851819, 0.04546108115217734 },
                { 2.980750760090539, 56.26742322088717, 55.18849491675574, 54.10821735240848, 53.02647690730848, 51.94314766917075, 50.85809015023852, 49.77115004235222, 48.68215714965477, 47.59092473225899, 46.49724963899375, 45.40091382224847, 44.30168813267759, 43.19933969381514, 42.09364462432931, 40.98440828305063, 39.87149525778289, 38.75487044909929, 37.6346500573275, 36.51115652455347, 35.38496518943921, 34.25692563623589, 33.1281425418558, 31.99991257571031, 30.87363172544874, 29.75070019365453, 28.63245048452739, 27.52011041532112, 26.41479733139314, 25.31753165494213, 24.2292580149754, 23.15086644741337, 22.08321047644484, 21.02712158098728, 19.98342068106925, 18.9529275012727, 17.93646853283073, 16.93488411381478, 15.94903498222666, 14.97980854542367, 14.0281250388023, 13.09494370187458, 12.18126906952495, 11.28815745295899, 10.41672366368965, 9.568148011002979, 8.743683575065931, 7.944663720129873, 7.172509760193683, 6.428738616753785, 5.714970206980202, 5.032934161143414, 4.384475279273352, 3.771556887640473, 3.196260937531419, 2.660783303132942, 2.167422303879795, 1.718558059206129, 1.316620001494452, 0.9640399311006482, 0.6631886860618257, 0.4162961325997979, 0.2253568727956442, 0.09202672751887635, 0.01750128953726927, 1.557431454307808e-08, 3.493649095094061e-07, 3.863663075699065e-06, 2.808885707675179e-05, 0.0001510386838882701, 0.0006408769317270705, 0.002235875852455392, 0.006599632894885806, 0.01683412479581349, 0.03772498053607231, 0.07527785367764205, 0.1352825566642293, 0.2211547141703946, 0.3318947679382248, 0.4612298290600008, 0.5985892660982542, 0.7316810206245385, 0.8496238207105067, 0.9453621971697272, 1.016549294433622, 1.064881394176949, 1.094509927109809, 1.110342523181488, 1.116811859455643, 1.117294445030964, 1.114052070918466, 1.108451360824775, 1.101252682793074, 1.092853902863949, 1.083455514581845, 1.073157117098225, 1.062007875875164, 1.05003080856504, 1.037233839643034, 1.023614717157261, 1.009163229608892, 0.9938622461120197, 0.9776882158875025, 0.9606113873521324, 0.9425958572089593, 0.9235995020317247, 0.9035738227873607, 0.8824637250404648, 0.8602072565811946, 0.8367353275182646, 0.8119714451122921, 0.7858315073304596, 0.7582237163644205, 0.7290486976580883, 0.698199943092363, 0.6655647405787344, 0.631025807415999, 0.5944639103027492, 0.5557618253328272, 0.5148100526327502, 0.4715147243258907, 0.4258080821815258, 0.3776616788461936, 0.3271019833474946, 0.2742272772201462, 0.2192236590707665, 0.1623770709251552, 0.1040802798426451, 0.04489254488742121 },
                { 3.071184325722975, 54.76360213265639, 53.71736551755925, 52.66988236384946, 51.62104882140383, 50.57074986859653, 49.51885811860697, 48.4652326329371, 47.40971784904629, 46.35214280371554, 45.29232094895731, 44.23005102996042, 43.1651197434354, 42.09730723283742, 41.02639689289087, 39.95219137522889, 38.87453690743509, 37.79335765032318, 36.70870018609958, 35.62078470140279, 34.5300540207237, 33.43720614237249, 32.34319439561859, 31.24918612571835, 30.15648574305038, 29.0664432620607, 27.9803745401514, 26.89951092506364, 25.82498108675456, 24.75781655015283, 23.69896923240098, 22.64933192559923, 21.60975695176966, 20.58107150523673, 19.56408989281846, 18.55962343095619, 17.56848875332793, 16.59151510745598, 15.62955104446211, 14.68347077894264, 13.75418041331257, 12.84262416877869, 11.9497907308138, 11.0767197919494, 10.22450885307521, 9.394320321910766, 8.587388920002296, 7.805029373287437, 7.048644310859686, 6.3197322255758, 5.619895250313716, 4.950846364705061, 4.31441545689174, 3.712553410434411, 3.147333057341317, 2.620945432232383, 2.135689297906641, 1.693951445831533, 1.298174927931241, 0.9508123621839373, 0.654262087948662, 0.4107865849933666, 0.2224153827777312, 0.09083764219755466, 0.01727646910328419, 8.898565124775977e-09, 2.059551493347234e-07, 2.349847428223805e-06, 1.762285990505409e-05, 9.774055753856722e-05, 0.0004276930058713545, 0.001538447111818743, 0.004680722586597984, 0.01230240628373944, 0.02839496839546038, 0.05832379868645547, 0.1078134208737587, 0.1811264713621479, 0.2790228798762491, 0.3974531131475359, 0.5277887242005052, 0.65871307124865, 0.7790688533868482, 0.8805027220242195, 0.9589256040126634, 1.014458993031961, 1.050231808089634, 1.07075495011654, 1.080534652750576, 1.083257166698996, 1.081536956367936, 1.077030536580214, 1.070695691800463, 1.063047760187868, 1.054350252908006, 1.044734060829226, 1.034263194734282, 1.02296772707031, 1.010859181671237, 0.9979374287293373, 0.9841937459871668, 0.9696122057997994, 0.954170316415307, 0.9378393000827592, 0.9205841663062897, 0.902363650701024, 0.883130056391252, 0.8628290227979369, 0.8413992438340093, 0.8187721599179214, 0.7948716548926463, 0.7696138002690582, 0.7429067062780893, 0.7146505636001141, 0.684737993293744, 0.6530548674095056, 0.6194818205409826, 0.5838967427689804, 0.5461786223913088, 0.5062131792629639, 0.4639007683957195, 0.419166987895979, 0.3719762160748753, 0.3223478275550715, 0.2703740089628841, 0.2162369386601326, 0.1602220434879269, 0.1027258684213362, 0.04431505945352658 },
                { 3.164361572545566, 53.29448313801706, 52.2798947800389, 51.26415324943307, 50.24716346483281, 49.22882017678728, 48.20900686125874, 47.18759459809619, 46.16444101685768, 45.13938945163065, 44.11226853842085, 43.08289262759583, 42.05106358676164, 41.016574851409, 39.9792189424458, 38.93880007052908, 37.89515375494932, 36.84817530647707, 35.7978580521528, 34.74433967823368, 33.68795069487832, 32.62925362869866, 31.56905802709703, 30.5083990100791, 29.44847813099968, 28.39058055778746, 27.33599245235491, 26.2859398998821, 25.24155840025562, 24.20388902455206, 23.17389086884242, 22.15245981567724, 21.14044728595393, 20.13867631642625, 19.1479545621107, 18.16908477539835, 17.20287350272269, 16.2501386257733, 15.31171620260284, 14.38846692335344, 13.48128239969595, 12.59109144618138, 11.71886647251793, 10.86563007837863, 10.03246191993715, 9.220505895024025, 8.430977667389442, 7.665172515658849, 6.924473443931492, 6.210359421926927, 5.524413524534254, 4.868330602682221, 4.243923926492572, 3.653129983248246, 3.098010273787257, 2.580748526096608, 2.103641248045052, 1.66907902542168, 1.279515557662694, 0.9374213329459205, 0.6452194135297501, 0.4052024330488161, 0.2194328324695265, 0.08963161127276753, 0.01704840816595502, 5.104540442996135e-09, 1.217826709047242e-07, 1.432176501427874e-06, 1.106971294355082e-05, 6.32682502066232e-05, 0.0002852516161643415, 0.00105701124227937, 0.003312108115174337, 0.008962742833246143, 0.02129019116670818, 0.0449834432714547, 0.08548125207435822, 0.1475093530920156, 0.2331706831507189, 0.340379045320404, 0.4624842334517309, 0.5894772718000818, 0.7104090431700884, 0.8160606327916918, 0.9008302862378803, 0.963259145552809, 1.00528639425534, 1.030811428398096, 1.044241149226865, 1.049476077173734, 1.049455827386515, 1.046138691952806, 1.040705013563752, 1.033810877045327, 1.025799049035648, 1.01684124407267, 1.00702124932698, 0.9963785026672203, 0.984929129593257, 0.9726755346007811, 0.9596106513625282, 0.945719826912119, 0.930981666025124, 0.9153683927522256, 0.8988459579741285, 0.8813739904148933, 0.862905637940497, 0.843387327338606, 0.8227584653384175, 0.8009511048207172, 0.7778896061573205, 0.7534903344887387, 0.7276614505273331, 0.7003028768189896, 0.6713065554447293, 0.6405571592564482, 0.6079334789158237, 0.5733107825951671, 0.5365645304167377, 0.4975759092338108, 0.4562397074652745, 0.4124750222431985, 0.3662390977029156, 0.3175441202368619, 0.2664759363099607, 0.2132124159008036, 0.1580379805688148, 0.1013524259962684, 0.0437292723085724 },
                { 3.260365741625059, 51.85963574628252, 50.87569056840591, 49.89067720406326, 48.90450845554018, 47.91708785652671, 46.92830864865655, 45.93805272766997, 44.94618962266518, 43.95257561911006, 42.95705320985718, 41.95945117037254, 40.959585719728, 39.95726346289425, 38.9522871199708, 37.94446541487635, 36.93362883665899, 35.91965309604703, 34.90249158983156, 33.8822164935949, 32.85906473340089, 31.83348026023061, 30.80613961460673, 29.77794737483535, 28.74999509321607, 27.72349070196949, 26.69967784049644, 25.67976753495139, 24.66489638011395, 23.6561125312748, 22.65438169448298, 21.66060303821587, 20.67562740772334, 19.70027389095741, 18.73534354177006, 17.7816304736609, 16.83993098810964, 15.91105139178558, 14.9958150069685, 14.09506873092691, 13.20968939152028, 12.34059007556636, 11.48872656140413, 10.6551039566516, 9.840783618587395, 9.046890412294358, 8.274620336108699, 7.525248510419061, 6.800137479065509, 6.100745705653569, 5.428636051132305, 4.785483882575707, 4.173084272188532, 3.593357484125495, 3.048351599338021, 2.54024068645771, 2.07131639922177, 1.643970316836651, 1.260663862120205, 0.9238824603932821, 0.6360710984929939, 0.3995500548135349, 0.2164125974992062, 0.0884099902546675, 0.01681736200501205, 2.941015002490461e-09, 7.226175946022759e-08, 8.751302429229994e-07, 6.965116510245664e-06, 4.09870415484681e-05, 0.0001902382867761733, 0.0007255761884669543, 0.002339623817960293, 0.006513278618961852, 0.01591117415137467, 0.0345577153595181, 0.06746625921067675, 0.1195218267978988, 0.1937853332288331, 0.289826191742521, 0.4028943663744075, 0.5244932678529948, 0.6442862246179976, 0.7526200969411079, 0.8426746434513949, 0.9114924226105598, 0.9597231491099828, 0.9904677088129524, 1.007854151548789, 1.015878901359528, 1.017756601466304, 1.015744825921859, 1.011265686057614, 1.005138625562584, 0.9978033392625134, 0.9894835639344997, 0.9802890072610981, 0.9702714910042144, 0.9594531012693825, 0.9478393497775927, 0.9354250589578438, 0.9221969468454604, 0.9081347603274012, 0.8932117546067405, 0.877394849058632, 0.860644596689573, 0.8429150288600214, 0.8241534086514931, 0.8042999170562839, 0.7832872957330233, 0.7610404751989657, 0.7374762276383652, 0.7125028999061276, 0.6860203064993303, 0.6579198965569705, 0.6280853560011683, 0.5963938682487821, 0.562718335593712, 0.5269309555807847, 0.4889086412117607, 0.4485408435633381, 0.4057403272626448, 0.3604572741375619, 0.3126966232292165, 0.2625376684796399, 0.2101536085167394, 0.1558273816979622, 0.0999615038546879, 0.04313583979366093 },
                { 3.3592825994948, 50.45860760560876, 49.50433698506428, 48.54907564700795, 47.5927434939674, 46.63525196697918, 45.6765031002953, 44.7163885354154, 43.7547885432981, 42.79157114133693, 41.82659145076254, 40.85969153059415, 39.89070105907889, 38.91943942719999, 37.94572007208131, 36.96935820499848, 35.99018342951888, 35.00805896035195, 34.02290895390668, 33.03475438033935, 32.0437553755644, 31.05025395715031, 30.05480638606498, 29.05819208759549, 28.06138951662751, 27.06551983804647, 26.07177233200103, 25.08133268876666, 24.09533179583762, 23.11482147419617, 22.14077289276778, 21.17408846475574, 20.21561875282073, 19.2661791604773, 18.32656426998241, 17.397559557877, 16.47995099205378, 15.57453315799506, 14.68211645944969, 13.80353379173824, 12.93964696633429, 12.09135308412076, 11.25959100266697, 10.44534800866927, 9.649666781509131, 8.873652711355597, 8.118481610330072, 7.385407823115309, 6.67577269848002, 5.991013318501973, 5.332671288654383, 4.702401257479341, 4.101978644372827, 3.533305790556052, 2.998415393797245, 2.499469629468069, 2.038752803960758, 1.618654775083054, 1.24164182411208, 0.9102114074176422, 0.6268276310068168, 0.3938358713070928, 0.2133580806202769, 0.08717414674463113, 0.01658358830069441, 1.702580883218419e-09, 4.30447108380722e-08, 5.363618338276574e-07, 4.391911016396145e-06, 2.658697100578864e-05, 0.0001269297317046798, 0.0004978786834709771, 0.001650728924107169, 0.004724003510114379, 0.01185923429129962, 0.02645879787873736, 0.05303509350628994, 0.09640483623950161, 0.1602502693342285, 0.2454736908554349, 0.3490644681630417, 0.4641277292598158, 0.5812501621517914, 0.6907452444893932, 0.784904882262662, 0.8594285881349933, 0.9136476068391333, 0.9497178659971535, 0.9713152465480856, 0.9823980798013755, 0.9863846931023198, 0.9858131814858217, 0.9823582172371265, 0.9770228091660708, 0.9703618685964174, 0.9626638034634797, 0.9540716416969508, 0.9446534142080405, 0.9344389616628822, 0.9234376826028785, 0.9116466097820562, 0.8990539633118546, 0.8856406898140923, 0.8713811078967111, 0.8562431316921675, 0.8401882670457498, 0.8231714638932824, 0.8051408660595181, 0.7860374850611818, 0.7657948218190455, 0.7443384642112744, 0.7215856980298388, 0.6974451848293793, 0.671816784088344, 0.6445916314786646, 0.6156526328257145, 0.5848755975241084, 0.5521313176006823, 0.5172889975121974, 0.4802215450859404, 0.4408133195895479, 0.398970945127108, 0.3546376430741578, 0.3078110799083054, 0.2585638179729541, 0.2070640483284499, 0.1535927628112214, 0.0985546661981178, 0.04253542434813067 },
                { 3.461200514775341, 49.09092686405881, 48.16539687048004, 47.23894687488393, 46.31150318547978, 45.38298437399519, 44.45330040334045, 43.52235170800393, 42.59002826471153, 41.65620872114997, 40.72075969815197, 39.78353545402423, 38.8443782097724, 37.9031195940325, 36.95958388859365, 36.0135940415134, 35.06498173753665, 34.11360308220689, 33.15936145693485, 32.20223846550983, 31.24233212350341, 30.27989819374056, 29.31538626477482, 28.34945872438361, 27.38298147494764, 26.41698251995807, 25.45258657943933, 24.49094382600125, 23.53317185582229, 22.58032181204846, 21.63336851648577, 20.69321725381887, 19.76071850004136, 18.83668426061068, 17.92190284011385, 17.01715115073628, 16.12320480379843, 15.24084657735111, 14.37087383037599, 13.51410530271572, 12.6713876132824, 11.84360167738579, 11.03166920414479, 10.23655939617058, 9.459295946380979, 8.700964403738201, 7.962719955320241, 7.245795641297687, 6.551510976377294, 5.881280888937853, 5.23662479804279, 4.619175516442541, 4.03068747883931, 3.473043530169846, 2.948259148328816, 2.458482503651119, 2.005988173639243, 1.593161674076154, 1.222471349249972, 0.8964238192391769, 0.6174995090361033, 0.388066320385387, 0.2102726978787956, 0.08592545488440271, 0.01634734608900924, 9.906998409283869e-10, 2.57504507734745e-08, 3.298595028472002e-07, 2.77651324628193e-06, 1.727631717895518e-05, 8.476816064508077e-05, 0.0003416791294326805, 0.001163908367237727, 0.003421400552451269, 0.008820196786256328, 0.02020062510580962, 0.04154662167395662, 0.07744660923998386, 0.1319238458980744, 0.2069004924988654, 0.3008918184626822, 0.4085972771294972, 0.5217415807599224, 0.6309536619463514, 0.7279778699856753, 0.8073819289054939, 0.8672171674516136, 0.9085970363957943, 0.9345899937414782, 0.9489753485457683, 0.955285889125516, 0.9563046077625552, 0.9539590452693151, 0.9494517390629653, 0.9434706710904099, 0.9363826256896753, 0.9283725591749443, 0.9195294125809602, 0.9098930852893137, 0.8994778990987939, 0.8882835341926988, 0.8762998909815917, 0.8635091906718217, 0.8498868524733041, 0.8354018114922099, 0.8200165527125797, 0.8036869762584275, 0.7863621468112195, 0.7679839575897857, 0.7484867334861709, 0.72779680054524, 0.7058320577797143, 0.6825016026684486, 0.6577054852455439, 0.6313347000076927, 0.603271573181732, 0.5733907686711121, 0.5415612218365051, 0.507649415467681, 0.47152452815022, 0.4330660867200099, 0.3921747879004324, 0.3487870225452785, 0.3028931921897853, 0.2545589818582214, 0.2039472668569042, 0.1513366460005877, 0.09713348378566269, 0.04192869182302683 },
                { 3.566210537119662, 47.7561044159638, 46.85841417486127, 45.95986857102382, 45.06039970152216, 44.15993257899796, 43.25838432700483, 42.35566332418743, 41.45166832603993, 40.54628761734993, 39.63939828691566, 38.7308657756654, 37.82054393934822, 36.90827599924397, 35.99389694095664, 35.0772381688342, 34.1581355189994, 33.2364420180345, 32.31204689804044, 31.3849020548937, 30.45505593471784, 29.52269233140276, 28.58816780855248, 27.65203760945689, 26.71505865825763, 25.77816252994827, 24.84240128006677, 23.90888003603971, 22.97869510358657, 22.052891796406, 21.13244607844075, 20.21826531779809, 19.31119993438538, 18.41205880385941, 17.52162419219133, 16.64066458209617, 15.76994526674769, 14.91023718720439, 14.06232458463107, 13.22701194174478, 12.40513056115789, 11.59754502733398, 10.80515973058913, 10.02892558743179, 9.269847061483675, 8.528989565262383, 7.807487299054156, 7.106551553472191, 6.427479461174711, 5.771663123311497, 5.140598947997068, 4.535896908766577, 3.959289244082967, 3.412637854289378, 2.897939287540121, 2.417325721701137, 1.973059740022006, 1.567519996759508, 1.203174182436147, 0.8825352631769269, 0.6080971997262585, 0.382247831793653, 0.2071598653809225, 0.0846652900387965, 0.01610889476023566, 5.79618625764809e-10, 1.547593873844743e-08, 2.036340880463467e-07, 1.760524814586881e-06, 1.125068339570565e-05, 5.668932100058897e-05, 0.0002346236986960741, 0.0008205162027996609, 0.002475707993983851, 0.006549234698265906, 0.01538703888051453, 0.03245107849294887, 0.06199817753188106, 0.1081698301377217, 0.173621606866617, 0.2581545473744733, 0.3579800104002354, 0.466084471402736, 0.5736959873058058, 0.672338316695115, 0.755694393772528, 0.8206333816113235, 0.8671812582532337, 0.8976715966455075, 0.915565967603233, 0.9244094593044297, 0.9271782772988844, 0.9260412607519704, 0.922410448427921, 0.9171231037786906, 0.9106385811429135, 0.9031934275321012, 0.8949030944759905, 0.885820418251622, 0.8759659885550952, 0.8653427159220325, 0.8539424214180173, 0.8417486994912322, 0.8287381147707794, 0.8148806505731795, 0.8001397955284097, 0.7844724283453697, 0.7678285705156322, 0.7501510431915283, 0.7313750542699469, 0.7114277424051263, 0.6902277124611082, 0.6676846115895475, 0.6436988182016986, 0.6181613502270312, 0.5909541476968161, 0.5619509517863553, 0.5310190913415751, 0.4980225990177993, 0.4628272051801446, 0.4253078750575582, 0.3853596098964519, 0.342912125972437, 0.297948599008958, 0.2505277241085511, 0.2008067816479335, 0.1490615497327604, 0.09569952785023825, 0.04131630890619158 },
                { 3.674406478553526, 46.45363603258548, 45.5829162021734, 44.71140017354881, 43.83902528394417, 42.96572237335703, 42.09141504238602, 41.21601885697063, 40.33944052193408, 39.46157706490982, 38.58231510345141, 37.70153031665067, 36.81908731640992, 35.93484022291589, 35.04863440534241, 34.16031006117644, 33.26970857217791, 32.37668285562825, 31.48111312268773, 30.58292934484167, 29.68214095739434, 28.77887246902173, 27.87340050295894, 26.96618399278994, 26.05787678180126, 25.14931362964041, 24.24146816839562, 23.33539208933408, 22.43215240034624, 21.53278281924982, 20.63825725790218, 19.74948390466839, 18.86731292253944, 17.99255026265757, 17.12597241276489, 16.26833961223928, 15.42040693060657, 14.58293349553186, 13.75669040720549, 12.94246783792771, 12.14108169889783, 11.3533801487652, 10.58025014174945, 9.822624162929146, 9.081487264907259, 8.357884494801407, 7.652928776549208, 6.967809284969488, 6.303800308751981, 5.662270542121641, 5.04469265958291, 4.45265290185391, 3.887860216711967, 3.352154234501963, 2.847510989934504, 2.376044806521897, 1.940004127481269, 1.541758332960483, 1.183771829730888, 0.8685611719920414, 0.5986311010281622, 0.3763868035166669, 0.2040229867187636, 0.08339502373530159, 0.01586849310507108, 3.410664532461185e-10, 9.347118339990041e-09, 1.262334541731062e-07, 1.120065264229799e-06, 7.345556806379982e-06, 3.797965979457922e-05, 0.0001612779274823213, 0.0005786021320575545, 0.00179061710919129, 0.004857411039431582, 0.01169918337957002, 0.02528477285083111, 0.0494813152361905, 0.08837987260614202, 0.1451195098012836, 0.2205412903922808, 0.3122329517611268, 0.4144865435271906, 0.5193422459112991, 0.6183990422736091, 0.7047181642217443, 0.7741316285358621, 0.8255845388544007, 0.8605827454603216, 0.8821422232917523, 0.8937112568897172, 0.8983936592873699, 0.898575578407238, 0.8958810616996939, 0.891309952129496, 0.8854281392633066, 0.8785342080492707, 0.8707765851495396, 0.8622245393324069, 0.8529066294497245, 0.8428297575927113, 0.8319879853480208, 0.8203664109391013, 0.8079428002589626, 0.7946882144716985, 0.7805671691570766, 0.7655375470956687, 0.7495503585910467, 0.7325493941825769, 0.7144707982670321, 0.6952425902820141, 0.6747841666206456, 0.6530058303138637, 0.6298084180166987, 0.6050831276286866, 0.5787116986650299, 0.5505671656384762, 0.5205154962975475, 0.4884185431349231, 0.4541388723588762, 0.4175471675350182, 0.3785329826859394, 0.3370195392889701, 0.2929828563566368, 0.2464745590624891, 0.197646083375046, 0.1467699795783994, 0.09425436431441837, 0.04069894067028042 },
                { 3.785884997283628, 45.18300437703666, 44.3384157277803, 43.49308510500863, 42.64695459719941, 41.79996032509584, 40.95203175706436, 40.10309097082804, 39.25305187814176, 38.40181944492607, 37.54928896479016, 36.69534548354829, 35.83986353301255, 34.98270742294723, 34.12373247116352, 33.26278773302594, 32.39972102518828, 31.53438730374829, 30.66666168407366, 29.79645841837488, 28.92375669093188, 28.04863275708158, 27.17129542942931, 26.29211842962752, 25.41166003218042, 24.53066026524063, 23.65001096733821, 22.7707035010459, 21.89376796335605, 21.02022034549776, 20.15102870364007, 19.2871002785093, 18.42928448624019, 17.57838444899049, 16.73517113024367, 15.90039674957758, 15.07480629674371, 14.25914715880197, 13.45417731838147, 12.66067262902677, 11.87943358038021, 11.11129185670913, 10.3571169077762, 9.617822694266427, 8.894374732635325, 8.187797537236906, 7.499182533452558, 6.829696487925045, 6.18059046452408, 5.553209259743534, 4.949001188944676, 4.369527971886625, 3.816474284592005, 3.291656282139984, 2.797028026812775, 2.334684251704365, 1.90685723616025, 1.515904785247565, 1.164285485838543, 0.8545167909951709, 0.5891115057016018, 0.3704895795138013, 0.2008654411018618, 0.08211601887976891, 0.01562639841204147, 2.019070267929164e-10, 5.675144781231559e-09, 7.860338304351021e-08, 7.152431537714882e-07, 4.810042015176379e-06, 2.550068463262762e-05, 0.000111021240472059, 0.0004083042563731089, 0.001295112300262754, 0.003600149231877261, 0.008883204464149412, 0.01966213350169814, 0.03939067622146707, 0.07198870571801754, 0.1208698012468331, 0.1876793029522761, 0.2712128535953877, 0.3670461977661776, 0.4681748080152468, 0.5665254070592375, 0.6547991005166068, 0.7279692485489271, 0.7839535465717035, 0.8233755223452796, 0.8486959077003254, 0.8631565565388806, 0.8699126150701299, 0.8715315179726584, 0.8698433227220752, 0.8660196209597471, 0.8607457542382376, 0.8543931969799225, 0.8471505761785368, 0.8391077200559696, 0.8303032550136407, 0.8207490468791826, 0.8104418164056845, 0.7993683375397331, 0.7875076485223656, 0.7748319221509625, 0.7613067237965269, 0.7468909632570449, 0.7315366679398693, 0.7151886346428277, 0.6977839923879073, 0.6792517034368093, 0.6595120345196966, 0.6384760432133434, 0.6160451462120243, 0.5921108695699927, 0.5665549297387586, 0.5392498631493949, 0.5100605160052137, 0.4788468275284034, 0.4454684849648245, 0.4097921770409387, 0.3717022727639421, 0.3311157001739293, 0.2880014189231924, 0.242403936060905, 0.1944686237664303, 0.1444644194865182, 0.09279954832775727, 0.04007724825301226 },
                { 3.900745684048431, 43.94368090425141, 43.12441299167489, 42.30445286692717, 41.48374693336243, 40.66223610474063, 39.8398551734054, 39.01653212530653, 38.19218741427003, 37.36673322088833, 36.54007274215973, 35.71209959054879, 34.88269743115307, 34.05174006083151, 33.21909224298088, 32.38461176591438, 31.54815339686918, 30.7095756477017, 29.86875150626783, 29.02558440342038, 28.18003045499361, 27.3321270997211, 26.48202629512906, 25.63002740080183, 24.77660160375617, 23.92239825818624, 23.06822629725849, 22.21501158047353, 21.36374043301022, 20.51540490655362, 19.67096291430757, 18.83131848296159, 17.99731945946651, 17.16976607749015, 16.34942399328595, 15.53703765101612, 14.733342145662, 13.93907324107832, 13.15497586888787, 12.38181159718331, 11.62036550537694, 10.87145279744924, 10.13592539531413, 9.414678690485718, 8.708658590355943, 8.018868966165472, 7.346379585122496, 6.692334582258182, 6.057961491832087, 5.444580805668645, 4.853615946667831, 4.286603426316356, 3.745202777073388, 3.231205590316321, 2.746542619495691, 2.293287396470879, 1.873654136200712, 1.489986882950354, 1.144735967374564, 0.8404171290569388, 0.5795485678011587, 0.364562428906792, 0.1976905722315236, 0.08082962526336099, 0.01538286561905314, 1.202785236631312e-10, 3.464761279861361e-09, 4.917898626303904e-08, 4.585766412714265e-07, 3.160090802412437e-06, 1.71656787305179e-05, 7.656519966531218e-05, 0.0002884516047709782, 0.0009371192608340608, 0.002667625760405028, 0.006738905459040968, 0.01526646647891295, 0.03129178635417492, 0.05848318335069187, 0.1003609561367367, 0.1591595072895792, 0.2346981588090635, 0.3237641919011718, 0.4203872784371382, 0.5170244051460245, 0.6062621986232557, 0.6824132026801207, 0.7424605173468712, 0.7861294586217239, 0.8152395887372814, 0.8327224008531347, 0.8417014634376059, 0.8448787293172729, 0.8442752698466602, 0.8412384184242028, 0.8365839745489219, 0.8307670820917603, 0.8240243776983145, 0.8164709840836571, 0.808158118004562, 0.7991038226170407, 0.7893080155875777, 0.7787593707955346, 0.7674382901974143, 0.7553180983184765, 0.7423654336186144, 0.7285402537595349, 0.7137956281095367, 0.6980773922344215, 0.6813237027325988, 0.6634645207673914, 0.6444210554730412, 0.624105210160981, 0.6024190952495902, 0.5792547045937975, 0.5544939004190982, 0.5280089215191682, 0.4996637252583947, 0.4693166000376169, 0.436824638698186, 0.402050826703057, 0.3648746218588517, 0.3252068794103404, 0.2830096233819858, 0.23832022529708, 0.1912778043903232, 0.1421473236306623, 0.09133661914280236, 0.03945188667704197 },
                { 4.019091151088796, 42.73512764752128, 41.94039756984725, 41.14502100300446, 40.34894827511548, 39.55212465708467, 38.75448977920045, 37.95597699574368, 37.15651270675387, 36.35601565668141, 35.55439624666348, 34.75155592394074, 33.94738675327541, 33.14177133773153, 32.33458334826643, 31.52568905262071, 30.71495041110828, 29.90223052718427, 29.08740247516577, 28.27036269380495, 27.45105006032826, 26.62947115941126, 25.80573078637756, 24.98006418665725, 24.15286436561664, 23.32469551590542, 22.49628455308421, 21.66848845423873, 20.84224394670587, 20.01851313265569, 19.19823917736765, 18.38232017202514, 17.57160121585519, 16.76687939948269, 15.96891522039494, 15.1784455937033, 14.39619593589347, 13.6228905443048, 12.85926140562453, 12.10605587418778, 11.36404366862532, 10.63402354582445, 9.9168299176367, 9.21333960580387, 8.524478883724229, 7.851230921749743, 7.194643727244927, 6.555838644312134, 5.936019443901254, 5.336481985051656, 4.758624352085268, 4.203957256903114, 3.674114321420998, 3.170861597952736, 2.696105314555636, 2.251896314958263, 1.840428973029516, 1.46403150440647, 1.125143652004987, 0.8262769136113765, 0.5699522717168094, 0.358611526669327, 0.1945016779455248, 0.07953717537214858, 0.01513814652125654, 7.211854640663922e-11, 2.127525424468022e-09, 3.092481699967742e-08, 2.952876192585048e-07, 2.083595350832913e-06, 1.158841592368433e-05, 5.291820686226646e-05, 0.0002040841797257485, 0.0006786321729055952, 0.001976941127745485, 0.00510969937009958, 0.01184041031141594, 0.02481631211146644, 0.04740640615320057, 0.08310852771479733, 0.1345576201586693, 0.2024103865133433, 0.2845582116698361, 0.3760882671561207, 0.4701384133708187, 0.559399821055843, 0.6377282219207115, 0.7012950641116431, 0.748948000150887, 0.7818066084183122, 0.8023992765969346, 0.8137328622233401, 0.8185883787229993, 0.8191540306334431, 0.8169509326764308, 0.8129336028979237, 0.8076510196661381, 0.8013959761664024, 0.7943141667201347, 0.7864723545169919, 0.77789624032036, 0.768589615765113, 0.7585433429624292, 0.747739305075509, 0.736152027361589, 0.7237492462434865, 0.7104919865188625, 0.6963343812515154, 0.6812233331653708, 0.6650980644302984, 0.6478895854243392, 0.6295201131796695, 0.6099024805676397, 0.5889395973334926, 0.5665240561405923, 0.5425380249308011, 0.5168536366437356, 0.4893341848296814, 0.4598365638659871, 0.4282155544940768, 0.394330733235296, 0.3580569298370927, 0.3192991643572252, 0.2780126733237856, 0.2342277049018677, 0.1880769663219934, 0.1398211088461394, 0.0898670953426093, 0.03882350281502121 },
                { 4.141027123817927, 41.55679889373306, 40.78585012683392, 40.01429693507424, 39.24209322202731, 38.46918822560391, 37.6955259790013, 36.92104472128834, 36.14567626423768, 35.36934533066652, 34.59196889352996, 33.81345556711967, 33.03370513599894, 32.25260835939666, 31.47004726609463, 30.68589626607206, 29.90002455820135, 29.11230050960758, 28.32259890495519, 27.53081215559511, 26.73686658933286, 25.94074457906729, 25.14251219200339, 24.34234998513501, 23.54058168351838, 22.7376927945481, 21.93433076642313, 21.13128205986886, 20.32942920333238, 19.52969880449969, 18.73301454874323, 17.94026549309856, 17.15229245324987, 16.36988889606924, 15.59381020950137, 14.82478600748316, 14.06353226415165, 13.31076200015031, 12.56719439890982, 11.83356270785335, 11.11062136918547, 10.39915276160194, 9.699973842247276, 9.013942902833758, 8.341966601766484, 7.685007399026715, 7.044091493906942, 6.420317339666715, 5.814864776441305, 5.229004776170123, 4.664109720623095, 4.121664021841781, 3.60327472437567, 3.110681475060902, 2.645764876586467, 2.21055171957562, 1.807214883586984, 1.438064807411821, 1.105528423484784, 0.8121105496967905, 0.5603324038119502, 0.3526429358500179, 0.1913020006516863, 0.07823998050717511, 0.01489248903672864, 4.353273707645976e-11, 1.314252395319555e-09, 1.95492866535125e-08, 1.910160768738633e-07, 1.379163306810111e-06, 7.848294510660971e-06, 3.666652607507176e-05, 0.0001446583684145696, 0.0004920213622399138, 0.001465855706320297, 0.003873978076186353, 0.00917674690077493, 0.01965574870597216, 0.03835814983626681, 0.06866448153373132, 0.1134510592374301, 0.1740337172971743, 0.2492787612512438, 0.3353088228083981, 0.4260431988395118, 0.5144630897959571, 0.5941662168048628, 0.6606555870388252, 0.7119537554431592, 0.7484498670964944, 0.7721920089112101, 0.7859873690152459, 0.792634504219679, 0.7944566955302422, 0.7931404920705692, 0.7897839094407039, 0.7850387364959262, 0.7792621005027332, 0.7726359756360662, 0.7652460469086529, 0.7571274367302684, 0.7482886457103197, 0.738723088882746, 0.7284142807560315, 0.7173380082756647, 0.7054631336174084, 0.6927517670329283, 0.6791591242451684, 0.6646331996705655, 0.649114314325872, 0.6325345725747544, 0.6148172584680726, 0.5958762110573304, 0.5756152370231797, 0.5539276501847587, 0.5306960750643316, 0.5057927214643737, 0.4790804357674605, 0.4504149684181099, 0.4196490666461, 0.3866391932292992, 0.3512558401334561, 0.3133984445034405, 0.2730156258359635, 0.2301305492718991, 0.1848693807054144, 0.1374881476706607, 0.08839247042843805, 0.03819273350370295 },
                { 4.266662535272494, 40.40814274996479, 39.66024405290668, 38.9117796762011, 38.16270678557865, 37.41297823621121, 36.66254207424797, 35.91134098991989, 35.15931172683947, 34.40638445921639, 33.65248216023995, 32.8975200031894, 32.14140486534086, 31.3840350482675, 30.62530039314761, 29.8650830641209, 29.10325940458425, 28.33970344475274, 27.57429284513347, 26.80691826096016, 26.03749721077315, 25.26599334295301, 24.49244123596433, 23.71697524781305, 22.93985840490824, 22.16150453836663, 21.38248547220379, 20.60351711328694, 19.8254245082491, 19.04909390803383, 18.27542485690653, 17.50529400791488, 16.73953602289844, 15.97894001896447, 15.22425619697965, 14.47620705800414, 13.73549937715299, 13.00283511429631, 12.27892082263411, 11.56447578140076, 10.86023927253576, 10.16697739793157, 9.485489749526347, 8.816616165445024, 8.161243748157905, 7.520314281980056, 6.894832159001465, 6.285872896551515, 5.69459229785159, 5.122236262268197, 4.570151182133324, 4.039794755360059, 3.532746877620835, 3.050720028387972, 2.595568197905216, 2.169292878054149, 1.774043923280954, 1.412112167772209, 1.085909622562605, 0.7979320830370106, 0.5506985266743416, 0.3466625913440914, 0.1880947185604265, 0.07693932721950121, 0.01464613653086419, 2.645899566570146e-11, 8.169075393049629e-10, 1.242646541281207e-08, 1.241628656772448e-07, 9.166870542823745e-07, 5.333813375190335e-06, 2.547749928118241e-05, 0.0001027578227080307, 0.0003572645579195197, 0.001087853499006515, 0.002937875690412563, 0.007109965411562374, 0.01555439395866211, 0.03099268832356119, 0.05662249111684682, 0.09543173171359598, 0.1492320228036571, 0.2177250847621817, 0.2980123035146214, 0.3848495284140288, 0.4716564963286335, 0.5519574846829521, 0.6207409182443254, 0.6752829637119701, 0.7152395524527573, 0.7421198361705657, 0.7584545743205363, 0.7669952488043375, 0.7701612206213039, 0.7697896914308872, 0.7671228967638487, 0.7629226598494973, 0.7576182992493022, 0.7514340541094857, 0.7444782861435245, 0.7367975931781012, 0.7284061932035177, 0.7193005073652332, 0.7094658713088875, 0.6988794100292234, 0.6875111437279464, 0.6753242861980415, 0.6622751524092878, 0.6483128494332423, 0.6333788259413588, 0.6174063197526139, 0.6003197349106432, 0.5820339862581055, 0.5624538671644827, 0.5414735263375958, 0.5189761865707639, 0.4948343078839373, 0.4689104971937629, 0.4410596034871803, 0.4111326140457226, 0.3789831722512441, 0.3444777276168376, 0.307510399052715, 0.2680233797043245, 0.2260328186361561, 0.1816582402133477, 0.1351507619943611, 0.08691420877247412, 0.03756020380935555 },
                { 4.39610962342934, 39.28860260452726, 38.563046989695, 37.83696142552603, 37.11030605848005, 36.38303704697184, 35.6551061000428, 34.92645996971402, 34.19703990009989, 33.46678104219301, 32.73561185276691, 32.00345351105576, 31.27021941064992, 30.53581482051821, 29.80013686385584, 29.06307504367693, 28.32451265749609, 27.58432959573828, 26.84240720656783, 26.09863610830604, 25.35292796919669, 24.60523220789678, 23.85555805811695, 23.1040011969697, 22.35077200079597, 21.59621981092154, 20.84084559825007, 20.08529605825159, 19.33033679408821, 18.57680968013967, 17.8255857171416, 17.07752563806088, 16.33345579152932, 15.59415996849628, 14.86038295623474, 14.13284027110927, 13.4122297261394, 12.69924245460504, 11.99457257918628, 11.29892557817594, 10.61302571820392, 9.937622955173399, 9.273499636223457, 8.621477255580011, 7.982423455212944, 7.357259418741026, 6.74696777685058, 6.152601116262717, 5.575291153936349, 5.016258595172483, 4.476823628058424, 3.958416903056959, 3.462590685808231, 2.991029626419666, 2.545560224467321, 2.128157543705842, 1.740947003364826, 1.386198125785185, 1.066306003666879, 0.7837551671285162, 0.5410599559707297, 0.3406762852142977, 0.1848829377186989, 0.07563647406170357, 0.01439932719979935, 1.619526617529674e-11, 5.110167336691899e-10, 7.944089431071457e-09, 8.1115960445921e-08, 6.119752408387897e-07, 3.63851597944146e-06, 1.775770945360097e-05, 7.317315334005322e-05, 0.0002598890760562098, 0.0008083017866167785, 0.00222931837015969, 0.005508782175486593, 0.01230222552883117, 0.02501492895246536, 0.04662005629226845, 0.08011507693453482, 0.1276629811946109, 0.1896601599273386, 0.2641055666339467, 0.346607588724753, 0.4311355198113451, 0.5113040135763462, 0.5817427190479808, 0.639079629289092, 0.6822600446375278, 0.7122156995951011, 0.7311337403377671, 0.7416538907543913, 0.7462473053203944, 0.7468809600051105, 0.7449376103613218, 0.7412940762737081, 0.7364590308274928, 0.7307050481214262, 0.7241672340169726, 0.7169059976934165, 0.7089424669010419, 0.7002766216874671, 0.6908958554798267, 0.6807787268780057, 0.6698964526540824, 0.6582133688315253, 0.6456869042801629, 0.6322672964216902, 0.6178971461873794, 0.6025108592755197, 0.5860340067973737, 0.5683826422149869, 0.5494626276675412, 0.5291690519754931, 0.5073858687040158, 0.4839859518870055, 0.4588318672883212, 0.4317777965304732, 0.4026732343293419, 0.3713692965886893, 0.3377286887843526, 0.3016404864732553, 0.2630406652014134, 0.2219384498449016, 0.1784466514010658, 0.1328112173193215, 0.0854337419369012, 0.03692652544529246 },
                { 4.529484031474684, 38.19761848588536, 37.49372224830227, 36.78932904963682, 36.08440176388054, 35.37889957031992, 34.67277752618527, 33.96598609518622, 33.25847063380805, 32.55017084204779, 31.84102019317824, 31.13094536980476, 30.41986575337703, 29.7076930449624, 28.99433114135858, 28.27967645885734, 27.56361899448459, 26.8460445477329, 26.12683869523749, 25.40589330089569, 24.68311650418872, 23.95844714797641, 23.23187428611688, 22.50346148151788, 21.77337384718523, 21.04190332333716, 20.30948539238352, 19.57670000786385, 18.84425261715285, 18.1129376367453, 17.38359354407476, 16.65706162306894, 15.93415752537761, 15.21565849889079, 14.50230352670079, 13.79480118981939, 13.09384055577915, 12.40010217519346, 11.7142679615429, 11.03702978447902, 10.36909706612437, 9.711203773720143, 9.064115157863232, 8.42863450855474, 7.805610135588181, 7.195942733393803, 6.600593258001205, 6.020591417012298, 5.457044844026152, 4.91114898802975, 4.384197685211267, 3.877594281172911, 3.392863015708348, 2.931660142641857, 2.495783897186992, 2.087181898324767, 1.707953838365347, 1.360346340421342, 1.046735697242103, 0.7695930342656296, 0.5314257398736916, 0.3346896535481433, 0.1816696848407571, 0.07433264865454379, 0.01415229351267665, 9.984362150070414e-12, 3.217616602872824e-10, 5.108553406688776e-09, 5.327208492933951e-08, 4.104387267316666e-07, 2.491938085877819e-06, 1.241854357288005e-05, 5.224830795404315e-05, 0.0001894538408771381, 0.0006014954844098597, 0.001693210029940067, 0.00426968323720089, 0.009728091648413425, 0.02017558820497275, 0.03833825327162705, 0.06714588601561694, 0.1089892273261177, 0.1648241240318785, 0.2334505363478792, 0.3113133952751697, 0.3930068604227246, 0.472374965373622, 0.5438390050310983, 0.6034897335174093, 0.6496062690392141, 0.6825248422190222, 0.7040339219689042, 0.7165996082278163, 0.7226971920924141, 0.7243971420629793, 0.7232144840128146, 0.7201433177153498, 0.7157777680919881, 0.7104446784969046, 0.7043101858208621, 0.6974511059107577, 0.6898968567441026, 0.6816516388785163, 0.6727051940427483, 0.6630376332049659, 0.6526214165102659, 0.6414220224456908, 0.6293980069901993, 0.6165007526674909, 0.6026740333467886, 0.5878534522505289, 0.571965788996753, 0.5549282919634844, 0.5366479666868009, 0.5170209389714458, 0.4959320165182674, 0.4732546415079804, 0.4488515271450614, 0.4225764127660461, 0.3942775607159678, 0.3638038474802325, 0.33101453416334, 0.2957939359318742, 0.2580720354130296, 0.2178512483549539, 0.1752376279413425, 0.13047171762344, 0.08395246535746046, 0.03629229534099694 },
                { 4.666904911115422, 37.1346283231665, 36.451730124176, 35.76836545535522, 35.08449969008054, 34.4000947742134, 33.71510882984356, 33.02949571715213, 32.3432045553337, 31.65617920748352, 30.96835774093332, 30.27967188511445, 29.59004652572558, 28.89939929980367, 28.20764039546861, 27.51467271824111, 26.82039266967614, 26.12469190023465, 25.42746054974792, 24.72859266676687, 24.02799466717704, 23.32559776747268, 22.62137514823383, 21.91536392886446, 21.20769062141613, 20.49859655585085, 19.78845739628513, 19.07778968814793, 18.36723913227308, 17.65755057842223, 16.94952655309148, 16.24398548058896, 15.54172978619738, 14.84352874173181, 14.1501149648074, 13.46219005591176, 12.78043451977835, 12.10551856904295, 11.43811214545672, 10.77889372377037, 10.12855807533903, 9.487823359804158, 8.857437904445437, 8.238186961630493, 7.630899666901257, 7.036456370015925, 6.455796476256471, 5.889926907707042, 5.339931265433652, 4.806979734516916, 4.292339713928948, 3.797387057937482, 3.323617664992185, 2.872658915894561, 2.446280107784902, 2.0464005070979, 1.67509290312581, 1.33457955092364, 1.027216177564281, 0.7554584704067954, 0.5218046410096044, 0.3287081648266109, 0.1784579009249439, 0.07302904506504786, 0.0139052617120976, 6.200429807729382e-12, 2.039532370358651e-10, 3.305046728547322e-09, 3.517618039654163e-08, 2.76598284767401e-07, 1.71383734507923e-06, 8.715826778008456e-06, 3.741832513088587e-05, 0.000138436698712906, 0.0004484031067097225, 0.001287589032074419, 0.003311466906135586, 0.00769346243987212, 0.0162659566891321, 0.0314998260347363, 0.0562014807652343, 0.09288670346371529, 0.1429457720955528, 0.2058754167981419, 0.2789164178462896, 0.3573307892057843, 0.4353042447982225, 0.5071890253807928, 0.5686558681436279, 0.6173797768578833, 0.6531028560480879, 0.6771735884634545, 0.6918279382565353, 0.6994963415164154, 0.7023220591959844, 0.7019397059682826, 0.6994599710144723, 0.6955671172718253, 0.6906478189672986, 0.684903634014872, 0.6784306009202198, 0.6712679927815701, 0.6634250075174261, 0.6548940859706463, 0.6456570375250152, 0.6356876229019772, 0.6249524858742122, 0.6134113218345477, 0.6010166705620909, 0.5877134959000227, 0.5734386237349866, 0.5581200782706306, 0.5416763528362623, 0.5240156637869418, 0.5050352626310829, 0.4846209255454223, 0.462646807302149, 0.4389759471923382, 0.4134618578235269, 0.3859518213135588, 0.3562927576524439, 0.3243407827904242, 0.2899757405216734, 0.2531218590444362, 0.2137748813766047, 0.1720340847216275, 0.1281344008187928, 0.08247173538677218, 0.0356580943611305 },
                { 4.808495029024803, 36.09906911216779, 35.43652911313394, 34.77355085889998, 34.11010201634263, 33.44614706854365, 32.7816469470002, 32.11655862417083, 31.4508346665739, 30.78442275193659, 30.1172651593763, 29.44929825047699, 28.78045197317888, 28.11064944221923, 27.43980668310695, 26.76783267622546, 26.09462990979287, 25.42009575160017, 24.74412508402581, 24.06661481085932, 23.38747101385257, 22.7066196476423, 22.02402158491465, 21.33969235213717, 20.65372578492048, 19.96631896175705, 19.27779346952353, 18.58860639194213, 17.89934505066626, 17.21070357142391, 16.52344574375141, 15.83836395981036, 15.15624483037282, 14.47784803929427, 13.80389910919041, 13.13509250878413, 12.47210031618963, 11.81558264238503, 11.16619770523992, 10.5246108160222, 9.891502309106179, 9.267574738671161, 8.653559704158069, 8.050224610928661, 7.458379604706581, 6.87888486477421, 6.312658403151295, 5.760684488258827, 5.224022783238822, 4.703818251908043, 4.201311828365357, 3.717851755124569, 3.254905349117774, 2.814070726607706, 2.397087668234961, 2.005846284841057, 1.642391398982223, 1.308919545501553, 1.007764235830797, 0.7413637937598691, 0.5122051208595112, 0.3227371097690402, 0.1752504356401927, 0.07172682149004467, 0.01365845137169968, 3.879147098170935e-12, 1.301595315652213e-10, 2.151508992976777e-09, 2.335722989543462e-08, 1.873325611833005e-07, 1.183872855584609e-06, 6.140333813913033e-06, 2.68835528582808e-05, 0.0001014231260445384, 0.0003349610411483741, 0.0009805944045175169, 0.002570710408080168, 0.006086867522499054, 0.01311264423687667, 0.02586620786754022, 0.04699282844427323, 0.07905051263333039, 0.1237519935546901, 0.1811850291097137, 0.2493277495182564, 0.3241250778465633, 0.4001899320266139, 0.4719295851282498, 0.5347125490423467, 0.585684815819769, 0.6240133419431874, 0.6505797997615176, 0.6673409150815758, 0.6766339462343384, 0.6806410243288194, 0.6810995895703222, 0.6792331046333419, 0.6758189501674519, 0.6713085805727067, 0.6659433333922629, 0.6598414522590447, 0.6530538023557696, 0.6455954738540112, 0.6374620231599314, 0.6286371353514535, 0.619095941565621, 0.6088062774050905, 0.5977289896643129, 0.5858177852972933, 0.5730188318076449, 0.5592701986611353, 0.5445011856489773, 0.528631575110494, 0.511570854708919, 0.4932174824596207, 0.4734583084972858, 0.4521683349889249, 0.4292110958768478, 0.4044400826851848, 0.3777018406707387, 0.3488416099835463, 0.3177126586293538, 0.2841906521837408, 0.248194314639312, 0.2097128721400985, 0.1688388327784962, 0.1258013347904923, 0.08099286669016733, 0.03502448617165723 },
                { 4.954380876517585, 35.0903779909186, 34.44757703303755, 33.80436395640953, 33.16070853534253, 32.51657758297601, 31.87193460956707, 31.22673944327886, 30.58094781313322, 29.93451089650896, 29.28737483814904, 28.63948025510463, 27.99076175390966, 27.34114750476955, 26.69055894583571, 26.03891073306623, 25.38611111330028, 24.73206298625338, 24.07666604027675, 23.41982049629298, 22.76143315854254, 22.10142660225685, 21.43975232517783, 20.77640837661172, 20.11146112295879, 19.44506923789756, 18.77750586172639, 18.10917294853582, 17.44060158575238, 16.77243490427447, 16.1053958605997, 15.44024798101449, 14.77775950339927, 14.11867878030239, 13.46372335315082, 12.81358029497214, 12.16891333604894, 11.53037270470884, 10.89860514719687, 10.2742630564948, 9.658012560941589, 9.050540829911279, 8.452562950180622, 7.864828692070622, 7.288129419530145, 6.723305342112654, 6.171253266253681, 5.632934973160371, 5.109386322494458, 4.60172714544547, 4.111171936720869, 3.639041267954085, 3.186773704784757, 2.755937787683796, 2.348243292848693, 1.965550472838229, 1.609875228552921, 1.283387136763291, 0.9883959582921762, 0.7273208369431767, 0.5026353265300006, 0.3167815926097672, 0.1720500424611261, 0.0704270982372966, 0.01341207500943504, 2.445118240522821e-12, 8.364009669362358e-11, 1.409440014015457e-09, 1.559830538125146e-08, 1.275284647260463e-07, 8.215208800883551e-07, 4.343133496293946e-06, 1.93806643981668e-05, 7.451728151475088e-05, 0.0002507911481297554, 0.0007480937274187021, 0.001998057459006817, 0.00481906014272567, 0.01057256562274758, 0.02123393843750408, 0.03926412111145543, 0.06719864689604728, 0.1069751828627414, 0.1591699427986853, 0.2224282738242534, 0.29336998691594, 0.3670952763828416, 0.4381727829824874, 0.5017823783565666, 0.5546246159742109, 0.5953253543950938, 0.6242870182934003, 0.6431468967052136, 0.6541032601522869, 0.659341281016661, 0.6606809311126011, 0.6594515047660218, 0.6565245472673006, 0.6524204022687392, 0.6474243680714235, 0.6416799742515233, 0.6352515656579042, 0.6281611361207681, 0.6204078435007877, 0.6119774606750061, 0.6028465739171256, 0.5929842421242965, 0.5823524757932616, 0.5709061571218189, 0.5585926679099984, 0.5453513381750982, 0.5311127695092396, 0.5157980716386662, 0.4993180573814948, 0.4815724644128678, 0.4624493136589856, 0.4418245799532023, 0.4195624503226374, 0.3955165906598981, 0.3695330433524156, 0.341455638111262, 0.3111350887845054, 0.2784431782169449, 0.243293386137754, 0.2056685952334467, 0.1656545750395017, 0.1234745139984722, 0.07951712998457196, 0.03439201624939271 },
                { 5.104692782552638, 34.10799322894735, 33.48433205564737, 32.86028300079439, 32.23581777772273, 31.61090534224112, 30.9855115748201, 30.3595989273767, 29.73312603389751, 29.10604728639588, 28.4783123815374, 27.8498658495579, 27.22064658714386, 26.59058743165788, 25.95961483822559, 25.32764875756509, 24.69460286602289, 24.06038537594615, 23.42490075971825, 22.78805285610194, 22.14974998328931, 21.50991282473393, 20.86848590169986, 20.22545325458795, 19.58085831316058, 18.93482664306047, 18.28758832640045, 17.63949471127125, 16.99102339126758, 16.34276702136624, 15.69540632871527, 15.04967355580077, 14.40631612320495, 13.76606923154405, 13.12964141809343, 12.49771198235243, 11.8709363195997, 11.24995496882887, 10.63540345531351, 10.027921508724, 9.428161296577406, 8.836794840153116, 8.254520946023468, 7.682071980247617, 7.120220753944438, 6.569787731304308, 6.031648727867373, 5.506743235215676, 4.996083480061475, 4.500764291547763, 4.021973799263479, 3.561004901509731, 3.119267308429994, 2.698299748786106, 2.299781592017957, 1.925542625538195, 1.577568978595275, 1.258002143503593, 0.9691267091709765, 0.7133409325617073, 0.4931030797989306, 0.3108465237544178, 0.1688593745265364, 0.06913095599470942, 0.01316633775481993, 1.552893516309732e-12, 5.412313725269243e-11, 9.29249285393135e-10, 1.047776901646392e-08, 8.727511156359722e-08, 5.727655848303124e-07, 3.084722082466091e-06, 1.402203915754311e-05, 5.491599038892159e-05, 0.000188241886878363, 0.0005718432095126648, 0.001555214045043302, 0.003818891590228001, 0.008528325190689717, 0.0174308272019028, 0.03279127753692857, 0.05707398311943683, 0.09235877479009165, 0.1396142341749212, 0.198076419270599, 0.2650138430252433, 0.3360509111464164, 0.4060050492239381, 0.4699731368926451, 0.5242980662410691, 0.5671107953938774, 0.5983356533807632, 0.6192601092281231, 0.6319017331184517, 0.6384123472349202, 0.640671338365562, 0.6401039118956666, 0.6376747483841541, 0.6339761470083386, 0.6293412204248241, 0.623941883873405, 0.617857969696488, 0.6111194969569523, 0.6037297821382579, 0.595676935855891, 0.5869391012812706, 0.5774865982205689, 0.5672826141502019, 0.5562832131300317, 0.5444369991461884, 0.5316845760810988, 0.5179578690427713, 0.5031793481404383, 0.4872611988550613, 0.4701045043129385, 0.4515985446633759, 0.4316203833093222, 0.4100350086903677, 0.386696446141563, 0.3614504593222465, 0.3341397288027687, 0.304612703364465, 0.2727375792655373, 0.2384228596945034, 0.2016452729584021, 0.1624839028384186, 0.1211558566215971, 0.07804575010909861, 0.03376121103049127 },
                { 5.419135976424149, 32.21990688353932, 31.63280346419774, 31.04535557042618, 30.45753834980606, 29.86932455002577, 29.28068424311848, 28.69158451822475, 28.10198914157019, 27.5118581839047, 26.9211476183572, 26.32980889616131, 25.73778851496577, 25.14502760588614, 24.55146158315955, 23.95701992716402, 23.36162621162518, 22.76519854402561, 22.16765066993675, 21.56889410109633, 20.96884176144038, 20.36741378787192, 19.76454622608645, 19.16020332898355, 18.55439383503735, 17.94719077519587, 17.33875290123154, 16.72934393021395, 16.11934422770515, 15.50924962236322, 14.89965485010229, 14.29122422508139, 13.68465701731236, 13.08065663837933, 12.47991014092783, 11.88307971498683, 11.29080383475296, 10.7037041018162, 10.12239431598652, 9.54748966414114, 8.979615170427011, 8.419413322425891, 7.867551121571012, 7.32472688136284, 6.79167706524855, 6.26918340076112, 5.758080459044968, 5.259263853696834, 4.773699183952199, 4.302431815319031, 3.846597544507287, 3.407434120381541, 2.986293468387666, 2.584654263257817, 2.20413417219755, 1.846500591771314, 1.513677956909582, 1.207748641526236, 0.9309430717674239, 0.6856130474143073, 0.4741808389486057, 0.2990563685566137, 0.1625173052492371, 0.06655353073582276, 0.01267756250955801, 6.408297897083538e-13, 2.314844669544028e-11, 4.119000491077717e-10, 4.813138722071482e-09, 4.154557758759706e-08, 2.825242511582201e-07, 1.576530821922789e-06, 7.424385989709281e-06, 3.012013153148222e-05, 0.0001069342707849815, 0.0003363872826979676, 0.0009471440733717196, 0.002407162552525962, 0.005561925239987784, 0.01175679981461391, 0.0228619073147406, 0.04110502989346947, 0.06865798470786487, 0.1070215010627409, 0.15637850288827, 0.2151665346943726, 0.2800916254893549, 0.3466560614874541, 0.4100635216853721, 0.4662034825604689, 0.512388942861686, 0.5476387634855105, 0.5724901363001976, 0.5884964226357149, 0.5976376434816662, 0.6018354904054639, 0.6026668291280886, 0.601271040784148, 0.598388581319593, 0.5944577245945974, 0.5897160918011195, 0.5842807952727016, 0.5782016479849902, 0.5714922352197589, 0.5641462541230058, 0.556145344596159, 0.5474624917544696, 0.5380632842040939, 0.5279061658559763, 0.5169421992935001, 0.5051145628482555, 0.4923578772581757, 0.4785974123830625, 0.4637482177673051, 0.4477142369156044, 0.4303875015176213, 0.4116475634390302, 0.3913614190159494, 0.3693843257802361, 0.3455621212422246, 0.3197359357176562, 0.2917505308197877, 0.2614678130793648, 0.2287871577437346, 0.1936736048828611, 0.1561931066198869, 0.1165503098972839, 0.07512072145662402, 0.03250660106575636 },
                { 5.752948508742444, 30.43037142024296, 29.87764977679703, 29.32462121491234, 28.77126381147049, 28.21755354512908, 27.66346405605937, 27.10896637774827, 26.5540286392701, 25.99861573750777, 25.44268898072664, 24.88620570815465, 24.32911889552119, 23.7713767649311, 23.212922430576, 22.65369363187648, 22.09362263583554, 21.53263643476062, 20.97065742891734, 20.40760487068461, 19.84339745900501, 19.2779576032156, 18.71121799708354, 18.14313119466975, 17.57368274382898, 17.00290794034015, 16.43091124351359, 15.85788582392303, 15.28412898407318, 14.71004826923917, 14.13615420920235, 13.56303931395876, 12.99134790288038, 12.42174478801856, 11.85489056118918, 11.29142762684384, 10.73197671359501, 10.17714079072492, 9.627512776555592, 9.083684352369446, 8.546254479188912, 8.015837192125856, 7.493068770182982, 6.978614567196751, 6.47317580569521, 5.977496592505272, 5.492371366391226, 5.01865294948948, 4.557261343974093, 4.10919338489807, 3.675533318286431, 3.257464305796446, 2.856280743443441, 2.473401092782575, 2.110380616231137, 1.768922925013292, 1.450888513104783, 1.158297383037427, 0.8933214227795716, 0.6582604487753259, 0.4554941825970585, 0.2874018528824543, 0.1562433315332867, 0.06400235010623831, 0.01219360945901578, 2.726740650982571e-13, 1.018718121274945e-11, 1.874734890275797e-10, 2.265551435306588e-09, 2.0223010805159e-08, 1.422085186544368e-07, 8.205199005709214e-07, 3.995077295606825e-06, 1.675531321382024e-05, 6.148747877116327e-05, 0.0001999006305294484, 0.0005815820692560865, 0.001526924243883661, 0.003643575222293276, 0.007951089594019781, 0.01595486954924875, 0.02958575003508529, 0.0509323334239478, 0.08175764593082261, 0.1228984036391141, 0.1737455950143522, 0.2320341780431931, 0.2940880934827944, 0.3554959966327456, 0.4120132068949404, 0.4603903817943016, 0.4988689180776424, 0.5272318128049128, 0.5464752142513757, 0.5582845804303516, 0.5645185034173944, 0.5668390147496861, 0.5665315084723333, 0.5644811185732799, 0.561239385846308, 0.5571200401016442, 0.552285867635758, 0.5468119068707503, 0.5407250336172415, 0.5340260191062731, 0.5267006537984982, 0.5187248414532108, 0.5100666537270701, 0.5006869338936458, 0.4905392094536644, 0.479569249563633, 0.4677144106576895, 0.4549028373437878, 0.4410525650909386, 0.4260705805011424, 0.4098519270409208, 0.3922790021605815, 0.373221285439445, 0.3525358814242022, 0.3300694726417859, 0.3056625715187221, 0.279157326779131, 0.2504105114590459, 0.2193134927991689, 0.1858205206910458, 0.1499848555306905, 0.1119984377688739, 0.07222660817569012, 0.03126446283164508 },
                { 6.107323508438847, 28.73501660886824, 28.21463566142853, 27.69398041569724, 27.1730314591299, 26.6517675367489, 26.13016534096235, 25.60819927659577, 25.08584119942113, 24.56306012720833, 24.03982192369709, 23.51608895825353, 22.99181974788149, 22.46696859452372, 21.94148524042021, 21.41531457944373, 20.88839648527442, 20.36066585133163, 19.8320529867129, 19.30248458149109, 18.77188554685419, 18.24018214906291, 17.70730697708568, 17.17320637339701, 16.63785093602587, 16.10124943490663, 15.56346580902181, 15.02463770899246, 14.48499345613482, 13.94486291300386, 13.40467768350624, 12.86495824425371, 12.32628981462141, 11.7892930211053, 11.25459710742844, 10.72282155768445, 10.19456800217588, 9.670420708548491, 9.150952366399732, 8.636732128614044, 8.128333986086576, 7.626344650086781, 7.131370824061431, 6.644046070598953, 6.165037565487293, 5.695053013127049, 5.234847953213381, 4.785233648007799, 4.347085707435726, 3.921353579471158, 3.509070995065852, 3.111367395885437, 2.729480269383647, 2.364768140228112, 2.018723677161788, 1.692985909374365, 1.389349826027662, 1.10977056536834, 0.8563579189260884, 0.6313550318342533, 0.4370933308031019, 0.2759148234498104, 0.1500547970821729, 0.06148451795671322, 0.01171583120314742, 1.196355922466967e-13, 4.613687780192308e-12, 8.763914134227006e-11, 1.093150695003857e-09, 1.007117871188021e-08, 7.309119915327983e-08, 4.352165990514346e-07, 2.1866763367984e-06, 9.462676536231929e-06, 3.582620875293095e-05, 0.0001201492810220649, 0.0003605272548153077, 0.0009760588186915589, 0.002401094607333322, 0.005400057756047456, 0.01116328680705438, 0.02131609429742363, 0.03776568032600504, 0.06234558624050591, 0.09629899093081327, 0.1397420982122431, 0.1913124382849837, 0.2481830295463794, 0.3065023893792422, 0.3621509078718362, 0.4115706152042591, 0.4523981417713962, 0.4837219677329714, 0.505943001716419, 0.5203605515833951, 0.5286717215275387, 0.5325490008788278, 0.5333820735721532, 0.532186243150849, 0.5296277164831218, 0.5261037652933656, 0.5218304888748143, 0.5169137559954333, 0.5113971330277584, 0.5052902563186319, 0.4985839002915407, 0.4912572267822971, 0.4832809039380521, 0.4746181972939214, 0.4652250946740513, 0.4550499531273051, 0.4440328790317914, 0.4321049345009585, 0.4191872234876112, 0.4051899111696602, 0.3900112570229561, 0.3735367959445711, 0.3556388918204757, 0.3361770292527351, 0.3149994212931158, 0.2919468119527076, 0.2668597417350963, 0.239590964560715, 0.210024962155196, 0.1781061531495902, 0.1438756682134147, 0.1075126623269355, 0.06937143088160249, 0.03003826506058659 },
                { 6.48352759981215, 27.12955957151901, 26.63960385633831, 26.14940228170123, 25.65893759660687, 25.16819092560037, 24.67714158418195, 24.18576687220733, 23.69404184354383, 23.20193905075409, 22.70942826456166, 22.21647616958767, 21.72304604075263, 21.22909740944165, 20.73458573597055, 20.2394621164293, 19.74367306956971, 19.2471604757326, 18.74986177836924, 18.2517106135974, 17.75263810824871, 17.25257518320566, 16.75145631010001, 16.24922527260784, 15.74584352523544, 15.241301624388, 14.73563378475436, 14.2289347438233, 13.72137678328465, 13.21322328376322, 12.70483438852308, 12.19666126889747, 11.68922857068853, 11.18310883186567, 10.67889566349582, 10.17718237889488, 9.678549771419705, 9.183562976129479, 8.69277487582904, 8.206732964823897, 7.725987329798156, 7.251098502394111, 6.782644794050629, 6.321229193515085, 5.867486083768408, 5.422088057384093, 4.98575307650298, 4.55925218340469, 4.143417934033747, 3.739153697225783, 3.347443927129903, 2.969365461428675, 2.606099803794235, 2.258946186893113, 1.92933493957232, 1.618840236826462, 1.329190609511256, 1.062274531736726, 0.8201369016986452, 0.6049603053616399, 0.4190229211476871, 0.2646237342769127, 0.1439672612305853, 0.05900642557076234, 0.01124544662137934, 5.411654383251249e-14, 2.150266028159029e-12, 4.208277563152649e-11, 5.407968196422724e-10, 5.132925417561003e-09, 3.837599240012865e-08, 2.353884154814416e-07, 1.218202543331384e-06, 5.429609435983538e-06, 2.117054058906845e-05, 7.310998581791671e-05, 0.0002258681372867129, 0.000629473662390745, 0.001593683834857176, 0.003687809723547868, 0.00784150747280837, 0.01539503776053256, 0.02803011110945684, 0.04752558893793455, 0.07533864982142631, 0.1120998485112227, 0.1571894577103531, 0.2085810999898533, 0.2630675571728027, 0.3168421938125681, 0.3662629642840586, 0.4085499190828674, 0.4422009207895746, 0.4670333072578624, 0.4839054380735458, 0.4942714215849975, 0.4997397716509631, 0.5017544156060791, 0.5014366170882698, 0.4995614261908814, 0.4966131086513761, 0.4928671392777573, 0.4884655214821782, 0.4834720811775424, 0.4779073470539408, 0.4717680806572414, 0.4650371337632478, 0.4576879237087424, 0.449686170566036, 0.4409903116003003, 0.4315512736328641, 0.4213119056038997, 0.4102062021780652, 0.3981583839967574, 0.3850818883699806, 0.3708783445319668, 0.3554366568377698, 0.3386324050446808, 0.3203279084635775, 0.3003735114500549, 0.2786109533057791, 0.2548800932503521, 0.2290307241402002, 0.200941546398499, 0.1705481420108699, 0.1378801711461627, 0.1031040734383208, 0.06656239133892182, 0.02883113238130801 },
                { 6.88290542975857, 25.60982000245518, 25.14849118882006, 24.68694139802085, 24.2251552482142, 23.76311591975564, 23.30080499246616, 22.83820226333136, 22.37528554293788, 21.91203042929479, 21.44841005839173, 20.98439483212462, 20.5199521263978, 20.0550459857763, 19.58963681674373, 19.12368110049242, 18.65713115978017, 18.18993503490182, 17.72203655414243, 17.25337572778936, 16.78388965567925, 16.31351421890926, 15.84218692476822, 15.3698513771173, 14.89646391754616, 14.42200295512789, 13.94648125923235, 13.46996088801438, 12.99256937481697, 12.51451442508125, 12.03609322572721, 11.55769246477427, 11.0797770960025, 10.60286951111659, 10.12752438297739, 9.654305827328211, 9.183771870896241, 8.716467788645384, 8.25292684076413, 7.793675593815908, 7.339241236088318, 6.890159251253467, 6.446980754713708, 6.010279404909947, 5.580658082224964, 5.158755604963399, 4.745253739376342, 4.340884724599506, 3.94643949909229, 3.562776785424612, 3.190833157318059, 2.831634163357975, 2.486306496577404, 2.156091049981515, 1.842356442776125, 1.546612178233132, 1.270519914587959, 1.015900286328148, 0.7847312018280099, 0.5791315531381262, 0.4013220824095323, 0.2535536735300015, 0.1379945054901034, 0.05657375213123885, 0.01078354073428826, 2.523036436214122e-14, 1.031107442876768e-12, 2.075503825523379e-11, 2.743139039802295e-10, 2.677674556485651e-09, 2.058795667570147e-08, 1.298606488232456e-07, 6.910740717294881e-07, 3.167049423931461e-06, 1.269584312892631e-05, 4.507171799007957e-05, 0.0001431281943699329, 0.0004099434618845991, 0.001066458075819236, 0.002535167623110435, 0.005536224635185911, 0.01115894426948862, 0.02085037854843996, 0.0362610478281258, 0.05892236109531115, 0.08980078811701087, 0.1288545370496653, 0.1747642578044877, 0.2249811353616664, 0.2761300998414977, 0.3246656327449807, 0.3675721016842687, 0.4028847222506574, 0.4298879425704117, 0.4489806825272254, 0.4613153020869316, 0.4683694388078151, 0.4715882156357626, 0.4721674526170151, 0.4709784217857715, 0.4685913273564444, 0.4653448321856602, 0.4614215940365125, 0.4569091775729966, 0.4518411598987002, 0.4462214304075254, 0.4400370514962571, 0.4332643856659831, 0.4258716539017608, 0.417819729865872, 0.4090620806409808, 0.3995442726029131, 0.3892032245391994, 0.3779662923327095, 0.3657502422287766, 0.3524601820230868, 0.3379885633699196, 0.3222144493894844, 0.3050033749018075, 0.2862083343247695, 0.2656727398259253, 0.243236613655182, 0.2187477785818626, 0.1920802225242214, 0.1631616988319704, 0.1320111299172719, 0.09878244015118578, 0.06380587467884987, 0.02764584509884158 },
                { 7.306884473873853, 24.17173214373839, 23.73734125420251, 23.30275123279028, 22.86794832070848, 22.43291748192998, 21.99764225920569, 21.56210461264903, 21.12628473927299, 20.6901608720855, 20.25370905785332, 19.81690291359151, 19.37971336348067, 18.94210836063866, 18.50405260255255, 18.06550725585883, 17.62642971678066, 17.18677344964239, 16.74648796988013, 16.30551907292793, 15.86380945981222, 15.42129997734026, 14.97793177591216, 14.5336497845051, 14.08840798816868, 13.64217701896459, 13.19495444801771, 12.74677776839723, 12.29773926715732, 11.84800080752742, 11.39780529480461, 10.94748100890838, 10.49743593605138, 10.04814202029999, 9.600112872179012, 9.153880885895789, 8.709979410232727, 8.268932938474275, 7.831255078834467, 7.397452048668893, 6.968029059609898, 6.543497642999179, 6.124382905717106, 5.711230426050145, 5.304612888503363, 4.905136700390587, 4.513448850339653, 4.130244241636969, 3.756273699985952, 3.39235282543462, 3.039371827070026, 2.698306434304221, 2.370229901621506, 2.056325986966734, 1.757902545863126, 1.476404981455648, 1.213428135776653, 0.9707241842620863, 0.7502025857487714, 0.5539161035622552, 0.3840245843981079, 0.2427264386367893, 0.1321485662324257, 0.05419147581824912, 0.01033106657931068, 1.211865859483647e-14, 5.085591471941283e-13, 1.051133474217626e-11, 1.426485484523098e-10, 1.42971271020698e-09, 1.128650076853185e-08, 7.309021265611825e-08, 3.993177185513616e-07, 1.878595761781406e-06, 7.730209042909678e-06, 2.816728378630158e-05, 9.179710828731051e-05, 0.0002697941167835223, 0.0007200893958931045, 0.001755891298312187, 0.003932315572839894, 0.008125939611283233, 0.015560498972766, 0.02772149335746576, 0.04611973150550465, 0.0719162498397516, 0.1054949688263717, 0.146129365076018, 0.1918943993634139, 0.2399057303560395, 0.2868464717455004, 0.3296239319095975, 0.3659452168701535, 0.3946387804263933, 0.4156570530119949, 0.4298165511626397, 0.4384097910677168, 0.4428320225217339, 0.4443181518685026, 0.4438174557592272, 0.4419805227529646, 0.4392103384531947, 0.4357335272888582, 0.4316645089165083, 0.4270520579815041, 0.4219084171353461, 0.416225454320581, 0.4099827156886155, 0.4031509864744071, 0.3956935649007969, 0.3875664207787742, 0.3787177985795387, 0.3690875132075267, 0.3586060490723084, 0.3471935263151672, 0.3347586005427537, 0.3211974001065069, 0.3063926806719297, 0.2902135048062353, 0.2725159577517651, 0.2531457176220178, 0.2319437292287433, 0.2087567617503908, 0.1834551104070301, 0.155959702087657, 0.1262795057154814, 0.09455624100139853, 0.06110746368877103, 0.0264848441461547 },
                { 7.756980138605731, 22.81135394296473, 22.40231419665912, 21.99309456058008, 21.58368269087807, 21.17406510520809, 20.76422705488256, 20.35415238147198, 19.94382335632605, 19.53322050163178, 19.1223223919838, 18.71110543614595, 18.29954363993357, 17.88760835324475, 17.4752680076729, 17.06248785651956, 16.64922973738656, 16.23545189028406, 15.82110888332003, 15.4061517261487, 14.99052829161081, 14.57418422159759, 14.15706456591116, 13.73911648995445, 13.32029347492006, 12.90056148870311, 12.47990756059702, 12.05835094337094, 11.63595647079026, 11.21284875707588, 10.78922469078677, 10.36536076808996, 9.941612008242186, 9.518401104069391, 9.096199697083573, 8.675506625440952, 8.256828856764675, 7.840669107316234, 7.427521139269656, 7.017871251731687, 6.612203503699859, 6.211006515925016, 5.81478054854118, 5.424044340085654, 5.039341685952214, 4.661247953846425, 4.290376790074976, 3.927387257682882, 3.572991617299386, 3.227963932087994, 2.893149648460248, 2.569476263513359, 2.257965120739983, 1.95974425064885, 1.676061951665581, 1.408300427048063, 1.15798816514624, 0.9268087526021821, 0.7166023114892634, 0.5293536845646453, 0.3671590489738984, 0.2321606507484728, 0.1264397889106859, 0.05186389372985888, 0.009888848764192258, 5.99361571599849e-15, 2.578768148374964e-13, 5.46457493105144e-12, 7.602967794697613e-11, 7.812130712847928e-10, 6.32223041544427e-09, 4.197040007337854e-08, 2.350469588197315e-07, 1.133435666051714e-06, 4.780273543550311e-06, 1.785126931779658e-05, 5.961743431947959e-05, 0.000179533593604709, 0.0004909155263149408, 0.001226168257014765, 0.002812170538232045, 0.005949718550211442, 0.01166110616214855, 0.02125491591390638, 0.03616190738118303, 0.05763179610572193, 0.08634351758895133, 0.1220458679265027, 0.163373326769385, 0.2079452611182821, 0.2527595654387401, 0.2947750890820182, 0.3314987573645721, 0.3613937582253801, 0.3840031404539952, 0.3997968130186063, 0.4098433025914806, 0.4154428688156529, 0.4178331570003879, 0.4180193406564654, 0.4167228316709554, 0.4144092577252207, 0.4113510095160949, 0.4076918637926879, 0.4034977873002667, 0.3987906176619451, 0.3935676726765863, 0.3878119571526167, 0.3814969014419588, 0.3745882200783587, 0.3670443428920641, 0.3588161420311984, 0.34984628445861, 0.3400683551502613, 0.3294058258399689, 0.3177709347744926, 0.3050635735601653, 0.2911703471448799, 0.2759640952484261, 0.2593043616426088, 0.2410396021367879, 0.2210123589301942, 0.1990691851287378, 0.1750776438013013, 0.1489528156066626, 0.1206945318802243, 0.0904327097036663, 0.05847196307289454, 0.0253502403401332 },
                { 8.234801177693094, 21.52487378107829, 21.13969399223689, 20.75435131623278, 20.36883464740996, 19.98313186200126, 19.59722970423508, 19.21111365853323, 18.82476780637341, 18.43817466647526, 18.05131501722148, 17.66416770074973, 17.27670940910665, 16.88891445448409, 16.50075452822536, 16.11219845754041, 15.72321197550525, 15.33375753010227, 14.94379417341674, 14.55327759484257, 14.16216039504229, 13.77039274351296, 13.37792362434574, 12.9847029516581, 12.59068492035302, 12.19583302629439, 11.80012719378784, 11.40357330358433, 11.00621500938087, 10.60814697340687, 10.20952758721855, 9.810588211269512, 9.411635648826334, 9.013045692853377, 8.615248232273427, 8.218707490360575, 7.823902704663494, 7.431313864077133, 7.041414589817809, 6.654671566149522, 6.271548422447325, 5.892511844907673, 5.518038369475359, 5.14862111223911, 4.78477627277648, 4.427049544228158, 4.076022666834923, 3.732320369005736, 3.396617915840479, 3.069649456740867, 2.752217335266152, 2.44520248719629, 2.149575990178208, 1.866411714466801, 1.596899819254569, 1.342360481676688, 1.104256644919976, 0.884203603491476, 0.6839717646444366, 0.5054768429390423, 0.3507492084141796, 0.2218719002205703, 0.1208768994895359, 0.04959464891475409, 0.009457588379227052, 3.050369836141677e-15, 1.343635806194794e-13, 2.914898015275428e-12, 4.151819200808812e-11, 4.367188811634245e-10, 3.617985448604691e-09, 2.458600940719348e-08, 1.409384540484582e-07, 6.956321787255846e-07, 3.002736480678206e-06, 1.147582440037593e-05, 3.921938755139841e-05, 0.0001208483705836049, 0.0003380764404151369, 0.0008637844055250212, 0.00202611505070662, 0.004383173379227398, 0.00878178656134994, 0.01635716203495291, 0.02842673949397322, 0.04625369333311413, 0.07070575190445193, 0.1018970983440491, 0.1389429992215814, 0.1799468054797674, 0.2222679920709627, 0.2630134629269914, 0.2996027577416027, 0.3302279511916198, 0.354075988130368, 0.3712792461023229, 0.3826593111745588, 0.389384930579178, 0.3926620703562343, 0.3935277036164441, 0.3927613468760464, 0.3908869178184125, 0.3882227044273134, 0.3849435301713652, 0.381134252426075, 0.3768274855583676, 0.3720266580369994, 0.3667185339192695, 0.3608792851734359, 0.3544770392137446, 0.3474726402492448, 0.3398195293197261, 0.3314631684742256, 0.3223401976873743, 0.31237741492225, 0.3014906462730334, 0.2895835956769639, 0.2765468274395081, 0.2622571509205828, 0.2465778685880505, 0.2293606486492299, 0.2104502226633589, 0.1896936841699083, 0.1669567580848551, 0.1421496240433021, 0.1152638057710767, 0.08641789294447417, 0.05590343170284002, 0.02424382711985272 },
                { 8.74205544225157, 20.30861511978346, 19.94589359371768, 19.58302424968842, 19.21999706947796, 18.85680112163799, 18.49342445970626, 18.12985400795602, 17.76607543335438, 17.40207300244919, 17.0378294220794, 16.67332566319398, 16.30854076779858, 15.94345164032151, 15.57803282679727, 15.21225628864783, 14.84609118315169, 14.4795036708805, 14.11245678280237, 13.74491039825763, 13.37682141201135, 13.00814420689464, 12.63883160079402, 12.26883650382548, 11.89811459927928, 11.52662843509464, 11.15435334572825, 10.78128555163617, 10.40745250787711, 10.03292499316092, 9.657829524152701, 9.282358645659395, 8.906776012763036, 8.531413667763419, 8.156660908906946, 7.782947058605465, 7.410722721204376, 7.040444354678039, 6.672565112089797, 6.307532269544185, 5.94578965471005, 5.58778292382056, 5.233965962364126, 4.884807447703596, 4.540797252557378, 4.202452742530509, 3.870325175948772, 3.545006447209964, 3.227136399887022, 2.917410909876303, 2.616590911716435, 2.325512507046323, 2.04509823771571, 1.776369502468142, 1.520459906647397, 1.278628998885508, 1.052275276545775, 0.8429464056492457, 0.6523431486034683, 0.4823114094499125, 0.3348141986214123, 0.2118729155118902, 0.1154670891032351, 0.04738676293578406, 0.009037868972743311, 1.596389376316366e-15, 7.189184783252903e-14, 1.594505279133322e-12, 2.321865362012326e-11, 2.496815938993837e-10, 2.11458661650618e-09, 1.468949261002501e-08, 8.607791629601493e-08, 4.342758709498158e-07, 1.916035824633739e-06, 7.484154289286445e-06, 2.613958414595964e-05, 8.230716245114235e-05, 0.0002352678028065837, 0.000614109083048541, 0.00147138515820409, 0.003250778785388939, 0.006649880325559699, 0.01264281135809182, 0.02241875636161025, 0.03720390522411563, 0.05797228453646003, 0.0851069390536402, 0.1181216136986422, 0.1555631222624987, 0.1951682514968249, 0.2342581965935044, 0.2702583665977891, 0.301179538946595, 0.325914544042892, 0.3442825532406119, 0.3568500400884424, 0.3646276037029509, 0.3687591908964549, 0.3702893114854576, 0.3700407590857897, 0.36858909260755, 0.3662969587899407, 0.3633709796263926, 0.3599161863773351, 0.3559770164238417, 0.3515636487159507, 0.3466669178238135, 0.341265845230097, 0.3353309726530802, 0.3288255117081949, 0.3217054074459673, 0.3139188498653683, 0.3054054740133846, 0.2960953594693174, 0.2859079001793202, 0.274750629038118, 0.2625181386930651, 0.2490913496177001, 0.2343375614299079, 0.2181120174362271, 0.2002621508870031, 0.1806362712429518, 0.1590990880415682, 0.1355567798453882, 0.1099933916983119, 0.08251671728348929, 0.05340522103330243, 0.0231670960058622 },
                { 9.280555985057755, 19.15903938066461, 18.81745825768038, 18.47574271107884, 18.13388368097307, 17.79187128597191, 17.44969473194576, 17.10734220959224, 16.76480077957771, 16.42205624404498, 16.07909300339607, 15.73589389754846, 15.39244003142964, 15.04871058547485, 14.70468261356847, 14.36033083358023, 14.01562741992931, 13.6705418142457, 13.32504058031336, 12.9790873446379, 12.63264288625606, 12.28566547133012, 11.93811157226822, 11.58993716922225, 11.24109990207285, 10.89156241359206, 10.54129727391123, 10.19029385204661, 9.838567320487594, 9.486169544686051, 9.133200861416506, 8.779820785291271, 8.426254883152364, 8.072795068675166, 7.719791940871176, 7.367640338392532, 7.01676181195379, 6.667588707147407, 6.320553413635175, 5.976083945756702, 5.634604875342623, 5.296541661575964, 4.962326558538091, 4.632404947273937, 4.307241609782667, 3.98732690388638, 3.673183007595371, 3.365370464849175, 3.064495261955791, 2.771216641907916, 2.486255838154699, 2.210405877934111, 1.944542554300854, 1.689636571873882, 1.446766696612784, 1.217133425814569, 1.002072151093719, 0.8030638855857177, 0.6217402067900747, 0.4598769934395325, 0.3193688761203502, 0.2021737487119318, 0.1102161083576354, 0.04524267253334873, 0.008630163321589657, 8.584508335631928e-16, 3.947378565185997e-14, 8.939249310343082e-13, 1.329077615865101e-11, 1.459247519561737e-10, 1.261787798046009e-09, 8.94897731580352e-09, 5.353640305743418e-08, 2.757377888664293e-07, 1.241899259151404e-06, 4.951680929015396e-06, 1.765248972585856e-05, 5.672919555809963e-05, 0.0001654818497593039, 0.0004407584801400654, 0.001077423548303153, 0.002428157450453542, 0.005065713668004245, 0.009819642834803433, 0.01774809213617228, 0.03000882421630064, 0.04762068832248087, 0.07115473403404777, 0.1004444123501814, 0.1344282295104209, 0.1712132705095522, 0.2083750190591138, 0.243417252505034, 0.2742498524547202, 0.2995360254153313, 0.3188164899982375, 0.3324069939064422, 0.3411433656088305, 0.3460826583915541, 0.3482540400159472, 0.348507738959763, 0.3474625404486496, 0.3455223785954396, 0.3429254431597422, 0.3397977218134302, 0.3361963188066122, 0.3321387441664901, 0.3276202074988687, 0.3226226929427724, 0.3171191617058443, 0.3110751454593825, 0.3044490241194257, 0.2971916407028433, 0.289245553910581, 0.2805440644887287, 0.2710100930556178, 0.2605549902966689, 0.2490774103620817, 0.2364624810447387, 0.2225816817711115, 0.207294127165724, 0.1904503890645213, 0.1719005889340276, 0.151509170043766, 0.1291791569479884, 0.1048879311730279, 0.07873306249186096, 0.05098001803680636, 0.02212125408995735 },
                { 9.852227540850316, 18.07274733260397, 17.75106733714934, 17.42926485677532, 17.10733167892474, 16.7852588500536, 16.46303659362024, 16.14065421798973, 15.81810001312498, 15.49536113492998, 15.17242347618681, 14.84927152324268, 14.52588819804101, 14.20225468588137, 13.87835025063468, 13.5541520413284, 13.22963489749473, 12.90477116609155, 12.57953055110177, 12.25388002941076, 11.9277838850391, 11.60120394051504, 11.274100101606, 10.94643138179341, 10.61815763552347, 10.28924229831933, 9.959656489234379, 9.629384838188402, 9.298433290623201, 8.966838824043958, 8.634680408248698, 8.302089680778506, 7.969258950765276, 7.636443829709224, 7.303958619269325, 6.972164683071188, 6.641454570878686, 6.312236201858451, 5.984920992252628, 5.659917817814857, 5.337632476000952, 5.018470994476656, 4.702844957829521, 4.39117754667396, 4.083909649273691, 3.781505900978631, 3.484460770324929, 3.193304907660435, 2.908611985120101, 2.631006240052128, 2.361170910406074, 2.099857721570896, 1.847897538080381, 1.606212208197167, 1.375827468572908, 1.157886482727703, 0.9536630723310515, 0.764572834779886, 0.5921789581739235, 0.4381874930172636, 0.3044241492693291, 0.1927819717517949, 0.1051283681118168, 0.04316426911816469, 0.008234840757761504, 4.739469157706478e-16, 2.22253717819441e-14, 5.132882055951729e-13, 7.78257866039814e-12, 8.713784482641022e-11, 7.683500712957438e-10, 5.556863744903153e-09, 3.389811701503167e-08, 1.780232748855576e-07, 8.175270002726147e-07, 3.323389302810541e-06, 1.207871328198691e-05, 3.957086929718916e-05, 0.0001176617746891775, 0.0003194153939991037, 0.0007957128495744767, 0.001827235179951741, 0.003883510910285738, 0.007667375517422426, 0.01411070920421675, 0.02428534440805093, 0.03921100317761324, 0.05958152501870018, 0.08547893665540017, 0.1161774847944733, 0.1501322147591582, 0.1851916429203599, 0.218990630345709, 0.2494064060764751, 0.2749348676472511, 0.294879016361135, 0.30931806962645, 0.3189057293186431, 0.3245934021106182, 0.3273745849899415, 0.3281110978646509, 0.327455376585509, 0.3258482802645856, 0.3235583850359376, 0.3207328710723069, 0.3174420988565342, 0.3137113957275384, 0.309540625926654, 0.3049148471894284, 0.2998094471249394, 0.2941922300867419, 0.2880239388570543, 0.2812579887465519, 0.2738397816998534, 0.2657057663703955, 0.2567823312987304, 0.2469846102550929, 0.2362153211356316, 0.2243638554745958, 0.2113060052135907, 0.196904991783328, 0.1810148919487743, 0.1634881587323148, 0.1441896440056398, 0.1230200071754741, 0.09995075725785336, 0.07506983899073182, 0.04862989120165194, 0.02110724294098951 },
                { 10.45911340581018, 17.0464792309764, 16.74353478892789, 16.44047853150174, 16.1373029976773, 15.83400005637386, 15.53056083253242, 15.22697562409662, 14.92323380885441, 14.61932374008104, 14.31523262996992, 14.0109464199952, 13.70644963768929, 13.40172523994684, 13.09675444404778, 12.79151654937081, 12.48598875561366, 12.18014598778901, 11.87396074511415, 11.56740300127622, 11.26044019896577, 10.9530374040109, 10.6451577162205, 10.33676307730054, 10.02781567162074, 9.718280179677266, 9.408127204167084, 9.097338215379649, 8.785912302147808, 8.473874787177436, 8.161287288482318, 7.848258064560067, 7.53495063274368, 7.221588128723206, 6.908451270153635, 6.595869415798655, 6.284206596281347, 5.973846274481625, 5.665178807099417, 5.358594064945004, 5.054479507815586, 4.753222437601486, 4.45521467460752, 4.160858245436844, 3.870571298001834, 3.584793990697187, 3.303994416373797, 3.028674754465228, 2.759377875796403, 2.496694614975661, 2.241271904281433, 1.993821936265224, 1.755132480607143, 1.526078403308008, 1.30763428850728, 1.100887789585721, 0.9070528497280966, 0.7274811035933481, 0.5636684306146112, 0.4172516091831574, 0.2899873155602753, 0.1837028781946934, 0.1002070439985339, 0.04115293998628873, 0.007852174842339654, 2.684194896916522e-16, 1.282222933485787e-14, 3.016480095924588e-13, 4.658873812890716e-12, 5.313430049477541e-11, 4.77231592559083e-10, 3.515534176353146e-09, 2.184321048203762e-08, 1.168375939880088e-07, 5.464567897718622e-07, 2.262364968505334e-06, 8.373477740075824e-06, 2.79341812746873e-05, 8.457396946167671e-05, 0.0002337529461025135, 0.0005927999303306868, 0.001385597364592074, 0.002996992093279014, 0.00602057933041508, 0.01127102994343913, 0.01972655253157407, 0.03237775821766822, 0.04999037315750881, 0.07283342671728655, 0.1004616140300796, 0.1316463678413765, 0.1645117865218269, 0.1968590198466666, 0.2265878031637488, 0.2520837048558891, 0.2724549996497889, 0.2875655395609525, 0.29788750554112, 0.3042540657421908, 0.3076060185844987, 0.3088017783241529, 0.3085173020196701, 0.3072250280137094, 0.3052218827572469, 0.3026759229903136, 0.2996710668288661, 0.2962408218242393, 0.2923899442970256, 0.288106666326763, 0.2833688078546895, 0.2781463983654252, 0.27240246967926, 0.266092924548805, 0.2591659209166269, 0.2515609719318344, 0.2432078609562205, 0.2340254504452906, 0.2239204978771141, 0.2127866803170015, 0.2005041906234663, 0.1869405375889303, 0.1719536040056468, 0.155398621265102, 0.1371414514077849, 0.1170811160464138, 0.09518401030706517, 0.07152906738639467, 0.0463563383294484, 0.02012575838991335 },
                { 11.10338274080877, 16.07711392166956, 15.79180861334147, 15.50640104922065, 15.22088443685489, 14.93525137641992, 14.64949379392577, 14.36360286619249, 14.07756893664018, 13.79138142090793, 13.50502870133931, 13.21849800948624, 12.93177529604628, 12.64484508815012, 12.35769033479194, 12.07029224265098, 11.7826301068948, 11.49468114523926, 11.20642034923197, 10.91782037537481, 10.62885151162693, 10.33948177376714, 10.04967721315073, 9.759402554702688, 9.468622332780489, 9.177302751052173, 8.885414552056148, 8.592937220605071, 8.299864819500952, 8.006213597725547, 7.712031139267389, 7.417406190946406, 7.122477510538585, 6.827439440234947, 6.532541971954279, 6.238084260035126, 5.944402661453666, 5.651856429983464, 5.360814923613831, 5.071649179857869, 4.784728732219694, 4.500422812333591, 4.219104327413485, 3.941155145981004, 3.666971782583704, 3.396971120588436, 3.131596169225687, 2.871322019788148, 2.616662217382156, 2.36817576370596, 2.126474948623539, 1.892234183935128, 1.666199975005655, 1.449202095703692, 1.242165896439443, 1.046125420356281, 0.8622365438927434, 0.6917885667812066, 0.5362113796325484, 0.3970733543572082, 0.2760623982569275, 0.1749396863115107, 0.0954541823546441, 0.03920961030943049, 0.007482351207476368, 1.558081998663712e-16, 7.573612267326837e-15, 1.813001765887613e-13, 2.849253386184754e-12, 3.306515685308759e-11, 3.021775935942548e-10, 2.264917662651279e-09, 1.431840054194403e-08, 7.792279805474974e-08, 3.707885054721113e-07, 1.561720783173523e-06, 5.880242886936612e-06, 1.995484189166638e-05, 6.145274608981659e-05, 0.0001727496266367696, 0.0004455324972308232, 0.00105892735347577, 0.002328670438920437, 0.004755275090817644, 0.00904733047641691, 0.01608833342595324, 0.02682052716435275, 0.04204298891703871, 0.06216017741418257, 0.08695563371979134, 0.11548104398732, 0.1461270484913209, 0.1768816612199546, 0.2057095498585585, 0.2309357610995014, 0.2515162173352593, 0.2671249123465506, 0.2780594926677448, 0.2850280379869816, 0.2889052847699357, 0.2905327285954804, 0.2905997167887051, 0.289604272097608, 0.2878689228791392, 0.2855817648275182, 0.2828402734770182, 0.2796863554644867, 0.2761298396660363, 0.2721622152768687, 0.2677637364559187, 0.2629066095474145, 0.2575560804448061, 0.2516704517196936, 0.2452005450712608, 0.2380888468936366, 0.2302684507599696, 0.2216618771608536, 0.2121798766880245, 0.2017204038707308, 0.190168101946091, 0.177394898391139, 0.1632627233930091, 0.1476299652368593, 0.1303640265251416, 0.1113629553305703, 0.09058875286332504, 0.06811195841882371, 0.04416033505624971, 0.01917727073365388 },
                { 11.78733832452792, 15.16166709533612, 14.89296941570971, 14.62417806626619, 14.35528685101151, 14.08628902216313, 13.81717721964916, 13.5479434031483, 13.27857877579237, 13.00907369861701, 12.73941759485231, 12.4695988432267, 12.1996046596612, 11.92942096713374, 11.65903225420684, 11.38842142391011, 11.11756963661003, 10.84645615356745, 10.57505819264264, 10.30335081486926, 10.03130687151792, 9.758897057328923, 9.486090138708051, 9.212853457902057, 8.939153857030358, 8.664959218757135, 8.390240877476666, 8.114977199673, 7.839158630302203, 7.562794395835459, 7.285920768406785, 7.008610270868147, 6.73098047800697, 6.45320038431634, 6.175492129041393, 5.898126672587244, 5.621413832060879, 5.345689151499495, 5.071301206506504, 4.798602430937174, 4.527944835404581, 4.25968019690777, 3.994163310993616, 3.731756834076315, 3.472836706521079, 3.217797692527989, 2.967058964743228, 2.721069864977229, 2.480316045597451, 2.245326205375436, 2.016679619873592, 1.79501464448635, 1.581038334090384, 1.375537259632283, 1.179389477572542, 0.9935773712839889, 0.8192006514928994, 0.6574880490721779, 0.5098049829222369, 0.3776525477165871, 0.2626504768921319, 0.166493739904871, 0.09087080562251995, 0.03733478510616888, 0.007125475415434725, 9.261336963550396e-17, 4.576253062681954e-15, 1.113587035483942e-13, 1.778978112619042e-12, 2.098540861976965e-11, 1.949436395626676e-10, 1.485219365862426e-09, 9.543638557487233e-09, 5.27902179838155e-08, 2.553116645961488e-07, 1.092915963456594e-06, 4.182135421147593e-06, 1.442272587172558e-05, 4.513452873137915e-05, 0.0001289199709633651, 0.0003378144438604006, 0.0008156670303342745, 0.001821985359300894, 0.003778613994737459, 0.00729981989704383, 0.01317751940508652, 0.02229430604629044, 0.03545432685943304, 0.0531554326267995, 0.07536375756554163, 0.1013739186163847, 0.1298263637631944, 0.1589049198331999, 0.1866700316598504, 0.2114280706028242, 0.2320223368378968, 0.247964575352501, 0.259389631382417, 0.2668786706925234, 0.2712307085927868, 0.2732587122264348, 0.2736557472920071, 0.2729391047339427, 0.271453623479783, 0.2694061378802729, 0.2669073841976768, 0.2640077315774725, 0.2607221936466945, 0.257045574603351, 0.2529605575678965, 0.2484414759601818, 0.243455714065877, 0.2379638849674964, 0.2319193784371565, 0.2252675570206777, 0.2179447308726735, 0.2098769946745617, 0.2009790270559824, 0.1911530264640145, 0.1802881020609573, 0.1682606875946262, 0.1549369478389631, 0.1401787430731809, 0.1238554787195548, 0.1058648302949461, 0.08616508191747269, 0.06481899194001706, 0.04204238319925309, 0.01826204497034822 },
                { 12.51342478416305, 14.29728885241289, 14.04422825337653, 13.79108171403711, 13.53784357197565, 13.28450766241906, 13.03106726331514, 12.77751503363342, 12.52384294408484, 12.27004219941265, 12.01610315140146, 11.7620152018075, 11.50776669457109, 11.25334479699636, 10.9987353701675, 10.74392282986304, 10.48889000084765, 10.23361796999121, 9.978085947668684, 9.722271153025526, 9.466148747934133, 9.209691858148105, 8.952871739982093, 8.695658178733918, 8.438020242688558, 8.17992756408324, 7.921352372054536, 7.662272550076636, 7.402676004596513, 7.142566564162812, 6.881971411038195, 6.620949615490485, 6.359600699300702, 6.098071466702897, 5.836558996973331, 5.575308174457023, 5.314603622093298, 5.054757889570633, 4.796099138348071, 4.538961498442803, 4.283679867255611, 4.03058915293163, 3.780026796171689, 3.532337139007919, 3.287876558732568, 3.047018808797349, 2.810160425107816, 2.577726291581156, 2.350175554301727, 2.128008094125838, 1.91177175861811, 1.702070534766301, 1.49957381304544, 1.305026835750671, 1.119262308513299, 0.9432129339954128, 0.7779242206183062, 0.6245662024172237, 0.4844415033155086, 0.3589852914658846, 0.2497500072950772, 0.1583647040392642, 0.0864570156438274, 0.03552859054167847, 0.006781580710089076, 5.632174121540405e-17, 2.826324077352395e-15, 6.984597548813733e-14, 1.133152030817527e-12, 1.357468016132827e-11, 1.280587113945512e-10, 9.907650783224808e-10, 6.464946047793161e-09, 3.631319154192368e-08, 1.78331872995447e-07, 7.751351996634829e-07, 3.011642709982768e-06, 1.054499459574342e-05, 3.350245062662036e-05, 9.714638714616345e-05, 0.0002583971265111436, 0.0006332604377289519, 0.00143556345398004, 0.003021031381547178, 0.005921117734994235, 0.01084179212093634, 0.01860046366933162, 0.02998629960645807, 0.04555708446133091, 0.06542133288369291, 0.08908035973308315, 0.1154031031694917, 0.1427693433555207, 0.1693561380636326, 0.1934850438750493, 0.2139225435121429, 0.230046064774816, 0.2418425984991928, 0.2497687224469516, 0.2545415713840248, 0.2569360950740732, 0.2576402157679589, 0.2571841510030975, 0.2559313945887673, 0.2541058354126299, 0.251830898523403, 0.2491653213506961, 0.2461293389820485, 0.2427210980996962, 0.2389256955504646, 0.2347195396318509, 0.2300720768416179, 0.2249461406348452, 0.2192975910286999, 0.2130745654933414, 0.206216490277833, 0.1986529399084237, 0.1903024406720772, 0.1810713798831716, 0.1708533189119774, 0.1595292468430829, 0.146969701519296, 0.1330402719785191, 0.1176127642836446, 0.1005850200923104, 0.08191223713234212, 0.06164999381271303, 0.040002558195897, 0.01738016074661401 },
                { 13.28423733312815, 13.48126071724089, 13.24292390942191, 13.00450813531495, 12.76600821106252, 12.52741849454653, 12.28873283541842, 12.04994451896546, 11.81104620307115, 11.57202984748485, 11.33288663460184, 11.0936068809919, 10.8541799390366, 10.61459408829652, 10.37483641671135, 10.13489269256099, 9.894747229472713, 9.654382748925223, 9.413780248087624, 9.172918886037129, 8.931775909274418, 8.690326649166162, 8.448544641006859, 8.20640193859218, 7.963869731233805, 7.720919412701228, 7.477524301305373, 7.233662258193371, 6.989319475494417, 6.744495667130837, 6.499210732420442, 6.253512610567577, 6.007485481656874, 5.761256806916517, 5.515001253379042, 5.268939771951553, 5.023333277914338, 4.778472216207507, 4.534664841626336, 4.292227355347748, 4.051477968056974, 3.812735284025694, 3.576320106831748, 3.342559316114792, 3.111790689753115, 2.88436803094858, 2.660666390295441, 2.441087436422812, 2.226065146340825, 2.016072019285544, 1.811626014266668, 1.613298394800184, 1.421722636481439, 1.237604500825711, 1.061733274389551, 0.8949939681501729, 0.7383798907921432, 0.5930043291642009, 0.4601089149660361, 0.3410644236731893, 0.237357127839535, 0.150550753457777, 0.08221209359359772, 0.0337908140330717, 0.006450635560458672, 3.501135806989545e-17, 1.78268435153379e-15, 4.470021198930455e-14, 7.358131357410111e-13, 8.943650833013393e-12, 8.56040031349304e-11, 6.719673433245139e-10, 4.448632269394951e-09, 2.535130385905264e-08, 1.263070405989373e-07, 5.569614427533537e-07, 2.195250627775082e-06, 7.7972408737784e-06, 2.512826106110669e-05, 7.39055013394324e-05, 0.0001993745498850262, 0.0004955157968901279, 0.001139052832187012, 0.002430336841795569, 0.004828764956729183, 0.008961301677210281, 0.01557864421632469, 0.02544136288350175, 0.03914112800850141, 0.05689470958129514, 0.07837639393462798, 0.1026600710635122, 0.1283152766493953, 0.1536482252496431, 0.1770220170667491, 0.1971575237787649, 0.2133247903259398, 0.2253797753725982, 0.2336600303601005, 0.2387977816383238, 0.2415226415569767, 0.2425095762090743, 0.2422956111111058, 0.2412590477203955, 0.2396388513366607, 0.2375703221909931, 0.2351203202673974, 0.2323142603952178, 0.2291536250084475, 0.2256258971217382, 0.2217095044158539, 0.2173758790009071, 0.2125899843998974, 0.2073100519776748, 0.2014868902180793, 0.1950629359861765, 0.1879711411595729, 0.180133786925222, 0.1714613764874958, 0.1618518847056092, 0.1511908714342543, 0.1393533426369924, 0.1262088196971641, 0.11163184684896, 0.09552091019080579, 0.07782870397904199, 0.05860420986582024, 0.03804055505191735, 0.01653153175977091 },
                { 14.10253104699337, 12.7109922199358, 12.48651971408256, 12.26197454773153, 12.03735196730867, 11.81264680041787, 11.58785341028748, 11.36296564459775, 11.13797677800671, 10.91287944764787, 10.68766558085367, 10.46232631438046, 10.23685190450485, 10.01123162757236, 9.785453670977709, 9.559505015246431, 9.333371309031572, 9.107036740674066, 8.880483912856709, 8.653693731325263, 8.426645325395191, 8.199316028032551, 7.971681458043541, 7.74371576796672, 7.515392150306092, 7.286683732759403, 7.057565038789098, 6.828014236631873, 6.598016430792438, 6.367568232056785, 6.136683722267972, 5.905401645324862, 5.673793170154701, 5.441968951125991, 5.210083706040486, 4.97833655684442, 4.746966276271088, 4.516242225413992, 4.286453380413697, 4.057898462744904, 3.830879446471816, 3.605699183710813, 3.382662524925639, 3.162079696606907, 2.944270794713391, 2.729570685014731, 2.518334035353604, 2.310940491632322, 2.107800148008777, 1.909359507083338, 1.716108128197434, 1.528586148150504, 1.347392833681709, 1.173196277760812, 1.006744256139295, 0.8488760714521452, 0.7005348545211378, 0.5627791476347754, 0.4367914892752437, 0.3238799446011835, 0.2254659494931556, 0.1430487520152853, 0.07813459559313817, 0.03212094275347098, 0.006132550917571207, 2.222725671548048e-17, 1.147370683591992e-15, 2.916672477454884e-14, 4.867323571406334e-13, 5.997596694008383e-12, 5.819565803045742e-11, 4.630972179359335e-10, 3.10792343745318e-09, 1.795373856761943e-08, 9.067391812963664e-08, 4.052917407102613e-07, 1.619197687662938e-06, 5.829247804274043e-06, 1.90400999796094e-05, 5.675371193006228e-05, 0.0001551560280856239, 0.0003907533830253125, 0.0009101084603953486, 0.001967291636756793, 0.003959400881108525, 0.007441842307626019, 0.01309976173429727, 0.02165642363851876, 0.03371754480954004, 0.04957976744651297, 0.0690599033126408, 0.0914127434540994, 0.1153870980104655, 0.1394242689050879, 0.1619485393916166, 0.1816615669775072, 0.1977510485016294, 0.2099595071505789, 0.218513388213294, 0.2239596523573533, 0.2269773409270323, 0.2282218359467909, 0.2282312684798515, 0.2273948649296467, 0.2259644876213904, 0.2240862985512184, 0.2218348960458899, 0.2192407556133369, 0.2163086525317702, 0.2130284144099959, 0.2093804287635742, 0.2053380362989373, 0.2008682406478186, 0.1959315454378693, 0.1904813247945499, 0.18446291732667, 0.1778125436664559, 0.1704561373442301, 0.1623082297458938, 0.1532711493693873, 0.1432350131692947, 0.1320793518758506, 0.1196777747328861, 0.1059078458056606, 0.09066911611986036, 0.07391231103464722, 0.05568037625931311, 0.03615573234845994, 0.01571592441388224 },
                { 14.97123071080962, 11.98401714730666, 11.77260001721716, 11.5611159398561, 11.34956054943911, 11.13792909672785, 10.92621640742367, 10.71441683542955, 10.50252421035228, 10.29053177857248, 10.07843213718665, 9.866217160135798, 9.653877915907502, 9.441404576369034, 9.228786316619969, 9.016011206333598, 8.803066094025396, 8.589936487249966, 8.376606434191428, 8.163058415924465, 7.949273264428434, 7.735230130135079, 7.520906535584381, 7.306278570145866, 7.091321306338212, 6.876009552213042, 6.660319096006352, 6.444228644015928, 6.2277226871886, 6.01079552885083, 5.793456619656233, 5.575737116977159, 5.357697170222712, 5.139432864625841, 4.921081226517116, 4.702821570100262, 4.48487211763736, 4.267482257805325, 4.050922414639581, 3.835474347522593, 3.621424270904283, 3.409059829012269, 3.198670574419166, 2.990550850153297, 2.785003943328431, 2.582346748210331, 2.382914603738673, 2.187066275239902, 1.995189208320601, 1.807705240977487, 1.625076968651862, 1.447814946238444, 1.276485888822915, 1.111721990102369, 0.9542313899468942, 0.8048096472910095, 0.664351739430806, 0.5338634983976511, 0.414470338535505, 0.3074194145578347, 0.2140688280094266, 0.1358544219341796, 0.07422244329469934, 0.03051820023014727, 0.005827187125166583, 1.439873816609855e-17, 7.529200526944004e-16, 1.938813322630689e-14, 3.277463841578421e-13, 4.090909119788108e-12, 4.020895974242999e-11, 3.241067327568451e-10, 2.203244821511971e-09, 1.289186224215392e-08, 6.594802372686706e-08, 2.985619389542273e-07, 1.208093286130486e-06, 4.40485089814847e-06, 1.457093027905573e-05, 4.398346126452822e-05, 0.0001217626985066932, 0.0003105038442364654, 0.0007322134755887152, 0.001602313341583981, 0.003264272469400726, 0.006209372681059626, 0.01106008236331638, 0.0184973126007874, 0.02912606489709775, 0.0432996532591558, 0.06095056771181146, 0.08149110731497811, 0.1038362308536139, 0.1265631759831623, 0.1481712542231689, 0.1673646116947255, 0.183271181205829, 0.1955375655518961, 0.2042885948148364, 0.2099877813780123, 0.2132602745200197, 0.2147364767669385, 0.2149504756204795, 0.214298636665887, 0.2130434277508323, 0.2113407055402829, 0.2092723021514093, 0.2068735619454729, 0.2041524738107066, 0.2011011534046636, 0.197701883919098, 0.1939298372031468, 0.1897539677783752, 0.1851369529809303, 0.1800346267653012, 0.1743951185759877, 0.1681578048626796, 0.1612521613966913, 0.1535966481400289, 0.1450978697354017, 0.1356504616207988, 0.1251385022550019, 0.11343980114802, 0.100435172532121, 0.08602559812041775, 0.07016032094560556, 0.0528767857986814, 0.03434715397548431, 0.01493297557791656 },
                { 15.89344127301708, 11.29798954890064, 11.09886639965263, 10.89968148957343, 10.7004308031582, 10.50110997324577, 10.30171424294917, 10.10223842289178, 9.902676843170262, 9.703023299422461, 9.503270992351636, 9.303412460060878, 9.103439502605828, 8.903343098312775, 8.703113311684783, 8.50273919320936, 8.302208672206191, 8.101508445191544, 7.900623864352909, 7.699538834013837, 7.498235727988589, 7.296695348272073, 7.094896956654109, 6.892818426944168, 6.690436588059205, 6.48772785851687, 6.284669310855744, 6.081240346770608, 5.877425199908235, 5.673216490794532, 5.46861999789044, 5.263660626006328, 5.058389199754862, 4.852889195321333, 4.64728199359725, 4.441729008924351, 4.236429491264186, 4.031614022258162, 3.827535275908886, 3.624458626719646, 3.422655033815428, 3.222397474409787, 3.023960833882365, 2.827624305101596, 2.633675197019477, 2.442413352638181, 2.25415578777145, 2.069241479100262, 1.888036405779978, 1.710939019422489, 1.538386332596086, 1.370860808528648, 1.208898215077292, 1.053096567293305, 0.9041262028386415, 0.7627408721812294, 0.6297894117333406, 0.5062269909920631, 0.3931239164560462, 0.2916683222007231, 0.2031566172453655, 0.1289625020948384, 0.07047300894992281, 0.02898158082072973, 0.005534360441482005, 9.509291033128533e-18, 5.033306771101474e-16, 1.311953024846739e-14, 2.244886503336591e-13, 2.836262170632729e-12, 2.821724749161601e-11, 2.302181506288546e-10, 1.58404485399991e-09, 9.381364420457469e-09, 4.857232637431232e-08, 2.225604185669619e-07, 9.114400082178632e-07, 3.363245105623434e-06, 1.125893152979461e-05, 3.4392328644664e-05, 9.634396462479551e-05, 0.0002485915355727862, 0.0005931047500805974, 0.001313026698602301, 0.002705791090637875, 0.00520566090448702, 0.009376311773254175, 0.01585392272821824, 0.02523208832488649, 0.03790212644105326, 0.05388896977041016, 0.07274043821484901, 0.09352312559831472, 0.1149473002799872, 0.1355963081261128, 0.1541941203776345, 0.1698287663800713, 0.1820677346219496, 0.1909446304995049, 0.19684302180558, 0.2003325270719367, 0.2020143844152023, 0.2024141270487358, 0.2019316763157718, 0.2008377827462704, 0.1992967238279288, 0.1973969620045327, 0.1951784532753009, 0.1926522860623419, 0.1898127923440714, 0.1866440819115277, 0.1831230798593942, 0.179220603428979, 0.1749014062217386, 0.1701236766138313, 0.1648382230871454, 0.1589874621409788, 0.1525042960969006, 0.1453110044876237, 0.1373183760826052, 0.128425505024583, 0.1185210111697944, 0.1074869783415284, 0.09520765451055039, 0.08158576654229496, 0.0665695147743658, 0.0501913498985227, 0.0326136283598184, 0.01418220933733506 },
                { 16.87245894330237, 10.6506795709623, 10.46313369772484, 10.2755307806537, 10.08786712132084, 9.900138698298019, 9.712341132264672, 9.524469646814403, 9.336519024426488, 9.148483557026906, 8.960356990534846, 8.772132462786994, 8.583802434272085, 8.395358611221224, 8.206791860830077, 8.018092118805525, 7.829248290135224, 7.640248145129331, 7.451078214611351, 7.261723690981309, 7.072168346234198, 6.882394484590381, 6.692382957137697, 6.502113280025712, 6.311563917708913, 6.120712819790796, 5.929538334499619, 5.73802066136947, 5.546144042162759, 5.353899903907105, 5.161291127368607, 4.968337469204014, 4.775081866826191, 4.58159689475711, 4.387990126067069, 4.194406851790756, 4.001028883040496, 3.808069182452018, 3.615763529220586, 3.424361539020057, 3.234119445277438, 3.045296098110307, 2.858152325368881, 2.672952869678076, 2.489969852290021, 2.309486940984307, 2.13180378716172, 1.95724062119664, 1.786143085938382, 1.618887470794725, 1.455886530898341, 1.29759607178726, 1.144522462930021, 0.9972312084252346, 0.8563566299317216, 0.722612566586662, 0.5968037030822576, 0.4798365920018595, 0.372728475689555, 0.2766104229702667, 0.1927189031190149, 0.1223668949137503, 0.06688319465983782, 0.02750988192721879, 0.005253849143707529, 6.397167493046635e-18, 3.425051079301632e-16, 9.030320330748763e-15, 1.562957554398451e-13, 1.997391869699851e-12, 2.009977713070136e-11, 1.658710947442595e-10, 1.15437578322497e-09, 6.91492312133184e-09, 3.621126773778179e-08, 1.678134199530333e-07, 6.950556322345582e-07, 2.593877716225129e-06, 8.781567123729706e-06, 2.712699879333858e-05, 7.684363693055854e-05, 0.0002004871636307056, 0.0004836339918730478, 0.001082445516710297, 0.002254902635964384, 0.004384849221940034, 0.007981569296652354, 0.01363602750232948, 0.02192292565542536, 0.03325678754161439, 0.04773518523749378, 0.06502130875589917, 0.0843184137489704, 0.1044642502618415, 0.1241312784754802, 0.1420767149019865, 0.1573657581009765, 0.1695024515091884, 0.1784399199981198, 0.1844865245966436, 0.1881561395305677, 0.1900177911390659, 0.190584625923008, 0.190256817866417, 0.1893111153868926, 0.1879188811193883, 0.1861745284622782, 0.1841223118204409, 0.1817762730857897, 0.1791328741336717, 0.1761779773160426, 0.1728901826693421, 0.1692420832808381, 0.1652004131515927, 0.160725610771701, 0.1557710519303706, 0.1502820758616809, 0.1441948918474475, 0.1374354827716365, 0.1299187177604886, 0.121548072139329, 0.1122166755838712, 0.1018109264111167, 0.09021864761874519, 0.07734457803470974, 0.06313626962149491, 0.04762165602840173, 0.03095374504215052, 0.0134630526672565 },
                { 17.91178297407096, 10.03996917953567, 9.863325903574011, 9.686629881455949, 9.5098777023619, 9.333065658355999, 9.156189712355186, 8.97924546215098, 8.802228099991534, 8.62513236719123, 8.447952503205553, 8.270682188600676, 8.09331448137637, 7.915841746192727, 7.738255576244831, 7.560546707884437, 7.382704928694271, 7.204718980714785, 7.026576462108314, 6.848263733021439, 6.669765835209134, 6.49106644073424, 6.312147853605951, 6.132991100682765, 5.9535761658558, 5.77388244572086, 5.593889536208386, 5.413578496394485, 5.23293377159629, 5.051945977586789, 4.870615722451508, 4.688958528190978, 4.507010661865471, 4.324835277385182, 4.142527778918279, 3.960218970743019, 3.778074691871267, 3.596291470927253, 3.415089080092907, 3.234702039526363, 3.055372408305696, 2.877345449445994, 2.700868524598813, 2.526192595398777, 2.35357534783911, 2.183285107993635, 2.015605075778485, 1.85083772897815, 1.689309452989016, 1.531375545444759, 1.377425773673307, 1.227890662332274, 1.083248673911853, 0.9440344132124877, 0.810847919854324, 0.6843649737418242, 0.5653480638397435, 0.4546571562568038, 0.3532584832228551, 0.2622280479189113, 0.1827442181522119, 0.1160608016430435, 0.06344950565906358, 0.02610173387119323, 0.00498539919881658, 4.380083111617309e-18, 2.370537524920164e-16, 6.317793810811896e-15, 1.105322307850838e-13, 1.427844658740331e-12, 1.452381718329078e-11, 1.211510976905693e-10, 8.522469470973457e-10, 5.160131781912529e-09, 2.731271462353375e-08, 1.279342295450219e-07, 5.355601750656367e-07, 2.020015593584369e-06, 6.911613503915712e-06, 2.157716528071247e-05, 6.176829051435653e-05, 0.0001628490277502791, 0.0003969423755095756, 0.0008976230863216364, 0.00188908357657072, 0.003710758619796717, 0.006822120135445229, 0.01176974240389334, 0.01910443363951451, 0.02925236790017966, 0.04236709715899144, 0.05820906823407974, 0.07610342320918401, 0.09500809722041906, 0.1136866472229642, 0.1309395436448795, 0.1458235216239748, 0.1577934491919704, 0.1667326441655038, 0.1728798336767709, 0.176694097234942, 0.1787102326734795, 0.1794258488300059, 0.1792384017144086, 0.1784284473718503, 0.1771730769468896, 0.1755719226122212, 0.1736731785216012, 0.171493665889484, 0.1690318764593066, 0.1662753463582541, 0.1632042719495488, 0.1597929367950542, 0.1560099613796127, 0.1518179316635592, 0.1471726798763834, 0.1420223502084628, 0.1363063368604523, 0.1299542045357388, 0.1228847896432654, 0.1150058564926746, 0.1062149914523425, 0.09640291784914551, 0.08546113704785922, 0.07329662273422086, 0.05985662955594528, 0.04516502058393394, 0.02936590852907815, 0.01277484998643125 },
                { 19.01512816764474, 9.463847823919496, 9.297471993573575, 9.131047339353123, 8.964570711825798, 8.798038687873665, 8.631447541244771, 8.464793209476998, 8.29807125673949, 8.131276832098213, 7.964404622682406, 7.797448801216973, 7.630402967406251, 7.46326008272938, 7.296012398370547, 7.128651376311111, 6.961167604134009, 6.793550704953534, 6.625789245264114, 6.457870645664468, 6.289781102743948, 6.121505535466823, 5.953027576920382, 5.784329643309579, 5.615393127801652, 5.446198788487194, 5.276727428052469, 5.106960996765292, 4.936884285099181, 4.766487395168633, 4.59576916641221, 4.424741641383688, 4.253435445326795, 4.081905592306243, 3.910236771364187, 3.738546794762281, 3.566986914876564, 3.395738388049654, 3.225005881686499, 3.055009509475639, 2.885977724529411, 2.71814274272713, 2.551739034478843, 2.387004421412088, 2.22418287083105, 2.063528159876282, 1.905307905594697, 1.749807779502365, 1.597335938092089, 1.448227804598112, 1.302851372662402, 1.161613205437614, 1.024965291371206, 0.8934128894722239, 0.7675234355058897, 0.6479364517753489, 0.5353741464746213, 0.4306519035849938, 0.3346869950620486, 0.2485023836646915, 0.1732202368872822, 0.1100368461523262, 0.06016811761376087, 0.02475562740622011, 0.004728729494540038, 3.049864563087829e-18, 1.667470177107505e-16, 4.489389386617779e-15, 7.934480948202343e-14, 1.035416404002192e-12, 1.063936159469248e-11, 8.965169133045444e-11, 6.370710102324478e-10, 3.896444744126171e-09, 2.083296267327911e-08, 9.856966858478661e-08, 4.167980873523991e-07, 1.587895556611938e-06, 5.487610560899608e-06, 1.730291573469241e-05, 5.002568688904896e-05, 0.000133196609224956, 0.0003278608696181298, 0.0007486495094490772, 0.001590815712034299, 0.003154781672066563, 0.005854741550621399, 0.01019456698673311, 0.01669806805912964, 0.02579418807480866, 0.03767860310888496, 0.0521929827621626, 0.06877022040718559, 0.08648009529461901, 0.1041768697316326, 0.1207113778399156, 0.1351437321809026, 0.1468923628579667, 0.1557810694287747, 0.161985014733277, 0.1659103455474838, 0.1680565188190104, 0.1689031113133461, 0.1688422523861457, 0.1681562533190422, 0.1670265916667765, 0.1655573554082938, 0.1638002854633422, 0.1617747847605457, 0.1594812628536348, 0.1569088465564736, 0.1540392497921384, 0.1508483629072076, 0.1473066011998326, 0.1433785975743274, 0.1390225313488524, 0.1341892343345828, 0.128821162390674, 0.1228513368397772, 0.1162024411437151, 0.1087864244567947, 0.1005052585198059, 0.09125397641700423, 0.08092782741038211, 0.06943620277386512, 0.05672636999633883, 0.04281853721464348, 0.02784836940534185, 0.01211687657704372 },
                { 20.1864381538885, 8.920408083032103, 8.76370172848041, 8.606950135530915, 8.450150392748839, 8.293299336267671, 8.136393522676757, 7.979429198570249, 7.822402266337185, 7.665308245735412, 7.50814223076246, 7.350898841322264, 7.193572169200165, 7.036155717919329, 6.878642336189564, 6.721024144920299, 6.563292458223069, 6.405437699580387, 6.24744931556521, 6.089315691391915, 5.931024075507837, 5.772560524884185, 5.613909889319916, 5.455055862841607, 5.295981144287841, 5.136667768595868, 4.977097695980511, 4.817253777563909, 4.657121249224455, 4.496689930097041, 4.335957297145021, 4.174932537709988, 4.013641503866784, 3.852132174968883, 3.690479809097998, 3.528790582471576, 3.367202456393687, 3.205882538144219, 3.045021291670445, 2.884825128087909, 2.725509474714485, 2.567294039277346, 2.410400960831741, 2.25505553575797, 2.101488695414394, 1.949940421857844, 1.800663575167702, 1.653927920933572, 1.510024366227598, 1.369269525219504, 1.232010777175498, 1.098631985938992, 0.9695600399910269, 0.8452723466321567, 0.7263053576798464, 0.6132640848692048, 0.5068323232703661, 0.4077828439961963, 0.3169859920584089, 0.2354137245466991, 0.1641339527325611, 0.1042871874334602, 0.05703493801477411, 0.0234699388861664, 0.004483536632463905, 2.157947809272079e-18, 1.191174000460801e-16, 3.237866035964045e-15, 5.777526807245025e-14, 7.611798946633282e-13, 7.896473064607662e-12, 6.717649615739939e-11, 4.819292401790109e-10, 2.975740577067029e-09, 1.606210002349322e-08, 7.672058278174448e-08, 3.274936653822244e-07, 1.259497949982899e-06, 4.393848517263928e-06, 1.398469709784579e-05, 4.081143265449895e-05, 0.0001096772980982827, 0.0002724731917226097, 0.0006279055722816283, 0.001346425430306963, 0.002694239024039937, 0.005044610860439422, 0.008860934824772627, 0.0146383424124175, 0.02280184254851745, 0.03357782994915595, 0.04687517926158054, 0.06222131740750972, 0.07878901837074388, 0.09552109746712094, 0.1113234529775829, 0.1252691244142878, 0.136751274846941, 0.1455438709027812, 0.1517648010783074, 0.1557698245842222, 0.1580227153764235, 0.1589831353616473, 0.1590356508709149, 0.1584624447286691, 0.1574480828006484, 0.156100335198975, 0.1544740732995764, 0.1525910656962429, 0.1504535175947951, 0.1480520597391004, 0.1453698449131093, 0.1423842884013052, 0.1390675111226427, 0.1353860948756234, 0.1313004587600194, 0.1267640060670262, 0.1217221308762906, 0.1161111836734473, 0.1098575694619377, 0.1028773085831299, 0.09507667166080758, 0.08635496409752897, 0.07661122267930198, 0.06575740252413024, 0.05374105577023675, 0.04057912071001214, 0.02639925273890956, 0.01148835087637511 },
                { 21.42989948572291, 8.407841329790076, 8.260241461325704, 8.112599637121616, 7.964913162826924, 7.81717911097625, 7.669394295994783, 7.521555246126709, 7.373658171898327, 7.225698930691802, 7.077672986976462, 6.92957536772858, 6.781400612578674, 6.633142718274633, 6.484795077165712, 6.336350409637299, 6.187800690820855, 6.03913707256074, 5.890349802679531, 5.741428145253174, 5.592360308191218, 5.443133388352981, 5.29373335033117, 5.144145063723776, 4.994352436223821, 4.844338697312831, 4.694086910619498, 4.543580821880133, 4.392806180933406, 4.241752701718203, 4.090416825741146, 3.938805401123854, 3.786940240120303, 3.634863239546686, 3.482641357285035, 3.330370356996931, 3.178176110599766, 3.02621265011763, 2.874657123890822, 2.723702949372869, 2.573553114656452, 2.424415355771671, 2.276500025991245, 2.130020486695739, 1.98519528412049, 1.842251321980618, 1.701427488250319, 1.562978498503211, 1.427178942230246, 1.294327639094228, 1.164752459513718, 1.038815773712176, 0.916920685576888, 0.7995181847749428, 0.6871152991906099, 0.5802842194025771, 0.4796721427972515, 0.3860111544742621, 0.300126679010889, 0.222941698314019, 0.1554718369917865, 0.09880362120734823, 0.05404566182733207, 0.0222429531420067, 0.00424949929179378, 1.550360652284608e-18, 8.635398082533198e-17, 2.368532092454226e-15, 4.264549602564661e-14, 5.669261692912858e-13, 5.934403965263647e-12, 5.094039362887754e-11, 3.68743929088286e-10, 2.297355854506112e-09, 1.251184202334773e-08, 6.029893965050944e-08, 2.596997331257829e-07, 1.007691144268606e-06, 3.546707016915765e-06, 1.138860186796806e-05, 3.352900828408354e-05, 9.089888795957975e-05, 0.0002277961539337731, 0.0005295062942075411, 0.00114519978466156, 0.002311099043305357, 0.004363617914151992, 0.007728197969532585, 0.01287066238962183, 0.02020713421931653, 0.02998542919358317, 0.04216949809426364, 0.05636915492607119, 0.07185120695388652, 0.08764361529531097, 0.1027100816111692, 0.1161440923991846, 0.1273231840119487, 0.1359804319720359, 0.1421827429871878, 0.1462385151770348, 0.1485761345250184, 0.1496340191151133, 0.1497873034169253, 0.1493163463742521, 0.148407571336984, 0.1471716637611211, 0.1456661962641546, 0.1439150737501075, 0.1419221669674079, 0.1396795209428886, 0.1371716489617367, 0.1343774113923182, 0.1312705482409558, 0.1278194949061108, 0.1239868054295846, 0.1197283402531417, 0.1149923089337039, 0.109718262612306, 0.1038361986666659, 0.09726608758472056, 0.08991839992359248, 0.08169665704841394, 0.07250369664577022, 0.06225415103604642, 0.05089609314023282, 0.03844354659873912, 0.02501658384900241, 0.01088844566312765 },
                { 22.74995660290491, 7.924433442207207, 7.785409982568606, 7.64634757703293, 7.507243729590455, 7.368095728706941, 7.228900624251887, 7.089655201588093, 6.950355952462687, 6.810999042306192, 6.671580273517905, 6.532095044298706, 6.392538302596321, 6.252904494767814, 6.113187508663362, 5.97338061102981, 5.833476379476921, 5.693466629826305, 5.553342340596793, 5.413093577855386, 5.272709425950912, 5.132177933140234, 4.991486086365462, 4.850619837191665, 4.70956421211432, 4.568303556158158, 4.426821979807667, 4.285104105855149, 4.143136242439778, 4.000908134283487, 3.858415450420732, 3.71566312634445, 3.572669553610133, 3.429471366140507, 3.286128214980974, 3.142726550527911, 2.999381262623514, 2.856234325183327, 2.713450435439853, 2.571210722541074, 2.429706323100077, 2.289133533475612, 2.149691452740497, 2.011582074415524, 1.875012180267824, 1.740196277081088, 1.607360026256112, 1.476743906464057, 1.348607075366975, 1.223231523349331, 1.10092666500526, 0.9820345271276304, 0.8669356862725974, 0.7560560885275232, 0.6498748370860806, 0.548932931077918, 0.4538427297283533, 0.3652975107274814, 0.2840797493667294, 0.2110654668542535, 0.1472199809765412, 0.09357767111486202, 0.05119582161955711, 0.02107288414593454, 0.004026282177446666, 1.130150332931738e-18, 6.34853971007315e-17, 1.75613047645633e-15, 3.188852565435973e-14, 4.27532298816851e-13, 4.51333611923236e-12, 3.907127071776206e-11, 2.8522708172326e-10, 1.792091236374978e-09, 9.842685815653345e-09, 4.783615071338446e-08, 2.077613749953925e-07, 8.129405684723472e-07, 2.885256739961095e-06, 9.342115828618047e-06, 2.773300187119434e-05, 7.580869296627393e-05, 0.0001915449523094953, 0.0004488848143236547, 0.000978712486548243, 0.00199098070856606, 0.003789019893374402, 0.006762977204696659, 0.01134949707196409, 0.01795226015970051, 0.026832995794652, 0.03800032796603333, 0.05113544732815052, 0.0655904039657692, 0.08047405109312976, 0.09480906900247424, 0.1077151489437331, 0.1185623938514326, 0.127051109202231, 0.1332033501332217, 0.1372834892508218, 0.1396853305817282, 0.1408252084509986, 0.1410673079947011, 0.1406886670280296, 0.1398764201508314, 0.1387434230596704, 0.1373495169916589, 0.1357205055119399, 0.1338617890981109, 0.1317667353939947, 0.1294211404755743, 0.1268052320742348, 0.1238942855479023, 0.1206584975679026, 0.1170624550777822, 0.113064363651015, 0.1086151269975489, 0.1036573683753093, 0.09812454611359459, 0.09194045429370922, 0.08501965440849355, 0.07726981147852333, 0.06859755460463161, 0.05892027719401235, 0.04818677612891063, 0.0364084866559076, 0.02369831153579413, 0.01031629817426103 },
                { 24.15132771755963, 7.468560584443179, 7.337614426472883, 7.206632086180784, 7.075611249064016, 6.944549401140898, 6.813443807629263, 6.68229148900253, 6.551089194090132, 6.419833369857074, 6.28852012746993, 6.157145204238848, 6.025703921025579, 5.894191134739669, 5.762601185629434, 5.630927839243151, 5.499164223237613, 5.367302759719567, 5.235335094631204, 5.103252026998811, 4.971043442896599, 4.838698262087183, 4.706204409983141, 4.57354883450743, 4.440717597482617, 4.307696084348256, 4.174469395185617, 4.041023004415792, 3.907343804394598, 3.773421673577947, 3.639251719690131, 3.504837318357775, 3.370193963272782, 3.235353730717997, 3.100369836124817, 2.965320401086533, 2.830310348328372, 2.695470549871431, 2.56095408552498, 2.426930490717964, 2.293579634671422, 2.161086899607581, 2.029640647998481, 1.899432050676356, 1.77065671702305, 1.643517404683043, 1.518227256396926, 1.395013285934196, 1.274120060439949, 1.155813658503489, 1.040386040880504, 0.9281599868898653, 0.8194947458537941, 0.7147925347653506, 0.6145059703313172, 0.5191464289473875, 0.4292931325881597, 0.3456023773146466, 0.2688156179429811, 0.1997639035768717, 0.1393642221982578, 0.08860067004713115, 0.04848083243662308, 0.01995789356117598, 0.003813539569996137, 8.3530085278172e-19, 4.729926599501298e-17, 1.318892384550771e-15, 2.414109327541316e-14, 3.262563038633999e-13, 3.471781242877834e-12, 3.029518966148339e-11, 2.229280040352092e-10, 1.41184617729916e-09, 7.816084552833857e-09, 3.828902794999979e-08, 1.676171886506503e-07, 6.610588402410056e-07, 2.364742732366921e-06, 7.71705557959065e-06, 2.308856700407496e-05, 6.360585616783492e-05, 0.0001619601031644568, 0.0003824802590554158, 0.0008403090125009957, 0.001722376766845005, 0.003302370452091926, 0.005937816598436443, 0.01003684496357484, 0.01598823672834602, 0.02406163182186515, 0.03430147252395814, 0.04645045431956763, 0.05993744410466255, 0.07394740951274052, 0.08756196424558962, 0.09993125811718875, 0.1104248199548321, 0.1187174564573975, 0.1247922197981107, 0.1288729591162364, 0.1313200982833226, 0.1325274697934138, 0.1328471191685651, 0.1325514659787237, 0.1318273063052472, 0.1307889546061825, 0.1294980930559926, 0.1279821826413862, 0.1262480142908122, 0.1242901854977923, 0.1220956984012963, 0.1196460726393498, 0.1169180380865421, 0.1138834634817367, 0.110508869683237, 0.1067546980857913, 0.1025744272416171, 0.09791362481324355, 0.09270907760272774, 0.08688827284749759, 0.08036974606645332, 0.07306522034956417, 0.06488508698021212, 0.05574955810530674, 0.04560832750246636, 0.03447054054067112, 0.02244232889162451, 0.009771019198025359 },
                { 25.63902167824289, 7.038685076357032, 6.915346257919013, 6.791973798010847, 6.668565548484114, 6.545119176373404, 6.421632144170035, 6.29810168767078, 6.17452479109245, 6.050898159113054, 5.927218185473831, 5.803480917758322, 5.67968201796254, 5.555816718496017, 5.431879773325678, 5.3078654041214, 5.183767241527412, 5.059578262132981, 4.935290722448331, 4.810896092355, 4.686384992311819, 4.56174714137445, 4.43697132727676, 4.312045416040972, 4.186956427627124, 4.06169071693438, 3.936234316905347, 3.810573522881782, 3.68469582341428, 3.558591307565527, 3.432254690951157, 3.305688081111325, 3.178904515614363, 3.051932119897716, 2.924818437048291, 2.797634139279173, 2.670475108558522, 2.54346200837081, 2.416737098624236, 2.290458998971513, 2.164796887362627, 2.03992574885802, 1.916023712733953, 1.793271651254298, 1.671854566372885, 1.551964082407071, 1.433801495423749, 1.317581086883635, 1.203533631989151, 1.09191016894961, 0.9829861572388867, 0.8770661718928383, 0.7744892791534077, 0.6756352226666576, 0.5809315100555223, 0.4908614020830458, 0.4059726239422579, 0.3268862595539076, 0.2543046241259001, 0.1890157491226725, 0.1318902556950977, 0.08386383221848944, 0.04589603171824487, 0.01889610728986253, 0.003610918497792555, 6.255410945191814e-19, 3.568941880666055e-17, 1.002685836061318e-15, 1.849187449118727e-14, 2.517961830777444e-13, 2.699642224277493e-12, 2.373494150871955e-11, 1.759690463420493e-10, 1.122825271784435e-09, 6.262713150305289e-09, 3.090940525330177e-08, 1.363237559762865e-07, 5.416544914100746e-07, 1.952030606682989e-06, 6.417480048509566e-06, 1.934228797777297e-05, 5.367739545800646e-05, 0.0001376792704026234, 0.000327502808566992, 0.0007247123638183644, 0.001496047899726179, 0.002888667715617856, 0.005230088953717238, 0.008900953879152125, 0.01427354470358866, 0.02162066198886302, 0.03101507983213501, 0.04225222641255053, 0.05482984809170471, 0.06800397459244307, 0.08091417819076606, 0.09274405757320428, 0.1028682214975327, 0.1109424060027989, 0.1169161462242484, 0.1209763215535924, 0.1234514711507187, 0.1247128633859686, 0.1250995118044637, 0.1248781164479721, 0.1242341886669408, 0.1232828329867716, 0.1220871568534751, 0.1206760381078426, 0.1190575175297292, 0.1172273295148944, 0.1151736068620293, 0.112879088045063, 0.1103218795943141, 0.1074754363393393, 0.104308117307293, 0.100782493422728, 0.09685450126453073, 0.09247252672715098, 0.08757655256989584, 0.08209762627489045, 0.07595813444611846, 0.06907376177266982, 0.06135861559322939, 0.05273576125830925, 0.04315593478797873, 0.03262626380519553, 0.02124649182830324, 0.00925170119596237 },
                { 27.21835587281045, 6.633351366142843, 6.517177354822984, 6.400972041086209, 6.284733429472029, 6.168459353121848, 6.052147455509581, 5.93579516992735, 5.819399696439332, 5.702957975988453, 5.586466661315156, 5.469922084329374, 5.353320219572661, 5.236656643427958, 5.119926488796177, 5.003124395087124, 4.886244453606212, 4.769280148816831, 4.652224296610089, 4.535068981751482, 4.417805498293897, 4.30042429923326, 4.182914965443044, 4.065266209515858, 3.947465938295322, 3.829501409469776, 3.711359533474074, 3.593027392516632, 3.474493072858391, 3.355746930471709, 3.236783424072236, 3.117603634497768, 2.998218516659408, 2.878652767361789, 2.758948925622637, 2.639170998407659, 2.519406669565301, 2.399767224424457, 2.280384860797723, 2.161407939250997, 2.042995510908562, 1.925312670120534, 1.808527801838388, 1.69281198356863, 1.57834014897735, 1.465293374442186, 1.353861747071302, 1.244247510904423, 1.136668406768545, 1.031361259577377, 0.9285859323569806, 0.8286297879018741, 0.7318127990208817, 0.6384934341537323, 0.5490754090929697, 0.4640153143903415, 0.3838309573897818, 0.3091099205499445, 0.2405172079867866, 0.1787997470843871, 0.1247837315765576, 0.07935831661288177, 0.04343671457657945, 0.01788563014054858, 0.003418061553473189, 4.743396796337921e-19, 2.725556941396168e-17, 7.711897434634067e-16, 1.43237276608554e-14, 1.964268776374584e-13, 2.120958730285819e-12, 1.877956890706134e-11, 1.402174156060501e-10, 9.010364294088001e-10, 5.061192461831209e-09, 2.515568216262252e-08, 1.117290804767176e-07, 4.470533654651107e-07, 1.622399806716836e-06, 5.371066047014402e-06, 1.630111197623394e-05, 4.555130766458699e-05, 0.0001176419039766692, 0.0002817562208751408, 0.0006277204103447546, 0.00130454955620975, 0.00253567633347362, 0.004621106765024276, 0.007915256694558849, 0.01277297171326476, 0.01946649856241897, 0.02809065257330714, 0.03848585718222583, 0.05021136142495618, 0.06258911850224575, 0.07481499668768435, 0.08610798796953216, 0.09585236409342252, 0.1036904072373981, 0.1095432086933252, 0.1135641938563376, 0.1160517180100861, 0.1173547162989232, 0.11779854384809, 0.117643266743764, 0.1170722719948854, 0.1162008348699423, 0.115093090210975, 0.1137790965533151, 0.1122680045895028, 0.1105565933784732, 0.108634052636213, 0.106484269096564, 0.1040866511061134, 0.1014161569031798, 0.09844289131063271, 0.09513145174606755, 0.09144011887844428, 0.08731997278836825, 0.08271406049998945, 0.07755685556729392, 0.07177446835379686, 0.06528643992709881, 0.05801053324732684, 0.04987268097545516, 0.04082478170440902, 0.03087219252568014, 0.020108635464499, 0.008757425511419838 },
                { 28.89497523408338, 6.251182117251292, 6.141756197903962, 6.032301132032073, 5.922815064512402, 5.81329598112375, 5.703741691610165, 5.594149810663869, 5.484517736561432, 5.374842627159907, 5.265121372935359, 5.155350566728189, 5.045526469853998, 4.935644974254912, 4.825701560419209, 4.715691250909484, 4.605608559546523, 4.495447436650423, 4.385201211322305, 4.274862532678639, 4.164423313402408, 4.053874681208804, 3.94320694720571, 3.832409605170175, 3.721471383132029, 3.610380379165092, 3.499124327755942, 3.387691062019182, 3.276069259670936, 3.164249583695697, 3.052226343566458, 2.939999793127914, 2.827579120619515, 2.714986043858129, 2.602258682754407, 2.489455077272946, 2.376655477584916, 2.263962559485554, 2.151499174706364, 2.039404056698913, 1.927826679445552, 1.816922740735445, 1.706851355134621, 1.597774289502133, 1.48985692372614, 1.383270342678392, 1.27819402955874, 1.174818849852093, 1.073350228306624, 0.9740115610635227, 0.8770479735838123, 0.782730559036319, 0.6913612335373562, 0.6032783322226825, 0.518863037143122, 0.4385466527732568, 0.3628185855257532, 0.2922345665582001, 0.2274240616943124, 0.1690947614041169, 0.1180303398712998, 0.07507528244537039, 0.04109816476162594, 0.01692455874227124, 0.003234609378219094, 3.639734404542458e-19, 2.105419927923461e-17, 5.997171387502826e-16, 1.121350321879304e-14, 1.548047401818575e-13, 1.682718204269113e-12, 1.499885244575464e-11, 1.127365175073719e-10, 7.292757655973843e-10, 4.123680750324695e-09, 2.063223862585303e-08, 9.224632800595491e-08, 3.715424597086146e-07, 1.357268249364904e-06, 4.522912484520008e-06, 1.381701952173314e-05, 3.886199182597982e-05, 0.0001010179558905653, 0.000243503243836823, 0.0005459728634776541, 0.001141861708477212, 0.002233387676030935, 0.004095400686435983, 0.007057488939961784, 0.01145662842775664, 0.01756164743503278, 0.02548414736412191, 0.03510276442226866, 0.04603146738055678, 0.05765304667502659, 0.06921751412687404, 0.07998034625579945, 0.08933912264055717, 0.09692752565989575, 0.1026428376464117, 0.1066084401322728, 0.1090943362794803, 0.1104275945598795, 0.11091951830008, 0.1108227997901581, 0.1103179684377059, 0.1095199045835403, 0.1084933948855893, 0.1072694499873618, 0.1058581929893064, 0.1042573569102102, 0.1024571166202033, 0.1004424391267256, 0.09819396279974438, 0.09568806993194092, 0.09289652222590214, 0.08978584398215843, 0.08631654920158972, 0.08244229070934653, 0.07810904964378643, 0.07325459123266556, 0.06780861932252388, 0.06169441927970627, 0.05483333728359346, 0.04715416967256393, 0.03861007538459283, 0.02920486480988021, 0.01902658852225089, 0.008287268724974497 },
                { 30.67487241624053, 5.890874417948935, 5.787804176642652, 5.684706778177756, 5.581580496585596, 5.478423458090605, 5.37523362539434, 5.272008780029972, 5.168746502539578, 5.065444150201325, 4.962098832010422, 4.858707380600015, 4.755266320781402, 4.651771834395545, 4.548219721213318, 4.444605355720653, 4.340923639808333, 4.237168951702274, 4.13333509199094, 4.029415228439775, 3.925401842588046, 3.82128668313453, 3.717060734169247, 3.612714210863308, 3.508236601903683, 3.403616787507777, 3.298843275058748, 3.193904611773605, 3.088790054881285, 2.983490601749644, 2.878000497927226, 2.772319335484149, 2.666454803563653, 2.560426028426504, 2.454267222949715, 2.348031081323641, 2.241791112120127, 2.13564209063654, 2.029698195863086, 1.924089138936801, 1.818955349144952, 1.714443608017395, 1.610704218342597, 1.507890101252935, 1.406157573818948, 1.305668258275215, 1.206591607850578, 1.109107733970891, 1.01341042605618, 0.9197103952164416, 0.8282388440874219, 0.7392514911971793, 0.6530331815227458, 0.5699032041106987, 0.490221407444959, 0.4143951335382504, 0.3428868428133891, 0.2762220037557812, 0.2149962585150878, 0.1598798770687165, 0.1116158837468793, 0.07100593727795428, 0.03887568164363938, 0.01601099283416966, 0.003060202837641556, 2.824449820407836e-19, 1.644135414404181e-17, 4.712795696492675e-16, 8.867581182531836e-15, 1.231907217041483e-13, 1.34751287627344e-12, 1.208662181336925e-11, 9.141850131041876e-11, 5.950872151530577e-10, 3.386019767231266e-09, 1.704755392052448e-08, 7.669569815869594e-08, 3.108355177700643e-07, 1.14256571717864e-06, 3.831058737672443e-06, 1.177580092832127e-05, 3.332461463747153e-05, 8.715433901793626e-05, 0.0002113631417852543, 0.0004767712939758414, 0.001003098506568124, 0.001973589552294146, 0.003640134065821238, 0.006308958497119549, 0.01029911575421302, 0.0158738439681269, 0.02315716508947096, 0.03206001406749487, 0.04224489591564839, 0.05315050324811203, 0.06407850849194434, 0.07432127829458049, 0.08329253321543339, 0.09062150589247349, 0.09618585943512286, 0.1000821870908401, 0.1025540411291999, 0.1039072739556162, 0.1044389444680276, 0.1043937915278844, 0.1039488571960136, 0.1032181171632902, 0.1022666599375566, 0.1011262298419222, 0.09980778884979725, 0.09830993551724917, 0.09662376037531935, 0.09473524538719816, 0.09262619020533795, 0.09027432515421131, 0.08765298340190813, 0.08473052006623054, 0.08146957512717941, 0.07782625569851865, 0.07374934901840931, 0.06917977824367179, 0.06405070871701397, 0.05828905283165647, 0.05181965771600378, 0.04457416441565176, 0.03650706975657751, 0.02762083943400562, 0.0179981858831403, 0.007840308218433136 },
                { 32.56440921405356, 5.551196119465439, 5.454112017827889, 5.357002596747926, 5.259866249267801, 5.162701231001958, 5.065505645541135, 4.968277428065139, 4.871014326934013, 4.773713883003429, 4.676373406388131, 4.578989950379893, 4.481560282218861, 4.384080850426818, 4.286547748450008, 4.188956674446111, 4.091302887213304, 3.993581158542056, 3.895785722737777, 3.797910224812004, 3.699947670016462, 3.6018903792096, 3.50372995730327, 3.405457286162098, 3.307062559385674, 3.208535385093724, 3.109864994903506, 3.011040613264948, 2.912052060900991, 2.812890686959418, 2.713550740265378, 2.614031287762811, 2.514338746279777, 2.414489984632784, 2.31451575708272, 2.214463964476932, 2.114401999382233, 2.014417388868176, 1.914616269898244, 1.815119907329396, 1.716060199061927, 1.61757547553272, 1.519807670668128, 1.422901306053014, 1.327004104342934, 1.232268727748524, 1.138855143843513, 1.046933301729564, 0.9566860004027831, 0.86831197067346, 0.7820292647712032, 0.698079075776069, 0.61673011369368, 0.5382836556959016, 0.4630793604202615, 0.3915018715865722, 0.3239880970591064, 0.2610347693176608, 0.2032053615847131, 0.1511344856609583, 0.1055263421383908, 0.06714157841615284, 0.03676460353849181, 0.01514304505923921, 0.002894484913209661, 2.215289457318211e-19, 1.297209530966745e-17, 3.740466708793225e-16, 7.079873589143731e-15, 9.893951504305385e-14, 1.088664830650772e-12, 9.822757963563096e-12, 7.473555259232698e-11, 4.893678265353747e-10, 2.800931213048701e-09, 1.418499360681648e-08, 6.41929719565036e-08, 2.616923426319626e-07, 9.675624588278479e-07, 3.263220947988556e-06, 1.00887882915863e-05, 2.87160004578404e-05, 7.553451761445336e-05, 0.0001842333523633978, 0.0004179396566749491, 0.0008842800298470377, 0.001749522724051463, 0.003244627738888703, 0.005653941852163411, 0.00927882192958672, 0.01437530579018755, 0.02107622990593946, 0.02931969468260591, 0.03881114368593056, 0.04904045527429955, 0.05935827547220659, 0.06909372455819716, 0.07767880286771973, 0.0847418032303518, 0.09014452116991011, 0.09395982926919908, 0.09640675005831072, 0.09777070922172847, 0.09833449856633316, 0.09833446857704576, 0.09794364296217853, 0.09727463961880915, 0.09639252679939844, 0.09532957625619454, 0.09409746055578004, 0.09269555829842199, 0.09111580870820905, 0.08934514611578798, 0.08736646575517194, 0.08515877327252767, 0.082696891400499, 0.07995091362499846, 0.07688550212258808, 0.07345910312404035, 0.06962318457473148, 0.06532169520800309, 0.0604911292322305, 0.05506190506500566, 0.04896228052198913, 0.04212670924149943, 0.03451108543920931, 0.02611671185633081, 0.01702127945334368, 0.007415627009086739 },
                { 34.5703393015221, 5.230982306665099, 5.139536341037345, 5.048066755364398, 4.956572052482076, 4.865050607351738, 4.773500653493439, 4.68192026775472, 4.59030735320069, 4.498659619888634, 4.406974563269398, 4.315249439941, 4.223481240471698, 4.131666659017014, 4.039802059488901, 3.947883438112046, 3.855906382347959, 3.763866026421121, 3.671757004102036, 3.579573400078103, 3.487308702306238, 3.394955759383649, 3.302506749472185, 3.209953171055236, 3.117285871314344, 3.024495135835475, 2.931570874399487, 2.838502952315088, 2.745281734946847, 2.651898932836207, 2.558348850592514, 2.464630142994439, 2.370748146932928, 2.276717762192866, 2.182566677310521, 2.08833849095814, 1.994095044562983, 1.89991721569684, 1.805903688146673, 1.712167826887654, 1.618833491221947, 1.526031009501534, 1.433894373719676, 1.342560133760232, 1.252167864626593, 1.162861746099179, 1.074792776221117, 0.9881213023050296, 0.9030197436448765, 0.8196755182231951, 0.7382942597802865, 0.6591034412071367, 0.5823565261751932, 0.5083377629810899, 0.4373677093015635, 0.3698095166012477, 0.3060758729250158, 0.2466362395124216, 0.1920235145078322, 0.1428383572477774, 0.09974792278046771, 0.06347362819219308, 0.03476032769367667, 0.01431884938834207, 0.00273710233276562, 1.755169540239135e-19, 1.033534834270239e-17, 2.99685662233208e-16, 5.704130769108765e-15, 8.015967654824678e-14, 8.869533046738635e-13, 8.047450066167158e-12, 6.156983103907855e-11, 4.054050855131322e-10, 2.333275655504896e-09, 1.188225356402212e-08, 5.407030722413228e-08, 2.216455078168122e-07, 8.240195099149504e-07, 2.794399398066999e-06, 8.686727557993643e-06, 2.486030684121588e-05, 6.574786024537873e-05, 0.0001612293400087953, 0.0003677158305004152, 0.0007821523752587444, 0.001555606222114443, 0.002899974036362079, 0.005079185233481456, 0.008377330500070003, 0.01304208945966876, 0.019212151934269, 0.02684834596731975, 0.03569401537719145, 0.04528576958121536, 0.05502043581776472, 0.06426333075893862, 0.0724662855655432, 0.07925958840210213, 0.08449249767930158, 0.0882170241817115, 0.09062956278490554, 0.09199600149604522, 0.09258498374775599, 0.0926241654799544, 0.0922821136355239, 0.09166969103227349, 0.09085165272863718, 0.08986060532524017, 0.08870880999139048, 0.08739634335284419, 0.08591592909955579, 0.08425539411325306, 0.08239866652102707, 0.08032595785409581, 0.07801350200594947, 0.07543304203161152, 0.07255116220397657, 0.06932853621074294, 0.0657191903242665, 0.06166996850914394, 0.05712056147605141, 0.05200477020781855, 0.04625416662190494, 0.03980597368059239, 0.03261752649016433, 0.02468912784629519, 0.01609374748327739, 0.007012317914894128 },
                { 36.69983237118272, 4.929131903498098, 4.842996343683765, 4.756838736870841, 4.670657687298985, 4.584451680137642, 4.498219068865924, 4.411958061104844, 4.325666702702326, 4.239342859850253, 4.152984198992945, 4.066588164270204, 3.980151952229457, 3.893672483546803, 3.807146371525851, 3.720569887211235, 3.633938921083954, 3.547248941533704, 3.460494950682739, 3.373671438746996, 3.286772339082787, 3.199790987556783, 3.11272009214624, 3.02555172208069, 2.938277330854493, 2.850887834674769, 2.763373778029678, 2.675725631604938, 2.587934284677208, 2.49999181275607, 2.411892616828803, 2.323635032812532, 2.235223481000035, 2.146671141377114, 2.058002981248136, 1.969258733848149, 1.880495199112498, 1.791787153750015, 1.703226376642511, 1.614918849364827, 1.526980863971063, 1.439535178813009, 1.352708254683897, 1.266629079670945, 1.181429507105788, 1.097245688080887, 1.014220140410042, 0.9325041404607143, 0.8522603059848322, 0.7736653740674439, 0.6969132531737696, 0.6222184591897954, 0.5498200524419712, 0.479986185987514, 0.4130193523311279, 0.3492623600941809, 0.2891049506526944, 0.2329907173406641, 0.1814235157133813, 0.1349717000015307, 0.09426710658674217, 0.05999366371426778, 0.03285832724090541, 0.01353656829659935, 0.002587706963004902, 1.404009163556538e-19, 8.31115789415339e-18, 2.422628339762713e-16, 4.635466201828765e-15, 6.548495530779269e-14, 7.283938424172379e-13, 6.643573918381315e-12, 5.10960298105949e-11, 3.382061446471718e-10, 1.956718898219801e-09, 1.001677203233278e-08, 4.581949697596785e-08, 1.888026810947131e-07, 7.055680136292215e-07, 2.405112972536201e-06, 7.515209388606231e-06, 2.161822855489586e-05, 5.746628338270511e-05, 0.0001416382234267177, 0.0003246669753321493, 0.0006940454432653877, 0.001387217239728108, 0.002598722917663287, 0.004573492428788588, 0.007578922401379275, 0.01185353834447585, 0.01753946718769582, 0.02461644170792098, 0.03286119273407991, 0.04185289241517557, 0.05103172714403991, 0.05979833339356682, 0.06762543171276988, 0.07414773014222231, 0.07920488288290248, 0.08283067824081225, 0.08520073662135883, 0.08656236404950866, 0.08717028967296131, 0.08724328179017551, 0.0869450977196292, 0.08638450199606922, 0.08562567321590997, 0.08470137492827596, 0.08362434199633888, 0.08239527096582822, 0.08100760867859365, 0.07945001754621139, 0.07770739887151196, 0.07576110385231106, 0.07358870259781655, 0.07116350258495691, 0.06845391383245808, 0.06542272950224705, 0.06202641513367513, 0.05821458209081899, 0.05392998626200334, 0.04910968638352595, 0.04368846704020992, 0.0376062678917731, 0.03082189432570088, 0.02333479495712042, 0.01521350248237496, 0.006629487109498422 },
                { 38.96049976037144, 4.6446044140919, 4.563470616833137, 4.482316230036947, 4.401139951698028, 4.319940368864355, 4.238715945889132, 4.157465011242587, 4.076185742697612, 3.994876150683382, 3.913534059582258, 3.832157086729585, 3.750742618867193, 3.669287785805057, 3.58778943107068, 3.506244079386127, 3.424647900929419, 3.342996672542481, 3.261285736390852, 3.179509957134108, 3.097663679539525, 3.015740689824958, 2.933734186081647, 2.851636766229465, 2.769440446536954, 2.687136730356289, 2.604716756008875, 2.52217156524112, 2.439492549368174, 2.356672147790308, 2.273704888811946, 2.190588866465454, 2.107327723248184, 2.023933134970271, 1.940427650025464, 1.856847524672997, 1.773244976979435, 1.689689184854043, 1.606265531622436, 1.523073102214551, 1.440221070826424, 1.35782504044774, 1.276004335092569, 1.19488077340072, 1.114578893038561, 1.03522724740729, 0.9569603378765541, 0.8799208724742965, 0.8042622145809208, 0.7301510184496062, 0.6577701235517281, 0.5873218117217322, 0.5190315391723065, 0.4531522498840713, 0.3899693557037119, 0.3298064168464398, 0.2730314429137003, 0.2200635020465616, 0.1713788783547685, 0.1275152088595989, 0.08907068426547894, 0.05669344163093625, 0.03105416540695321, 0.01279439880914767, 0.002445956985899814, 1.13334958984738e-19, 6.742304436331488e-18, 1.975083384102632e-16, 3.797892491001166e-15, 5.391877318155209e-14, 6.027154995436128e-13, 5.524508732222653e-12, 4.269949527804529e-11, 2.840261579198463e-10, 1.651367491444875e-09, 8.495291045860721e-09, 3.905100103547414e-08, 1.617025838104616e-07, 6.072526857519184e-07, 2.080087969527573e-06, 6.531242094909653e-06, 1.887881693521619e-05, 5.04263648317375e-05, 0.0001248828698717083, 0.0002876232345832502, 0.0006177601883657346, 0.001240514367561373, 0.002334626404832665, 0.004127384095691453, 0.006870157539156689, 0.01079180992732432, 0.01603594761162703, 0.02259792558972452, 0.03028383482936604, 0.03871153901331832, 0.04736178884258636, 0.05566942841962195, 0.06312871772840708, 0.06938075989650328, 0.07425816797538671, 0.07777892452054092, 0.08009965770323324, 0.08145008641870805, 0.08207135174827227, 0.08217323923621138, 0.08191442173529969, 0.08140127380520071, 0.08069716382216291, 0.0798348496514052, 0.0788274325892957, 0.07767615524413891, 0.07637512933799477, 0.07491379859044766, 0.07327798068042747, 0.07145010340351832, 0.06940900154097922, 0.06712946547135013, 0.06458163838819121, 0.06173032873581582, 0.05853432581718384, 0.05494588348826421, 0.05091069317693413, 0.04636894615911064, 0.04125853470065017, 0.03552205478798645, 0.02911979911114009, 0.0220504920577007, 0.01437849786315349, 0.006266257123626 },
                { 41.36042165603453, 4.376416799192659, 4.299994091823798, 4.223552146493712, 4.147089747967975, 4.070605577569226, 3.994098202233412, 3.91756606222494, 3.841007457337321, 3.764420531387219, 3.687803254791939, 3.611153405005392, 3.534468544578601, 3.457745996613174, 3.380982817397867, 3.304175766072069, 3.227321271264971, 3.150415394844821, 3.073453793223412, 2.99643167716381, 2.91934377183368, 2.842184280078973, 2.764946853775044, 2.68762458094359, 2.610210000510815, 2.532695162644553, 2.455071761138443, 2.377331375828462, 2.299465877609527, 2.221468065147014, 2.143332617185683, 2.065057449278034, 1.986645544174887, 1.908107260282981, 1.829462992662977, 1.750745866292625, 1.672003931802849, 1.593301227295738, 1.514717212870286, 1.436344534399103, 1.358285675465259, 1.280649480584609, 1.203548515079983, 1.127097803331867, 1.051414954143004, 0.9766213325238194, 0.9028438629166922, 0.8302171607736792, 0.7588858528040173, 0.6890070762600371, 0.6207532226981253, 0.5543150244413126, 0.489905090942949, 0.427761997704917, 0.3681550110322967, 0.3113894839552512, 0.2578128524509428, 0.2078209426428682, 0.1618638774076258, 0.1204501044346633, 0.0841457860017444, 0.05356491842674344, 0.02934350725837285, 0.01209057752728964, 0.002311517879981608, 9.227667491190955e-20, 5.51523870766724e-18, 1.623186083854057e-16, 3.135821466988339e-15, 4.472734859202187e-14, 5.023061728010153e-13, 4.62563237712331e-12, 3.591860977870247e-11, 2.400336751176811e-10, 1.402077432651061e-09, 7.246326834691157e-09, 3.346414041793959e-08, 1.392092771240073e-07, 5.251937455266595e-07, 1.807278202852962e-06, 5.70066619807204e-06, 1.65532479196149e-05, 4.441557991975516e-05, 0.0001104939747125995, 0.000255625614956109, 0.0005514789547575599, 0.001112295297542764, 0.002102430153713701, 0.003732815967453363, 0.006239523309856272, 0.00984147181472085, 0.01468217397637746, 0.02076979701332248, 0.02793621105429407, 0.03583439790270263, 0.0439829466220274, 0.05184962968992134, 0.05895056123022623, 0.06493482258181218, 0.06963020877399449, 0.07304109354616297, 0.07530680857090558, 0.07664049714633741, 0.07727011018230945, 0.07739643915982993, 0.07717286792370501, 0.0767031377448443, 0.07604960183540912, 0.07524486523275079, 0.07430229641599307, 0.07322361468321702, 0.07200354149389267, 0.07063225043913224, 0.06909642162796574, 0.06737949945522229, 0.06546151516002939, 0.06331866408252637, 0.06092273379793788, 0.05824044770091655, 0.05523280708590122, 0.05185458664460138, 0.04805428593119397, 0.04377510395799734, 0.03895793326833404, 0.03354795950258646, 0.02750696890013774, 0.02083307712628713, 0.01358673344150187, 0.005921769346646958 },
                { 43.90817597532433, 4.123640486725136, 4.051655116749907, 3.979651763261136, 3.907629291408472, 3.835586469837376, 3.763521960487985, 3.691434307144309, 3.61932192257199, 3.547183074065284, 3.475015867207029, 3.402818227630975, 3.330587880566908, 3.258322327950249, 3.186018822896609, 3.113674341389668, 3.041285551125261, 2.96884877762256, 2.896359967995451, 2.823814653234667, 2.751207910575026, 2.678534328646436, 2.605787979826405, 2.532962406800782, 2.460050634173532, 2.38704522152798, 2.313938382188174, 2.240722202563458, 2.167389010507809, 2.093931956655766, 2.020345886997267, 1.946628590719934, 1.872782491302715, 1.798816791733027, 1.724749967294369, 1.650612319521137, 1.576448105309766, 1.502316642280806, 1.428291904668011, 1.354460528542565, 1.280918712068206, 1.207768920317354, 1.135117321748669, 1.06307250491783, 0.9917455180980874, 0.9212509265112628, 0.8517084941116794, 0.7832451940361427, 0.7159974060173266, 0.650113285481662, 0.5857553636318389, 0.5231034711869266, 0.4623580881774081, 0.4037442185666906, 0.3475158707451143, 0.293961180397551, 0.243408112933721, 0.1962304774049374, 0.1528535854827037, 0.1137581632948349, 0.07947990497688146, 0.05060026673069002, 0.02772212923856967, 0.01142338473957662, 0.002184063226220711, 7.574517817969687e-20, 4.547132096669651e-18, 1.344159611048473e-16, 2.60820710755734e-15, 3.736550883101959e-14, 4.214750516986158e-13, 3.898328974403148e-12, 3.040388403520997e-11, 2.040712290915478e-10, 1.197234467284533e-09, 6.21469609559779e-09, 2.882525211360269e-08, 1.204340331730472e-07, 4.563349214340454e-07, 1.577128175812308e-06, 4.996192766218565e-06, 1.457004959389538e-05, 3.926165954738175e-05, 9.808825762014625e-05, 0.0002278848587439068, 0.0004936939458636763, 0.0009998819863633111, 0.00189770316243683, 0.003382945544029457, 0.005677139349082192, 0.008989156872040587, 0.01346116457652723, 0.01911174332504418, 0.02579536685477737, 0.03319685292269513, 0.04087000145553715, 0.04831412237887592, 0.05506722645598782, 0.06078761686432947, 0.06530018444379375, 0.0685976783211445, 0.070803732677564, 0.07211592539109555, 0.07274946902663142, 0.07289622040623931, 0.07270413246594369, 0.0722741147505584, 0.07166732806709238, 0.0709160928837195, 0.07003395380336849, 0.06902304207156584, 0.06787863691766227, 0.06659159312199685, 0.06514940205815028, 0.06353646770411856, 0.06173395278843673, 0.05971938318883528, 0.05746610581908714, 0.05494266258324367, 0.05211215884807347, 0.04893177199095069, 0.04535268494561493, 0.04132098075759721, 0.03678044341378512, 0.03167877651635668, 0.02597925677972945, 0.01967949349473761, 0.01283625991236526, 0.005595186079024085 },
                { 46.61286902520641, 3.885398514476522, 3.817592661087752, 3.749769989422394, 3.681929439165271, 3.614069859919761, 3.546190001693076, 3.478288504216359, 3.410363884948572, 3.342414525596694, 3.274438656968725, 3.206434341962282, 3.138399456482669, 3.070331668084695, 3.002228412148811, 2.934086865444913, 2.865903917022477, 2.797676136518079, 2.72939974022812, 2.661070555711545, 2.592683986348078, 2.524234978304997, 2.455717993938234, 2.387126998024843, 2.318455466740222, 2.249696434402924, 2.180842600235386, 2.111886527216624, 2.042820977694204, 1.973639445002936, 1.904336954085622, 1.834911210482694, 1.765364163977103, 1.695704002802698, 1.625947488103464, 1.556122372314429, 1.48626945564711, 1.416443718158107, 1.346714052731754, 1.277161487600996, 1.207876318970984, 1.138954993704148, 1.070497629120015, 1.002606720055294, 0.9353871048317692, 0.8689469177375154, 0.8033991567361256, 0.7388635786889564, 0.6754687794488719, 0.6133544386591881, 0.552673782846603, 0.4935963541376065, 0.4363111822843378, 0.381030454886436, 0.3279937644757963, 0.2774729697340623, 0.229777615220136, 0.1852606611121345, 0.1443238987404383, 0.1074217406412062, 0.07506091543655871, 0.04779188808421666, 0.02618592673804587, 0.01079114771556083, 0.002063275357000723, 6.265612680642995e-20, 3.776986672155045e-18, 1.121133119967508e-16, 2.184468979120183e-15, 3.142469277117463e-14, 3.559320072376164e-13, 3.305728602056449e-12, 2.58886615557733e-11, 1.744826109817811e-10, 1.02786750016372e-09, 5.357506649542121e-09, 2.495156292227636e-08, 1.04677199435062e-07, 3.982544095042061e-07, 1.382015693766407e-06, 4.39590668875579e-06, 1.287142852644702e-05, 3.482432314230884e-05, 8.735136302751209e-05, 0.000203748868694861, 0.0004431499774186277, 0.0009010277372991125, 0.001716698366493606, 0.003071938691700281, 0.005174509428050213, 0.008223269042953033, 0.01235805311096189, 0.01760581452133493, 0.02384082124729733, 0.03077672460922629, 0.03800002630622434, 0.04504011544427636, 0.05145672371983715, 0.05691832794622387, 0.06124854961916234, 0.0644302947697032, 0.06657299642740804, 0.06785966170019507, 0.06849325537293069, 0.0686568178237379, 0.06849278440534448, 0.06809907566608624, 0.06753550904850929, 0.06683400377675944, 0.06600819773555387, 0.06506057407060328, 0.06398692099825762, 0.06277872851310826, 0.06142425078728793, 0.05990879725384557, 0.05821460031507281, 0.0563204453998864, 0.05420115741831511, 0.05182700423369204, 0.04916309129546662, 0.04616888421440383, 0.04279812758038684, 0.03899966644853723, 0.03472006683821035, 0.02990947473708481, 0.02453264625732449, 0.01858677471819365, 0.01212518241195695, 0.005285692183155551 },
                { 49.48416805066332, 3.660862802298221, 3.596993646112191, 3.533108754847138, 3.469207137359402, 3.405287718374681, 3.341349329608447, 3.277390699799286, 3.21341044351415, 3.149407048569004, 3.085378861893225, 3.021324073653037, 2.957240699440501, 2.893126560334255, 2.828979260652334, 2.764796163255722, 2.700574362338427, 2.636310653778407, 2.572001503357665, 2.507643013540649, 2.443230890104284, 2.378760410853577, 2.314226400097993, 2.249623214739076, 2.184944751049388, 2.120184485923232, 2.055335573041068, 1.990391023479457, 1.925344012003979, 1.860188363961184, 1.794919290853845, 1.729534449467271, 1.664035388819174, 1.598429404701798, 1.532731725401752, 1.466967798968866, 1.40117527304063, 1.335405139700834, 1.269721584290394, 1.204200403053931, 1.138926352462227, 1.073990204808315, 1.009486356132836, 0.945511533774146, 0.8821646996143788, 0.8195479070235142, 0.7577677616132584, 0.6969372070146664, 0.6371774930505543, 0.578620301959045, 0.5214100809644998, 0.4657066634030382, 0.4116882714858917, 0.3595549917229903, 0.3095327991869944, 0.2618781683109102, 0.2168832210050211, 0.1748811816468957, 0.1362515541681348, 0.1014237863216294, 0.07087708596027671, 0.04513242258059111, 0.02473091992080351, 0.01019224327302189, 0.001948845865404931, 5.220803240652176e-20, 3.159469197956621e-18, 9.414991535632354e-17, 1.841627459997853e-15, 2.659616549812784e-14, 3.024167899627312e-13, 2.819652079225163e-12, 2.216796323181164e-11, 1.499872565001213e-10, 8.869991851056464e-10, 4.64119915065754e-09, 2.16992018828218e-08, 9.138465325027712e-08, 3.490221698295294e-07, 1.215827737667824e-06, 3.882118424732288e-06, 1.141042753750037e-05, 3.098882659889737e-05, 7.802439336897471e-05, 0.0001826768103097695, 0.0003987985134462118, 0.0008138418144482545, 0.001556238280065387, 0.002794809099408579, 0.00472431284098831, 0.007533732487377794, 0.01135980965137043, 0.01623613639883886, 0.02205429450743949, 0.02855403157905356, 0.0353521728916218, 0.04200669617194052, 0.04809870595593309, 0.05330755538882858, 0.0574569817139488, 0.06052163869877835, 0.06259814934435953, 0.0638559182496851, 0.06448617887993441, 0.06466332151263489, 0.06452422542526694, 0.06416370227958688, 0.06364009983736888, 0.06298483393599072, 0.06221156101134265, 0.06132306075063899, 0.06031558473519722, 0.05918121484540619, 0.05790892219826393, 0.05648487034229407, 0.05489230259088996, 0.05311119628584853, 0.05111777662530786, 0.04888394874597583, 0.04637671815796455, 0.0435577280884122, 0.04038316636578707, 0.03680452019279209, 0.03277102836553095, 0.02823520079651139, 0.02316325510560307, 0.01755204823125432, 0.01145166326949854, 0.004992496376815105 },
        };
    }

    std::vector<Real> ExponentialFittingHestonEngine::moneyness_;

    ExponentialFittingHestonEngine::ExponentialFittingHestonEngine(
        const ext::shared_ptr<HestonModel>& model,
        ControlVariate cv,
        Real scaling, Real alpha)
    : GenericModelEngine<HestonModel,
                         VanillaOption::arguments,
                         VanillaOption::results>(model),
      cv_(cv),
      scaling_(scaling),
      alpha_(alpha),
      analyticEngine_(ext::make_shared<AnalyticHestonEngine>(model, 1)) {

        if (moneyness_.empty()) {
            const Size n = sizeof(values4)/sizeof(values4[0]);
            moneyness_.reserve(n);

            for (const auto& i : values4)
                moneyness_.push_back(i[0]);
        }
    }

    void ExponentialFittingHestonEngine::calculate() const {
        QL_REQUIRE(arguments_.exercise->type() == Exercise::European,
                   "not an European option");

        const Date maturityDate = arguments_.exercise->lastDate();

        const ext::shared_ptr<PlainVanillaPayoff> payoff =
            ext::dynamic_pointer_cast<PlainVanillaPayoff>(arguments_.payoff);
        QL_REQUIRE(payoff, "non plain vanilla payoff given");

        const Real strike = payoff->strike();

        const ext::shared_ptr<HestonProcess> process = model_->process();

        const Time t = process->time(maturityDate);

        const DiscountFactor rd
            = process->riskFreeRate()->discount(maturityDate);
        const DiscountFactor dd
            = process->dividendYield()->discount(maturityDate);

        const Real spot = process->s0()->value();
        QL_REQUIRE(spot > 0.0, "negative or null underlying given");

        const Real freq = std::log(spot) - std::log(rd/dd) - std::log(strike);

        const Real fwd = spot * dd / rd;

        const Real v0    = model_->v0();
        const Real kappa = model_->kappa();
        const Real theta = model_->theta();
        const Real sigma = model_->sigma();
        const Real rho   = model_->rho();

        QL_REQUIRE(cv_ != ControlVariate::Gatheral && cv_ != ControlVariate::BranchCorrection,
            "Gatheral and Branch-Correction are not supported as control-variate");

        const AnalyticHestonEngine::ComplexLogFormula analyticCV =
            (cv_ == ControlVariate::OptimalCV)
            ? AnalyticHestonEngine::optimalControlVariate(t, v0, kappa, theta, sigma, rho)
            : cv_;

        const AnalyticHestonEngine::AP_Helper helper(
            t, fwd, strike, analyticCV, analyticEngine_.get(), alpha_);

        const Real vAvg = (1-std::exp(-kappa*t))*(v0-theta)/(kappa*t) + theta;

        const Real scalingFactor = (scaling_ == Null<Real>())
            ? (analyticCV != AnalyticHestonEngine::AsymptoticChF)
                    ? std::max(0.25, std::min(1000.0, 0.25/std::sqrt(0.5*vAvg*t)))
                    : Real(1.0)
            : scaling_;

        Size n;
        Real u;
        if (std::fabs(freq) < 0.1) {
            n = 0;
            u = scalingFactor;
        }
        else {
            const Real lookup = std::fabs(scalingFactor*freq);
            n = std::min(Size(moneyness_.size() - 1),
                    Size(std::distance(moneyness_.begin(),
                        std::lower_bound(
                            moneyness_.begin(),
                            moneyness_.end(), lookup))));

            if (n > 0 && std::fabs(lookup - moneyness_[n])
                            > std::fabs(lookup - moneyness_[n-1])) {
                --n;
            }

            const Real omega = moneyness_[n];
            u = std::fabs(omega / freq);
        }
        const Size order = (sizeof(values4[0]) / sizeof(values4[0][0]) - 1) / 2;

        Real s = 0.0;
        for (Size i=0; i < order; ++i) {
            const Real x_i = values4[n][i+1];
            const Real w_i = values4[n][order + 1 +i];

            s += w_i*u*helper(u*x_i);
        }

        const Real h_cv = s * fwd/M_PI;
        const Real cvValue = helper.controlVariateValue();

        switch (payoff->optionType())
        {
          case Option::Call:
              results_.value = (cvValue + h_cv)*rd;
            break;
          case Option::Put:
              results_.value = (cvValue + h_cv - (fwd - strike))*rd;
            break;
          default:
            QL_FAIL("unknown option type");
        }
    }
}
